/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.swing.PositiveDecimalFilter;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import main.java.guru.vfrflight.gui.swing.panel.CollapsablePanel;
import main.java.guru.vfrflight.gui.swing.panel.WindCanvas;
import main.java.guru.vfrflight.util.UnitUtil;

public class WindCollapsablePanel
extends CollapsablePanel {
    private static final long serialVersionUID = -2525451625980401738L;
    private JTextField windDirectionTextField;
    private JTextField windSpeedTextField;
    private WindCanvas windCanvas;
    private JButton calculateFromMetarButton;

    public WindCollapsablePanel(boolean expanded) {
        super(Messages.getInstance().get("main_frame_tab_wind"));
        JPanel windTabPanel = new JPanel();
        GridBagLayout gbl_windTabPanel = new GridBagLayout();
        int offset = Math.round((SettingsBean.getInstance().getParamSidePanelWidth() - 300) / 2);
        if (offset < 0) {
            offset = 0;
        }
        gbl_windTabPanel.columnWidths = new int[]{offset, 285, 0};
        gbl_windTabPanel.rowHeights = new int[]{0, 303};
        gbl_windTabPanel.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_windTabPanel.rowWeights = new double[]{0.0, 0.0};
        windTabPanel.setLayout(gbl_windTabPanel);
        JPanel windPanel = new JPanel();
        windPanel.setBorder(new EtchedBorder(1, null, null));
        windPanel.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gbc_windPanel = new GridBagConstraints();
        gbc_windPanel.fill = 1;
        gbc_windPanel.gridx = 1;
        gbc_windPanel.gridy = 1;
        windTabPanel.add((Component)windPanel, gbc_windPanel);
        JPanel textPanel = new JPanel();
        windPanel.add((Component)textPanel, "North");
        textPanel.setLayout(new BorderLayout(0, 0));
        JPanel northTextPanel = new JPanel();
        textPanel.add((Component)northTextPanel, "North");
        JLabel windDirectionLabel = new JLabel(Messages.getInstance().get("main_frame_tab_wind_direction"));
        northTextPanel.add(windDirectionLabel);
        this.windDirectionTextField = new JTextField();
        northTextPanel.add(this.windDirectionTextField);
        this.windDirectionTextField.setText("");
        this.windDirectionTextField.setHorizontalAlignment(0);
        this.windDirectionTextField.setColumns(10);
        ((AbstractDocument)this.windDirectionTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter(3));
        JPanel centerTextPanel = new JPanel();
        textPanel.add((Component)centerTextPanel, "Center");
        JLabel windSpeedLabel = new JLabel(Messages.getInstance().get("main_frame_tab_wind_speed") + UnitUtil.getWindSpeedUnit());
        centerTextPanel.add(windSpeedLabel);
        this.windSpeedTextField = new JTextField();
        centerTextPanel.add(this.windSpeedTextField);
        this.windSpeedTextField.setHorizontalAlignment(0);
        this.windSpeedTextField.setColumns(10);
        JPanel windWrapperPanel = new JPanel();
        windWrapperPanel.setBorder(new EmptyBorder(10, 40, 10, 40));
        windPanel.add((Component)windWrapperPanel, "Center");
        windWrapperPanel.setLayout(new BorderLayout(0, 0));
        this.windCanvas = new WindCanvas();
        windWrapperPanel.add((Component)this.windCanvas, "Center");
        this.windCanvas.setBorder(null);
        this.windCanvas.setBackgroundColor(this.getBackground());
        this.windCanvas.setLayout(new FlowLayout(1, 5, 5));
        JPanel buttonPanel = new JPanel();
        windPanel.add((Component)buttonPanel, "South");
        this.calculateFromMetarButton = new JButton(Messages.getInstance().get("main_frame_tab_wind_calculate_from_metar"));
        buttonPanel.add(this.calculateFromMetarButton);
        ((AbstractDocument)this.windSpeedTextField.getDocument()).setDocumentFilter(new PositiveDecimalFilter());
        this.setContentPanel(windTabPanel);
        this.setExpanded(expanded);
    }

    public JButton getCalculateFromMetarButton() {
        return this.calculateFromMetarButton;
    }

    public void setCalculateFromMetarButton(JButton calculateFromMetarButton) {
        this.calculateFromMetarButton = calculateFromMetarButton;
    }

    public JTextField getWindDirectionTextField() {
        return this.windDirectionTextField;
    }

    public void setWindDirectionTextField(JTextField windDirectionTextField) {
        this.windDirectionTextField = windDirectionTextField;
    }

    public JTextField getWindSpeedTextField() {
        return this.windSpeedTextField;
    }

    public void setWindSpeedTextField(JTextField windSpeedTextField) {
        this.windSpeedTextField = windSpeedTextField;
    }

    public WindCanvas getWindCanvas() {
        return this.windCanvas;
    }

    public void setWindCanvas(WindCanvas windCanvas) {
        this.windCanvas = windCanvas;
    }
}

