/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.item.NumericComboBoxItem;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.panel.CollapsablePanel;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.gui.table.waypoints.WaypointsDataTable;
import main.java.guru.vfrflight.util.UnitUtil;

public class VorCollapsablePanel
extends CollapsablePanel {
    private static final long serialVersionUID = 5905925645032868013L;
    private WaypointsDataTable vorTable;
    private JCheckBox vorsMouseDragCheckBox;
    private JPanel vorTableWrapper;
    private JButton newVorButton;
    private JButton newVorFromDBButton;
    private JButton delVorButton;
    private JButton btnNewButton;
    private JButton searchVorButton;
    private JButton addMultipleMapRadialsButton;
    private JButton clearMapRadialsButton;
    private JPanel panel;
    private JPanel panel_1;
    private IntegerTextField gridRangeTextField;
    private JCheckBox showGridCheckBox;
    private JPanel tableTypeComboPanel;
    private JComboBox<NumericComboBoxItem> tableTypeComboBox;
    private static NumericComboBoxItem[] TABLE_TYPES_COMBO = new NumericComboBoxItem[]{new NumericComboBoxItem(Messages.getInstance().get("points_table_type_deg_min_sec"), WaypointsDataTable.TYPE_DEG_MIN_SEC), new NumericComboBoxItem(Messages.getInstance().get("points_table_type_decimal"), WaypointsDataTable.TYPE_DECIMAL)};

    public VorCollapsablePanel(boolean expanded) {
        super(Messages.getInstance().get("main_frame_tab_vor"));
        JPanel vorTabPanel = new JPanel();
        vorTabPanel.setLayout(new BorderLayout(0, 0));
        this.vorTableWrapper = new JPanel();
        this.vorTableWrapper.setPreferredSize(new Dimension(370, 120));
        vorTabPanel.add((Component)this.vorTableWrapper, "Center");
        JPanel vorBottomPanel = new JPanel();
        vorTabPanel.add((Component)vorBottomPanel, "South");
        vorBottomPanel.setLayout(new BorderLayout(0, 0));
        JPanel vorInfoPanel = new JPanel();
        vorBottomPanel.add((Component)vorInfoPanel, "North");
        this.vorsMouseDragCheckBox = new JCheckBox(Messages.getInstance().get("main_frame_tab_vor_enable_edit"));
        this.vorsMouseDragCheckBox.setSelected(false);
        this.vorsMouseDragCheckBox.setBorder(null);
        vorInfoPanel.setLayout(new FlowLayout());
        vorInfoPanel.add(this.vorsMouseDragCheckBox);
        JPanel panel_5 = new JPanel();
        vorBottomPanel.add((Component)panel_5, "South");
        panel_5.setLayout(new BorderLayout(0, 0));
        JPanel panel_3 = new JPanel();
        panel_5.add((Component)panel_3, "North");
        this.newVorButton = new JButton(Messages.getInstance().get("main_frame_tab_vor_new"));
        panel_3.setLayout(new FlowLayout());
        panel_3.add(this.newVorButton);
        this.newVorFromDBButton = new JButton(Messages.getInstance().get("main_frame_tab_vor_new_from_db"));
        panel_3.add(this.newVorFromDBButton);
        this.delVorButton = new JButton(Messages.getInstance().get("main_frame_tab_vor_delete"));
        panel_3.add(this.delVorButton);
        this.btnNewButton = new JButton(Messages.getInstance().get("clear_all"));
        panel_3.add(this.btnNewButton);
        this.searchVorButton = new JButton(Messages.getInstance().get("main_frame_tab_vor_search"));
        panel_3.add(this.searchVorButton);
        JPanel panel_2 = new JPanel();
        panel_5.add((Component)panel_2, "Center");
        this.addMultipleMapRadialsButton = new JButton(Messages.getInstance().get("main_frame_tab_vor_add_multiple_map_radials"));
        panel_2.add(this.addMultipleMapRadialsButton);
        this.clearMapRadialsButton = new JButton(Messages.getInstance().get("main_frame_tab_vor_clear_all_map_radials"));
        panel_2.add(this.clearMapRadialsButton);
        this.panel = new JPanel();
        panel_5.add((Component)this.panel, "South");
        this.panel_1 = new JPanel();
        this.panel_1.setBorder(new EtchedBorder(1, null, null));
        this.panel.add(this.panel_1);
        this.showGridCheckBox = new JCheckBox(Messages.getInstance().get("main_frame_tab_vor_show_grid"));
        this.showGridCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VorCollapsablePanel.this.toggleGridAction();
            }
        });
        this.panel_1.add(this.showGridCheckBox);
        JLabel gridRangeLabel = new JLabel(Messages.getInstance().get("main_frame_tab_vor_show_grid_range") + UnitUtil.getDistanceUnit());
        this.panel_1.add(gridRangeLabel);
        this.gridRangeTextField = new IntegerTextField(1);
        this.gridRangeTextField.setValue(100);
        this.gridRangeTextField.setNullable(false);
        this.gridRangeTextField.setMinValue(10);
        this.gridRangeTextField.setMaxValue(100);
        this.panel_1.add(this.gridRangeTextField);
        this.gridRangeTextField.setColumns(3);
        this.vorTableWrapper.setLayout(new BorderLayout(0, 0));
        this.tableTypeComboPanel = new JPanel();
        vorTabPanel.add((Component)this.tableTypeComboPanel, "North");
        JLabel tableTypeLabel = new JLabel(Messages.getInstance().get("points_table_type_label"));
        this.tableTypeComboPanel.add(tableTypeLabel);
        this.tableTypeComboBox = new JComboBox();
        this.tableTypeComboBox.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(TABLE_TYPES_COMBO));
        this.tableTypeComboPanel.add(this.tableTypeComboBox);
        this.setContentPanel(vorTabPanel);
        this.setExpanded(expanded);
    }

    private void toggleGridAction() {
        if (!this.showGridCheckBox.isSelected() || FlightPlanBean.getInstance().getRoute().getOnlyVors().size() > 0) {
            double rangeNm = this.gridRangeTextField.getValue().doubleValue();
            rangeNm = UnitUtil.recalculateDistance(rangeNm, SettingsBean.getInstance().getParamUnitsDistance(), "nm", false);
            MapFrame.getInstance().setDrawRadialsFromVorsAction(this.showGridCheckBox.isSelected(), rangeNm);
            this.gridRangeTextField.setEnabled(!this.showGridCheckBox.isSelected());
            if (!MapFrame.getInstance().getUnderCursorTextCheckBox().isSelected()) {
                MapFrame.getInstance().getUnderCursorTextCheckBox().setSelected(true);
                MapFrame.getInstance().underCursorTextAction();
            }
        } else {
            this.showGridCheckBox.setSelected(false);
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("main_frame_tab_vor_show_grid_no_vors"), "", 0);
        }
    }

    public JButton getNewVorButton() {
        return this.newVorButton;
    }

    public void setNewVorButton(JButton newVorButton) {
        this.newVorButton = newVorButton;
    }

    public JButton getNewVorFromDBButton() {
        return this.newVorFromDBButton;
    }

    public void setNewVorFromDBButton(JButton newVorFromDBButton) {
        this.newVorFromDBButton = newVorFromDBButton;
    }

    public JButton getDelVorButton() {
        return this.delVorButton;
    }

    public void setDelVorButton(JButton delVorButton) {
        this.delVorButton = delVorButton;
    }

    public JButton getBtnNewButton() {
        return this.btnNewButton;
    }

    public void setBtnNewButton(JButton btnNewButton) {
        this.btnNewButton = btnNewButton;
    }

    public JButton getSearchVorButton() {
        return this.searchVorButton;
    }

    public void setSearchVorButton(JButton searchVorButton) {
        this.searchVorButton = searchVorButton;
    }

    public WaypointsDataTable getVorTable() {
        return this.vorTable;
    }

    public void setVorTable(WaypointsDataTable vorTable) {
        this.vorTable = vorTable;
    }

    public JCheckBox getVorsMouseDragCheckBox() {
        return this.vorsMouseDragCheckBox;
    }

    public void setVorsMouseDragCheckBox(JCheckBox vorsMouseDragCheckBox) {
        this.vorsMouseDragCheckBox = vorsMouseDragCheckBox;
    }

    public JPanel getVorTableWrapper() {
        return this.vorTableWrapper;
    }

    public void setVorTableWrapper(JPanel vorTableWrapper) {
        this.vorTableWrapper = vorTableWrapper;
    }

    public JButton getAddMultipleMapRadialsButton() {
        return this.addMultipleMapRadialsButton;
    }

    public void setAddMultipleMapRadialsButton(JButton addMultipleMapRadialsButton) {
        this.addMultipleMapRadialsButton = addMultipleMapRadialsButton;
    }

    public JButton getClearMapRadialsButton() {
        return this.clearMapRadialsButton;
    }

    public void setClearMapRadialsButton(JButton clearMapRadialsButton) {
        this.clearMapRadialsButton = clearMapRadialsButton;
    }

    public JComboBox<NumericComboBoxItem> getTableTypeComboBox() {
        return this.tableTypeComboBox;
    }

    public void setTableTypeComboBox(JComboBox<NumericComboBoxItem> tableTypeComboBox) {
        this.tableTypeComboBox = tableTypeComboBox;
    }
}

