/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsDialog;
import main.java.guru.vfrflight.gui.swing.panel.CollapsablePanel;
import main.java.guru.vfrflight.gui.table.UserPointsTagsVisibilityDataTable;
import main.java.guru.vfrflight.gui.table.model.row.UserPointsTagsVisibilityRow;
import main.java.guru.vfrflight.gui.task.RefreshUserPointsTask;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.UserPointsUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class UserPointsFilterCollapsablePanel
extends CollapsablePanel {
    private static final long serialVersionUID = 9058535629907177937L;
    private JPanel visibilityPanel;
    private UserPointsTagsVisibilityDataTable visibilityDataTable;
    private JPanel visibilityPanelTablePanel;
    private JPanel visibilitySelectAllNonePanel;
    private JCheckBox selectAllNoneCheckBox;
    private JPanel allNonePanel;
    private final Map<String, AirspaceType> airspaceTypesMappings;
    private JPanel panel;
    private JButton openDialogButton;
    private JPanel panel_1;
    private JLabel lblNewLabel;

    public UserPointsFilterCollapsablePanel(boolean expanded) {
        super(Messages.getInstance().get("main_frame_tab_user_points_filter"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        this.setContentPanel(mainPanel);
        this.visibilityPanel = new JPanel();
        this.visibilityPanel.setBorder(new EmptyBorder(0, 100, 10, 100));
        mainPanel.add((Component)this.visibilityPanel, "Center");
        this.visibilityPanel.setLayout(new BorderLayout(0, 0));
        this.visibilityPanelTablePanel = new JPanel();
        this.visibilityPanel.add((Component)this.visibilityPanelTablePanel, "Center");
        this.visibilityPanelTablePanel.setLayout(new BorderLayout(0, 0));
        this.visibilityDataTable = new UserPointsTagsVisibilityDataTable(this, null);
        this.visibilityPanelTablePanel.add((Component)this.visibilityDataTable, "Center");
        this.visibilitySelectAllNonePanel = new JPanel();
        this.visibilitySelectAllNonePanel.setBorder(null);
        this.visibilityPanelTablePanel.add((Component)this.visibilitySelectAllNonePanel, "North");
        this.visibilitySelectAllNonePanel.setLayout(new BorderLayout(0, 0));
        this.allNonePanel = new JPanel();
        this.allNonePanel.setBorder(new EtchedBorder(1, null, null));
        this.visibilitySelectAllNonePanel.add((Component)this.allNonePanel, "Center");
        this.allNonePanel.setLayout(new BorderLayout(0, 0));
        this.selectAllNoneCheckBox = new JCheckBox(Messages.getInstance().get("select_all_none"));
        this.selectAllNoneCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsFilterCollapsablePanel.this.selectAllNoneAction();
            }
        });
        this.allNonePanel.add((Component)this.selectAllNoneCheckBox, "North");
        this.selectAllNoneCheckBox.setHorizontalAlignment(0);
        this.panel = new JPanel();
        this.panel.setBorder(new EtchedBorder(1, null, null));
        mainPanel.add((Component)this.panel, "South");
        this.openDialogButton = new JButton(Messages.getInstance().get("main_frame_tab_user_points_filter_open_dialog"));
        this.openDialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserPointsDialog userPointsFrame = new UserPointsDialog(MapFrame.getInstance());
                userPointsFrame.setVisible(true);
            }
        });
        this.panel.add(this.openDialogButton);
        this.panel_1 = new JPanel();
        mainPanel.add((Component)this.panel_1, "North");
        this.lblNewLabel = new JLabel(Messages.getInstance().get("table_tags") + ":");
        this.panel_1.add(this.lblNewLabel);
        this.airspaceTypesMappings = new HashMap<String, AirspaceType>();
        for (AirspaceType type : AirspaceType.values()) {
            this.airspaceTypesMappings.put(AirspacesUtil.getMessageString(type), type);
        }
        this.updateUI(SettingsBean.getInstance().isDrawAllUserPoints());
        this.setExpanded(expanded);
    }

    private void selectAllNoneAction() {
        if (this.selectAllNoneCheckBox.isSelected()) {
            this.visibilityDataTable.selectAll();
        } else {
            this.visibilityDataTable.deselectAll();
        }
    }

    public void updateUserPointsTags() {
        boolean setAllToTrue = !this.isAnyTagInTable();
        ArrayList<UserPointsTagsVisibilityRow> visibilityTableRows = new ArrayList<UserPointsTagsVisibilityRow>();
        if (setAllToTrue) {
            MapObjectsBean.getInstance().getUserPointsFilter().getDrawTagsList().clear();
        }
        for (String tag : UserPointsUtil.getCurrentUserPointsTags()) {
            if (setAllToTrue) {
                MapObjectsBean.getInstance().getUserPointsFilter().getDrawTagsList().add(tag);
            }
            visibilityTableRows.add(new UserPointsTagsVisibilityRow(tag, MapObjectsBean.getInstance().getUserPointsFilter().checkDrawList(tag)));
        }
        this.visibilityDataTable.setData(visibilityTableRows);
        this.selectAllNoneCheckBox.setSelected(this.visibilityDataTable.isAnySelected());
    }

    public void setDrawUserPointsAction(boolean value) {
        SettingsBean.getInstance().setDrawAllUserPoints(value);
        this.updateUI(value);
        VfrUtil.setLayerVisibilityAction(new RefreshUserPointsTask());
    }

    public void updateUI(boolean value) {
        this.visibilityDataTable.getTable().setEnabled(value);
        this.selectAllNoneCheckBox.setEnabled(value);
    }

    public void visibilityTableAction(String key, boolean value) {
        if (value) {
            MapObjectsBean.getInstance().getUserPointsFilter().getDrawTagsList().add(key);
        } else {
            MapObjectsBean.getInstance().getUserPointsFilter().getDrawTagsList().remove(key);
        }
        MapFrame.getInstance().updateMap();
    }

    public boolean isAnyTagInTable() {
        return this.visibilityDataTable.getRowCount() > 0;
    }
}

