/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.filter.TerrainLayerFilter;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.panel.textfield.terrain.AmslTextField;
import main.java.guru.vfrflight.gui.swing.panel.CollapsablePanel;
import main.java.guru.vfrflight.util.UnitUtil;

public class TerrainLayerFilterCollapsablePanel
extends CollapsablePanel {
    private static final long serialVersionUID = 2900234817711933362L;
    private JCheckBox solidColorCheckBox;
    private AmslTextField amslTextField;
    private JPanel flagsPanel;
    private JPanel panel2;
    private JButton clearButton;
    private JPanel contentPanel;

    public TerrainLayerFilterCollapsablePanel(boolean expanded) {
        super(Messages.getInstance().get("main_frame_tab_terrain_layer_filter"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        this.setContentPanel(mainPanel);
        TerrainLayerFilter filter = MapObjectsBean.getInstance().getTerrainLayerFilter();
        this.flagsPanel = new JPanel();
        mainPanel.add((Component)this.flagsPanel, "Center");
        this.flagsPanel.setLayout(new BorderLayout(0, 0));
        this.panel2 = new JPanel();
        this.flagsPanel.add((Component)this.panel2, "Center");
        this.clearButton = new JButton(Messages.getInstance().get("clear"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerrainLayerFilterCollapsablePanel.this.clearAction();
            }
        });
        this.panel2.add(this.clearButton);
        this.contentPanel = new JPanel();
        mainPanel.add((Component)this.contentPanel, "North");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel amslPanel = new JPanel();
        this.contentPanel.add((Component)amslPanel, "North");
        amslPanel.add(new JLabel(Messages.getInstance().get("main_frame_tab_obstacles_filter_elevation_amsl") + UnitUtil.getAltitudeUnit()));
        this.amslTextField = new AmslTextField();
        this.amslTextField.setColumns(5);
        this.amslTextField.setHorizontalAlignment(0);
        if (filter.getAmsl() != null) {
            this.amslTextField.setSuppressChanged(true);
            this.amslTextField.setText(filter.getAmsl().toString());
            this.amslTextField.setSuppressChanged(false);
        }
        amslPanel.add(this.amslTextField);
        this.solidColorCheckBox = new JCheckBox(Messages.getInstance().get("main_frame_tab_terrain_layer_filter_solid_color"), filter.isSolidColor());
        this.solidColorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerrainLayerFilterCollapsablePanel.this.solidColorAction();
            }
        });
        amslPanel.add(this.solidColorCheckBox);
        this.setExpanded(expanded);
    }

    private void clearAction() {
        MapObjectsBean.getInstance().getTerrainLayerFilter().clear();
        this.solidColorCheckBox.setSelected(MapObjectsBean.getInstance().getTerrainLayerFilter().isSolidColor());
        this.amslTextField.setValue(MapObjectsBean.getInstance().getTerrainLayerFilter().getAmsl());
        MapFrame.getInstance().updateMap();
    }

    private void solidColorAction() {
        TerrainLayerFilter filter = MapObjectsBean.getInstance().getTerrainLayerFilter();
        filter.setSolidColor(this.solidColorCheckBox.isSelected());
        MapObjectsBean.getInstance().setTerrainLayerFilter(filter);
        MapFrame.getInstance().updateMap();
    }
}

