/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.combo.item.ComboBoxItem;
import main.java.guru.vfrflight.bean.meteo.MeteoMapBean;
import main.java.guru.vfrflight.bean.meteo.MeteoMapType;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.panel.CollapsablePanel;

public class MeteoMapCollapsablePanel
extends CollapsablePanel {
    private static final long serialVersionUID = -9122683816163285195L;
    private JComboBox<ComboBoxItem<MeteoMapType>> mapTypeCombo;
    private JSlider forecastHourSlider;
    private JLabel forecastHourLabel;
    private JLabel startingHourLabel;
    private JCheckBox withBackgroundMapCheckBox;

    public MeteoMapCollapsablePanel(boolean expanded) {
        super(Messages.getInstance().get("main_frame_tab_meteo_map_panel_name"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        this.setContentPanel(mainPanel);
        JPanel buttonsPanel = new JPanel();
        mainPanel.add((Component)buttonsPanel, "Center");
        buttonsPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel2 = new JPanel();
        buttonsPanel.add((Component)panel2, "North");
        panel2.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        panel2.add((Component)panel, "North");
        panel.setLayout(new BorderLayout(0, 0));
        MeteoMapBean meteoMapBean = MapObjectsBean.getInstance().getMeteoMapBean();
        this.forecastHourLabel = new JLabel(MapObjectsBean.getInstance().getMeteoMapBean().getDateTimeForForecastHour());
        panel.add((Component)this.forecastHourLabel, "West");
        this.forecastHourSlider = new JSlider();
        panel.add(this.forecastHourSlider);
        this.forecastHourSlider.setMajorTickSpacing(24);
        this.forecastHourSlider.setMinorTickSpacing(3);
        this.forecastHourSlider.setMaximum(72);
        this.forecastHourSlider.setMinimum(1);
        this.forecastHourSlider.setValue(meteoMapBean.getForecastHour());
        JPanel checkBoxPanel = new JPanel();
        buttonsPanel.add((Component)checkBoxPanel, "Center");
        checkBoxPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        checkBoxPanel.add((Component)panel_1, "North");
        this.withBackgroundMapCheckBox = new JCheckBox(Messages.getInstance().get("main_frame_tab_meteo_map_panel_background_map"), MapObjectsBean.getInstance().getMeteoMapBean().isBackgroundMap());
        this.withBackgroundMapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MeteoMapCollapsablePanel.this.withBackgroundMapAction();
            }
        });
        this.startingHourLabel = new JLabel(Messages.getInstance().get("main_frame_tab_meteo_map_panel_starting_hour") + ": " + meteoMapBean.getStartingDateWithHour() + " UTC");
        panel_1.add(this.startingHourLabel);
        panel_1.add(this.withBackgroundMapCheckBox);
        this.forecastHourSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                MeteoMapCollapsablePanel.this.forecastHourSliderAction();
            }
        });
        JPanel contentPanel = new JPanel();
        mainPanel.add((Component)contentPanel, "North");
        contentPanel.setLayout(new FlowLayout(1, 5, 5));
        MeteoMapType[] types = MeteoMapType.values();
        ArrayList<ComboBoxItem<MeteoMapType>> values = new ArrayList<ComboBoxItem<MeteoMapType>>(types.length);
        int selIdx = 0;
        int i = 0;
        for (MeteoMapType type : meteoMapBean.getMapTypes()) {
            String key = "meteo_map_type_" + type.toString().toLowerCase();
            String label = null;
            label = Messages.getInstance().exists(key) ? Messages.getInstance().get(key) : type.toString();
            values.add(new ComboBoxItem<MeteoMapType>(label, type));
            if (type.equals((Object)meteoMapBean.getType())) {
                selIdx = i;
            }
            ++i;
        }
        this.mapTypeCombo = new JComboBox();
        this.mapTypeCombo.setModel(new DefaultComboBoxModel<ComboBoxItem>(values.toArray(new ComboBoxItem[values.size()])));
        this.mapTypeCombo.setSelectedIndex(selIdx);
        this.mapTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeteoMapCollapsablePanel.this.mapTypeComboAction();
            }
        });
        contentPanel.add(this.mapTypeCombo);
        this.setExpanded(true);
    }

    protected void withBackgroundMapAction() {
        MapObjectsBean.getInstance().getMeteoMapBean().setBackgroundMap(this.withBackgroundMapCheckBox.isSelected());
        MapFrame.getInstance().updateMap();
    }

    protected void forecastHourSliderAction() {
        MapObjectsBean.getInstance().getMeteoMapBean().setForecastHour(this.forecastHourSlider.getValue());
        this.forecastHourLabel.setText(MapObjectsBean.getInstance().getMeteoMapBean().getDateTimeForForecastHour());
        MapFrame.getInstance().updateMap();
    }

    private void mapTypeComboAction() {
        ComboBoxItem sel = (ComboBoxItem)this.mapTypeCombo.getSelectedItem();
        MapObjectsBean.getInstance().getMeteoMapBean().setType((MeteoMapType)((Object)sel.getValue()));
        MapFrame.getInstance().updateMap();
    }
}

