/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.AlternateAirport;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.gui.flightplan.AddAlternateFromDBDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.SelectAirportFrequencyDialog;
import main.java.guru.vfrflight.gui.swing.panel.CollapsablePanel;
import main.java.guru.vfrflight.gui.table.AlternateAirportsDataTable;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class AlternateAirportsCollapsablePanel
extends CollapsablePanel {
    private static final long serialVersionUID = 7390101499740554193L;
    private AlternateAirportsDataTable alternateAirportsTable;
    private JButton newFromDbButton;
    private JButton showInTheMapButton;
    private JButton removeButton;
    private JButton clearAllButton;

    public AlternateAirportsCollapsablePanel(boolean expanded) {
        super(Messages.getInstance().get("main_frame_tab_alternate_airports"));
        JPanel pointsTabPanel = new JPanel();
        pointsTabPanel.setLayout(new BorderLayout(0, 0));
        JPanel infoPanel = new JPanel();
        pointsTabPanel.add((Component)infoPanel, "South");
        infoPanel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        infoPanel.add((Component)buttonPanel, "South");
        buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        this.newFromDbButton = new JButton(Messages.getInstance().get("main_frame_tab_alternate_airports_new_from_db"));
        this.newFromDbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlternateAirportsCollapsablePanel.this.newFromDbAction();
            }
        });
        buttonPanel.add(this.newFromDbButton);
        this.showInTheMapButton = new JButton(Messages.getInstance().get("main_frame_tab_alternate_airports_show_in_the_map"));
        this.showInTheMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlternateAirportsCollapsablePanel.this.showInTheMapAction();
            }
        });
        buttonPanel.add(this.showInTheMapButton);
        this.removeButton = new JButton(Messages.getInstance().get("main_frame_tab_alternate_airports_remove"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlternateAirportsCollapsablePanel.this.delAlternateAirportAction();
            }
        });
        buttonPanel.add(this.removeButton);
        this.clearAllButton = new JButton(Messages.getInstance().get("clear_all"));
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlternateAirportsCollapsablePanel.this.removeAllAlternateAirportAction();
            }
        });
        buttonPanel.add(this.clearAllButton);
        pointsTabPanel.setPreferredSize(new Dimension(370, 150));
        this.setContentPanel(pointsTabPanel);
        this.alternateAirportsTable = new AlternateAirportsDataTable(FlightPlanBean.getInstance().getRoute().getAlternateAirports());
        pointsTabPanel.add((Component)this.alternateAirportsTable, "Center");
        this.setExpanded(expanded);
    }

    protected void removeAllAlternateAirportAction() {
        FlightPlanBean.getInstance().getRoute().getAlternateAirports().clear();
        this.alternateAirportsTable.setData(FlightPlanBean.getInstance().getRoute().getAlternateAirports());
        MapFrame.getInstance().updateMap();
    }

    protected void newFromDbAction() {
        AddAlternateFromDBDialog dialog = new AddAlternateFromDBDialog(MapFrame.getInstance());
        dialog.setVisible(true);
    }

    protected void showInTheMapAction() {
        int row = this.alternateAirportsTable.getTable().getSelectedRow();
        if (row >= 0 && row < FlightPlanBean.getInstance().getRoute().getAlternateAirports().size()) {
            GpsPlace center = FlightPlanBean.getInstance().getRoute().getAlternateAirports().get(row).getGpsPlace();
            MapFrame.getInstance().centerOnPoint(center, 4);
            MapFrame.getInstance().setMarkerPlace(center);
            MapFrame.getInstance().updateMap();
            MapFrame.getInstance().setMarkerPlace(null);
        }
    }

    public void markAirportAsAlternate(int id) {
        AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
        Airport a = airportFacade.findAirportById(id);
        Double freq = null;
        boolean cont = true;
        if (a.getFrequencies().size() > 0) {
            SelectAirportFrequencyDialog dialog = new SelectAirportFrequencyDialog(a.getFrequencies());
            dialog.setVisible(true);
            freq = dialog.getChosenFrequency();
            cont = dialog.isFrequencyWasChosen();
        }
        if (cont) {
            AlternateAirport aa = new AlternateAirport(a, freq);
            if (aa.getElev() != null && !"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                aa.setElev((int)Math.round(UnitUtil.recalculateAltitude(aa.getElev().intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false)));
            }
            FlightPlanBean.getInstance().getRoute().getAlternateAirports().add(aa);
            this.alternateAirportsTable.addAirport(aa);
            MapFrame.getInstance().updateMap();
        }
    }

    private void delAlternateAirportAction() {
        if (this.alternateAirportsTable.getTable().getSelectedRow() >= 0) {
            int[] idxs = this.alternateAirportsTable.getTable().getSelectedRows();
            for (int q = 0; q < idxs.length; ++q) {
                this.delAlternateAirportAction(idxs[q] - q);
            }
        }
    }

    private void delAlternateAirportAction(int idx) {
        if (idx < FlightPlanBean.getInstance().getRoute().getAlternateAirports().size()) {
            FlightPlanBean.getInstance().getRoute().getAlternateAirports().remove(idx);
            this.alternateAirportsTable.setData(FlightPlanBean.getInstance().getRoute().getAlternateAirports());
            MapFrame.getInstance().updateMap();
        }
    }

    public AlternateAirportsDataTable getAlternateAirportsTable() {
        return this.alternateAirportsTable;
    }

    public JButton getNewFromDbButton() {
        return this.newFromDbButton;
    }

    public void setNewFromDbButton(JButton newFromDbButton) {
        this.newFromDbButton = newFromDbButton;
    }

    public JButton getShowInTheMapButton() {
        return this.showInTheMapButton;
    }

    public void setShowInTheMapButton(JButton showInTheMapButton) {
        this.showInTheMapButton = showInTheMapButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public void setRemoveButton(JButton removeButton) {
        this.removeButton = removeButton;
    }

    public void setAlternateAirportsTable(AlternateAirportsDataTable alternateAirportsTable) {
        this.alternateAirportsTable = alternateAirportsTable;
    }
}

