/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.gui.flightplan.DrawAirspacesAtAltitudeDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.ReservedAirspaceDataInputDialog;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import main.java.guru.vfrflight.gui.swing.panel.CollapsablePanel;
import main.java.guru.vfrflight.gui.table.AirspaceTypeVisibilityDataTable;
import main.java.guru.vfrflight.gui.table.model.row.AirspaceTypeVisibilityRow;
import main.java.guru.vfrflight.gui.task.RefreshAirspacesTask;
import main.java.guru.vfrflight.util.AirspacesUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class AirspacesFilterCollapsablePanel
extends CollapsablePanel {
    private static final long serialVersionUID = 823930274151015702L;
    private JCheckBox airspaceRangeFromCheckBox;
    private JCheckBox airspaceRangeToCheckBox;
    private JTextField airspaceRangeFromTextField;
    private JTextField airspaceRangeToTextField;
    private JPanel visibilityPanel;
    private AirspaceTypeVisibilityDataTable visibilityDataTable;
    private JPanel bottomPanel;
    private JPanel visibilityPanelTablePanel;
    private JPanel visibilitySelectAllNonePanel;
    private JCheckBox selectAllNoneCheckBox;
    private JPanel allNonePanel;
    private final Map<String, AirspaceType> airspaceTypesMappings;
    private JButton clearButton;
    private JPanel panel;
    private JCheckBox zoomLimitCheckBox;

    public AirspacesFilterCollapsablePanel(boolean expanded) {
        super(Messages.getInstance().get("main_frame_tab_airspaces_filter"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        JPanel airspaceTabPanel = new JPanel();
        mainPanel.add((Component)airspaceTabPanel, "North");
        JLabel airspacesRangeLabel = new JLabel(Messages.getInstance().get("map_frame_airspace_range"));
        airspaceTabPanel.add(airspacesRangeLabel);
        this.airspaceRangeFromCheckBox = new JCheckBox(Messages.getInstance().get("map_frame_airspace_range_from"));
        this.airspaceRangeFromCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirspacesFilterCollapsablePanel.this.airspaceRangeFromToggleAction();
            }
        });
        airspaceTabPanel.add(this.airspaceRangeFromCheckBox);
        this.airspaceRangeFromTextField = new JTextField();
        this.airspaceRangeFromTextField.setHorizontalAlignment(0);
        this.airspaceRangeFromTextField.setEnabled(false);
        this.airspaceRangeFromTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                AirspacesFilterCollapsablePanel.this.airspaceRangeFromChanged();
            }
        });
        this.airspaceRangeFromTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    AirspacesFilterCollapsablePanel.this.airspaceRangeFromChanged();
                }
            }
        });
        ((AbstractDocument)this.airspaceRangeFromTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter(5));
        airspaceTabPanel.add(this.airspaceRangeFromTextField);
        this.airspaceRangeFromTextField.setColumns(5);
        this.airspaceRangeToCheckBox = new JCheckBox(Messages.getInstance().get("map_frame_airspace_range_to"));
        this.airspaceRangeToCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirspacesFilterCollapsablePanel.this.airspaceRangeToToggleAction();
            }
        });
        airspaceTabPanel.add(this.airspaceRangeToCheckBox);
        this.airspaceRangeToTextField = new JTextField();
        this.airspaceRangeToTextField.setHorizontalAlignment(0);
        this.airspaceRangeToTextField.setEnabled(false);
        this.airspaceRangeToTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                AirspacesFilterCollapsablePanel.this.airspaceRangeToChanged();
            }
        });
        this.airspaceRangeToTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    AirspacesFilterCollapsablePanel.this.airspaceRangeToChanged();
                }
            }
        });
        ((AbstractDocument)this.airspaceRangeToTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter(5));
        airspaceTabPanel.add(this.airspaceRangeToTextField);
        this.airspaceRangeToTextField.setColumns(5);
        this.setContentPanel(mainPanel);
        this.visibilityPanel = new JPanel();
        this.visibilityPanel.setBorder(new EmptyBorder(0, 100, 10, 100));
        mainPanel.add((Component)this.visibilityPanel, "Center");
        this.visibilityPanel.setLayout(new BorderLayout(0, 0));
        TreeMap<String, Boolean> visibilityTableRows = new TreeMap<String, Boolean>();
        for (AirspaceType type : AirspaceType.values()) {
            visibilityTableRows.put(type.toString(), !MapObjectsBean.getInstance().getAirspaceFilter().checkDontDrawList(type));
        }
        this.visibilityPanelTablePanel = new JPanel();
        this.visibilityPanel.add((Component)this.visibilityPanelTablePanel, "Center");
        this.visibilityPanelTablePanel.setLayout(new BorderLayout(0, 0));
        this.visibilityDataTable = new AirspaceTypeVisibilityDataTable(this, null);
        this.visibilityPanelTablePanel.add((Component)this.visibilityDataTable, "Center");
        this.visibilitySelectAllNonePanel = new JPanel();
        this.visibilitySelectAllNonePanel.setBorder(null);
        this.visibilityPanelTablePanel.add((Component)this.visibilitySelectAllNonePanel, "North");
        this.visibilitySelectAllNonePanel.setLayout(new BorderLayout(0, 0));
        this.allNonePanel = new JPanel();
        this.allNonePanel.setBorder(new EtchedBorder(1, null, null));
        this.visibilitySelectAllNonePanel.add((Component)this.allNonePanel, "Center");
        this.allNonePanel.setLayout(new BorderLayout(0, 0));
        this.selectAllNoneCheckBox = new JCheckBox(Messages.getInstance().get("select_all_none"));
        this.selectAllNoneCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirspacesFilterCollapsablePanel.this.selectAllNoneAction();
            }
        });
        this.allNonePanel.add((Component)this.selectAllNoneCheckBox, "North");
        this.selectAllNoneCheckBox.setHorizontalAlignment(0);
        this.panel = new JPanel();
        this.visibilityPanel.add((Component)this.panel, "South");
        this.zoomLimitCheckBox = new JCheckBox(Messages.getInstance().get("main_frame_tab_airports_filter_limited_by_zoom"), MapObjectsBean.getInstance().getAirspaceFilter().isRestrictToZoom());
        this.zoomLimitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirspacesFilterCollapsablePanel.this.restrictToZoomAction();
            }
        });
        this.panel.add(this.zoomLimitCheckBox);
        this.bottomPanel = new JPanel();
        mainPanel.add((Component)this.bottomPanel, "South");
        this.clearButton = new JButton(Messages.getInstance().get("clear"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirspacesFilterCollapsablePanel.this.clearAction();
            }
        });
        this.bottomPanel.add(this.clearButton);
        JButton drawAtAlt = new JButton(Messages.getInstance().get("map_frame_airspace_draw_at_altitude"));
        drawAtAlt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawAirspacesAtAltitudeDialog dialog = new DrawAirspacesAtAltitudeDialog();
                dialog.setVisible(true);
            }
        });
        this.bottomPanel.add(drawAtAlt);
        JButton reservationsButton = new JButton(Messages.getInstance().get("map_frame_airspace_show_reservations"));
        reservationsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirspacesFilterCollapsablePanel.this.loadAirspaceReservationsAction();
            }
        });
        this.bottomPanel.add(reservationsButton);
        this.airspaceTypesMappings = new HashMap<String, AirspaceType>();
        for (AirspaceType type : AirspaceType.values()) {
            this.airspaceTypesMappings.put(AirspacesUtil.getMessageString(type), type);
        }
        this.updateUI(SettingsBean.getInstance().isDrawAirspaces());
        this.setExpanded(expanded);
    }

    private void restrictToZoomAction() {
        MapObjectsBean.getInstance().getAirspaceFilter().setRestrictToZoom(this.zoomLimitCheckBox.isSelected());
        MapFrame.getInstance().updateMap();
    }

    private void loadAirspaceReservationsAction() {
        if (SettingsBean.getInstance().isDrawAirspaces() && MapObjectsBean.getInstance().getAirspaces() != null) {
            ReservedAirspaceDataInputDialog dialog = new ReservedAirspaceDataInputDialog(MapFrame.getInstance());
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("reserved_airspaces_no_loaded_airspaces"), "", 0);
        }
    }

    private void clearAction() {
        this.airspaceRangeFromCheckBox.setSelected(false);
        this.airspaceRangeFromTextField.setText("");
        this.airspaceRangeFromToggleAction();
        this.airspaceRangeToCheckBox.setSelected(false);
        this.airspaceRangeToTextField.setText("");
        this.airspaceRangeToToggleAction();
        this.selectAllNoneCheckBox.setSelected(true);
        this.selectAllNoneAction();
        this.zoomLimitCheckBox.setSelected(true);
        this.restrictToZoomAction();
    }

    private void selectAllNoneAction() {
        if (this.selectAllNoneCheckBox.isSelected()) {
            this.visibilityDataTable.selectAll();
        } else {
            this.visibilityDataTable.deselectAll();
        }
    }

    public void updateAirspacesTypes() {
        ArrayList<AirspaceTypeVisibilityRow> visibilityTableRows = new ArrayList<AirspaceTypeVisibilityRow>();
        for (AirspaceType type : AirspacesUtil.getCurrentAirspacesTypes()) {
            visibilityTableRows.add(new AirspaceTypeVisibilityRow(AirspacesUtil.getMessageString(type), type, !MapObjectsBean.getInstance().getAirspaceFilter().checkDontDrawList(type)));
        }
        this.visibilityDataTable.setData(visibilityTableRows);
        this.selectAllNoneCheckBox.setSelected(this.visibilityDataTable.isAnySelected());
    }

    public void airspaceRangeToToggleAction() {
        this.airspaceRangeToTextField.setEnabled(this.airspaceRangeToCheckBox.isSelected());
        if (!this.airspaceRangeToCheckBox.isSelected()) {
            MapObjectsBean.getInstance().getAirspaceFilter().setDrawAirspaceRangeTo(null);
            MapFrame.getInstance().updateMap();
        } else {
            this.airspaceRangeToChanged();
        }
    }

    public void airspaceRangeFromToggleAction() {
        this.airspaceRangeFromTextField.setEnabled(this.airspaceRangeFromCheckBox.isSelected());
        if (!this.airspaceRangeFromCheckBox.isSelected()) {
            MapObjectsBean.getInstance().getAirspaceFilter().setDrawAirspaceRangeFrom(null);
            MapFrame.getInstance().updateMap();
        } else {
            this.airspaceRangeFromChanged();
        }
    }

    public void airspaceRangeFromChanged() {
        Integer rangeTo = MapObjectsBean.getInstance().getAirspaceFilter().getDrawAirspaceRangeTo();
        Integer rangeFrom = null;
        try {
            rangeFrom = Integer.parseInt(this.airspaceRangeFromTextField.getText());
            if (rangeTo == null || rangeFrom <= rangeTo) {
                MapObjectsBean.getInstance().getAirspaceFilter().setDrawAirspaceRangeFrom(rangeFrom);
            } else if (rangeTo != null) {
                MapObjectsBean.getInstance().getAirspaceFilter().setDrawAirspaceRangeFrom(null);
                this.airspaceRangeFromTextField.setText("");
            }
        }
        catch (NumberFormatException e) {
            MapObjectsBean.getInstance().getAirspaceFilter().setDrawAirspaceRangeFrom(null);
            this.airspaceRangeFromTextField.setText("");
        }
        MapFrame.getInstance().updateMap();
    }

    public void airspaceRangeToChanged() {
        Integer rangeFrom = MapObjectsBean.getInstance().getAirspaceFilter().getDrawAirspaceRangeFrom();
        Integer rangeTo = null;
        try {
            rangeTo = Integer.parseInt(this.airspaceRangeToTextField.getText());
            if (rangeFrom == null || rangeFrom <= rangeTo) {
                MapObjectsBean.getInstance().getAirspaceFilter().setDrawAirspaceRangeTo(rangeTo);
            } else if (rangeFrom != null) {
                MapObjectsBean.getInstance().getAirspaceFilter().setDrawAirspaceRangeTo(null);
                this.airspaceRangeToTextField.setText("");
            }
        }
        catch (NumberFormatException e) {
            MapObjectsBean.getInstance().getAirspaceFilter().setDrawAirspaceRangeTo(null);
            this.airspaceRangeToTextField.setText("");
        }
        MapFrame.getInstance().updateMap();
    }

    public void setDrawAirspacesAction(boolean value) {
        SettingsBean.getInstance().setDrawAirspaces(value);
        this.updateUI(value);
        VfrUtil.setLayerVisibilityAction(new RefreshAirspacesTask());
    }

    public void updateUI(boolean value) {
        this.airspaceRangeFromCheckBox.setEnabled(value);
        this.airspaceRangeToCheckBox.setEnabled(value);
        if (!value) {
            this.airspaceRangeFromTextField.setEnabled(false);
            this.airspaceRangeFromTextField.setText("");
            this.airspaceRangeFromCheckBox.setSelected(false);
            this.airspaceRangeToTextField.setEnabled(false);
            this.airspaceRangeToTextField.setText("");
            this.airspaceRangeToCheckBox.setSelected(false);
        }
        this.visibilityDataTable.getTable().setEnabled(value);
        this.selectAllNoneCheckBox.setEnabled(value);
    }

    public void visibilityTableAction(String key, boolean value) {
        if (!value) {
            MapObjectsBean.getInstance().getAirspaceFilter().getDontDrawAirspacesList().add(this.airspaceTypesMappings.get(key));
        } else {
            MapObjectsBean.getInstance().getAirspaceFilter().getDontDrawAirspacesList().remove((Object)this.airspaceTypesMappings.get(key));
        }
        MapFrame.getInstance().updateMap();
    }
}

