/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.item.BooleanComboBoxItem;
import main.java.guru.vfrflight.bean.filter.AirportFilter;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.panel.textfield.airport.ElevationFromTextField;
import main.java.guru.vfrflight.gui.flightplan.panel.textfield.airport.ElevationToTextField;
import main.java.guru.vfrflight.gui.flightplan.panel.textfield.airport.RunwayLengthFromTextField;
import main.java.guru.vfrflight.gui.flightplan.panel.textfield.airport.RunwayLengthToTextField;
import main.java.guru.vfrflight.gui.swing.panel.CollapsablePanel;
import main.java.guru.vfrflight.util.UnitUtil;

public class AirportsFilterCollapsablePanel
extends CollapsablePanel {
    private static final long serialVersionUID = -7306705178471023989L;
    private JCheckBox useRunwayLengthFromCheckBox;
    private JCheckBox useRunwayLengthToCheckBox;
    private RunwayLengthFromTextField runwayLengthFrom;
    private RunwayLengthToTextField runwayLengthTo;
    private JPanel elevationPanel;
    private JPanel flagsPanel;
    private JCheckBox elevationFromCheckBox;
    private ElevationFromTextField elevationFrom;
    private JCheckBox elevationToCheckBox;
    private ElevationToTextField elevationTo;
    private JPanel panel;
    private JLabel mountainousLabel;
    private JComboBox<BooleanComboBoxItem> mountainousComboBox;
    private JLabel heliLabel;
    private JLabel hardenedLabel;
    private JComboBox<BooleanComboBoxItem> heliComboBox;
    private JComboBox<BooleanComboBoxItem> hardenedComboBox;
    private JPanel panel1;
    private JLabel withIlsLabel;
    private JComboBox<BooleanComboBoxItem> withIlsComboBox;
    private JComboBox<BooleanComboBoxItem> skewedLocComboBox;
    private JLabel withVorLabel;
    private JComboBox<BooleanComboBoxItem> withVorComboBox;
    private JLabel withNdbLabel;
    private JComboBox<BooleanComboBoxItem> withNdbComboBox;
    private BooleanComboBoxItem[] YES_NO_COMBO = new BooleanComboBoxItem[]{new BooleanComboBoxItem("", null), new BooleanComboBoxItem(Messages.getInstance().get("yes"), Boolean.TRUE), new BooleanComboBoxItem(Messages.getInstance().get("no"), Boolean.FALSE)};
    private JCheckBox restrictToZoomCheckBox;
    private JPanel panel2;
    private JButton clearButton;
    private JPanel panel_1;
    private JPanel panel_2;

    public AirportsFilterCollapsablePanel(boolean expanded) {
        super(Messages.getInstance().get("main_frame_tab_airports_filter"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(0, 0));
        this.setContentPanel(mainPanel);
        JPanel runwayRangePanel = new JPanel();
        mainPanel.add((Component)runwayRangePanel, "North");
        AirportFilter filter = MapObjectsBean.getInstance().getAirportFilter();
        runwayRangePanel.add(new JLabel(Messages.getInstance().get("main_frame_tab_airports_filter_runway_length") + "[" + "m" + "]"));
        this.useRunwayLengthFromCheckBox = new JCheckBox(Messages.getInstance().get("from"), filter.getRunwayLengthFrom() != null);
        this.useRunwayLengthFromCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirportsFilterCollapsablePanel.this.useRunwayLengthFromCheckBoxAction();
            }
        });
        runwayRangePanel.add(this.useRunwayLengthFromCheckBox);
        this.runwayLengthFrom = new RunwayLengthFromTextField(1);
        this.runwayLengthFrom.setColumns(5);
        this.runwayLengthFrom.setHorizontalAlignment(0);
        this.runwayLengthFrom.setEnabled(this.useRunwayLengthFromCheckBox.isSelected());
        if (filter.getRunwayLengthFrom() != null) {
            this.runwayLengthFrom.setSuppressChanged(true);
            this.runwayLengthFrom.setText(filter.getRunwayLengthFrom().toString());
            this.runwayLengthFrom.setSuppressChanged(false);
        }
        runwayRangePanel.add(this.runwayLengthFrom);
        this.useRunwayLengthToCheckBox = new JCheckBox(Messages.getInstance().get("to"), filter.getRunwayLengthTo() != null);
        this.useRunwayLengthToCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirportsFilterCollapsablePanel.this.useRunwayLengthToCheckBoxAction();
            }
        });
        runwayRangePanel.add(this.useRunwayLengthToCheckBox);
        this.runwayLengthTo = new RunwayLengthToTextField(1);
        this.runwayLengthTo.setColumns(5);
        this.runwayLengthTo.setHorizontalAlignment(0);
        this.runwayLengthTo.setEnabled(this.useRunwayLengthToCheckBox.isSelected());
        if (filter.getRunwayLengthTo() != null) {
            this.runwayLengthTo.setSuppressChanged(true);
            this.runwayLengthTo.setText(filter.getRunwayLengthTo().toString());
            this.runwayLengthTo.setSuppressChanged(false);
        }
        runwayRangePanel.add(this.runwayLengthTo);
        this.elevationPanel = new JPanel();
        mainPanel.add((Component)this.elevationPanel, "Center");
        this.elevationPanel.setLayout(new BorderLayout(0, 0));
        this.panel = new JPanel();
        this.elevationPanel.add((Component)this.panel, "North");
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("main_frame_tab_airports_filter_elevation") + UnitUtil.getAltitudeUnit());
        this.panel.add(lblNewLabel);
        this.elevationFromCheckBox = new JCheckBox(Messages.getInstance().get("from"), filter.getElevationFrom() != null);
        this.elevationFromCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirportsFilterCollapsablePanel.this.elevationFromCheckBoxAction();
            }
        });
        this.panel.add(this.elevationFromCheckBox);
        this.elevationFrom = new ElevationFromTextField(1);
        this.elevationFrom.setEnabled(this.elevationFromCheckBox.isSelected());
        this.elevationFrom.setHorizontalAlignment(0);
        if (filter.getElevationFrom() != null) {
            int elFrom = (int)Math.round(UnitUtil.recalculateAltitude(filter.getElevationFrom().intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false));
            this.elevationFrom.setSuppressChanged(true);
            this.elevationFrom.setText(String.valueOf(elFrom));
            this.elevationFrom.setSuppressChanged(false);
        }
        this.panel.add(this.elevationFrom);
        this.elevationFrom.setColumns(5);
        this.elevationToCheckBox = new JCheckBox(Messages.getInstance().get("to"), filter.getElevationTo() != null);
        this.elevationToCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirportsFilterCollapsablePanel.this.elevationToCheckBoxAction();
            }
        });
        this.panel.add(this.elevationToCheckBox);
        this.elevationTo = new ElevationToTextField(1);
        this.elevationTo.setEnabled(this.elevationToCheckBox.isSelected());
        this.elevationTo.setHorizontalAlignment(0);
        if (filter.getElevationTo() != null) {
            int elTo = (int)Math.round(UnitUtil.recalculateAltitude(filter.getElevationTo().intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false));
            this.elevationTo.setSuppressChanged(true);
            this.elevationTo.setText(String.valueOf(elTo));
            this.elevationTo.setSuppressChanged(false);
        }
        this.panel.add(this.elevationTo);
        this.elevationTo.setColumns(5);
        this.restrictToZoomCheckBox = new JCheckBox(Messages.getInstance().get("main_frame_tab_airports_filter_limited_by_zoom"), filter.isRestrictToZoom());
        this.restrictToZoomCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirportsFilterCollapsablePanel.this.restrictToZoomAction();
            }
        });
        this.panel.add(this.restrictToZoomCheckBox);
        this.flagsPanel = new JPanel();
        this.elevationPanel.add((Component)this.flagsPanel, "Center");
        this.flagsPanel.setLayout(new BorderLayout(0, 0));
        if (filter.getMountainous() != null) {
            this.mountainousComboBox.setSelectedIndex(filter.getMountainous() != false ? 1 : 2);
        }
        if (filter.getWithIls() != null) {
            this.withIlsComboBox.setSelectedIndex(filter.getWithIls() != false ? 1 : 2);
        }
        if (filter.getWithVor() != null) {
            this.withVorComboBox.setSelectedIndex(filter.getWithVor() != false ? 1 : 2);
        }
        if (filter.getWithNdb() != null) {
            this.withNdbComboBox.setSelectedIndex(filter.getWithNdb() != false ? 1 : 2);
        }
        if (filter.getHeli() != null) {
            this.heliComboBox.setSelectedIndex(filter.getHeli() != false ? 1 : 2);
        }
        this.panel2 = new JPanel();
        this.flagsPanel.add((Component)this.panel2, "Center");
        this.clearButton = new JButton(Messages.getInstance().get("clear"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AirportsFilterCollapsablePanel.this.clearAction();
            }
        });
        this.panel2.add(this.clearButton);
        this.panel_1 = new JPanel();
        this.flagsPanel.add((Component)this.panel_1, "North");
        this.panel_1.setLayout(new BorderLayout(0, 0));
        this.panel1 = new JPanel();
        this.panel_1.add((Component)this.panel1, "North");
        this.withVorLabel = new JLabel(Messages.getInstance().get("main_frame_tab_airports_filter_vor"));
        this.panel1.add(this.withVorLabel);
        this.withVorComboBox = new JComboBox();
        this.withVorComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        this.withVorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirportsFilterCollapsablePanel.this.vorAction();
            }
        });
        this.panel1.add(this.withVorComboBox);
        this.withNdbLabel = new JLabel(Messages.getInstance().get("main_frame_tab_airports_filter_ndb"));
        this.panel1.add(this.withNdbLabel);
        this.withNdbComboBox = new JComboBox();
        this.withNdbComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        this.withNdbComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirportsFilterCollapsablePanel.this.ndbAction();
            }
        });
        this.panel1.add(this.withNdbComboBox);
        this.heliLabel = new JLabel(Messages.getInstance().get("main_frame_tab_airports_filter_heli"));
        this.panel1.add(this.heliLabel);
        this.heliComboBox = new JComboBox();
        this.heliComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        this.heliComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirportsFilterCollapsablePanel.this.heliAction();
            }
        });
        this.panel1.add(this.heliComboBox);
        this.hardenedLabel = new JLabel(Messages.getInstance().get("main_frame_tab_airports_filter_hardened"));
        this.panel1.add(this.hardenedLabel);
        this.hardenedComboBox = new JComboBox();
        this.hardenedComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        this.hardenedComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirportsFilterCollapsablePanel.this.hardenedAction();
            }
        });
        this.panel1.add(this.hardenedComboBox);
        this.panel_2 = new JPanel();
        this.panel_1.add((Component)this.panel_2, "South");
        this.mountainousLabel = new JLabel(Messages.getInstance().get("main_frame_tab_airports_filter_mountainous"));
        this.panel_2.add(this.mountainousLabel);
        this.mountainousComboBox = new JComboBox();
        this.panel_2.add(this.mountainousComboBox);
        this.mountainousComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        this.mountainousComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirportsFilterCollapsablePanel.this.mountainousAction();
            }
        });
        this.withIlsLabel = new JLabel(Messages.getInstance().get("main_frame_tab_airports_filter_ils"));
        this.panel_2.add(this.withIlsLabel);
        this.withIlsComboBox = new JComboBox();
        this.panel_2.add(this.withIlsComboBox);
        this.withIlsComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        this.withIlsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirportsFilterCollapsablePanel.this.ilsAction();
            }
        });
        JLabel skewedLocLabel = new JLabel(Messages.getInstance().get("main_frame_tab_airports_filter_skewed_loc"));
        this.panel_2.add(skewedLocLabel);
        this.skewedLocComboBox = new JComboBox();
        this.panel_2.add(this.skewedLocComboBox);
        this.skewedLocComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        this.skewedLocComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AirportsFilterCollapsablePanel.this.skewedLocAction();
            }
        });
        this.setExpanded(expanded);
    }

    private void clearAction() {
        this.useRunwayLengthFromCheckBox.setSelected(false);
        this.useRunwayLengthFromCheckBoxAction();
        this.useRunwayLengthToCheckBox.setSelected(false);
        this.useRunwayLengthToCheckBoxAction();
        this.elevationFromCheckBox.setSelected(false);
        this.elevationFromCheckBoxAction();
        this.elevationToCheckBox.setSelected(false);
        this.elevationToCheckBoxAction();
        this.restrictToZoomCheckBox.setSelected(true);
        this.restrictToZoomAction();
        this.heliComboBox.setSelectedIndex(0);
        this.mountainousComboBox.setSelectedIndex(0);
        this.withIlsComboBox.setSelectedIndex(0);
        this.withVorComboBox.setSelectedIndex(0);
        this.withNdbComboBox.setSelectedIndex(0);
        this.hardenedComboBox.setSelectedIndex(0);
    }

    private void restrictToZoomAction() {
        MapObjectsBean.getInstance().getAirportFilter().setRestrictToZoom(this.restrictToZoomCheckBox.isSelected());
        MapFrame.getInstance().updateMap();
    }

    private void elevationToCheckBoxAction() {
        this.elevationTo.setEnabled(this.elevationToCheckBox.isSelected());
        if (!this.elevationToCheckBox.isSelected()) {
            this.elevationTo.setValue(null);
        }
    }

    private void elevationFromCheckBoxAction() {
        this.elevationFrom.setEnabled(this.elevationFromCheckBox.isSelected());
        if (!this.elevationFromCheckBox.isSelected()) {
            this.elevationFrom.setValue(null);
        }
    }

    private void useRunwayLengthFromCheckBoxAction() {
        this.runwayLengthFrom.setEnabled(this.useRunwayLengthFromCheckBox.isSelected());
        if (!this.useRunwayLengthFromCheckBox.isSelected()) {
            this.runwayLengthFrom.setValue(null);
        }
    }

    private void useRunwayLengthToCheckBoxAction() {
        this.runwayLengthTo.setEnabled(this.useRunwayLengthToCheckBox.isSelected());
        if (!this.useRunwayLengthToCheckBox.isSelected()) {
            this.runwayLengthTo.setValue(null);
        }
    }

    private void mountainousAction() {
        if (this.mountainousComboBox != null && this.mountainousComboBox.getSelectedItem() != null) {
            BooleanComboBoxItem sel = (BooleanComboBoxItem)this.mountainousComboBox.getSelectedItem();
            MapObjectsBean.getInstance().getAirportFilter().setMountainous(sel.getValue());
            MapFrame.getInstance().updateMap();
        }
    }

    private void skewedLocAction() {
        if (this.skewedLocComboBox != null && this.skewedLocComboBox.getSelectedItem() != null) {
            BooleanComboBoxItem sel = (BooleanComboBoxItem)this.skewedLocComboBox.getSelectedItem();
            MapObjectsBean.getInstance().getAirportFilter().setWithSkewedIls(sel.getValue());
            MapFrame.getInstance().updateMap();
        }
    }

    private void ilsAction() {
        if (this.withIlsComboBox != null && this.withIlsComboBox.getSelectedItem() != null) {
            BooleanComboBoxItem sel = (BooleanComboBoxItem)this.withIlsComboBox.getSelectedItem();
            MapObjectsBean.getInstance().getAirportFilter().setWithIls(sel.getValue());
            MapFrame.getInstance().updateMap();
        }
    }

    private void vorAction() {
        if (this.withVorComboBox != null && this.withVorComboBox.getSelectedItem() != null) {
            BooleanComboBoxItem sel = (BooleanComboBoxItem)this.withVorComboBox.getSelectedItem();
            MapObjectsBean.getInstance().getAirportFilter().setWithVor(sel.getValue());
            MapFrame.getInstance().updateMap();
        }
    }

    private void ndbAction() {
        if (this.withNdbComboBox != null && this.withNdbComboBox.getSelectedItem() != null) {
            BooleanComboBoxItem sel = (BooleanComboBoxItem)this.withNdbComboBox.getSelectedItem();
            MapObjectsBean.getInstance().getAirportFilter().setWithNdb(sel.getValue());
            MapFrame.getInstance().updateMap();
        }
    }

    private void heliAction() {
        if (this.heliComboBox != null && this.heliComboBox.getSelectedItem() != null) {
            BooleanComboBoxItem sel = (BooleanComboBoxItem)this.heliComboBox.getSelectedItem();
            MapObjectsBean.getInstance().getAirportFilter().setHeli(sel.getValue());
            MapFrame.getInstance().updateMap();
        }
    }

    private void hardenedAction() {
        if (this.hardenedComboBox != null && this.hardenedComboBox.getSelectedItem() != null) {
            BooleanComboBoxItem sel = (BooleanComboBoxItem)this.hardenedComboBox.getSelectedItem();
            MapObjectsBean.getInstance().getAirportFilter().setHardened(sel.getValue());
            MapFrame.getInstance().updateMap();
        }
    }
}

