/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.opengl.painter;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL2;
import javax.media.opengl.awt.GLJPanel;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gl.GlNamedPoint;
import main.java.guru.vfrflight.gui.flightplan.opengl.bean.ProjectionData;
import main.java.guru.vfrflight.gui.flightplan.opengl.painter.GlPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;

public class GlRoutePainter
implements GlPainter {
    private final GlNamedPoint[] route;
    private final GLJPanel mainPanel;
    private ProjectionData projectionData;
    private static final Font WP_LABEL_FONT = new Font("SansSerif", 1, 14);
    private static final BasicStroke BASIC_STROKE_3 = new BasicStroke(3.0f);
    private static final BasicStroke BASIC_STROKE_5 = new BasicStroke(5.0f);
    private float routeBorderColorRed = (float)SettingsBean.getInstance().getColorTheme().getRouteBorderColor().getRed() / 255.0f;
    private float routeBorderColorGreen = (float)SettingsBean.getInstance().getColorTheme().getRouteBorderColor().getGreen() / 255.0f;
    private float routeBorderColorBlue = (float)SettingsBean.getInstance().getColorTheme().getRouteBorderColor().getBlue() / 255.0f;
    private float routeColorRed = (float)SettingsBean.getInstance().getColorTheme().getRouteColor(false).getRed() / 255.0f;
    private float routeColorGreen = (float)SettingsBean.getInstance().getColorTheme().getRouteColor(false).getGreen() / 255.0f;
    private float routeColorBlue = (float)SettingsBean.getInstance().getColorTheme().getRouteColor(false).getBlue() / 255.0f;

    public GlRoutePainter(GlNamedPoint[] route, GLJPanel mainPanel, ProjectionData projectionData) {
        this.route = route;
        this.mainPanel = mainPanel;
        this.projectionData = projectionData;
    }

    @Override
    public void paint3D(GL2 gl, float zScaleFactor) {
        if (this.route.length > 1) {
            int i;
            gl.glLineWidth(4.0f);
            gl.glBegin(1);
            gl.glColor3f(this.routeBorderColorRed, this.routeBorderColorGreen, this.routeBorderColorBlue);
            for (i = 1; i < this.route.length; ++i) {
                gl.glVertex3f(this.route[i - 1].getX(), this.route[i - 1].getY(), this.route[i - 1].getZ() * zScaleFactor);
                gl.glVertex3f(this.route[i].getX(), this.route[i].getY(), this.route[i].getZ() * zScaleFactor);
            }
            gl.glEnd();
            gl.glLineWidth(2.0f);
            gl.glBegin(1);
            gl.glColor3f(this.routeColorRed, this.routeColorGreen, this.routeColorBlue);
            for (i = 1; i < this.route.length; ++i) {
                gl.glVertex3f(this.route[i - 1].getX(), this.route[i - 1].getY(), this.route[i - 1].getZ() * zScaleFactor);
                gl.glVertex3f(this.route[i].getX(), this.route[i].getY(), this.route[i].getZ() * zScaleFactor);
            }
            gl.glEnd();
            gl.glLineWidth(1.0f);
        }
        for (int i = 0; i < this.route.length; ++i) {
            double[] coords = this.projectionData.getScreenCoords(this.route[i].getX(), this.route[i].getY(), this.route[i].getZ() * zScaleFactor);
            this.route[i].setScrX((int)Math.round(coords[0]));
            this.route[i].setScrY((int)Math.round(this.mainPanel.getSize().getHeight() - coords[1]));
        }
    }

    @Override
    public void paint2D(Graphics2D g2d) {
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        for (int i = 0; i < this.route.length; ++i) {
            int x = this.route[i].getScrX();
            int y = this.route[i].getScrY();
            g2d.setColor(SettingsBean.getInstance().getColorTheme().getWpStrokeColor(false));
            g2d.setStroke(BASIC_STROKE_5);
            g2d.drawOval(x - 12, y - 12, 23, 23);
            g2d.setColor(SettingsBean.getInstance().getColorTheme().getWpColor(false));
            g2d.setStroke(BASIC_STROKE_3);
            g2d.drawOval(x - 12, y - 12, 23, 23);
            g2d.setFont(WP_LABEL_FONT);
            FontMetrics fm = g2d.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(this.route[i].getName(), g2d);
            GraphicsUtil.drawOutlinedString(g2d, (int)Math.round((double)x - rect.getWidth() / 2.0), y + 25, this.route[i].getName(), WP_LABEL_FONT, SettingsBean.getInstance().getColorTheme().getWpColor(false), SettingsBean.getInstance().getColorTheme().getWpStrokeColor(false), 3.0f);
        }
    }
}

