/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.opengl.painter;

import java.awt.Graphics2D;
import javax.media.opengl.GL2;
import main.java.guru.vfrflight.core.gl.GlColorPoint;
import main.java.guru.vfrflight.core.gl.GlColorTriangleMesh;
import main.java.guru.vfrflight.gui.flightplan.opengl.painter.GlPainter;

public class GlMeshPainter
implements GlPainter {
    private final GlColorTriangleMesh mesh;
    private Integer texture = null;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private boolean drawTexture = true;

    public GlMeshPainter(GlColorTriangleMesh mesh) {
        this.mesh = mesh;
        this.minX = 1000000.0f;
        this.minY = 1000000.0f;
        this.maxX = -1000000.0f;
        this.maxY = -1000000.0f;
        for (int i = 0; i < mesh.getTriangles().length; ++i) {
            for (int q = 0; q < 3; ++q) {
                GlColorPoint p = mesh.getTriangles()[i].getVertices()[q];
                if (p.getX() < this.minX) {
                    this.minX = p.getX();
                } else if (p.getX() > this.maxX) {
                    this.maxX = p.getX();
                }
                if (p.getY() < this.minY) {
                    this.minY = p.getY();
                    continue;
                }
                if (!(p.getY() > this.maxY)) continue;
                this.maxY = p.getY();
            }
        }
    }

    @Override
    public void paint3D(GL2 gl, float zScaleFactor) {
        boolean doTexture;
        boolean bl = doTexture = this.texture != null && this.drawTexture;
        if (doTexture) {
            gl.glBindTexture(3553, this.texture.intValue());
            gl.glColor3f(1.0f, 1.0f, 1.0f);
        }
        gl.glBegin(4);
        gl.glPointSize(1.0f);
        for (int i = 0; i < this.mesh.getTriangles().length; ++i) {
            gl.glNormal3f(this.mesh.getNormals()[i].getX(), this.mesh.getNormals()[i].getY(), this.mesh.getNormals()[i].getZ());
            for (int q = 0; q < 3; ++q) {
                GlColorPoint p = this.mesh.getTriangles()[i].getVertices()[q];
                if (doTexture) {
                    float x = (p.getX() - this.minX) / (this.maxX - this.minX);
                    float y = (p.getY() - this.minY) / (this.maxY - this.minY);
                    gl.glTexCoord2f(x, y);
                } else {
                    gl.glColor3f(p.getR(), p.getG(), p.getB());
                }
                gl.glVertex3f(p.getX(), p.getY(), p.getZ() * zScaleFactor);
            }
        }
        gl.glEnd();
    }

    @Override
    public void paint2D(Graphics2D g2d) {
    }

    public GlColorTriangleMesh getMesh() {
        return this.mesh;
    }

    public Integer getTexture() {
        return this.texture;
    }

    public void setTexture(Integer texture) {
        this.texture = texture;
    }

    public boolean isDrawTexture() {
        return this.drawTexture;
    }

    public void setDrawTexture(boolean drawTexture) {
        this.drawTexture = drawTexture;
    }
}

