/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.opengl.painter;

import java.awt.Graphics2D;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.media.opengl.GL2;
import main.java.guru.vfrflight.core.gl.GlAirspace;
import main.java.guru.vfrflight.core.gl.GlTriangleMesh;
import main.java.guru.vfrflight.gui.flightplan.opengl.painter.GlPainter;

public class GlAirspacesPainter
implements GlPainter {
    private final GlAirspace[] airspaces;
    private final Map<String, Integer> visibilityLayers;

    public GlAirspacesPainter(GlAirspace[] airspaces) {
        this.airspaces = airspaces;
        this.visibilityLayers = new LinkedHashMap<String, Integer>();
        if (airspaces != null) {
            for (int i = 0; i < airspaces.length; ++i) {
                this.visibilityLayers.put(airspaces[i].getName() + " (" + String.valueOf(airspaces[i].getId()) + ")", i);
            }
        }
    }

    public Map<String, Boolean> getVisibilityTableData() {
        LinkedHashMap<String, Boolean> values = new LinkedHashMap<String, Boolean>();
        for (Map.Entry<String, Integer> pair : this.visibilityLayers.entrySet()) {
            values.put(pair.getKey(), Boolean.TRUE);
        }
        return values;
    }

    public void setVisibility(String key, boolean value) {
        if (this.visibilityLayers.containsKey(key)) {
            this.airspaces[this.visibilityLayers.get(key)].setVisible(value);
        }
    }

    @Override
    public void paint3D(GL2 gl, float zScaleFactor) {
        gl.glLineWidth(3.0f);
        for (int q = 0; q < this.airspaces.length; ++q) {
            if (!this.airspaces[q].isVisible()) continue;
            this.airspaces[q].getColor().enable(gl);
            this.airspaces[q].getLineStroke().enable(gl);
            this.drawAirspaceWireframe(this.airspaces[q], gl, zScaleFactor);
            this.airspaces[q].getLineStroke().disable(gl);
            if (!this.airspaces[q].hasMesh()) continue;
            this.drawAirspaceMesh(this.airspaces[q], gl, zScaleFactor);
        }
    }

    public void drawMesh(GlTriangleMesh mesh, GL2 gl, float zScaleFactor) {
        for (int q = 0; q < mesh.getTriangles().length; ++q) {
            for (int i = 0; i < mesh.getTriangles().length; ++i) {
                gl.glNormal3f(mesh.getNormals()[i].getX(), mesh.getNormals()[i].getY(), mesh.getNormals()[i].getZ());
                for (int j = 0; j < 3; ++j) {
                    gl.glVertex3f(mesh.getTriangles()[i].getVertices()[j].getX(), mesh.getTriangles()[i].getVertices()[j].getY(), mesh.getTriangles()[i].getVertices()[j].getZ() * zScaleFactor);
                }
            }
        }
    }

    public void drawAirspaceMesh(GlAirspace airspace, GL2 gl, float zScaleFactor) {
        gl.glBegin(4);
        airspace.getColor().enable(gl);
        this.drawMesh(airspace.getAirspaceMesh().getSidesMesh(), gl, zScaleFactor);
        gl.glDisable(2929);
        airspace.getBackgroundColor().enable(gl);
        this.drawMesh(airspace.getAirspaceMesh().getBottomMesh(), gl, zScaleFactor);
        this.drawMesh(airspace.getAirspaceMesh().getTopMesh(), gl, zScaleFactor);
        gl.glEnable(2929);
        gl.glEnd();
    }

    private void drawAirspaceWireframe(GlAirspace airspace, GL2 gl, float zScaleFactor) {
        int i;
        gl.glBegin(1);
        int j = 0;
        for (i = 0; i < airspace.getBottom().length; ++i) {
            j = i == 0 ? airspace.getBottom().length - 1 : i - 1;
            gl.glVertex3f(airspace.getBottom()[j].getX(), airspace.getBottom()[j].getY(), airspace.getBottom()[j].getZ() * zScaleFactor);
            gl.glVertex3f(airspace.getBottom()[i].getX(), airspace.getBottom()[i].getY(), airspace.getBottom()[i].getZ() * zScaleFactor);
        }
        for (i = 0; i < airspace.getTop().length; ++i) {
            j = i == 0 ? airspace.getTop().length - 1 : i - 1;
            gl.glVertex3f(airspace.getTop()[j].getX(), airspace.getTop()[j].getY(), airspace.getTop()[j].getZ() * zScaleFactor);
            gl.glVertex3f(airspace.getTop()[i].getX(), airspace.getTop()[i].getY(), airspace.getTop()[i].getZ() * zScaleFactor);
        }
        for (i = 0; i < airspace.getTop().length; ++i) {
            gl.glVertex3f(airspace.getTop()[i].getX(), airspace.getTop()[i].getY(), airspace.getTop()[i].getZ() * zScaleFactor);
            gl.glVertex3f(airspace.getBottom()[i].getX(), airspace.getBottom()[i].getY(), airspace.getBottom()[i].getZ() * zScaleFactor);
        }
        gl.glEnd();
    }

    @Override
    public void paint2D(Graphics2D g2d) {
    }

    public boolean hasAirspaces() {
        return this.airspaces != null && this.airspaces.length > 0;
    }
}

