/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.opengl.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL2;
import javax.media.opengl.awt.GLJPanel;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gl.GlNamedPoint;
import main.java.guru.vfrflight.gui.flightplan.opengl.bean.ProjectionData;
import main.java.guru.vfrflight.gui.flightplan.opengl.painter.GlPainter;
import main.java.guru.vfrflight.util.GraphicsUtil;

public class GlAirportsPainter
implements GlPainter {
    private final GlNamedPoint[] airports;
    private final GLJPanel mainPanel;
    private ProjectionData projectionData;
    private static final Font LABEL_FONT = new Font("SansSerif", 1, 12);

    public GlAirportsPainter(GlNamedPoint[] airports, GLJPanel mainPanel, ProjectionData projectionData) {
        this.airports = airports;
        this.mainPanel = mainPanel;
        this.projectionData = projectionData;
    }

    @Override
    public void paint3D(GL2 gl, float zScaleFactor) {
        if (this.airports != null) {
            for (int i = 0; i < this.airports.length; ++i) {
                double[] coords = this.projectionData.getScreenCoords(this.airports[i].getX(), this.airports[i].getY(), this.airports[i].getZ() * zScaleFactor);
                this.airports[i].setScrX((int)Math.round(coords[0]));
                this.airports[i].setScrY((int)Math.round(this.mainPanel.getSize().getHeight() - coords[1]));
            }
        }
    }

    @Override
    public void paint2D(Graphics2D g2d) {
        GraphicsUtil.setRenderingHints(g2d, SettingsBean.getInstance().getRenderingHintsQuality());
        if (this.airports != null) {
            for (int i = 0; i < this.airports.length; ++i) {
                int x = this.airports[i].getScrX();
                int y = this.airports[i].getScrY();
                Color vorColor = SettingsBean.getInstance().getColorTheme().getAirportColorOnMap(true);
                Color vorStrokeColor = SettingsBean.getInstance().getColorTheme().getAirportStrokeColorOnMap();
                GraphicsUtil.drawAirport(g2d, x, y, 9, null, vorColor, vorStrokeColor);
                if (!SettingsBean.getInstance().isDrawTextLabels() || this.airports[i].getName() == null) continue;
                g2d.setFont(LABEL_FONT);
                FontMetrics fm = g2d.getFontMetrics();
                Rectangle2D rect = fm.getStringBounds(this.airports[i].getName(), g2d);
                if (vorStrokeColor == null) {
                    g2d.drawString(this.airports[i].getName(), (int)Math.round((double)x - rect.getWidth() / 2.0), y + 25);
                    continue;
                }
                GraphicsUtil.drawOutlinedString(g2d, (int)Math.round((double)x - rect.getWidth() / 2.0), y + 25, this.airports[i].getName(), LABEL_FONT, vorColor, vorStrokeColor, 3.0f);
            }
        }
    }
}

