/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.opengl;

import com.jogamp.opengl.util.FPSAnimator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.flightplan.opengl.OpenGlTerrainCanvas;
import main.java.guru.vfrflight.gui.table.OpenGlVisibilityDataTable;

public class OpenGlViewerFrame
extends JFrame {
    private static final long serialVersionUID = -4758879278600274044L;
    private static final int FPS = 30;
    private final FPSAnimator animator;
    private JSlider slider;
    private JLabel sliderLabel;
    private OpenGlTerrainCanvas canvas;
    private JPanel terrainPanel;
    private JPanel sliderPanel;
    private OpenGlVisibilityDataTable airspaceVisibilityDataTable;
    private JPanel panel;
    private JPanel airspacesPanel;
    private JPanel bottomPanel;
    private JCheckBox drawTextureCheckBox;

    public OpenGlViewerFrame(OpenGlTerrainCanvas c) {
        this.canvas = c;
        this.animator = new FPSAnimator((GLAutoDrawable)this.canvas, 30, true);
        JPanel contentPanel = new JPanel(new BorderLayout());
        this.terrainPanel = new JPanel();
        this.terrainPanel.add((Component)((Object)this.canvas));
        contentPanel.add((Component)this.terrainPanel, "Center");
        this.getContentPane().add(contentPanel);
        this.panel = new JPanel();
        contentPanel.add((Component)this.panel, "East");
        this.panel.setLayout(new BorderLayout(0, 0));
        this.sliderPanel = new JPanel();
        this.panel.add((Component)this.sliderPanel, "North");
        this.sliderPanel.setLayout(new BorderLayout(0, 0));
        this.sliderLabel = new JLabel();
        this.sliderLabel.setHorizontalAlignment(0);
        this.sliderPanel.add((Component)this.sliderLabel, "North");
        boolean hasAirspaces = this.canvas.getAirspacesPainter() != null && this.canvas.getAirspacesPainter().hasAirspaces();
        this.slider = new JSlider(hasAirspaces ? 0 : 1, -9, 18, 0);
        this.slider.setMinorTickSpacing(1);
        this.slider.setMajorTickSpacing(27);
        this.slider.setPaintTicks(true);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                OpenGlViewerFrame.this.changeSliderAction();
            }
        });
        this.sliderPanel.add(this.slider);
        this.bottomPanel = new JPanel();
        contentPanel.add((Component)this.bottomPanel, "South");
        this.drawTextureCheckBox = new JCheckBox(Messages.getInstance().get("opengl_terrain_frame_draw_texture"), this.canvas.isDrawTexture());
        this.drawTextureCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OpenGlViewerFrame.this.canvas.setDrawTexture(OpenGlViewerFrame.this.drawTextureCheckBox.isSelected());
            }
        });
        this.bottomPanel.add(this.drawTextureCheckBox);
        if (this.canvas.getAirspacesPainter() != null && this.canvas.getAirspacesPainter().hasAirspaces()) {
            this.airspacesPanel = new JPanel();
            this.airspacesPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            this.airspaceVisibilityDataTable = new OpenGlVisibilityDataTable(this, this.canvas.getAirspacesPainter().getVisibilityTableData());
            this.airspaceVisibilityDataTable.setSize(1000, 200);
            this.airspacesPanel.add(this.airspaceVisibilityDataTable);
            this.panel.add((Component)this.airspacesPanel, "Center");
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OpenGlViewerFrame.this.closeAction();
            }
        });
        this.setTitle(Messages.getInstance().get("opengl_terrain_frame_title"));
        this.pack();
        this.animator.start();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(Math.round((dim.width - this.getWidth()) / 2), Math.round((dim.height - this.getHeight()) / 2));
        this.updateLabel();
        this.setViewerBounds();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OpenGlViewerFrame.this.setViewerBounds();
            }
        });
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    public void setViewerBounds() {
        this.canvas.setPreferredSize(new Dimension(this.terrainPanel.getWidth() - 10, this.terrainPanel.getHeight() - 10));
        this.terrainPanel.revalidate();
    }

    public void closeAction() {
        new Thread(){

            @Override
            public void run() {
                if (OpenGlViewerFrame.this.animator.isStarted()) {
                    OpenGlViewerFrame.this.animator.stop();
                }
                OpenGlViewerFrame.this.setVisible(false);
                System.gc();
            }
        }.start();
    }

    public void changeSliderAction() {
        this.updateLabel();
        this.canvas.setzScaleFactor(this.getZScaleFactor());
    }

    public float getZScaleFactor() {
        return this.slider.getValue() <= 0 ? (float)(this.slider.getValue() + 10) / 10.0f : (float)(this.slider.getValue() + 2) / 2.0f;
    }

    public void updateLabel() {
        this.sliderLabel.setText("x" + String.valueOf(this.getZScaleFactor()));
    }

    public void visibilityTableAction(String key, boolean value) {
        this.canvas.getAirspacesPainter().setVisibility(key, value);
    }
}

