/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.opengl;

import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureIO;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLJPanel;
import javax.media.opengl.glu.GLU;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gl.GlTerrainData;
import main.java.guru.vfrflight.gui.flightplan.opengl.bean.ProjectionData;
import main.java.guru.vfrflight.gui.flightplan.opengl.painter.GlAirportsPainter;
import main.java.guru.vfrflight.gui.flightplan.opengl.painter.GlAirspacesPainter;
import main.java.guru.vfrflight.gui.flightplan.opengl.painter.GlMeshPainter;
import main.java.guru.vfrflight.gui.flightplan.opengl.painter.GlPainter;
import main.java.guru.vfrflight.gui.flightplan.opengl.painter.GlRoutePainter;
import main.java.guru.vfrflight.gui.flightplan.opengl.painter.GlUserTrackPainter;
import main.java.guru.vfrflight.util.IO.IOUtil;
import org.apache.log4j.Logger;

public class OpenGlTerrainCanvas
extends GLJPanel
implements GLEventListener,
MouseWheelListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final Logger log = Logger.getLogger(OpenGlTerrainCanvas.class);
    private List<GlPainter> painters = new ArrayList<GlPainter>();
    private boolean wireframe = false;
    private boolean staticCamera = true;
    private int prevMouseX = 0;
    private int prevMouseY = 0;
    private boolean mousePressed = false;
    private float rotationAngleX = -45.0f;
    private float rotationAngleY = -45.0f;
    private float zoom = -10000.0f;
    private float positionX = 0.0f;
    private float positionY = 0.0f;
    private ProjectionData projectionData = new ProjectionData();
    private static final Font INFO_LABEL_FONT = new Font("Monospaced", 0, 11);
    private float zScaleFactor = 1.0f;
    private GlAirspacesPainter airspacesPainter;
    private GlMeshPainter meshPainter;

    public OpenGlTerrainCanvas(GlTerrainData data) {
        if (data.getMesh() != null) {
            this.meshPainter = new GlMeshPainter(data.getMesh());
            this.painters.add(this.meshPainter);
        }
        if (data.getRoute() != null && data.getRoute().length > 0) {
            this.painters.add(new GlRoutePainter(data.getRoute(), this, this.projectionData));
        }
        if (data.getUserTrack() != null && data.getUserTrack().length > 1) {
            this.painters.add(new GlUserTrackPainter(data.getUserTrack()));
        }
        if (data.getAirspaces() != null && data.getAirspaces().length > 0) {
            this.airspacesPainter = new GlAirspacesPainter(data.getAirspaces());
            this.painters.add(this.airspacesPainter);
        }
        if (data.getAirports() != null && data.getAirports().length > 0) {
            this.painters.add(new GlAirportsPainter(data.getAirports(), this, this.projectionData));
        }
        this.addGLEventListener(this);
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    private Texture loadTexture(String fileName, GL2 gl) {
        Texture tex = null;
        try {
            tex = TextureIO.newTexture((File)new File(fileName), (boolean)true);
            tex.setTexParameteri((GL)gl, 10240, 9729);
            tex.setTexParameteri((GL)gl, 10241, 9987);
        }
        catch (IOException e) {
            log.error("Error loading texture " + fileName, e);
        }
        return tex;
    }

    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        this.projectionData.setGlu(new GLU());
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClearDepth(1.0);
        gl.glEnable(2929);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4354);
        gl.glHint(3155, 4354);
        gl.glHint(3154, 4354);
        gl.glHint(35723, 4354);
        gl.glShadeModel(7425);
        gl.glEnable(2903);
        gl.glEnable(2848);
        gl.glEnable(3042);
        gl.glBlendFunc(770, 771);
        this.setUpLighting(gl);
        gl.glEnable(2896);
        gl.glEnable(16384);
        if (this.wireframe) {
            gl.glPolygonMode(1032, 6913);
        }
        if (this.meshPainter != null) {
            Texture tex = this.loadTexture("tmp/tex.png", gl);
            if (tex != null) {
                IOUtil.deleteFile("tmp/tex.png");
                this.meshPainter.setTexture(tex.getTextureObject((GL)gl));
            }
            gl.glEnable(3553);
        }
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        GL2 gl = drawable.getGL().getGL2();
        if (height == 0) {
            height = 1;
        }
        float aspect = (float)width / (float)height;
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        if (this.staticCamera) {
            this.projectionData.getGlu().gluPerspective(1.0f, aspect, 100.0f, 25000.0f);
        } else {
            this.projectionData.getGlu().gluPerspective(1.0f, aspect, 100.0f, 1000.0f);
        }
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClear(16640);
        gl.glLoadIdentity();
        this.translateStaticScene(gl);
        gl.glGetIntegerv(2978, this.projectionData.getViewport(), 0);
        gl.glGetDoublev(2982, this.projectionData.getModelview(), 0);
        gl.glGetDoublev(2983, this.projectionData.getProjection(), 0);
        for (GlPainter painter : this.painters) {
            painter.paint3D(gl, this.zScaleFactor);
        }
        gl.glFlush();
    }

    private void setUpLighting(GL2 gl) {
        float[] mat_specular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] mat_shininess = new float[]{15.0f};
        float[] light_position = new float[]{0.0f, 0.0f, -300.0f, 0.0f};
        gl.glMaterialfv(1028, 4610, mat_specular, 0);
        gl.glMaterialfv(1028, 5633, mat_shininess, 0);
        gl.glLightfv(16384, 4611, light_position, 0);
    }

    private void translateStaticScene(GL2 gl) {
        gl.glTranslatef(this.positionX, this.positionY, this.zoom);
        gl.glRotatef(this.rotationAngleY, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(this.rotationAngleX, 0.0f, 0.0f, 1.0f);
    }

    public void dispose(GLAutoDrawable drawable) {
    }

    private float getZoomFactor() {
        return (float)Math.floor(Math.abs(this.zoom / 40.0f) + 1.0f);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.zoom(e.getWheelRotation());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mousePressed) {
            float dx = this.prevMouseX - e.getX();
            float dy = this.prevMouseY - e.getY();
            if (e.getModifiers() == 16) {
                this.move(dx, dy);
            } else if (e.getModifiers() == 4) {
                this.rotate(dx, dy);
            }
        }
        this.mousePressed = true;
        this.prevMouseX = e.getX();
        this.prevMouseY = e.getY();
    }

    private void zoom(float factor) {
        this.zoom -= factor * (this.getZoomFactor() * 2.0f);
        if (this.zoom > 0.0f) {
            this.zoom = 0.0f;
        }
        this.repaint();
    }

    private void rotate(float dx, float dy) {
        this.rotationAngleX -= dx / 15.0f;
        this.rotationAngleY -= dy / 15.0f;
        this.repaint();
    }

    private void move(float dx, float dy) {
        float speedRatio = (float)Math.pow(this.getZoomFactor(), 1.2) / 500.0f / ((float)(this.getSize().getWidth() + this.getSize().getHeight()) / 700.0f);
        this.positionX -= dx * speedRatio;
        this.positionY += dy * speedRatio;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.mousePressed = false;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        for (GlPainter painter : this.painters) {
            painter.paint2D(g2d);
        }
        g2d.setColor(Color.WHITE);
        g2d.setFont(INFO_LABEL_FONT);
        String txt = Messages.getInstance().get("opengl_terrain_frame_info");
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D rect = fm.getStringBounds(txt, g2d);
        g2d.drawString(txt, (int)(this.getSize().getWidth() - rect.getWidth() - 5.0), (int)(this.getSize().getHeight() - 5.0));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 65) {
            this.move(2.0f, 0.0f);
        } else if (e.getKeyCode() == 68) {
            this.move(-2.0f, 0.0f);
        } else if (e.getKeyCode() == 87) {
            this.move(0.0f, 2.0f);
        } else if (e.getKeyCode() == 83) {
            this.move(0.0f, -2.0f);
        } else if (e.getKeyCode() == 81) {
            this.rotate(-7.0f, 0.0f);
        } else if (e.getKeyCode() == 69) {
            this.rotate(7.0f, 0.0f);
        } else if (e.getKeyCode() == 82) {
            this.rotate(0.0f, 4.0f);
        } else if (e.getKeyCode() == 70) {
            this.rotate(0.0f, -4.0f);
        } else if (e.getKeyCode() == 90) {
            this.zoom(-0.2f);
        } else if (e.getKeyCode() == 88) {
            this.zoom(0.2f);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public float getzScaleFactor() {
        return this.zScaleFactor;
    }

    public void setzScaleFactor(float zScaleFactor) {
        this.zScaleFactor = zScaleFactor;
    }

    public GlAirspacesPainter getAirspacesPainter() {
        return this.airspacesPainter;
    }

    public void setAirspacesPainter(GlAirspacesPainter airspacesPainter) {
        this.airspacesPainter = airspacesPainter;
    }

    public void setDrawTexture(boolean drawTexture) {
        if (this.meshPainter != null) {
            this.meshPainter.setDrawTexture(drawTexture);
        }
    }

    public boolean isDrawTexture() {
        if (this.meshPainter != null) {
            return this.meshPainter.isDrawTexture();
        }
        return false;
    }
}

