/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.map;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.map.EditMapTypeDialog;
import main.java.guru.vfrflight.gui.map.tilefactory.util.TileFactoryInfoUtil;
import main.java.guru.vfrflight.gui.swing.list.MapTypesListModel;

public class MapTypesDialog
extends JDialog {
    private static final long serialVersionUID = 2132256883676656000L;
    private JPanel layoutPdf;
    private JList<String> sectionsList;

    public MapTypesDialog(Window frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MapTypesDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("map_type_edit_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)buttonPanel, "South");
        JButton eksportujButton = new JButton(Messages.getInstance().get("ok_button"));
        eksportujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapTypesDialog.this.saveAction();
            }
        });
        buttonPanel.add(eksportujButton);
        JButton anulujButton = new JButton(Messages.getInstance().get("cancel_button"));
        anulujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapTypesDialog.this.cancelAction();
            }
        });
        buttonPanel.add(anulujButton);
        this.layoutPdf = new JPanel();
        panel.add((Component)this.layoutPdf, "Center");
        this.layoutPdf.setLayout(new BorderLayout(0, 0));
        JPanel jlistPanel = new JPanel();
        this.layoutPdf.add((Component)jlistPanel, "Center");
        jlistPanel.setLayout(new BorderLayout(0, 0));
        JPanel listWrapperPanel = new JPanel();
        listWrapperPanel.setBorder(new CompoundBorder(new EmptyBorder(10, 50, 10, 50), new EtchedBorder(1, null, null)));
        jlistPanel.add((Component)listWrapperPanel, "Center");
        listWrapperPanel.setLayout(new BorderLayout(0, 0));
        this.sectionsList = new JList();
        JScrollPane scrollPane = new JScrollPane(22, 30);
        scrollPane.setViewportView(this.sectionsList);
        listWrapperPanel.add(scrollPane);
        JPanel listButtonPanel = new JPanel();
        this.layoutPdf.add((Component)listButtonPanel, "South");
        JButton upButton = new JButton("^^^");
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int idx = MapTypesDialog.this.sectionsList.getSelectedIndex();
                if (MapTypesDialog.this.getListModel().moveUp(idx)) {
                    MapTypesDialog.this.sectionsList.setSelectedIndex(idx - 1);
                }
            }
        });
        listButtonPanel.add(upButton);
        JButton addButton = new JButton(Messages.getInstance().get("add_button"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EditMapTypeDialog addDialog = new EditMapTypeDialog((Window)MapTypesDialog.this, null);
                addDialog.setVisible(true);
                if (addDialog.isSaveClicked()) {
                    int idx = MapTypesDialog.this.sectionsList.getSelectedIndex();
                    if (idx >= 0) {
                        MapTypesDialog.this.getListModel().addType(idx + 1, addDialog.getResult());
                        MapTypesDialog.this.sectionsList.setSelectedIndex(idx + 1);
                    } else {
                        MapTypesDialog.this.getListModel().addType(addDialog.getResult());
                    }
                }
            }
        });
        listButtonPanel.add(addButton);
        JButton deleteButton = new JButton(Messages.getInstance().get("delete_button"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapTypesDialog.this.sectionsList.getSelectedIndex() >= 0) {
                    MapTypesDialog.this.getListModel().remove(MapTypesDialog.this.sectionsList.getSelectedIndex());
                }
            }
        });
        JButton editButton = new JButton(Messages.getInstance().get("edit_button"));
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int idx = MapTypesDialog.this.sectionsList.getSelectedIndex();
                if (idx >= 0) {
                    EditMapTypeDialog addDialog = new EditMapTypeDialog((Window)MapTypesDialog.this, MapTypesDialog.this.getListModel().getTypes().get(idx));
                    addDialog.setVisible(true);
                    if (addDialog.isSaveClicked()) {
                        MapTypesDialog.this.getListModel().remove(idx);
                        MapTypesDialog.this.getListModel().addType(idx, addDialog.getResult());
                    }
                }
            }
        });
        listButtonPanel.add(editButton);
        listButtonPanel.add(deleteButton);
        JButton downButton = new JButton("vvv");
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = MapTypesDialog.this.sectionsList.getSelectedIndex();
                if (MapTypesDialog.this.getListModel().moveDown(idx)) {
                    MapTypesDialog.this.sectionsList.setSelectedIndex(idx + 1);
                }
            }
        });
        listButtonPanel.add(downButton);
        this.updateValues();
        this.setModal(true);
        this.setSize(400, 341);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    public void updateValues() {
        this.sectionsList.setModel(new MapTypesListModel(MapFrame.getInstance().getTileFactoriesInfo()));
    }

    private MapTypesListModel getListModel() {
        return (MapTypesListModel)this.sectionsList.getModel();
    }

    public void closeWindowAction() {
        this.setVisible(false);
    }

    public void cancelAction() {
        this.closeWindowAction();
    }

    public void saveAction() {
        if (this.doValidate()) {
            TileFactoryInfoUtil.save("data/maps.dat", this.getListModel().getTypes());
            MapFrame.getInstance().setTileFactoriesInfo(this.getListModel().getTypes());
            MapFrame.getInstance().updateMapTypeComboValues();
            this.closeWindowAction();
        }
    }

    public boolean doValidate() {
        return true;
    }
}

