/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.map;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.map.GpsMapImagePanel;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.gui.swing.panel.image.CenteredImagePanel;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import org.apache.log4j.Logger;

public class GpsMap
implements MouseListener,
MouseWheelListener,
MouseMotionListener,
KeyListener {
    private static final Logger log = Logger.getLogger(GpsMap.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final GpsMapImagePanel imagePanel;
    private final SimConnectUpdateMapTask task;
    private static final double[] ZOOM_LEVELS = new double[]{0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0};
    private int currentZoomLevel = 5;
    private int[] mapZoomsForZoomLevel = new int[ZOOM_LEVELS.length];
    private static final double RADIUS_MARGIN = 0.2;
    private static final Font LABEL_FONT = new Font("SansSerif", 1, 18);
    private static final Font BEARING_LABEL_FONT = new Font("SansSerif", 1, 25);
    private boolean running = false;

    public GpsMap(boolean drawOverlay) {
        this.imagePanel = new GpsMapImagePanel();
        this.task = new SimConnectUpdateMapTask(this.imagePanel, MapFrame.getInstance().getMapViewer(), drawOverlay);
        this.recalculateZooms();
        this.imagePanel.addMouseWheelListener(this);
        this.imagePanel.addMouseListener(this);
        this.imagePanel.addMouseMotionListener(this);
        this.imagePanel.addKeyListener(this);
    }

    private void recalculateZooms() {
        VfrMapViewer map = MapFrame.getInstance().getMapViewer();
        GpsPlace center = this.task.getCenter();
        if (center == null) {
            center = new GpsPlace(0.0, 0.0);
        }
        Dimension containerSize = map.getSize();
        containerSize.setSize(containerSize.getWidth() * 0.8, containerSize.getHeight() * 0.8);
        int minZoom = map.getTileFactory().getInfo().getMinimumZoomLevel();
        int maxZoom = map.getTileFactory().getInfo().getMaximumZoomLevel();
        for (int i = 0; i < ZOOM_LEVELS.length; ++i) {
            double distInNm = ZOOM_LEVELS[i] * 1.2;
            if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                distInNm = UnitUtil.recalculateDistance(distInNm, SettingsBean.getInstance().getParamUnitsDistance(), "nm", false);
            }
            GpsPlace topLeft = GpsUtil.getPointPositionByDistanceAndBearing(center, 315.0, Math.sqrt(2.0) * distInNm);
            GpsPlace right = GpsUtil.getPointPositionByDistanceAndBearing(center, 90.0, distInNm);
            GpsPlace bottom = GpsUtil.getPointPositionByDistanceAndBearing(center, 180.0, distInNm * 0.2);
            GpsArea area = new GpsArea(topLeft, new GpsPlace(bottom.getLat(), right.getLon()));
            long minError = Long.MAX_VALUE;
            int foundZoom = minZoom;
            for (int z = minZoom; z < maxZoom; ++z) {
                Dimension mapSize = area.getSize(map, z);
                long error = (long)(Math.pow(mapSize.getWidth() - containerSize.getWidth(), 2.0) + Math.pow(mapSize.getHeight() - containerSize.getHeight(), 2.0));
                if (error >= minError) continue;
                minError = error;
                foundZoom = z;
            }
            this.mapZoomsForZoomLevel[i] = foundZoom--;
            if (minZoom < maxZoom) continue;
            ++foundZoom;
        }
    }

    public void start() {
        if (!this.running) {
            MapFrame.getInstance().getUIPanel().hidePanel();
            MapFrame.getInstance().setMapLayersToolbarEnabled(true);
            MapFrame.getInstance().getGpsModeButton().setEnabled(true);
            MapFrame.getInstance().getAlwaysOnTopButton().setEnabled(true);
            MapFrame.getInstance().getFullscreenButton().setEnabled(true);
            MapFrame.getInstance().getMapViewer().setStopDrawing(true);
            MapFrame.getInstance().addToMiddlePanel(this.imagePanel);
            int intervalMs = SettingsBean.getInstance().getSimConnectConfigBean().getInterval();
            if (intervalMs < 250) {
                intervalMs = 250;
            }
            this.scheduler.scheduleAtFixedRate(this.task, 0L, intervalMs, TimeUnit.MILLISECONDS);
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            this.scheduler.shutdown();
            if (this.imagePanel.getFullScreenButton() != null) {
                this.imagePanel.getFullScreenButton().actionPerformed();
            }
            SettingsBean.getInstance().setTextLabelsRotationAngle(null);
            MapFrame.getInstance().getMapViewer().setStopDrawing(false);
            MapFrame.getInstance().addMapViewerToMiddlePanel();
            MapFrame.getInstance().getUIPanel().showPanel();
            MapFrame.getInstance().updateMap();
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.doZoom(e.getWheelRotation());
    }

    private void doZoom(int dz) {
        this.currentZoomLevel += dz;
        if (this.currentZoomLevel < 0) {
            this.currentZoomLevel = 0;
        } else if (this.currentZoomLevel >= ZOOM_LEVELS.length) {
            this.currentZoomLevel = ZOOM_LEVELS.length - 1;
        }
        this.recalculateZooms();
    }

    public void invalidate() {
        JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("gps_map_connection_error"), "", 0);
        MapFrame.getInstance().getGpsModeButton().doClick();
        MapFrame.getInstance().getGpsModeButton().toggle();
        this.stop();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.imagePanel.getFullScreenButton() != null && this.imagePanel.getFullScreenButton().contains(e.getX(), e.getY(), this.imagePanel.getSize())) {
            this.imagePanel.getFullScreenButton().actionPerformed();
        } else if (SettingsBean.getInstance().isTouchScreenMode()) {
            if (e.getX() <= (int)Math.round((double)this.imagePanel.getWidth() / 2.0)) {
                this.doZoom(-1);
            } else {
                this.doZoom(1);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public GpsMapImagePanel getImagePanel() {
        return this.imagePanel;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.imagePanel.getFullScreenButton() != null && this.imagePanel.getFullScreenButton().contains(e.getX(), e.getY(), this.imagePanel.getSize())) {
            this.imagePanel.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.imagePanel.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && this.imagePanel.getFullScreenButton() != null) {
            this.imagePanel.getFullScreenButton().actionPerformed();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private abstract class UpdateMapTask
    implements Runnable {
        private final CenteredImagePanel containerPanel;
        protected final VfrMapViewer map;
        private int invalidDataCounter = 0;
        private final boolean drawOverlay;

        public UpdateMapTask(CenteredImagePanel containerPanel, VfrMapViewer map, boolean drawOverlay) {
            this.containerPanel = containerPanel;
            this.map = map;
            this.drawOverlay = drawOverlay;
        }

        @Override
        public void run() {
            try {
                if (this.isValid() && SettingsBean.getInstance().isConnectedToSim()) {
                    this.invalidDataCounter = 0;
                    Double bearing = this.getBearing();
                    SettingsBean.getInstance().setTextLabelsRotationAngle(bearing);
                    double distInNm = this.getSizeInNm();
                    if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                        distInNm = UnitUtil.recalculateDistance(distInNm, SettingsBean.getInstance().getParamUnitsDistance(), "nm", false);
                    }
                    BufferedImage img = MapUtil.getMapAreaRotatedByBearing(this.map, this.getCenter(), bearing, Math.sqrt(2.0) * distInNm * 1.2, this.getZoom());
                    Graphics2D g = (Graphics2D)img.getGraphics();
                    GraphicsUtil.setRenderingHints(g, SettingsBean.getInstance().getRenderingHintsQuality());
                    g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.25f));
                    g.setStroke(new BasicStroke(3.0f));
                    g.drawLine((int)Math.round((double)img.getWidth() / 2.0), 0, (int)Math.round((double)img.getWidth() / 2.0), (int)Math.round((double)img.getHeight() / 2.0));
                    Double magvar = this.getMagvar();
                    double angle = 0.0;
                    if (magvar != null) {
                        angle = -bearing.doubleValue() + magvar;
                        GraphicsUtil.drawBoxedCenteredString(g, FormatUtil.formattedCourse(bearing - magvar, true), (int)Math.round((double)img.getWidth() / 2.0), (int)Math.round((double)img.getHeight() * 0.05), BEARING_LABEL_FONT, Color.WHITE, Color.BLACK, 4);
                    }
                    if (this.drawOverlay && magvar != null) {
                        Double gs;
                        int radius = (int)Math.round((double)img.getWidth() * 0.8 * 0.5);
                        int cx = (int)Math.round((double)img.getWidth() / 2.0);
                        int cy = (int)Math.round((double)img.getHeight() / 2.0);
                        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
                        g.setStroke(new BasicStroke(5.0f));
                        GraphicsUtil.drawVorCircle(g, cx, cy, radius, angle, false, false);
                        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.25f));
                        g.setStroke(new BasicStroke(1.0f));
                        GraphicsUtil.drawVorCircle(g, cx, cy, radius, angle, true, false);
                        g.setColor(Color.RED);
                        g.setStroke(new BasicStroke(3.0f));
                        GraphicsUtil.drawVorCircle(g, cx, cy, radius, angle, false, true);
                        String radTxt = ZOOM_LEVELS[GpsMap.this.currentZoomLevel] < 1.0 ? String.valueOf(NumberUtil.roundDouble(ZOOM_LEVELS[GpsMap.this.currentZoomLevel], 1)) : String.valueOf((int)Math.round(ZOOM_LEVELS[GpsMap.this.currentZoomLevel]));
                        GraphicsUtil.drawBoxedCenteredString(g, " " + radTxt + SettingsBean.getInstance().getParamUnitsDistance() + " ", (int)Math.round((double)img.getWidth() * 0.35), (int)Math.round((double)img.getHeight() * 0.55), LABEL_FONT, Color.WHITE, Color.BLACK, 3);
                        Double amsl = this.getAltAmsl();
                        if (amsl != null) {
                            if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                                amsl = UnitUtil.recalculateAltitude(amsl, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
                            }
                            GraphicsUtil.drawBoxedCenteredString(g, (int)Math.round(amsl) + " " + SettingsBean.getInstance().getParamUnitsAltitude(), (int)Math.round((double)img.getWidth() / 2.0), (int)Math.round((double)img.getHeight() * 0.55), LABEL_FONT, Color.WHITE, Color.BLACK, 3);
                        }
                        if ((gs = this.getGs()) != null) {
                            if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
                                gs = UnitUtil.recalculateSpeed(gs, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false);
                            }
                            GraphicsUtil.drawBoxedCenteredString(g, "GS " + (int)Math.round(gs) + " " + SettingsBean.getInstance().getParamUnitsSpeed(), (int)Math.round((double)img.getWidth() * 0.65), (int)Math.round((double)img.getHeight() * 0.55), LABEL_FONT, Color.WHITE, Color.BLACK, 3);
                        }
                    }
                    GraphicsUtil.drawUserPlaneTop(g, (int)Math.round((double)img.getWidth() / 2.0), (int)Math.round((double)img.getHeight() / 2.0), Float.valueOf(0.0f), 4, false);
                    g.dispose();
                    img = img.getSubimage(0, 0, img.getWidth(), (int)Math.round((double)img.getHeight() * 0.6));
                    this.containerPanel.setImage(img);
                } else {
                    ++this.invalidDataCounter;
                    if (this.invalidDataCounter >= 10) {
                        log.error("Invalid data or not connected to sim. Closing session.");
                        GpsMap.this.invalidate();
                    }
                }
            }
            catch (Exception e) {
                log.error(e, e);
            }
        }

        private boolean isValid() {
            return this.getCenter() != null && this.getBearing() != null;
        }

        public abstract Double getBearing();

        public abstract double getSizeInNm();

        public abstract int getZoom();

        public abstract GpsPlace getCenter();

        public abstract Double getMagvar();

        public abstract Double getGs();

        public abstract Double getAltAmsl();
    }

    private class SimConnectUpdateMapTask
    extends UpdateMapTask {
        private double lastBearing;

        public SimConnectUpdateMapTask(CenteredImagePanel containerPanel, VfrMapViewer map, boolean drawOverlay) {
            super(containerPanel, map, drawOverlay);
            this.lastBearing = 0.0;
        }

        @Override
        public Double getBearing() {
            if (SimConnectUtil.getInstance().getExtConnectBean() == null) {
                return null;
            }
            if (SimConnectUtil.getInstance().getExtConnectBean().getUserTrueHeading() == null) {
                return this.lastBearing;
            }
            this.lastBearing = SimConnectUtil.getInstance().getExtConnectBean().getUserTrueHeading().doubleValue();
            return this.lastBearing;
        }

        @Override
        public double getSizeInNm() {
            return ZOOM_LEVELS[GpsMap.this.currentZoomLevel];
        }

        @Override
        public int getZoom() {
            return GpsMap.this.mapZoomsForZoomLevel[GpsMap.this.currentZoomLevel];
        }

        @Override
        public GpsPlace getCenter() {
            if (SimConnectUtil.getInstance().getExtConnectBean() == null) {
                return null;
            }
            return SimConnectUtil.getInstance().getExtConnectBean().getGpsPlace();
        }

        @Override
        public Double getMagvar() {
            GpsPlace place = this.getCenter();
            if (place == null) {
                return null;
            }
            return SettingsBean.getInstance().getDeclinationCalculator().getMagneticDeclination(place);
        }

        @Override
        public Double getGs() {
            if (SimConnectUtil.getInstance().getExtConnectBean() == null || SimConnectUtil.getInstance().getExtConnectBean().getUserGs() == null) {
                return null;
            }
            return SimConnectUtil.getInstance().getExtConnectBean().getUserGs().doubleValue();
        }

        @Override
        public Double getAltAmsl() {
            if (SimConnectUtil.getInstance().getExtConnectBean() == null || SimConnectUtil.getInstance().getExtConnectBean().getUserAlt() == null) {
                return null;
            }
            return SimConnectUtil.getInstance().getExtConnectBean().getUserAlt().doubleValue();
        }
    }
}

