/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.map;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoFactory;
import main.java.guru.vfrflight.gui.map.tilefactory.TileFactoryInfoType;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class EditMapTypeDialog
extends JDialog {
    private static final long serialVersionUID = -7096272207684031035L;
    private JPanel contentPanel;
    private JTextField nameTextField;
    private JTextField urlTextField;
    private JTextField copyrightNoticeTextField;
    private JTextField copyrightLinkTextField;
    private JComboBox<StringComboBoxItem> typeComboBox;
    private TileFactoryInfo result = null;
    private boolean saveClicked = false;

    public EditMapTypeDialog(Window frame, TileFactoryInfo record) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                EditMapTypeDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("map_type_edit_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.result = record;
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)buttonPanel, "South");
        JButton saveButton = new JButton(Messages.getInstance().get("ok_button"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMapTypeDialog.this.saveAction();
            }
        });
        buttonPanel.add(saveButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMapTypeDialog.this.cancelAction();
            }
        });
        buttonPanel.add(cancelButton);
        this.contentPanel = new JPanel();
        panel.add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel_7 = new JPanel();
        panel_7.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.contentPanel.add((Component)panel_7, "Center");
        GridBagLayout gbl_panel_7 = new GridBagLayout();
        gbl_panel_7.columnWidths = new int[]{104, 460, 0};
        gbl_panel_7.rowHeights = new int[]{20, 20, 20, 20, 0};
        gbl_panel_7.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_7.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel_7.setLayout(gbl_panel_7);
        JLabel nameLabel = new JLabel(Messages.getInstance().get("map_type_edit_name_label"));
        GridBagConstraints gbc_nameLabel = new GridBagConstraints();
        gbc_nameLabel.anchor = 11;
        gbc_nameLabel.fill = 2;
        gbc_nameLabel.insets = new Insets(0, 0, 5, 5);
        gbc_nameLabel.gridx = 0;
        gbc_nameLabel.gridy = 0;
        panel_7.add((Component)nameLabel, gbc_nameLabel);
        this.nameTextField = new JTextField();
        GridBagConstraints gbc_nameTextField = new GridBagConstraints();
        gbc_nameTextField.anchor = 11;
        gbc_nameTextField.fill = 2;
        gbc_nameTextField.insets = new Insets(0, 0, 5, 0);
        gbc_nameTextField.gridx = 1;
        gbc_nameTextField.gridy = 0;
        panel_7.add((Component)this.nameTextField, gbc_nameTextField);
        this.nameTextField.setColumns(40);
        JLabel urlLabel = new JLabel(Messages.getInstance().get("map_type_edit_url_label"));
        GridBagConstraints gbc_urlLabel = new GridBagConstraints();
        gbc_urlLabel.anchor = 11;
        gbc_urlLabel.fill = 2;
        gbc_urlLabel.insets = new Insets(0, 0, 5, 5);
        gbc_urlLabel.gridx = 0;
        gbc_urlLabel.gridy = 1;
        panel_7.add((Component)urlLabel, gbc_urlLabel);
        this.urlTextField = new JTextField();
        GridBagConstraints gbc_urlTextField = new GridBagConstraints();
        gbc_urlTextField.anchor = 11;
        gbc_urlTextField.fill = 2;
        gbc_urlTextField.insets = new Insets(0, 0, 5, 0);
        gbc_urlTextField.gridx = 1;
        gbc_urlTextField.gridy = 1;
        panel_7.add((Component)this.urlTextField, gbc_urlTextField);
        this.urlTextField.setColumns(40);
        JLabel copyrightNoticeLabel = new JLabel(Messages.getInstance().get("map_type_edit_copyright_notice_label"));
        GridBagConstraints gbc_copyrightNoticeLabel = new GridBagConstraints();
        gbc_copyrightNoticeLabel.anchor = 11;
        gbc_copyrightNoticeLabel.fill = 2;
        gbc_copyrightNoticeLabel.insets = new Insets(0, 0, 5, 5);
        gbc_copyrightNoticeLabel.gridx = 0;
        gbc_copyrightNoticeLabel.gridy = 2;
        panel_7.add((Component)copyrightNoticeLabel, gbc_copyrightNoticeLabel);
        this.copyrightNoticeTextField = new JTextField();
        GridBagConstraints gbc_copyrightNoticeTextField = new GridBagConstraints();
        gbc_copyrightNoticeTextField.anchor = 11;
        gbc_copyrightNoticeTextField.fill = 2;
        gbc_copyrightNoticeTextField.insets = new Insets(0, 0, 5, 0);
        gbc_copyrightNoticeTextField.gridx = 1;
        gbc_copyrightNoticeTextField.gridy = 2;
        panel_7.add((Component)this.copyrightNoticeTextField, gbc_copyrightNoticeTextField);
        this.copyrightNoticeTextField.setColumns(40);
        JLabel copyrightLinkLabel = new JLabel(Messages.getInstance().get("map_type_edit_copyright_link_label"));
        GridBagConstraints gbc_copyrightLinkLabel = new GridBagConstraints();
        gbc_copyrightLinkLabel.anchor = 11;
        gbc_copyrightLinkLabel.fill = 2;
        gbc_copyrightLinkLabel.insets = new Insets(0, 0, 0, 5);
        gbc_copyrightLinkLabel.gridx = 0;
        gbc_copyrightLinkLabel.gridy = 3;
        panel_7.add((Component)copyrightLinkLabel, gbc_copyrightLinkLabel);
        this.copyrightLinkTextField = new JTextField();
        GridBagConstraints gbc_copyrightLinkTextField = new GridBagConstraints();
        gbc_copyrightLinkTextField.anchor = 11;
        gbc_copyrightLinkTextField.fill = 2;
        gbc_copyrightLinkTextField.gridx = 1;
        gbc_copyrightLinkTextField.gridy = 3;
        panel_7.add((Component)this.copyrightLinkTextField, gbc_copyrightLinkTextField);
        this.copyrightLinkTextField.setColumns(40);
        JPanel panel_1 = new JPanel();
        this.contentPanel.add((Component)panel_1, "North");
        JLabel typeLabel = new JLabel(Messages.getInstance().get("map_type_edit_type_label"));
        panel_1.add(typeLabel);
        this.typeComboBox = new JComboBox();
        this.typeComboBox.setModel(new DefaultComboBoxModel<StringComboBoxItem>(TileFactoryInfoFactory.createComboBoxValues()));
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMapTypeDialog.this.typeComboBoxChanged();
            }
        });
        panel_1.add(this.typeComboBox);
        this.updateValues();
        this.setModal(true);
        this.setSize(600, 220);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void typeComboBoxChanged() {
        this.urlTextField.setEnabled(this.isUrlPathNeeded());
    }

    public void updateValues() {
        if (this.result != null) {
            this.nameTextField.setText(StringUtil.nullToEmpty(this.result.getName()));
            this.urlTextField.setText(StringUtil.nullToEmpty(this.result.getBaseURL()));
            this.copyrightNoticeTextField.setText(StringUtil.nullToEmpty(this.result.getCopyrightNotice()));
            this.copyrightLinkTextField.setText(StringUtil.nullToEmpty(this.result.getCopyrightLink()));
            if (this.result.getType() != null) {
                for (int i = 0; i < this.typeComboBox.getItemCount(); ++i) {
                    StringComboBoxItem sel = this.typeComboBox.getItemAt(i);
                    if (!this.result.getType().toString().equals(sel.getValue())) continue;
                    this.typeComboBox.setSelectedIndex(i);
                    break;
                }
            }
        }
        this.typeComboBoxChanged();
    }

    public void closeWindowAction() {
        this.setVisible(false);
    }

    public void cancelAction() {
        this.closeWindowAction();
    }

    public void saveAction() {
        StringComboBoxItem sel;
        if (this.doValidate() && (sel = (StringComboBoxItem)this.typeComboBox.getSelectedItem()) != null) {
            this.result = TileFactoryInfoFactory.create(TileFactoryInfoType.valueOf(sel.getValue()), StringUtil.emptyToNull(this.nameTextField.getText()), StringUtil.emptyToNull(this.urlTextField.getText()), StringUtil.emptyToNull(this.copyrightNoticeTextField.getText()), StringUtil.emptyToNull(this.copyrightLinkTextField.getText()));
            this.saveClicked = true;
            this.closeWindowAction();
        }
    }

    public boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmpty(this.urlTextField.getText()) && this.isUrlPathNeeded()) {
            errors.add(Messages.getInstance().get("map_type_edit_url_empty"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private boolean isUrlPathNeeded() {
        if (this.typeComboBox == null) {
            return false;
        }
        StringComboBoxItem sel = (StringComboBoxItem)this.typeComboBox.getSelectedItem();
        return sel == null || !TileFactoryInfoType.METEO.toString().equals(sel.getValue()) && !TileFactoryInfoType.VIRTUAL_EARTH_HYBRID.toString().equals(sel.getValue()) && !TileFactoryInfoType.VIRTUAL_EARTH_MAP.toString().equals(sel.getValue()) && !TileFactoryInfoType.VIRTUAL_EARTH_SATELLITE.toString().equals(sel.getValue());
    }

    public TileFactoryInfo getResult() {
        return this.result;
    }

    public boolean isSaveClicked() {
        return this.saveClicked;
    }
}

