/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.fsx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SceneryConfigPathsBean;
import main.java.guru.vfrflight.core.SceneryConfigEntry;
import main.java.guru.vfrflight.core.fsx.BglImportBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.fsx.FsxImportDataStep2Dialog;
import main.java.guru.vfrflight.gui.table.BooleanDataTable;
import main.java.guru.vfrflight.gui.task.fsx.BglImportTask;
import main.java.guru.vfrflight.util.GuiUtil;
import org.apache.log4j.Logger;

public class FsxImportDataStep3Dialog
extends JDialog {
    private static final long serialVersionUID = 9092079255492602361L;
    private static final Logger log = Logger.getLogger(FsxImportDataStep3Dialog.class);
    private static final String IMPORT_AIRPORTS = "fsx_import_data_import_airports";
    private static final String IMPORT_NAVAIDS = "fsx_import_data_import_navaids";
    private static final String IMPORT_RUNWAYS = "fsx_import_data_import_runways";
    private static final String IMPORT_TAXIWAYS = "fsx_import_data_import_taxiways";
    private static final String IMPORT_ILS = "fsx_import_data_import_ils";
    private static final String IMPORT_AIRSPACES = "fsx_import_data_import_airspaces";
    private static final String IMPORT_IFR_POINTS = "fsx_import_data_import_ifr_points";
    private static final String IMPORT_IFR_ROUTES = "fsx_import_data_import_ifr_routes";
    private static final String IMPORT_FREQUENCIES = "fsx_import_data_import_frequencies";
    private static final String IMPORT_STARTS = "fsx_import_data_import_starts";
    private BooleanDataTable importElementsTable;
    private final List<SceneryConfigEntry> configEntries;
    private JButton nextButton;
    private final SceneryConfigPathsBean sceneryConfigPathsBean;
    private BglImportBean importBean = new BglImportBean();
    private JCheckBox selectiveImportCheckBox;

    public FsxImportDataStep3Dialog(JFrame frame, List<SceneryConfigEntry> configEntries, SceneryConfigPathsBean sceneryConfigPathsBean) {
        super(frame);
        this.configEntries = configEntries;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FsxImportDataStep3Dialog.this.closeWindowAction();
            }
        });
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("fsx_export_frame_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_2, "Center");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel panel_3 = new JPanel();
        panel_3.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(1, null, null), "", 4, 2, null, null), new EmptyBorder(0, 10, 0, 10)));
        panel_2.add((Component)panel_3, "North");
        panel_3.setLayout(new FlowLayout(1, 5, 5));
        JLabel sceneryPathsWarningLabel = new JLabel(Messages.getInstance().get("fsx_import_data_import_elements"));
        panel_3.add(sceneryPathsWarningLabel);
        sceneryPathsWarningLabel.setHorizontalAlignment(0);
        LinkedHashMap<String, Boolean> elementsTableRows = new LinkedHashMap<String, Boolean>();
        elementsTableRows.put(IMPORT_AIRPORTS, this.importBean.isImportAirports());
        elementsTableRows.put(IMPORT_NAVAIDS, this.importBean.isImportNavaids());
        elementsTableRows.put(IMPORT_RUNWAYS, this.importBean.isImportRunways());
        elementsTableRows.put(IMPORT_TAXIWAYS, this.importBean.isImportTaxiways());
        elementsTableRows.put(IMPORT_ILS, this.importBean.isImportIls());
        elementsTableRows.put(IMPORT_AIRSPACES, this.importBean.isImportBoundaries());
        elementsTableRows.put(IMPORT_IFR_POINTS, this.importBean.isImportWaypoints());
        elementsTableRows.put(IMPORT_IFR_ROUTES, this.importBean.isImportRoutes());
        elementsTableRows.put(IMPORT_FREQUENCIES, this.importBean.isImportFrequencies());
        elementsTableRows.put(IMPORT_STARTS, this.importBean.isImportStarts());
        this.importElementsTable = new BooleanDataTable(elementsTableRows, true);
        panel_2.add((Component)this.importElementsTable, "Center");
        JPanel bottomPanel = new JPanel();
        panel_2.add((Component)bottomPanel, "South");
        bottomPanel.setLayout(new FlowLayout(1, 5, 5));
        this.selectiveImportCheckBox = new JCheckBox(Messages.getInstance().get("fsx_import_data_import_selective"), this.importBean.isSelectiveTruncate());
        bottomPanel.add(this.selectiveImportCheckBox);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_1, "South");
        JButton prevButton = new JButton(Messages.getInstance().get("previous_button"));
        prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxImportDataStep3Dialog.this.prevButtonAction();
            }
        });
        panel_1.add(prevButton);
        this.nextButton = new JButton(Messages.getInstance().get("next_button"));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxImportDataStep3Dialog.this.nextButtonAction();
            }
        });
        panel_1.add(this.nextButton);
        this.setSize(636, 464);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.sceneryConfigPathsBean = sceneryConfigPathsBean;
    }

    public void closeWindowAction() {
        MapFrame.getInstance().showPanel();
        this.setVisible(false);
    }

    public boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        this.updateImportBean();
        if (this.importElementsTable.isAllUnchecked()) {
            errors.add(Messages.getInstance().get("fsx_import_data_no_import_elements_selected"));
        }
        if (this.importBean.isImportRunways() && !this.importBean.isImportAirports()) {
            errors.add(Messages.getInstance().get("fsx_import_data_import_runways_without_airports"));
        }
        if (this.importBean.isImportTaxiways() && !this.importBean.isImportAirports()) {
            errors.add(Messages.getInstance().get("fsx_import_data_import_taxiways_without_airports"));
        }
        if (this.importBean.isImportIls() && !this.importBean.isImportRunways()) {
            errors.add(Messages.getInstance().get("fsx_import_data_import_ils_without_runways"));
        }
        if (this.importBean.isImportRoutes() && !this.importBean.isImportWaypoints()) {
            errors.add(Messages.getInstance().get("fsx_import_data_import_ifr_routes_without_ifr_points"));
        }
        if (this.importBean.isImportFrequencies() && !this.importBean.isImportAirports()) {
            errors.add(Messages.getInstance().get("fsx_import_data_import_freq_without_airports"));
        }
        if (this.importBean.isImportStarts() && !this.importBean.isImportAirports()) {
            errors.add(Messages.getInstance().get("fsx_import_data_import_starts_without_airports"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public void prevButtonAction() {
        this.setVisible(false);
        FsxImportDataStep2Dialog fidDialog = new FsxImportDataStep2Dialog(MapFrame.getInstance(), this.sceneryConfigPathsBean);
        fidDialog.setVisible(true);
    }

    public void updateImportBean() {
        Map<String, Boolean> selection = this.importElementsTable.getData();
        this.importBean.setImportAirports(selection.get(Messages.getInstance().get(IMPORT_AIRPORTS)));
        this.importBean.setImportNavaids(selection.get(Messages.getInstance().get(IMPORT_NAVAIDS)));
        this.importBean.setImportRunways(selection.get(Messages.getInstance().get(IMPORT_RUNWAYS)));
        this.importBean.setImportTaxiways(selection.get(Messages.getInstance().get(IMPORT_TAXIWAYS)));
        this.importBean.setImportIls(selection.get(Messages.getInstance().get(IMPORT_ILS)));
        this.importBean.setImportBoundaries(selection.get(Messages.getInstance().get(IMPORT_AIRSPACES)));
        this.importBean.setImportWaypoints(selection.get(Messages.getInstance().get(IMPORT_IFR_POINTS)));
        this.importBean.setImportRoutes(selection.get(Messages.getInstance().get(IMPORT_IFR_ROUTES)));
        this.importBean.setImportFrequencies(selection.get(Messages.getInstance().get(IMPORT_FREQUENCIES)));
        this.importBean.setImportStarts(selection.get(Messages.getInstance().get(IMPORT_STARTS)));
        this.importBean.setSelectiveTruncate(this.selectiveImportCheckBox.isSelected());
    }

    public void nextButtonAction() {
        if (this.doValidate() && GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("fsx_data_import_start"), Messages.getInstance().get("fsx_import_data_begin_import"))) {
            log.info(this.importBean);
            Thread t = new Thread(new BglImportTask(this.importBean, this.configEntries, this.sceneryConfigPathsBean.getFsxP3dWorkingDir()));
            t.start();
            this.setVisible(false);
        }
    }
}

