/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.fsx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SceneryConfigPathsBean;
import main.java.guru.vfrflight.core.SceneryConfigEntry;
import main.java.guru.vfrflight.gui.flightplan.ImportDataStepDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.connect.SimulatorVersion;
import main.java.guru.vfrflight.gui.flightplan.fsx.FsxImportDataStep1Dialog;
import main.java.guru.vfrflight.gui.flightplan.fsx.FsxImportDataStep3Dialog;
import main.java.guru.vfrflight.gui.table.SceneryConfigDataTable;
import main.java.guru.vfrflight.util.BglImportUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import org.apache.log4j.Logger;

public class FsxImportDataStep2Dialog
extends JDialog
implements ImportDataStepDialog {
    private static final long serialVersionUID = 8803292807398680771L;
    private static final Logger log = Logger.getLogger(FsxImportDataStep2Dialog.class);
    private SceneryConfigDataTable sceneryConfigTable;
    private JButton nextButton;
    private final SceneryConfigPathsBean sceneryConfigPathsBean;
    private JLabel scenerySelectionStatus;
    private JCheckBox selectAllNoneCheckBox;

    public FsxImportDataStep2Dialog(JFrame frame, SceneryConfigPathsBean sceneryConfigPathsBean) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FsxImportDataStep2Dialog.this.closeWindowAction();
            }
        });
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("fsx_export_frame_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_2, "Center");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel panel_3 = new JPanel();
        panel_3.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(1, null, null), "", 4, 2, null, null), new EmptyBorder(0, 10, 0, 10)));
        panel_2.add((Component)panel_3, "North");
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel panel_4 = new JPanel();
        panel_3.add((Component)panel_4, "Center");
        JLabel sceneryPathsWarningLabel = new JLabel(Messages.getInstance().get("fsx_import_data_scenery_paths_remarks"));
        panel_4.add(sceneryPathsWarningLabel);
        sceneryPathsWarningLabel.setHorizontalAlignment(0);
        JPanel panel_5 = new JPanel();
        panel_3.add((Component)panel_5, "South");
        panel_5.setLayout(new FlowLayout(1, 5, 5));
        this.scenerySelectionStatus = new JLabel("");
        panel_5.add(this.scenerySelectionStatus);
        this.sceneryConfigTable = new SceneryConfigDataTable(this);
        panel_2.add(this.sceneryConfigTable);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_1, "South");
        JButton prevButton = new JButton(Messages.getInstance().get("previous_button"));
        prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxImportDataStep2Dialog.this.prevButtonAction();
            }
        });
        panel_1.add(prevButton);
        JButton defaultsButton = new JButton(Messages.getInstance().get("restore_defaults_button"));
        defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxImportDataStep2Dialog.this.restoreDefaultsAction();
            }
        });
        panel_1.add(defaultsButton);
        this.nextButton = new JButton(Messages.getInstance().get("next_button"));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxImportDataStep2Dialog.this.nextButtonAction();
            }
        });
        panel_1.add(this.nextButton);
        this.setSize(750, 600);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.sceneryConfigPathsBean = sceneryConfigPathsBean;
        this.updateValues();
        this.selectAllNoneCheckBox = new JCheckBox(Messages.getInstance().get("select_all_none"), this.sceneryConfigTable.anySelected());
        panel_5.add(this.selectAllNoneCheckBox);
        this.selectAllNoneCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FsxImportDataStep2Dialog.this.selectAllNoneAction();
            }
        });
    }

    public void updateValues() {
        String filepath;
        List<SceneryConfigEntry> defaultSceneryPaths = BglImportUtil.readSceneryConfig(this.sceneryConfigPathsBean.getFsxP3dSceneryConfigPath(), this.sceneryConfigPathsBean.getSimulatorVersion().getSceneryCfgEncoding(), this.sceneryConfigPathsBean.getFsxP3dMainDir());
        if (SimulatorVersion.P3D_v4.equals((Object)this.sceneryConfigPathsBean.getSimulatorVersion()) && new File(filepath = this.sceneryConfigPathsBean.getSimulatorVersion().getProgramDataPath() + "scenery_add-ons.xml").exists()) {
            defaultSceneryPaths.addAll(BglImportUtil.readSceneryAddOnsFile(filepath, defaultSceneryPaths.size()));
            Collections.sort(defaultSceneryPaths);
        }
        if (defaultSceneryPaths != null && defaultSceneryPaths.size() > 0) {
            this.sceneryConfigTable.setData(defaultSceneryPaths);
        } else {
            this.nextButton.setEnabled(false);
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_import_data_no_scenery_config_paths"), Messages.getInstance().get("error"), 0);
        }
        this.updateSelectionStatus();
    }

    @Override
    public void updateSelectionStatus() {
        if (this.scenerySelectionStatus != null) {
            long totalSize = 0L;
            long totalCount = 0L;
            for (SceneryConfigEntry entry : this.sceneryConfigTable.getData()) {
                totalCount += entry.getFileCount();
                totalSize += entry.getSize();
            }
            this.scenerySelectionStatus.setText(Messages.getInstance().get("fsx_import_data_scenery_paths_status") + " " + FormatUtil.formatFileSizeToGBs(totalSize, 1) + " GB / " + totalCount);
        } else {
            this.scenerySelectionStatus.setText(Messages.getInstance().get("fsx_import_data_scenery_paths_status") + " --- / --");
        }
    }

    public void closeWindowAction() {
        MapFrame.getInstance().showPanel();
        this.setVisible(false);
    }

    public boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.sceneryConfigTable.isAllUnchecked()) {
            errors.add(Messages.getInstance().get("fsx_import_data_no_scenery_config_paths_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public void selectAllNoneAction() {
        if (!this.selectAllNoneCheckBox.isSelected()) {
            this.sceneryConfigTable.deselectAll();
        } else {
            this.sceneryConfigTable.selectAll();
        }
        this.updateSelectionStatus();
    }

    public void prevButtonAction() {
        this.setVisible(false);
        FsxImportDataStep1Dialog fidDialog = new FsxImportDataStep1Dialog(MapFrame.getInstance(), this.sceneryConfigPathsBean);
        fidDialog.setVisible(true);
    }

    public void nextButtonAction() {
        if (this.doValidate()) {
            log.info(this.scenerySelectionStatus.getText());
            this.setVisible(false);
            FsxImportDataStep3Dialog fidDialog = new FsxImportDataStep3Dialog(MapFrame.getInstance(), this.sceneryConfigTable.getData(), this.sceneryConfigPathsBean);
            fidDialog.setVisible(true);
        }
    }

    public void restoreDefaultsAction() {
        this.updateValues();
    }
}

