/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.fsx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SceneryConfigPathsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.connect.SimulatorVersion;
import main.java.guru.vfrflight.gui.flightplan.connect.SimulatorVersionComboBoxItem;
import main.java.guru.vfrflight.gui.flightplan.fsx.FsxImportDataStep2Dialog;
import main.java.guru.vfrflight.gui.swing.panel.file.FileChooserPanel;

public class FsxImportDataStep1Dialog
extends JDialog {
    private static final long serialVersionUID = 8803292807398680771L;
    private final SceneryConfigPathsBean sceneryConfigPathsBean;
    private FileChooserPanel sceneryCfgPathPanel;
    private FileChooserPanel simMainDirPanel;
    private FileChooserPanel workingDirPanel;
    private JComboBox<SimulatorVersionComboBoxItem> simulatorVersionComboBox;

    public FsxImportDataStep1Dialog(JFrame frame, SceneryConfigPathsBean sceneryConfigPathsBean) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FsxImportDataStep1Dialog.this.closeWindowAction();
            }
        });
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("fsx_import_data_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.sceneryConfigPathsBean = sceneryConfigPathsBean;
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_2, "Center");
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        gbl_panel_2.columnWidths = new int[]{436};
        gbl_panel_2.rowHeights = new int[]{35, 65, 65, 65, 30};
        gbl_panel_2.columnWeights = new double[]{1.0};
        gbl_panel_2.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
        panel_2.setLayout(gbl_panel_2);
        this.sceneryCfgPathPanel = new FileChooserPanel(Messages.getInstance().get("fsx_import_data_scenery_config_path"), Messages.getInstance().get("config_files"), "CFG", true, 40);
        GridBagConstraints gbc_sceneryCfgPathPanel = new GridBagConstraints();
        gbc_sceneryCfgPathPanel.fill = 1;
        gbc_sceneryCfgPathPanel.insets = new Insets(0, 0, 5, 0);
        gbc_sceneryCfgPathPanel.gridx = 0;
        gbc_sceneryCfgPathPanel.gridy = 1;
        panel_2.add((Component)this.sceneryCfgPathPanel, gbc_sceneryCfgPathPanel);
        this.simMainDirPanel = new FileChooserPanel(Messages.getInstance().get("fsx_import_data_simulator_main_dir"), false);
        GridBagConstraints gbc_simMainDirPanel = new GridBagConstraints();
        gbc_simMainDirPanel.fill = 1;
        gbc_simMainDirPanel.insets = new Insets(0, 0, 5, 0);
        gbc_simMainDirPanel.gridx = 0;
        gbc_simMainDirPanel.gridy = 2;
        panel_2.add((Component)this.simMainDirPanel, gbc_simMainDirPanel);
        this.workingDirPanel = new FileChooserPanel(Messages.getInstance().get("fsx_import_data_working_dir"), false);
        GridBagConstraints gbc_workingDirPanel = new GridBagConstraints();
        gbc_workingDirPanel.gridheight = 2;
        gbc_workingDirPanel.fill = 1;
        gbc_workingDirPanel.insets = new Insets(0, 0, 5, 0);
        gbc_workingDirPanel.gridx = 0;
        gbc_workingDirPanel.gridy = 3;
        panel_2.add((Component)this.workingDirPanel, gbc_workingDirPanel);
        JPanel simulatorVersionPanel = new JPanel();
        GridBagConstraints gbc_simulatorVersionPanel = new GridBagConstraints();
        gbc_simulatorVersionPanel.fill = 1;
        gbc_simulatorVersionPanel.gridx = 0;
        gbc_simulatorVersionPanel.gridy = 0;
        panel_2.add((Component)simulatorVersionPanel, gbc_simulatorVersionPanel);
        JLabel infoLabel = new JLabel(Messages.getInstance().get("fsx_p3d_connect_dialog_simulator_version"));
        simulatorVersionPanel.add(infoLabel);
        this.simulatorVersionComboBox = new JComboBox();
        SimulatorVersionComboBoxItem[] values = new SimulatorVersionComboBoxItem[SimulatorVersion.values().length];
        int i = 0;
        for (SimulatorVersion type : SimulatorVersion.values()) {
            values[i] = new SimulatorVersionComboBoxItem(type);
            ++i;
        }
        this.simulatorVersionComboBox.setModel(new DefaultComboBoxModel<SimulatorVersionComboBoxItem>(values));
        this.simulatorVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxImportDataStep1Dialog.this.simulatorVersionAction();
            }
        });
        simulatorVersionPanel.add(this.simulatorVersionComboBox);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)panel_1, "South");
        JButton eksportujButton = new JButton(Messages.getInstance().get("next_button"));
        eksportujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxImportDataStep1Dialog.this.nextButtonAction();
            }
        });
        panel_1.add(eksportujButton);
        this.updateData();
        this.setSize(462, 315);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    protected void updateData() {
        this.workingDirPanel.setChosenPath(this.sceneryConfigPathsBean.getFsxP3dWorkingDir());
        this.sceneryCfgPathPanel.setChosenPath(this.sceneryConfigPathsBean.getFsxP3dSceneryConfigPath());
        if (new File(this.sceneryConfigPathsBean.getFsxP3dMainDir()).exists()) {
            this.simMainDirPanel.setChosenPath(this.sceneryConfigPathsBean.getFsxP3dMainDir());
        }
        int i = 0;
        for (SimulatorVersion ver : SimulatorVersion.values()) {
            if (ver.equals((Object)this.sceneryConfigPathsBean.getSimulatorVersion())) {
                this.simulatorVersionComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.simulatorVersionAction();
    }

    protected void simulatorVersionAction() {
        SimulatorVersion selectedSimulatorVersion = ((SimulatorVersionComboBoxItem)this.simulatorVersionComboBox.getSelectedItem()).getValue();
        this.sceneryCfgPathPanel.setChosenPath(selectedSimulatorVersion.getProgramDataPath() + "Scenery.cfg");
    }

    public void closeWindowAction() {
        MapFrame.getInstance().showPanel();
        this.setVisible(false);
    }

    public boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!(this.sceneryCfgPathPanel.isPathSelected() && this.simMainDirPanel.isPathSelected() && this.workingDirPanel.isPathSelected())) {
            errors.add(Messages.getInstance().get("fsx_import_data_all_paths_must_be_selected"));
        } else if (!new File(this.simMainDirPanel.getChosenPath() + "/fsx.exe").exists() && !new File(this.simMainDirPanel.getChosenPath() + "/Prepar3D.exe").exists()) {
            errors.add(Messages.getInstance().get("fsx_import_data_no_sim_exe_files"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public void nextButtonAction() {
        if (this.doValidate()) {
            this.setVisible(false);
            SceneryConfigPathsBean sceneryConfigPathsBean = new SceneryConfigPathsBean();
            sceneryConfigPathsBean.setFsxP3dSceneryConfigPath(this.sceneryCfgPathPanel.getChosenPath());
            sceneryConfigPathsBean.setFsxP3dMainDir(this.simMainDirPanel.getChosenPath());
            sceneryConfigPathsBean.setFsxP3dWorkingDir(this.workingDirPanel.getChosenPath());
            FsxImportDataStep2Dialog fidDialog = new FsxImportDataStep2Dialog(MapFrame.getInstance(), sceneryConfigPathsBean);
            fidDialog.setVisible(true);
            this.setVisible(false);
        }
    }
}

