/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.creator;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.item.BooleanComboBoxItem;
import main.java.guru.vfrflight.bean.combo.item.NumericComboBoxItem;
import main.java.guru.vfrflight.bean.filter.AirportFilter;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.gui.flightplan.AddRouteListDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.creator.RandomRouteCriteria;
import main.java.guru.vfrflight.gui.flightplan.creator.RouteConditionsType;
import main.java.guru.vfrflight.gui.flightplan.creator.RouteCriteriaComboBoxItem;
import main.java.guru.vfrflight.gui.flightplan.creator.RouteSurfaceType;
import main.java.guru.vfrflight.gui.swing.textfield.DecimalTextField;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.gui.task.WeatherInRegionDownloadTask;
import main.java.guru.vfrflight.sql.facade.AirportFacade;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.RouteUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.metar.MetarData;
import main.java.guru.vfrflight.util.metar.MetarDecoderUtil;
import main.java.guru.vfrflight.weather.core.Station;
import org.apache.log4j.Logger;

public class RouteCreatorDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(RouteCreatorDialog.class);
    private static final long serialVersionUID = 8379147648314785399L;
    private Set<String> airportIdents;
    private JComboBox<String> fromComboBox;
    private JComboBox<String> toComboBox;
    private DecimalTextField cruiseAltTextField;
    private DecimalTextField cruiseSpeedTextField;
    private JRadioButton directRadioButton;
    private JRadioButton vorToVorRadioButton;
    private JCheckBox autoCruiseAltCheckBox;
    private IntegerTextField distanceFromTextField;
    private IntegerTextField distanceToTextField;
    private IntegerTextField runwayLengthFromTextField;
    private IntegerTextField runwayLengthToTextField;
    private JCheckBox vorToVorCheckBox;
    private JComboBox<BooleanComboBoxItem> departureVorComboBox;
    private JComboBox<BooleanComboBoxItem> departureNdbComboBox;
    private JComboBox<BooleanComboBoxItem> departureMountanousComboBox;
    private JComboBox<BooleanComboBoxItem> arrivalVorComboBox;
    private JComboBox<BooleanComboBoxItem> arrivalNdbComboBox;
    private JComboBox<BooleanComboBoxItem> arrivalMountanousComboBox;
    private JComboBox<BooleanComboBoxItem> arrivalIlsComboBox;
    private JComboBox<NumericComboBoxItem> departureConditionsComboBox;
    private JComboBox<NumericComboBoxItem> arrivalConditionsComboBox;
    private JComboBox<RouteCriteriaComboBoxItem> presetComboBox;
    private RouteCriteriaComboBoxItem[] PRESETS_COMBO = new RouteCriteriaComboBoxItem[]{new RouteCriteriaComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_preset_custom"), null), new RouteCriteriaComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_preset_short_airliner"), PRESET_SHORT_AIRLINER), new RouteCriteriaComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_preset_airliner_imc"), PRESET_AIRLINER_IMC), new RouteCriteriaComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_preset_short_airliner_imc"), PRESET_SHORT_AIRLINER_IMC), new RouteCriteriaComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_preset_short_mountanous_airliner_imc"), PRESET_SHORT_MOUNTANOUS_AIRLINER_IMC), new RouteCriteriaComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_preset_short_ga"), PRESET_SHORT_GA), new RouteCriteriaComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_preset_short_ga_imc"), PRESET_SHORT_GA_IMC), new RouteCriteriaComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_preset_ga_imc"), PRESET_GA_IMC), new RouteCriteriaComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_preset_ga_mountanous_stol"), PRESET_GA_MOUNTANOUS_STOL)};
    private static final RandomRouteCriteria PRESET_SHORT_MOUNTANOUS_AIRLINER_IMC = RandomRouteCriteria.builder().withMinDistanceNm(100).withMaxDistanceNm(150).withArrivalConditions(RouteConditionsType.IMC).withArrivalMountanous(true).withArrivalIls(true).withMinRunwayLengthM(2000).withSurfaceType(RouteSurfaceType.HARDENED).withVorToVor(true).create();
    private static final RandomRouteCriteria PRESET_AIRLINER_IMC = RandomRouteCriteria.builder().withMinDistanceNm(150).withMaxDistanceNm(300).withArrivalConditions(RouteConditionsType.IMC).withArrivalIls(true).withMinRunwayLengthM(2000).withSurfaceType(RouteSurfaceType.HARDENED).withVorToVor(true).create();
    private static final RandomRouteCriteria PRESET_SHORT_AIRLINER_IMC = RandomRouteCriteria.builder().withMinDistanceNm(100).withMaxDistanceNm(150).withArrivalConditions(RouteConditionsType.IMC).withArrivalIls(true).withMinRunwayLengthM(2000).withSurfaceType(RouteSurfaceType.HARDENED).withVorToVor(true).create();
    private static final RandomRouteCriteria PRESET_GA_IMC = RandomRouteCriteria.builder().withMinDistanceNm(40).withMaxDistanceNm(80).withArrivalConditions(RouteConditionsType.IMC).withArrivalIls(true).withVorToVor(false).create();
    private static final RandomRouteCriteria PRESET_SHORT_GA_IMC = RandomRouteCriteria.builder().withMinDistanceNm(15).withMaxDistanceNm(30).withArrivalConditions(RouteConditionsType.IMC).withArrivalIls(true).withVorToVor(false).create();
    private static final RandomRouteCriteria PRESET_GA_MOUNTANOUS_STOL = RandomRouteCriteria.builder().withMinDistanceNm(25).withMaxDistanceNm(50).withMaxRunwayLengthM(600).withArrivalMountanous(true).withSurfaceType(RouteSurfaceType.SOFT).withVorToVor(false).create();
    private static final RandomRouteCriteria PRESET_SHORT_AIRLINER = RandomRouteCriteria.builder().withMinDistanceNm(100).withMaxDistanceNm(150).withArrivalIls(true).withMinRunwayLengthM(2000).withSurfaceType(RouteSurfaceType.HARDENED).withVorToVor(true).create();
    private static final RandomRouteCriteria PRESET_SHORT_GA = RandomRouteCriteria.builder().withMinDistanceNm(15).withMaxDistanceNm(30).withArrivalIls(true).withVorToVor(false).create();
    private BooleanComboBoxItem[] YES_NO_COMBO = new BooleanComboBoxItem[]{new BooleanComboBoxItem("", null), new BooleanComboBoxItem(Messages.getInstance().get("yes"), Boolean.TRUE), new BooleanComboBoxItem(Messages.getInstance().get("no"), Boolean.FALSE)};
    private static final int CONDITIONS_ANY = 0;
    private static final int CONDITIONS_IMC = 1;
    private static final int CONDITIONS_VFR = 2;
    private NumericComboBoxItem[] CONDITIONS_COMBO = new NumericComboBoxItem[]{new NumericComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_conditions_any"), 0), new NumericComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_conditions_imc"), 1), new NumericComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_conditions_vfr"), 2)};
    private static final int SURFACE_TYPE_ANY = 0;
    private static final int SURFACE_TYPE_HARDENED = 1;
    private static final int SURFACE_TYPE_SOFT = 2;
    private NumericComboBoxItem[] SURFACE_TYPE_COMBO = new NumericComboBoxItem[]{new NumericComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_surface_type_any"), 0), new NumericComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_surface_type_hardened"), 1), new NumericComboBoxItem(Messages.getInstance().get("route_creator_dialog_random_surface_type_soft"), 2)};
    private static final int ANY = 0;
    private static final int YES = 1;
    private static final int NO = 2;
    private JComboBox<NumericComboBoxItem> runwaySurfaceTypeComboBox;

    public RouteCreatorDialog() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                RouteCreatorDialog.this.closeWindowAction(true);
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("route_creator_dialog_title"));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.getContentPane().add((Component)tabbedPane, "Center");
        JPanel creatorTabPanel = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("route_creator_dialog_creator_tab"), null, creatorTabPanel, null);
        creatorTabPanel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        creatorTabPanel.add((Component)buttonPanel, "South");
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        JButton findRouteButton = new JButton(Messages.getInstance().get("route_creator_dialog_find_route_button"));
        findRouteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RouteCreatorDialog.this.findRouteAction();
            }
        });
        buttonPanel.add(findRouteButton);
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(20, 0, 0, 0));
        creatorTabPanel.add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel_3 = new JPanel();
        contentPanel.add((Component)panel_3, "North");
        panel_3.setLayout(new FlowLayout(1, 5, 5));
        JLabel fromLabel = new JLabel(Messages.getInstance().get("route_creator_dialog_from"));
        panel_3.add(fromLabel);
        this.fromComboBox = new JComboBox();
        panel_3.add(this.fromComboBox);
        JLabel toLabel = new JLabel(Messages.getInstance().get("route_creator_dialog_to"));
        panel_3.add(toLabel);
        this.toComboBox = new JComboBox();
        panel_3.add(this.toComboBox);
        JPanel panel = new JPanel();
        contentPanel.add((Component)panel, "Center");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        panel.add((Component)panel_1, "North");
        this.directRadioButton = new JRadioButton(Messages.getInstance().get("route_creator_dialog_direct"), true);
        panel_1.add(this.directRadioButton);
        this.vorToVorRadioButton = new JRadioButton(Messages.getInstance().get("route_creator_dialog_vor_to_vor"), false);
        panel_1.add(this.vorToVorRadioButton);
        buttonGroup.add(this.directRadioButton);
        buttonGroup.add(this.vorToVorRadioButton);
        JPanel panel_2 = new JPanel();
        panel.add((Component)panel_2, "Center");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel cruiseAltPanel = new JPanel();
        panel_2.add((Component)cruiseAltPanel, "North");
        JLabel cruiseAltitudeLabel = new JLabel(Messages.getInstance().get("route_creator_dialog_cruise_alt") + UnitUtil.getDistanceUnit());
        cruiseAltPanel.add(cruiseAltitudeLabel);
        this.cruiseAltTextField = new DecimalTextField(1);
        cruiseAltPanel.add(this.cruiseAltTextField);
        this.cruiseAltTextField.setColumns(10);
        this.autoCruiseAltCheckBox = new JCheckBox(Messages.getInstance().get("route_creator_dialog_calculate_cruise_alt_from_msa"));
        this.autoCruiseAltCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RouteCreatorDialog.this.cruiseAltTextField.setEnabled(!RouteCreatorDialog.this.autoCruiseAltCheckBox.isSelected());
            }
        });
        cruiseAltPanel.add(this.autoCruiseAltCheckBox);
        JPanel panel_4 = new JPanel();
        panel_2.add((Component)panel_4, "Center");
        JLabel cruiseSpeedLabel = new JLabel(Messages.getInstance().get("route_creator_dialog_cruise_speed") + UnitUtil.getSpeedUnit());
        panel_4.add(cruiseSpeedLabel);
        this.cruiseSpeedTextField = new DecimalTextField(1);
        this.cruiseSpeedTextField.setHorizontalAlignment(0);
        panel_4.add(this.cruiseSpeedTextField);
        this.cruiseSpeedTextField.setColumns(10);
        JPanel randomTabPanel = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("route_creator_dialog_random_tab"), null, randomTabPanel, null);
        randomTabPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel_16 = new JPanel();
        panel_16.setBorder(new EtchedBorder(1, null, null));
        randomTabPanel.add((Component)panel_16, "North");
        JLabel lblNewLabel_4 = new JLabel(Messages.getInstance().get("route_creator_dialog_random_preset"));
        panel_16.add(lblNewLabel_4);
        this.presetComboBox = new JComboBox();
        this.presetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RouteCreatorDialog.this.presetAction();
            }
        });
        this.presetComboBox.setModel(new DefaultComboBoxModel<RouteCriteriaComboBoxItem>(this.PRESETS_COMBO));
        panel_16.add(this.presetComboBox);
        JPanel panel_6 = new JPanel();
        randomTabPanel.add((Component)panel_6, "Center");
        panel_6.setLayout(new BorderLayout(0, 0));
        JPanel panel_7 = new JPanel();
        panel_6.add((Component)panel_7, "North");
        panel_7.setLayout(new FlowLayout(1, 5, 5));
        JLabel lblDistanceFrom = new JLabel(Messages.getInstance().get("route_creator_dialog_random_distance_from") + UnitUtil.getDistanceUnit());
        panel_7.add(lblDistanceFrom);
        this.distanceFromTextField = new IntegerTextField(1);
        panel_7.add(this.distanceFromTextField);
        this.distanceFromTextField.setColumns(10);
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("route_creator_dialog_random_distance_to"));
        panel_7.add(lblNewLabel);
        this.distanceToTextField = new IntegerTextField(1);
        panel_7.add(this.distanceToTextField);
        this.distanceToTextField.setColumns(10);
        JPanel panel_8 = new JPanel();
        panel_6.add((Component)panel_8, "Center");
        panel_8.setLayout(new BorderLayout(0, 0));
        JPanel panel_9 = new JPanel();
        panel_8.add((Component)panel_9, "North");
        JLabel lblNewLabel_1 = new JLabel(Messages.getInstance().get("route_creator_dialog_random_runway_length_from"));
        panel_9.add(lblNewLabel_1);
        this.runwayLengthFromTextField = new IntegerTextField(1);
        panel_9.add(this.runwayLengthFromTextField);
        this.runwayLengthFromTextField.setColumns(10);
        JLabel label = new JLabel(Messages.getInstance().get("route_creator_dialog_random_runway_length_to"));
        panel_9.add(label);
        this.runwayLengthToTextField = new IntegerTextField(1);
        panel_9.add(this.runwayLengthToTextField);
        this.runwayLengthToTextField.setColumns(10);
        JPanel panel_10 = new JPanel();
        panel_8.add((Component)panel_10, "Center");
        panel_10.setLayout(new BorderLayout(0, 0));
        JPanel panel_11 = new JPanel();
        panel_10.add((Component)panel_11, "North");
        JLabel lblNewLabel_2 = new JLabel(Messages.getInstance().get("route_creator_dialog_random_runway_surface_type"));
        panel_11.add(lblNewLabel_2);
        this.runwaySurfaceTypeComboBox = new JComboBox();
        this.runwaySurfaceTypeComboBox.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(this.SURFACE_TYPE_COMBO));
        panel_11.add(this.runwaySurfaceTypeComboBox);
        this.vorToVorCheckBox = new JCheckBox(Messages.getInstance().get("route_creator_dialog_random_vor_to_vor"));
        panel_11.add(this.vorToVorCheckBox);
        JPanel panel_12 = new JPanel();
        panel_10.add((Component)panel_12, "Center");
        panel_12.setLayout(new BorderLayout(0, 0));
        JPanel panel_13 = new JPanel();
        panel_13.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Messages.getInstance().get("route_creator_dialog_random_departure_airport"), 2, 2, null, new Color(0, 0, 0)));
        panel_12.add((Component)panel_13, "North");
        JLabel lblArrivalConditions = new JLabel(Messages.getInstance().get("route_creator_dialog_random_vor"));
        panel_13.add(lblArrivalConditions);
        this.departureVorComboBox = new JComboBox();
        this.departureVorComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        panel_13.add(this.departureVorComboBox);
        JLabel lblNdb = new JLabel(Messages.getInstance().get("route_creator_dialog_random_ndb"));
        panel_13.add(lblNdb);
        this.departureNdbComboBox = new JComboBox();
        this.departureNdbComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        panel_13.add(this.departureNdbComboBox);
        JLabel lblMountanous = new JLabel(Messages.getInstance().get("route_creator_dialog_random_mountanous"));
        panel_13.add(lblMountanous);
        this.departureMountanousComboBox = new JComboBox();
        this.departureMountanousComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        panel_13.add(this.departureMountanousComboBox);
        JLabel lblNewLabel_3 = new JLabel(Messages.getInstance().get("route_creator_dialog_random_conditions"));
        panel_13.add(lblNewLabel_3);
        this.departureConditionsComboBox = new JComboBox();
        this.departureConditionsComboBox.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(this.CONDITIONS_COMBO));
        panel_13.add(this.departureConditionsComboBox);
        JPanel panel_14 = new JPanel();
        panel_12.add((Component)panel_14, "Center");
        panel_14.setLayout(new BorderLayout(0, 0));
        JPanel panel_15 = new JPanel();
        panel_15.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Messages.getInstance().get("route_creator_dialog_random_destination_airport"), 2, 2, null, new Color(0, 0, 0)));
        panel_14.add((Component)panel_15, "North");
        JLabel label_1 = new JLabel(Messages.getInstance().get("route_creator_dialog_random_vor"));
        panel_15.add(label_1);
        this.arrivalVorComboBox = new JComboBox();
        this.arrivalVorComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        panel_15.add(this.arrivalVorComboBox);
        JLabel label_2 = new JLabel(Messages.getInstance().get("route_creator_dialog_random_ndb"));
        panel_15.add(label_2);
        this.arrivalNdbComboBox = new JComboBox();
        this.arrivalNdbComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        panel_15.add(this.arrivalNdbComboBox);
        JLabel label_3 = new JLabel(Messages.getInstance().get("route_creator_dialog_random_mountanous"));
        panel_15.add(label_3);
        this.arrivalMountanousComboBox = new JComboBox();
        this.arrivalMountanousComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        panel_15.add(this.arrivalMountanousComboBox);
        JLabel label_4 = new JLabel(Messages.getInstance().get("route_creator_dialog_random_conditions"));
        panel_15.add(label_4);
        this.arrivalConditionsComboBox = new JComboBox();
        this.arrivalConditionsComboBox.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(this.CONDITIONS_COMBO));
        panel_15.add(this.arrivalConditionsComboBox);
        JLabel lblIls = new JLabel(Messages.getInstance().get("route_creator_dialog_random_ils"));
        panel_15.add(lblIls);
        this.arrivalIlsComboBox = new JComboBox();
        this.arrivalIlsComboBox.setModel(new DefaultComboBoxModel<BooleanComboBoxItem>(this.YES_NO_COMBO));
        panel_15.add(this.arrivalIlsComboBox);
        JPanel panel_5 = new JPanel();
        panel_5.setBorder(new EtchedBorder(1, null, null));
        randomTabPanel.add((Component)panel_5, "South");
        JButton findRandomButton = new JButton(Messages.getInstance().get("search_button"));
        findRandomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RouteCreatorDialog.this.findRandomRouteAction(RouteCreatorDialog.this.getRandomRouteCriteria());
            }
        });
        panel_5.add(findRandomButton);
        this.setModal(true);
        this.initData();
        this.setPreferredSize(new Dimension(500, 340));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void presetAction() {
        RouteCriteriaComboBoxItem selectedCriteriaItem = (RouteCriteriaComboBoxItem)this.presetComboBox.getSelectedItem();
        RandomRouteCriteria selectedCriteria = selectedCriteriaItem.getValue();
        boolean enabled = selectedCriteria == null;
        this.distanceFromTextField.setEnabled(enabled);
        this.distanceToTextField.setEnabled(enabled);
        this.runwayLengthFromTextField.setEnabled(enabled);
        this.runwayLengthToTextField.setEnabled(enabled);
        this.runwaySurfaceTypeComboBox.setEnabled(enabled);
        this.vorToVorCheckBox.setEnabled(enabled);
        this.departureConditionsComboBox.setEnabled(enabled);
        this.arrivalConditionsComboBox.setEnabled(enabled);
        this.arrivalConditionsComboBox.setEnabled(enabled);
        this.departureMountanousComboBox.setEnabled(enabled);
        this.arrivalMountanousComboBox.setEnabled(enabled);
        this.departureNdbComboBox.setEnabled(enabled);
        this.arrivalNdbComboBox.setEnabled(enabled);
        this.departureVorComboBox.setEnabled(enabled);
        this.arrivalVorComboBox.setEnabled(enabled);
        this.arrivalIlsComboBox.setEnabled(enabled);
        if (selectedCriteria != null) {
            this.fillInRandomTabWithCriteria(selectedCriteria);
        }
    }

    private RandomRouteCriteria getRandomRouteCriteria() {
        Integer minDistanceNm = this.distanceFromTextField.getValue();
        Integer maxDistanceNm = this.distanceToTextField.getValue();
        if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
            if (minDistanceNm != null) {
                minDistanceNm = (int)Math.round(UnitUtil.recalculateDistance(minDistanceNm.intValue(), SettingsBean.getInstance().getParamUnitsDistance(), "nm", false));
            }
            if (maxDistanceNm != null) {
                maxDistanceNm = (int)Math.round(UnitUtil.recalculateDistance(maxDistanceNm.intValue(), SettingsBean.getInstance().getParamUnitsDistance(), "nm", false));
            }
        }
        Integer minRunwayLengthM = this.runwayLengthFromTextField.getValue();
        Integer maxRunwayLengthM = this.runwayLengthToTextField.getValue();
        RouteSurfaceType surfaceType = RouteSurfaceType.ANY;
        if (this.runwaySurfaceTypeComboBox.getSelectedIndex() == 1) {
            surfaceType = RouteSurfaceType.HARDENED;
        } else if (this.runwaySurfaceTypeComboBox.getSelectedIndex() == 2) {
            surfaceType = RouteSurfaceType.SOFT;
        }
        boolean vorToVor = this.vorToVorCheckBox.isSelected();
        RouteConditionsType departureConditions = RouteConditionsType.ANY;
        if (this.departureConditionsComboBox.getSelectedIndex() == 1) {
            departureConditions = RouteConditionsType.IMC;
        } else if (this.departureConditionsComboBox.getSelectedIndex() == 2) {
            departureConditions = RouteConditionsType.VFR;
        }
        RouteConditionsType arrivalConditions = RouteConditionsType.ANY;
        if (this.arrivalConditionsComboBox.getSelectedIndex() == 1) {
            arrivalConditions = RouteConditionsType.IMC;
        } else if (this.arrivalConditionsComboBox.getSelectedIndex() == 2) {
            arrivalConditions = RouteConditionsType.VFR;
        }
        Boolean departureMountanous = null;
        if (this.departureMountanousComboBox.getSelectedIndex() > 0) {
            departureMountanous = this.departureMountanousComboBox.getSelectedIndex() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean arrivalMountanous = null;
        if (this.arrivalMountanousComboBox.getSelectedIndex() > 0) {
            arrivalMountanous = this.arrivalMountanousComboBox.getSelectedIndex() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean departureNdb = null;
        if (this.departureNdbComboBox.getSelectedIndex() > 0) {
            departureNdb = this.departureNdbComboBox.getSelectedIndex() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean arrivalNdb = null;
        if (this.arrivalNdbComboBox.getSelectedIndex() > 0) {
            arrivalNdb = this.arrivalNdbComboBox.getSelectedIndex() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean departureVor = null;
        if (this.departureVorComboBox.getSelectedIndex() > 0) {
            departureVor = this.departureVorComboBox.getSelectedIndex() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean arrivalVor = null;
        if (this.arrivalVorComboBox.getSelectedIndex() > 0) {
            arrivalVor = this.arrivalVorComboBox.getSelectedIndex() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        Boolean arrivalIls = null;
        if (this.arrivalIlsComboBox.getSelectedIndex() > 0) {
            arrivalIls = this.arrivalIlsComboBox.getSelectedIndex() == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        return RandomRouteCriteria.builder().withArrivalConditions(arrivalConditions).withArrivalIls(arrivalIls).withArrivalMountanous(arrivalMountanous).withArrivalNdb(arrivalNdb).withArrivalVor(arrivalVor).withDepartureConditions(departureConditions).withDepartureMountanous(departureMountanous).withDepartureNdb(departureNdb).withDepartureVor(departureVor).withMaxDistanceNm(maxDistanceNm).withMaxRunwayLengthM(maxRunwayLengthM).withMinDistanceNm(minDistanceNm).withMinRunwayLengthM(minRunwayLengthM).withSurfaceType(surfaceType).withVorToVor(vorToVor).create();
    }

    private void fillInRandomTabWithCriteria(RandomRouteCriteria selectedCriteria) {
        Integer minDistNm = selectedCriteria.getMinDistanceNm();
        Integer maxDistNm = selectedCriteria.getMaxDistanceNm();
        if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
            if (minDistNm != null) {
                minDistNm = (int)Math.round(UnitUtil.recalculateDistance(minDistNm.intValue(), "nm", SettingsBean.getInstance().getParamUnitsDistance(), false));
            }
            if (maxDistNm != null) {
                maxDistNm = (int)Math.round(UnitUtil.recalculateDistance(minDistNm.intValue(), "nm", SettingsBean.getInstance().getParamUnitsDistance(), false));
            }
        }
        this.distanceFromTextField.setValue(minDistNm);
        this.distanceToTextField.setValue(maxDistNm);
        this.runwayLengthFromTextField.setValue(selectedCriteria.getMinRunwayLengthM());
        this.runwayLengthToTextField.setValue(selectedCriteria.getMaxRunwayLengthM());
        if (selectedCriteria.getSurfaceType() == null || RouteSurfaceType.ANY.equals((Object)selectedCriteria.getSurfaceType())) {
            this.runwaySurfaceTypeComboBox.setSelectedIndex(0);
        } else if (RouteSurfaceType.HARDENED.equals((Object)selectedCriteria.getSurfaceType())) {
            this.runwaySurfaceTypeComboBox.setSelectedIndex(1);
        } else if (RouteSurfaceType.SOFT.equals((Object)selectedCriteria.getSurfaceType())) {
            this.runwaySurfaceTypeComboBox.setSelectedIndex(2);
        }
        this.vorToVorCheckBox.setSelected(selectedCriteria.isVorToVor());
        if (selectedCriteria.getDepartureConditions() == null || RouteConditionsType.ANY.equals((Object)selectedCriteria.getDepartureConditions())) {
            this.departureConditionsComboBox.setSelectedIndex(0);
        } else if (RouteConditionsType.IMC.equals((Object)selectedCriteria.getDepartureConditions())) {
            this.departureConditionsComboBox.setSelectedIndex(1);
        } else if (RouteConditionsType.VFR.equals((Object)selectedCriteria.getDepartureConditions())) {
            this.departureConditionsComboBox.setSelectedIndex(2);
        }
        if (selectedCriteria.getArrivalConditions() == null || RouteConditionsType.ANY.equals((Object)selectedCriteria.getArrivalConditions())) {
            this.arrivalConditionsComboBox.setSelectedIndex(0);
        } else if (RouteConditionsType.IMC.equals((Object)selectedCriteria.getArrivalConditions())) {
            this.arrivalConditionsComboBox.setSelectedIndex(1);
        } else if (RouteConditionsType.VFR.equals((Object)selectedCriteria.getArrivalConditions())) {
            this.arrivalConditionsComboBox.setSelectedIndex(2);
        }
        if (selectedCriteria.getArrivalConditions() == null || RouteConditionsType.ANY.equals((Object)selectedCriteria.getArrivalConditions())) {
            this.arrivalConditionsComboBox.setSelectedIndex(0);
        } else if (RouteConditionsType.IMC.equals((Object)selectedCriteria.getArrivalConditions())) {
            this.arrivalConditionsComboBox.setSelectedIndex(1);
        } else if (RouteConditionsType.VFR.equals((Object)selectedCriteria.getArrivalConditions())) {
            this.arrivalConditionsComboBox.setSelectedIndex(2);
        }
        if (selectedCriteria.getDepartureMountanous() == null) {
            this.departureMountanousComboBox.setSelectedIndex(0);
        } else if (selectedCriteria.getDepartureMountanous().booleanValue()) {
            this.departureMountanousComboBox.setSelectedIndex(1);
        } else if (!selectedCriteria.getDepartureMountanous().booleanValue()) {
            this.departureMountanousComboBox.setSelectedIndex(2);
        }
        if (selectedCriteria.getArrivalMountanous() == null) {
            this.arrivalMountanousComboBox.setSelectedIndex(0);
        } else if (selectedCriteria.getArrivalMountanous().booleanValue()) {
            this.arrivalMountanousComboBox.setSelectedIndex(1);
        } else if (!selectedCriteria.getArrivalMountanous().booleanValue()) {
            this.arrivalMountanousComboBox.setSelectedIndex(2);
        }
        if (selectedCriteria.getDepartureNdb() == null) {
            this.departureNdbComboBox.setSelectedIndex(0);
        } else if (selectedCriteria.getDepartureNdb().booleanValue()) {
            this.departureNdbComboBox.setSelectedIndex(1);
        } else if (!selectedCriteria.getDepartureNdb().booleanValue()) {
            this.departureNdbComboBox.setSelectedIndex(2);
        }
        if (selectedCriteria.getArrivalNdb() == null) {
            this.arrivalNdbComboBox.setSelectedIndex(0);
        } else if (selectedCriteria.getArrivalNdb().booleanValue()) {
            this.arrivalNdbComboBox.setSelectedIndex(1);
        } else if (!selectedCriteria.getArrivalNdb().booleanValue()) {
            this.arrivalNdbComboBox.setSelectedIndex(2);
        }
        if (selectedCriteria.getDepartureVor() == null) {
            this.departureVorComboBox.setSelectedIndex(0);
        } else if (selectedCriteria.getDepartureVor().booleanValue()) {
            this.departureVorComboBox.setSelectedIndex(1);
        } else if (!selectedCriteria.getDepartureVor().booleanValue()) {
            this.departureVorComboBox.setSelectedIndex(2);
        }
        if (selectedCriteria.getArrivalVor() == null) {
            this.arrivalVorComboBox.setSelectedIndex(0);
        } else if (selectedCriteria.getArrivalVor().booleanValue()) {
            this.arrivalVorComboBox.setSelectedIndex(1);
        } else if (!selectedCriteria.getArrivalVor().booleanValue()) {
            this.arrivalVorComboBox.setSelectedIndex(2);
        }
        if (selectedCriteria.getArrivalIls() == null) {
            this.arrivalIlsComboBox.setSelectedIndex(0);
        } else if (selectedCriteria.getArrivalIls().booleanValue()) {
            this.arrivalIlsComboBox.setSelectedIndex(1);
        } else if (!selectedCriteria.getArrivalIls().booleanValue()) {
            this.arrivalIlsComboBox.setSelectedIndex(2);
        }
    }

    private void initData() {
        this.initRouteCreator();
        this.initRandomRoute();
    }

    private void initRandomRoute() {
        int idx = SettingsBean.getInstance().getRouteCreatorBean().getSelectedPresetIndex();
        this.presetComboBox.setSelectedIndex(idx);
        this.fillInRandomTabWithCriteria(SettingsBean.getInstance().getRouteCreatorBean().getSelectedCriteria());
    }

    private void initRouteCreator() {
        if (SettingsBean.getInstance().getRouteCreatorBean().getAirportsIdents() == null) {
            AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
            SettingsBean.getInstance().getRouteCreatorBean().setAirportsIdents(airportFacade.findAllAirportsIdents());
        }
        this.airportIdents = SettingsBean.getInstance().getRouteCreatorBean().getAirportsIdents();
        Object[] airportsIdentsArray = this.airportIdents.toArray(new String[this.airportIdents.size()]);
        AutoCompleteSupport.install(this.toComboBox, (EventList)GlazedLists.eventListOf((Object[])airportsIdentsArray));
        AutoCompleteSupport.install(this.fromComboBox, (EventList)GlazedLists.eventListOf((Object[])airportsIdentsArray));
    }

    private void closeWindowAction(boolean resetCreatedRoutes) {
        if (resetCreatedRoutes) {
            SettingsBean.getInstance().getRouteCreatorBean().setArrivalAirports(null);
            SettingsBean.getInstance().getRouteCreatorBean().setDepartureAirports(null);
            SettingsBean.getInstance().getRouteCreatorBean().setLastRouteIndex(0);
            MapFrame.getInstance().getNextRouteButton().setVisible(false);
            MapFrame.getInstance().getPrevRouteButton().setVisible(false);
        }
        this.setVisible(false);
    }

    private void findRandomRouteAction(RandomRouteCriteria routeCriteria) {
        if (this.doValidateRandomSearch() && (FlightPlanBean.getInstance().getRoute().getPoints().size() == 0 || GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("dialog_warning"), Messages.getInstance().get("dialog_all_data_will_be_lost")))) {
            SettingsBean.getInstance().getRouteCreatorBean().setSelectedCriteria(routeCriteria);
            SettingsBean.getInstance().getRouteCreatorBean().setSelectedPresetIndex(this.presetComboBox.getSelectedIndex());
            MapFacade mapFacade = new MapFacade(DBUtil.getDataSource());
            List<Airport> airports = mapFacade.findAirports(SettingsBean.getInstance().getParamMapRegionSelected());
            AirportFilter departureAirportFilter = new AirportFilter();
            AirportFilter arrivalAirportFilter = new AirportFilter();
            departureAirportFilter.setRunwayLengthFrom(routeCriteria.getMinRunwayLengthM());
            departureAirportFilter.setRunwayLengthTo(routeCriteria.getMaxRunwayLengthM());
            arrivalAirportFilter.setRunwayLengthFrom(routeCriteria.getMinRunwayLengthM());
            arrivalAirportFilter.setRunwayLengthTo(routeCriteria.getMaxRunwayLengthM());
            if (routeCriteria.getSurfaceType() != null && !RouteSurfaceType.ANY.equals((Object)routeCriteria.getSurfaceType())) {
                departureAirportFilter.setHardened(RouteSurfaceType.HARDENED.equals((Object)routeCriteria.getSurfaceType()));
                arrivalAirportFilter.setHardened(RouteSurfaceType.HARDENED.equals((Object)routeCriteria.getSurfaceType()));
            }
            departureAirportFilter.setMountainous(routeCriteria.getDepartureMountanous());
            arrivalAirportFilter.setMountainous(routeCriteria.getArrivalMountanous());
            departureAirportFilter.setWithVor(routeCriteria.getDepartureVor());
            arrivalAirportFilter.setWithVor(routeCriteria.getArrivalVor());
            departureAirportFilter.setWithNdb(routeCriteria.getDepartureNdb());
            arrivalAirportFilter.setWithNdb(routeCriteria.getArrivalNdb());
            arrivalAirportFilter.setWithIls(routeCriteria.getArrivalIls());
            AbstractList departureAirports = new LinkedList<AirportDTO>();
            AbstractList arrivalAirports = new LinkedList<AirportDTO>();
            for (Airport a : airports) {
                AirportDTO airport = new AirportDTO(a);
                if (departureAirportFilter.check(airport)) {
                    departureAirports.add(airport);
                }
                if (!arrivalAirportFilter.check(airport)) continue;
                arrivalAirports.add(airport);
            }
            if (routeCriteria.getDepartureConditions() != null && !RouteConditionsType.ANY.equals((Object)routeCriteria.getDepartureConditions()) || routeCriteria.getArrivalConditions() != null && !RouteConditionsType.ANY.equals((Object)routeCriteria.getArrivalConditions())) {
                WeatherInRegionDownloadTask wdt = new WeatherInRegionDownloadTask(true, false, false);
                Thread t = new Thread(wdt);
                t.start();
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    log.error(e, e);
                }
                if (wdt.getStations().size() > 0) {
                    Object a;
                    ListIterator it;
                    for (Station st : wdt.getStations()) {
                        if (st.getReport() == null || st.getReport().getMetar() == null) continue;
                        st.getReport().setMetarData(MetarDecoderUtil.decodeMetar(st.getReport().getMetar()));
                    }
                    if (routeCriteria.getDepartureConditions() != null && !RouteConditionsType.ANY.equals((Object)routeCriteria.getDepartureConditions())) {
                        it = departureAirports.listIterator();
                        while (it.hasNext()) {
                            a = (AirportDTO)it.next();
                            if (this.conditionsMatches((AirportDTO)a, wdt.getStations(), routeCriteria.getDepartureConditions())) continue;
                            it.remove();
                        }
                    }
                    if (routeCriteria.getArrivalConditions() != null && !RouteConditionsType.ANY.equals((Object)routeCriteria.getArrivalConditions())) {
                        it = arrivalAirports.listIterator();
                        while (it.hasNext()) {
                            a = (AirportDTO)it.next();
                            if (this.conditionsMatches((AirportDTO)a, wdt.getStations(), routeCriteria.getArrivalConditions())) continue;
                            it.remove();
                        }
                    }
                }
            }
            log.info("Found " + departureAirports.size() + " possible departure airports.");
            log.info("Found " + arrivalAirports.size() + " possible arrival airports.");
            departureAirports = new ArrayList(departureAirports);
            arrivalAirports = new ArrayList(arrivalAirports);
            if (departureAirports.size() > 0 && arrivalAirports.size() > 0) {
                Collections.shuffle(departureAirports);
                Collections.shuffle(arrivalAirports);
                LinkedList<GpsPlace> departureAirportsList = new LinkedList<GpsPlace>();
                LinkedList<GpsPlace> arrivalAirportsList = new LinkedList<GpsPlace>();
                boolean found = false;
                for (AirportDTO depAirport : departureAirports) {
                    for (AirportDTO arrAirport : arrivalAirports) {
                        found = false;
                        if (depAirport.getIdentOrName().equals(arrAirport.getIdentOrName()) || depAirport.getGpsPlace().equals(arrAirport.getGpsPlace())) continue;
                        if (routeCriteria.getMinDistanceNm() == null && routeCriteria.getMinDistanceNm() == null) {
                            found = true;
                        } else {
                            double dist = GpsUtil.getDistance(depAirport.getGpsPlace(), arrAirport.getGpsPlace());
                            if ((routeCriteria.getMinDistanceNm() == null || routeCriteria.getMinDistanceNm() != null && dist >= (double)routeCriteria.getMinDistanceNm().intValue()) && (routeCriteria.getMaxDistanceNm() == null || routeCriteria.getMaxDistanceNm() != null && dist <= (double)routeCriteria.getMaxDistanceNm().intValue())) {
                                found = true;
                            }
                        }
                        if (!found) continue;
                        departureAirportsList.add(depAirport.getGpsPlace());
                        arrivalAirportsList.add(arrAirport.getGpsPlace());
                    }
                }
                if (departureAirportsList.size() > 0) {
                    log.info("Found " + departureAirportsList.size() + " possible routes.");
                    GpsPlace departureAirport = (GpsPlace)departureAirportsList.getFirst();
                    GpsPlace arrivalAirport = (GpsPlace)arrivalAirportsList.getFirst();
                    SettingsBean.getInstance().getRouteCreatorBean().setDepartureAirports(departureAirportsList.toArray(new GpsPlace[departureAirportsList.size()]));
                    SettingsBean.getInstance().getRouteCreatorBean().setArrivalAirports(arrivalAirportsList.toArray(new GpsPlace[arrivalAirportsList.size()]));
                    SettingsBean.getInstance().getRouteCreatorBean().setLastRouteIndex(0);
                    MapFrame.getInstance().getNextRouteButton().setVisible(true);
                    MapFrame.getInstance().getPrevRouteButton().setVisible(true);
                    log.debug("Picking route from " + departureAirport.getName() + " to " + arrivalAirport.getName());
                    ArrayList<GpsPlace> newRoute = new ArrayList<GpsPlace>();
                    newRoute.add(departureAirport);
                    newRoute.add(arrivalAirport);
                    this.vorToVorRadioButton.setSelected(routeCriteria.isVorToVor());
                    this.autoCruiseAltCheckBox.setSelected(true);
                    this.cruiseAltTextField.setText(null);
                    this.cruiseSpeedTextField.setValue(null);
                    RouteUtil.findRouteAction(newRoute, this.vorToVorCheckBox.isSelected(), null, null, true);
                    this.closeWindowAction(false);
                } else {
                    JOptionPane.showMessageDialog(this, Messages.getInstance().get("route_creator_dialog_random_no_airports_found"), "", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("route_creator_dialog_random_no_airports_found"), "", 0);
            }
        }
    }

    private boolean conditionsMatches(AirportDTO a, List<Station> stations, RouteConditionsType departureConditions) {
        boolean imc = RouteConditionsType.IMC.equals((Object)departureConditions);
        GpsPlace airportCenter = a.getGpsPlace();
        GpsArea area = new GpsArea(airportCenter, 10.0);
        LinkedList<Station> stationsNearbyList = new LinkedList<Station>();
        for (Station s : stations) {
            if (!s.isMetarRecentAndValid() || !s.isInside(area)) continue;
            stationsNearbyList.add(s);
        }
        if (stationsNearbyList.size() == 0) {
            return false;
        }
        Station closestStation = null;
        double minDist = 100000.0;
        for (Station s : stationsNearbyList) {
            double dist = GpsUtil.getDistance(airportCenter, s.getGpsPlace());
            if (!(dist < minDist)) continue;
            closestStation = s;
            minDist = dist;
        }
        if (closestStation != null) {
            MetarData data = closestStation.getReport().getMetarData();
            return imc ? data.isImc() : data.isVfr();
        }
        return true;
    }

    private void findRouteAction() {
        if (this.doValidateRouteCreator() && (FlightPlanBean.getInstance().getRoute().getPoints().size() == 0 || GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("dialog_warning"), Messages.getInstance().get("dialog_all_data_will_be_lost")))) {
            ArrayList<GpsPlace> newRoute = new ArrayList<GpsPlace>();
            String fromIdent = (String)this.fromComboBox.getSelectedItem();
            String toIdent = (String)this.toComboBox.getSelectedItem();
            AirportFacade airportFacade = new AirportFacade(DBUtil.getDataSource());
            List<GpsPlace> fromAirport = airportFacade.findAirportsByIdent(fromIdent);
            List<GpsPlace> toAirport = airportFacade.findAirportsByIdent(toIdent);
            LinkedHashMap<String, List<GpsPlace>> newRouteMap = new LinkedHashMap<String, List<GpsPlace>>();
            newRouteMap.put(fromIdent, fromAirport);
            newRouteMap.put(toIdent, toAirport);
            for (Map.Entry pair : newRouteMap.entrySet()) {
                String pointName = (String)pair.getKey();
                List suggestionsList = (List)pair.getValue();
                if (suggestionsList.size() == 0) {
                    log.error("One of the airport suggestions couldn't be found ...");
                    this.closeWindowAction(true);
                    continue;
                }
                if (suggestionsList.size() == 1) {
                    newRoute.add(((GpsPlace)suggestionsList.get(0)).clone());
                    continue;
                }
                AddRouteListDialog routeList = new AddRouteListDialog(pointName, suggestionsList);
                routeList.setVisible(true);
                if (routeList.getSelectedPoint() == null) continue;
                newRoute.add(routeList.getSelectedPoint().clone());
            }
            RouteUtil.findRouteAction(newRoute, this.vorToVorRadioButton.isSelected(), this.cruiseSpeedTextField.getValue(), this.cruiseAltTextField.getValue(), this.autoCruiseAltCheckBox.isSelected());
            this.closeWindowAction(true);
        }
    }

    public boolean doValidateRandomSearch() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.runwayLengthFromTextField.getValue() != null && this.runwayLengthToTextField.getValue() != null && this.runwayLengthFromTextField.getValue() > this.runwayLengthToTextField.getValue()) {
            errors.add(Messages.getInstance().get("route_creator_dialog_random_invalid_runway_length_range"));
        }
        if (this.distanceFromTextField.getValue() != null && this.distanceToTextField.getValue() != null && this.distanceFromTextField.getValue() > this.distanceToTextField.getValue()) {
            errors.add(Messages.getInstance().get("route_creator_dialog_random_invalid_distance_range"));
        }
        if (0 == SettingsBean.getInstance().getParamMapRegionSelected()) {
            NumericComboBoxItem departureConditionsItem = (NumericComboBoxItem)this.departureConditionsComboBox.getSelectedItem();
            NumericComboBoxItem arrivalConditionsItem = (NumericComboBoxItem)this.arrivalConditionsComboBox.getSelectedItem();
            if (0 != departureConditionsItem.getValue() || 0 != arrivalConditionsItem.getValue()) {
                errors.add(Messages.getInstance().get("route_creator_dialog_random_whole_world_is_not_supported_for_conditions"));
            }
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public boolean doValidateRouteCreator() {
        ArrayList<String> errors = new ArrayList<String>();
        String from = (String)this.fromComboBox.getSelectedItem();
        if (StringUtil.isEmpty(from)) {
            errors.add(Messages.getInstance().get("route_creator_dialog_from_empty"));
        } else if (!this.airportIdents.contains(from)) {
            errors.add(Messages.getInstance().get("route_creator_dialog_from_invalid"));
        }
        String to = (String)this.toComboBox.getSelectedItem();
        if (StringUtil.isEmpty(to)) {
            errors.add(Messages.getInstance().get("route_creator_dialog_to_empty"));
        } else if (!this.airportIdents.contains(to)) {
            errors.add(Messages.getInstance().get("route_creator_dialog_to_invalid"));
        }
        if (!StringUtil.isEmpty(to) && !StringUtil.isEmpty(from) && to.equals(from)) {
            errors.add(Messages.getInstance().get("route_creator_dialog_same_departure_and_destination"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }
}

