/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.creator;

import main.java.guru.vfrflight.gui.flightplan.creator.RouteConditionsType;
import main.java.guru.vfrflight.gui.flightplan.creator.RouteSurfaceType;

public class RandomRouteCriteria {
    private final Integer minDistanceNm;
    private final Integer maxDistanceNm;
    private final Integer minRunwayLengthM;
    private final Integer maxRunwayLengthM;
    private final RouteSurfaceType surfaceType;
    private final RouteConditionsType departureConditions;
    private final RouteConditionsType arrivalConditions;
    private final Boolean departureMountanous;
    private final Boolean arrivalMountanous;
    private final Boolean departureVor;
    private final Boolean arrivalVor;
    private final Boolean departureNdb;
    private final Boolean arrivalNdb;
    private final Boolean arrivalIls;
    private final boolean vorToVor;

    public RandomRouteCriteria(Integer minDistanceNm, Integer maxDistanceNm, Integer minRunwayLengthM, Integer maxRunwayLengthM, RouteSurfaceType surfaceType, RouteConditionsType departureConditions, RouteConditionsType arrivalConditions, Boolean departureMountanous, Boolean arrivalMountanous, Boolean departureVor, Boolean arrivalVor, Boolean departureNdb, Boolean arrivalNdb, Boolean arrivalIls, boolean vorToVor) {
        this.minDistanceNm = minDistanceNm;
        this.maxDistanceNm = maxDistanceNm;
        this.minRunwayLengthM = minRunwayLengthM;
        this.maxRunwayLengthM = maxRunwayLengthM;
        this.surfaceType = surfaceType;
        this.departureConditions = departureConditions;
        this.arrivalConditions = arrivalConditions;
        this.departureMountanous = departureMountanous;
        this.arrivalMountanous = arrivalMountanous;
        this.departureVor = departureVor;
        this.arrivalVor = arrivalVor;
        this.departureNdb = departureNdb;
        this.arrivalNdb = arrivalNdb;
        this.arrivalIls = arrivalIls;
        this.vorToVor = vorToVor;
    }

    public Integer getMinDistanceNm() {
        return this.minDistanceNm;
    }

    public Integer getMaxDistanceNm() {
        return this.maxDistanceNm;
    }

    public Integer getMinRunwayLengthM() {
        return this.minRunwayLengthM;
    }

    public Integer getMaxRunwayLengthM() {
        return this.maxRunwayLengthM;
    }

    public RouteSurfaceType getSurfaceType() {
        return this.surfaceType;
    }

    public RouteConditionsType getDepartureConditions() {
        return this.departureConditions;
    }

    public RouteConditionsType getArrivalConditions() {
        return this.arrivalConditions;
    }

    public Boolean getDepartureMountanous() {
        return this.departureMountanous;
    }

    public Boolean getArrivalMountanous() {
        return this.arrivalMountanous;
    }

    public Boolean getDepartureVor() {
        return this.departureVor;
    }

    public Boolean getArrivalVor() {
        return this.arrivalVor;
    }

    public Boolean getDepartureNdb() {
        return this.departureNdb;
    }

    public Boolean getArrivalNdb() {
        return this.arrivalNdb;
    }

    public Boolean getArrivalIls() {
        return this.arrivalIls;
    }

    public boolean isVorToVor() {
        return this.vorToVor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer minDistanceNm;
        private Integer maxDistanceNm;
        private Integer minRunwayLengthM;
        private Integer maxRunwayLengthM;
        private RouteSurfaceType surfaceType;
        private RouteConditionsType departureConditions;
        private RouteConditionsType arrivalConditions;
        private Boolean departureMountanous;
        private Boolean arrivalMountanous;
        private Boolean departureVor;
        private Boolean arrivalVor;
        private Boolean departureNdb;
        private Boolean arrivalNdb;
        private Boolean arrivalIls;
        private boolean vorToVor = false;

        public RandomRouteCriteria create() {
            return new RandomRouteCriteria(this.minDistanceNm, this.maxDistanceNm, this.minRunwayLengthM, this.maxRunwayLengthM, this.surfaceType, this.departureConditions, this.arrivalConditions, this.departureMountanous, this.arrivalMountanous, this.departureVor, this.arrivalVor, this.departureNdb, this.arrivalNdb, this.arrivalIls, this.vorToVor);
        }

        public Builder withMinDistanceNm(Integer minDistanceNm) {
            this.minDistanceNm = minDistanceNm;
            return this;
        }

        public Builder withMaxDistanceNm(Integer maxDistanceNm) {
            this.maxDistanceNm = maxDistanceNm;
            return this;
        }

        public Builder withMinRunwayLengthM(Integer minRunwayLengthM) {
            this.minRunwayLengthM = minRunwayLengthM;
            return this;
        }

        public Builder withMaxRunwayLengthM(Integer maxRunwayLengthM) {
            this.maxRunwayLengthM = maxRunwayLengthM;
            return this;
        }

        public Builder withSurfaceType(RouteSurfaceType surfaceType) {
            this.surfaceType = surfaceType;
            return this;
        }

        public Builder withDepartureConditions(RouteConditionsType departureConditions) {
            this.departureConditions = departureConditions;
            return this;
        }

        public Builder withArrivalConditions(RouteConditionsType arrivalConditions) {
            this.arrivalConditions = arrivalConditions;
            return this;
        }

        public Builder withDepartureMountanous(Boolean departureMountanous) {
            this.departureMountanous = departureMountanous;
            return this;
        }

        public Builder withArrivalMountanous(Boolean arrivalMountanous) {
            this.arrivalMountanous = arrivalMountanous;
            return this;
        }

        public Builder withDepartureVor(Boolean departureVor) {
            this.departureVor = departureVor;
            return this;
        }

        public Builder withArrivalVor(Boolean arrivalVor) {
            this.arrivalVor = arrivalVor;
            return this;
        }

        public Builder withDepartureNdb(Boolean departureNdb) {
            this.departureNdb = departureNdb;
            return this;
        }

        public Builder withArrivalNdb(Boolean arrivalNdb) {
            this.arrivalNdb = arrivalNdb;
            return this;
        }

        public Builder withArrivalIls(Boolean arrivalIls) {
            this.arrivalIls = arrivalIls;
            return this;
        }

        public Builder withVorToVor(boolean vorToVor) {
            this.vorToVor = vorToVor;
            return this;
        }
    }
}

