/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.connect;

import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public enum SimulatorVersion {
    FSX("MS Flight Simulator X", "Microsoft\\FSX\\", null),
    FSX_SE("FSX: Steam Edition", "Microsoft\\FSX-SE\\", null),
    P3D_v1("Prepar3D v1", "Lockheed Martin\\Prepar3D\\", null),
    P3D_v2("Prepar3D v2", "Lockheed Martin\\Prepar3D v2\\", null),
    P3D_v3("Prepar3D v3", "Lockheed Martin\\Prepar3D v3\\", null),
    P3D_v4("Prepar3D v4", "Lockheed Martin\\Prepar3D v4\\", "UTF-16LE");

    private final String fullName;
    private final String localConfigPath;
    private final String sceneryCfgEncoding;

    private SimulatorVersion(String fullName, String localConfigPath, String sceneryCfgEncoding) {
        this.fullName = fullName;
        this.localConfigPath = localConfigPath;
        this.sceneryCfgEncoding = sceneryCfgEncoding;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSceneryCfgEncoding() {
        return this.sceneryCfgEncoding;
    }

    public String getAppDataPath() {
        return SimulatorVersion.getEnvAppData() + this.localConfigPath;
    }

    public String getProgramDataPath() {
        return SimulatorVersion.getEnvProgramData() + this.localConfigPath;
    }

    private static String getEnvAppData() {
        return StringUtil.finishWithSlash(StringUtil.nullToEmpty(VfrUtil.getEnvVar("APPDATA")));
    }

    private static String getEnvProgramData() {
        return StringUtil.finishWithSlash(StringUtil.nullToEmpty(VfrUtil.getEnvVar("PROGRAMDATA")));
    }
}

