/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.connect;

import java.io.File;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.gui.flightplan.connect.SimConnectXmlUtil;
import main.java.guru.vfrflight.gui.flightplan.connect.SimulatorVersion;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.bean.FsxP3DConnectConfigBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimConnectXmlFileHandler {
    private final SimulatorVersion simulatorType;

    public SimConnectXmlFileHandler(SimulatorVersion simulatorType) {
        this.simulatorType = simulatorType;
    }

    public boolean isSimConnectEntryExists() throws Exception {
        File xmlFile = new File(this.getFullFileName());
        if (!xmlFile.exists()) {
            return false;
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(this.getFullFileName());
        doc.getDocumentElement().normalize();
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        XPathExpression expression = xpath.compile("//*[contains(local-name(), 'SimConnect.Comm')]");
        Node commNode = (Node)expression.evaluate(doc, XPathConstants.NODE);
        return commNode != null;
    }

    public Integer readPortNumber() throws Exception {
        File xmlFile = new File(this.getFullFileName());
        if (xmlFile.exists()) {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(this.getFullFileName());
            doc.getDocumentElement().normalize();
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            XPathExpression expression = xpath.compile("//SimConnect.Comm/*[contains(local-name(), 'Port')]");
            Node portNode = (Node)expression.evaluate(doc, XPathConstants.NODE);
            if (portNode != null) {
                return Integer.valueOf(portNode.getFirstChild().getNodeValue());
            }
        }
        return null;
    }

    public String readIp() throws Exception {
        File xmlFile = new File(this.getFullFileName());
        if (xmlFile.exists()) {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(this.getFullFileName());
            doc.getDocumentElement().normalize();
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            XPathExpression expression = xpath.compile("//SimConnect.Comm/*[contains(local-name(), 'Address')]");
            Node ipNode = (Node)expression.evaluate(doc, XPathConstants.NODE);
            if (ipNode != null) {
                return ipNode.getFirstChild().getNodeValue();
            }
        }
        return null;
    }

    public void addOrUpdateConfiguration(String ip, Integer port) throws Exception {
        SimConnectXmlUtil.createSimConnectFileIfNotExists(this.getFullFileName());
        File fXmlFile = new File(this.getFullFileName());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(fXmlFile);
        doc.getDocumentElement().normalize();
        XPathFactory xpf = XPathFactory.newInstance();
        XPath xpath = xpf.newXPath();
        XPathExpression expression = xpath.compile("//*[contains(local-name(), 'SimConnect.Comm')]");
        Node commNode = (Node)expression.evaluate(doc, XPathConstants.NODE);
        if (commNode != null) {
            commNode.getParentNode().removeChild(commNode);
        }
        Element commElement = doc.createElement("SimConnect.Comm");
        doc.getFirstChild().appendChild(commElement);
        this.appendSimpleXmlNodeElement(doc, commElement, "Disabled", "False");
        this.appendSimpleXmlNodeElement(doc, commElement, "Protocol", "IPv4");
        this.appendSimpleXmlNodeElement(doc, commElement, "Scope", "global");
        this.appendSimpleXmlNodeElement(doc, commElement, "Address", ip);
        this.appendSimpleXmlNodeElement(doc, commElement, "MaxClients", "64");
        this.appendSimpleXmlNodeElement(doc, commElement, "Port", String.valueOf(port));
        this.appendSimpleXmlNodeElement(doc, commElement, "MaxRecvSize", "4096");
        this.appendSimpleXmlNodeElement(doc, commElement, "DisableNagle", "False");
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.setOutputProperty("encoding", "UTF-8");
        t.setOutputProperty("indent", "yes");
        t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(doc);
        t.transform(source, result);
        String content = result.getWriter().toString();
        IOUtil.saveTextFile("<?xml version=\"1.0\"?>" + Constants.EOL + content, this.getFullFileName());
    }

    private String getFullFileName() {
        return this.simulatorType.getAppDataPath() + "SimConnect.xml";
    }

    private void appendSimpleXmlNodeElement(Document doc, Element parentElement, String nodeName, String nodeValue) {
        Element element = doc.createElement(nodeName);
        element.appendChild(doc.createTextNode(nodeValue));
        parentElement.appendChild(element);
    }

    public FsxP3DConnectConfigBean readConfig() {
        return null;
    }
}

