/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.connect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.connect.SimConnectXmlFileHandler;
import main.java.guru.vfrflight.gui.flightplan.connect.SimulatorVersion;
import main.java.guru.vfrflight.util.bean.FsxP3DConnectConfigBean;
import org.apache.log4j.Logger;
import org.hsqldb.lib.StringUtil;

public class FsxP3DConnectRemoteDialog
extends JDialog {
    private static final long serialVersionUID = 5330698785754312544L;
    private static final Logger log = Logger.getLogger(FsxP3DConnectRemoteDialog.class);
    private final SimulatorVersion simulatorVersion;
    private boolean cancelled = false;
    private JTextField ipTextField;

    public FsxP3DConnectRemoteDialog(SimulatorVersion simulatorVersion) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FsxP3DConnectRemoteDialog.this.closeWindowAction(true);
            }
        });
        this.simulatorVersion = simulatorVersion;
        this.setAlwaysOnTop(true);
        this.setResizable(true);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxP3DConnectRemoteDialog.this.okAction();
            }
        });
        buttonPanel.add(okButton);
        JPanel panel_5 = new JPanel();
        panel_3.add((Component)panel_5, "Center");
        panel_5.setBorder(new EtchedBorder(1, null, null));
        panel_5.setLayout(new BorderLayout(0, 0));
        JPanel panel_6 = new JPanel();
        panel_5.add((Component)panel_6, "North");
        JLabel infoLabel = new JLabel(Messages.getInstance().get("fsx_p3d_connect_dialog_remote_ip"));
        panel_6.add(infoLabel);
        JPanel ipPanel = new JPanel();
        panel_5.add((Component)ipPanel, "Center");
        this.ipTextField = new JTextField();
        ipPanel.add(this.ipTextField);
        this.ipTextField.setHorizontalAlignment(0);
        this.ipTextField.setColumns(16);
        this.updateData();
        this.setSize(400, 150);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void updateData() {
        FsxP3DConnectConfigBean configBean = SettingsBean.getInstance().getFsxP3DConnectConfigBean();
        this.ipTextField.setText(configBean.getRemoteIp());
        try {
            String ip;
            SimConnectXmlFileHandler xmlFileHandler = new SimConnectXmlFileHandler(this.simulatorVersion);
            if (xmlFileHandler.isSimConnectEntryExists() && (ip = xmlFileHandler.readIp()) != null) {
                this.ipTextField.setText(ip);
                SettingsBean.getInstance().getFsxP3DConnectConfigBean().setRemoteIp(ip);
            }
        }
        catch (Exception e) {
            log.error(e, e);
        }
    }

    protected void okAction() {
        if (this.doValidate()) {
            FsxP3DConnectConfigBean configBean = SettingsBean.getInstance().getFsxP3DConnectConfigBean();
            configBean.setRemoteIp(this.ipTextField.getText());
            try {
                SimConnectXmlFileHandler xmlFileHandler = new SimConnectXmlFileHandler(configBean.getSimulatorVersion());
                xmlFileHandler.addOrUpdateConfiguration(configBean.getRemoteIp(), configBean.getPort());
                configBean.setIp(this.ipTextField.getText());
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_p3d_connect_dialog_sim_connect_file_updated_warning", this.simulatorVersion.getFullName()), "", 2);
            }
            catch (Exception e) {
                log.error(e, e);
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_p3d_connect_dialog_sim_connect_error_updating_file", this.simulatorVersion.getFullName()), "", 0);
            }
            this.closeWindowAction(false);
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmpty(this.ipTextField.getText())) {
            errors.add(Messages.getInstance().get("fsx_p3d_connect_dialog_ip_invalid"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void closeWindowAction(boolean cancelled) {
        this.cancelled = cancelled;
        this.setVisible(false);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

