/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan.connect;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.connect.FsxP3DConnectRemoteDialog;
import main.java.guru.vfrflight.gui.flightplan.connect.SimConnectXmlFileHandler;
import main.java.guru.vfrflight.gui.flightplan.connect.SimulatorVersion;
import main.java.guru.vfrflight.gui.flightplan.connect.SimulatorVersionComboBoxItem;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.bean.FsxP3DConnectConfigBean;
import org.apache.log4j.Logger;
import org.hsqldb.lib.StringUtil;

public class FsxP3DConnectDialog
extends JDialog {
    private static final long serialVersionUID = 3131958975286743369L;
    private static final Logger log = Logger.getLogger(FsxP3DConnectDialog.class);
    private boolean cancelled = false;
    private JTextField ipTextField;
    private IntegerTextField portTextField;
    private JCheckBox localhostCheckBox;
    private JButton installSimConnectButton;
    private JComboBox<SimulatorVersionComboBoxItem> simulatorVersionComboBox;

    public FsxP3DConnectDialog() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FsxP3DConnectDialog.this.closeWindowAction(true);
            }
        });
        this.setAlwaysOnTop(true);
        this.setResizable(true);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("connect_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxP3DConnectDialog.this.connectAction();
            }
        });
        buttonPanel.add(okButton);
        this.installSimConnectButton = new JButton(Messages.getInstance().get("fsx_p3d_connect_install_remote_sim_connect_xml"));
        this.installSimConnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxP3DConnectDialog.this.installSimConnectButtonAction();
            }
        });
        buttonPanel.add(this.installSimConnectButton);
        JPanel panel_5 = new JPanel();
        panel_3.add((Component)panel_5, "Center");
        panel_5.setBorder(new EtchedBorder(1, null, null));
        panel_5.setLayout(new BorderLayout(0, 0));
        JPanel panel_6 = new JPanel();
        panel_5.add((Component)panel_6, "North");
        JLabel infoLabel = new JLabel(Messages.getInstance().get("fsx_p3d_connect_dialog_simulator_version"));
        panel_6.add(infoLabel);
        this.simulatorVersionComboBox = new JComboBox();
        SimulatorVersionComboBoxItem[] values = new SimulatorVersionComboBoxItem[SimulatorVersion.values().length];
        int i = 0;
        for (SimulatorVersion type : SimulatorVersion.values()) {
            values[i] = new SimulatorVersionComboBoxItem(type);
            ++i;
        }
        this.simulatorVersionComboBox.setModel(new DefaultComboBoxModel<SimulatorVersionComboBoxItem>(values));
        this.simulatorVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxP3DConnectDialog.this.simulatorVersionAction();
            }
        });
        panel_6.add(this.simulatorVersionComboBox);
        JPanel panel_1 = new JPanel();
        panel_5.add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        panel_1.add((Component)contentPanel, "North");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel thisPcPanel = new JPanel();
        contentPanel.add((Component)thisPcPanel, "North");
        this.localhostCheckBox = new JCheckBox(Messages.getInstance().get("fsx_p3d_connect_dialog_simulator_on_this_pc"));
        this.localhostCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FsxP3DConnectDialog.this.localhostAction();
            }
        });
        thisPcPanel.add(this.localhostCheckBox);
        JPanel ipPanel = new JPanel();
        contentPanel.add((Component)ipPanel, "Center");
        JLabel label = new JLabel(Messages.getInstance().get("fsx_p3d_connect_dialog_ip"));
        ipPanel.add(label);
        this.ipTextField = new JTextField();
        ipPanel.add(this.ipTextField);
        this.ipTextField.setHorizontalAlignment(0);
        this.ipTextField.setColumns(16);
        JPanel panel = new JPanel();
        panel_1.add((Component)panel, "Center");
        JLabel label_1 = new JLabel(Messages.getInstance().get("fsx_p3d_connect_dialog_port"));
        panel.add(label_1);
        this.portTextField = new IntegerTextField(1);
        this.portTextField.setHorizontalAlignment(0);
        this.portTextField.setColumns(7);
        panel.add(this.portTextField);
        this.updateData();
        this.setSize(500, 220);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void installSimConnectButtonAction() {
        SimulatorVersion selectedSimulatorVersion = ((SimulatorVersionComboBoxItem)this.simulatorVersionComboBox.getSelectedItem()).getValue();
        FsxP3DConnectRemoteDialog dialog = new FsxP3DConnectRemoteDialog(selectedSimulatorVersion);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            this.updateData();
        }
    }

    private void updateData() {
        FsxP3DConnectConfigBean configBean = SettingsBean.getInstance().getFsxP3DConnectConfigBean();
        int i = 0;
        for (SimulatorVersion ver : SimulatorVersion.values()) {
            if (ver.equals((Object)configBean.getSimulatorVersion())) {
                this.simulatorVersionComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        this.ipTextField.setText(configBean.getIp());
        this.portTextField.setValue(configBean.getPort());
        this.localhostCheckBox.setSelected(configBean.isLocalhost());
        this.localhostAction();
        this.simulatorVersionAction();
    }

    private void localhostAction() {
        this.ipTextField.setEnabled(!this.localhostCheckBox.isSelected());
        this.installSimConnectButton.setEnabled(VfrUtil.isWindows() && this.localhostCheckBox.isSelected());
    }

    private void simulatorVersionAction() {
        if (this.localhostCheckBox.isSelected()) {
            try {
                SimulatorVersion selectedSimulatorVersion = ((SimulatorVersionComboBoxItem)this.simulatorVersionComboBox.getSelectedItem()).getValue();
                SimConnectXmlFileHandler xmlFileHandler = new SimConnectXmlFileHandler(selectedSimulatorVersion);
                if (xmlFileHandler.isSimConnectEntryExists()) {
                    String ip;
                    Integer port = xmlFileHandler.readPortNumber();
                    if (port != null) {
                        this.portTextField.setValue(port);
                        SettingsBean.getInstance().getFsxP3DConnectConfigBean().setPort(port);
                    }
                    if ((ip = xmlFileHandler.readIp()) != null) {
                        this.ipTextField.setText(ip);
                        SettingsBean.getInstance().getFsxP3DConnectConfigBean().setIp(ip);
                    }
                }
            }
            catch (Exception e) {
                log.error(e, e);
            }
        }
    }

    protected void connectAction() {
        if (this.doValidate()) {
            SimulatorVersion selectedSimulatorVersion = ((SimulatorVersionComboBoxItem)this.simulatorVersionComboBox.getSelectedItem()).getValue();
            boolean selectedLocalhost = this.localhostCheckBox.isSelected();
            String enteredIp = this.ipTextField.getText();
            Integer enteredPort = this.portTextField.getValue();
            FsxP3DConnectConfigBean configBean = SettingsBean.getInstance().getFsxP3DConnectConfigBean();
            boolean dataChanged = !enteredIp.equals(configBean.getIp()) || !enteredPort.equals(configBean.getPort());
            configBean.setLocalhost(selectedLocalhost);
            configBean.setIp(enteredIp);
            configBean.setPort(enteredPort);
            configBean.setSimulatorVersion(selectedSimulatorVersion);
            if (VfrUtil.isWindows() && configBean.isLocalhost()) {
                try {
                    boolean fileWasUpdated;
                    SimConnectXmlFileHandler xmlFileHandler = new SimConnectXmlFileHandler(configBean.getSimulatorVersion());
                    boolean bl = fileWasUpdated = !xmlFileHandler.isSimConnectEntryExists() || dataChanged;
                    if (SimulatorVersion.P3D_v4.equals((Object)configBean.getSimulatorVersion())) {
                        xmlFileHandler.addOrUpdateConfiguration(configBean.getIp(), configBean.getPort());
                    }
                    if (fileWasUpdated) {
                        JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_p3d_connect_dialog_sim_connect_file_updated_warning", selectedSimulatorVersion.getFullName()), "", 2);
                    }
                }
                catch (Exception e) {
                    log.error(e, e);
                    JOptionPane.showMessageDialog(this, Messages.getInstance().get("fsx_p3d_connect_dialog_sim_connect_error_updating_file", selectedSimulatorVersion.getFullName()), "", 0);
                }
            }
            this.closeWindowAction(false);
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.portTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("fsx_p3d_connect_dialog_port_empty"));
        }
        if (!this.localhostCheckBox.isSelected() && StringUtil.isEmpty(this.ipTextField.getText())) {
            errors.add(Messages.getInstance().get("fsx_p3d_connect_dialog_ip_invalid"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void closeWindowAction(boolean cancelled) {
        this.cancelled = cancelled;
        this.setVisible(false);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

