/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.SelectionDialog;
import main.java.guru.vfrflight.gui.swing.panel.file.FileChooserPanel;
import main.java.guru.vfrflight.gui.task.XmlExportTask;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;

public class XmlExportDialog
extends JDialog {
    private static final long serialVersionUID = -4670789705264494378L;
    private FileChooserPanel fileChooserPanel;
    private JRadioButton allDBRadio;
    private JRadioButton exportRegionRadio;
    private JCheckBox includeDeleteTagsCheckBox;

    public XmlExportDialog(Window frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                XmlExportDialog.this.closeWindowAction();
            }
        });
        this.setTitle(Messages.getInstance().get("export"));
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlExportDialog.this.exportAction();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlExportDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(cancelButton);
        JPanel panel_2 = new JPanel();
        panel.add((Component)panel_2, "Center");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        panel_2.add((Component)panel_1, "North");
        this.fileChooserPanel = new FileChooserPanel(Messages.getInstance().get("xml_export_dialog_select_file"), Messages.getInstance().get("xml_files"), "XML", true, 40);
        this.fileChooserPanel.setBorder(new EtchedBorder(1, null, null));
        panel_1.add(this.fileChooserPanel);
        JPanel panel_3 = new JPanel();
        panel_2.add((Component)panel_3, "South");
        this.allDBRadio = new JRadioButton(Messages.getInstance().get("xml_export_dialog_no_region"), true);
        panel_3.add(this.allDBRadio);
        this.exportRegionRadio = new JRadioButton(Messages.getInstance().get("xml_export_dialog_select_region"));
        panel_3.add(this.exportRegionRadio);
        ButtonGroup group = new ButtonGroup();
        group.add(this.allDBRadio);
        group.add(this.exportRegionRadio);
        JPanel panel_4 = new JPanel();
        panel_2.add((Component)panel_4, "Center");
        this.includeDeleteTagsCheckBox = new JCheckBox(Messages.getInstance().get("xml_export_dialog_include_delete_tags"), true);
        panel_4.add(this.includeDeleteTagsCheckBox);
        this.setSize(500, 200);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.setModal(true);
        this.pack();
    }

    private void exportAction() {
        String filename;
        if (this.doValidate() && (!new File(filename = IOUtil.addExtension(new File(this.fileChooserPanel.getChosenPath()), "xml")).exists() || GuiUtil.showConfirmationDialog(MapFrame.getInstance(), Messages.getInstance().get("export"), Messages.getInstance().get("file_saving_dialog_overwrite_question")))) {
            this.closeWindowAction();
            if (this.exportRegionRadio.isSelected()) {
                SelectionDialog dialog = new SelectionDialog(MapFrame.getInstance(), new XmlExportTask(filename, this.includeDeleteTagsCheckBox.isSelected()));
                dialog.setVisible(true);
            } else {
                new Thread(new XmlExportTask(filename, this.includeDeleteTagsCheckBox.isSelected(), null)).start();
            }
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.fileChooserPanel.isPathSelected()) {
            errors.add(Messages.getInstance().get("xml_export_dialog_path_must_be_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }
}

