/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.swing.panel.file.FileChooserPanel;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.XplaneImportUtil;
import main.java.guru.vfrflight.util.bean.XPConnectConfigBean;
import main.java.guru.vfrflight.xpc.XPCUtil;
import org.apache.log4j.Logger;

public class XPConnectDialog
extends JDialog {
    private static final long serialVersionUID = 8620594313432992264L;
    private static final Logger log = Logger.getLogger(XPConnectDialog.class);
    private static final String VIDEO_TUTORIAL_URL = "https://www.youtube.com/watch?v=okAgPP2sMO4&feature=youtu.be";
    private JTextField ipTextField;
    private IntegerTextField portTextField;
    private JCheckBox localhostCheckBox;
    private boolean cancelled = false;
    private FileChooserPanel xplaneDirectoryPanel;

    public XPConnectDialog() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                XPConnectDialog.this.closeWindowAction(true);
            }
        });
        this.setAlwaysOnTop(true);
        this.setResizable(true);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XPConnectDialog.this.connectAction();
            }
        });
        buttonPanel.add(okButton);
        JButton helpButton = new JButton(Messages.getInstance().get("show_me_tutorial_video_button"));
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UrlUtil.openUrlInBrowser(XPConnectDialog.VIDEO_TUTORIAL_URL);
            }
        });
        buttonPanel.add(helpButton);
        JPanel panel_5 = new JPanel();
        panel_3.add((Component)panel_5, "Center");
        panel_5.setBorder(new EtchedBorder(1, null, null));
        panel_5.setLayout(new BorderLayout(0, 0));
        JPanel panel_6 = new JPanel();
        panel_5.add((Component)panel_6, "North");
        JLabel infoLabel = new JLabel(Messages.getInstance().get("xpconnect_dialog_info"));
        panel_6.add(infoLabel);
        JPanel panel_1 = new JPanel();
        panel_5.add((Component)panel_1, "Center");
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        panel_1.add((Component)contentPanel, "North");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel xplaneIpPanel = new JPanel();
        contentPanel.add((Component)xplaneIpPanel, "North");
        JLabel ipLabel = new JLabel(Messages.getInstance().get("xpconnect_dialog_ip"));
        xplaneIpPanel.add(ipLabel);
        this.ipTextField = new JTextField();
        this.ipTextField.setHorizontalAlignment(0);
        xplaneIpPanel.add(this.ipTextField);
        this.ipTextField.setColumns(20);
        JLabel portLabel = new JLabel(Messages.getInstance().get("xpconnect_dialog_port"));
        xplaneIpPanel.add(portLabel);
        this.portTextField = new IntegerTextField(1);
        this.portTextField.setHorizontalAlignment(0);
        xplaneIpPanel.add(this.portTextField);
        this.portTextField.setColumns(7);
        JPanel panel = new JPanel();
        contentPanel.add((Component)panel, "Center");
        this.localhostCheckBox = new JCheckBox(Messages.getInstance().get("xpconnect_dialog_localhost"));
        this.localhostCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                XPConnectDialog.this.localhostAction();
            }
        });
        this.localhostCheckBox.setSelected(true);
        panel.add(this.localhostCheckBox);
        this.xplaneDirectoryPanel = new FileChooserPanel(Messages.getInstance().get("xpconnect_dialog_xplane_main_dir"), false);
        panel_1.add((Component)this.xplaneDirectoryPanel, "Center");
        this.updateData();
        this.setSize(500, 265);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void updateData() {
        XPConnectConfigBean configBean = SettingsBean.getInstance().getXpConnectConfigBean();
        this.ipTextField.setText(configBean.getXplaneIp());
        this.portTextField.setValue(configBean.getXplanePort());
        this.localhostCheckBox.setSelected(configBean.isLocalhost());
        if (configBean.getXplaneMainDir() != null) {
            this.xplaneDirectoryPanel.setChosenPath(configBean.getXplaneMainDir());
        }
        this.localhostAction();
    }

    private void localhostAction() {
        this.ipTextField.setEnabled(!this.localhostCheckBox.isSelected());
        this.portTextField.setEnabled(!this.localhostCheckBox.isSelected());
        this.xplaneDirectoryPanel.setEnabled(this.localhostCheckBox.isSelected());
    }

    protected void connectAction() {
        if (this.doValidate()) {
            XPConnectConfigBean configBean = SettingsBean.getInstance().getXpConnectConfigBean();
            configBean.setLocalhost(this.localhostCheckBox.isSelected());
            configBean.setXplaneIp(this.ipTextField.getText());
            configBean.setXplanePort(this.portTextField.getValue());
            configBean.setXplaneMainDir(this.xplaneDirectoryPanel.getChosenPath());
            this.closeWindowAction(false);
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.localhostCheckBox.isSelected()) {
            if (StringUtil.isEmpty(this.ipTextField.getText()) || !StringUtil.isValidIpAddress(this.ipTextField.getText())) {
                errors.add(Messages.getInstance().get("xpconnect_dialog_ip_invalid"));
            }
            if (this.portTextField.getValue() == null) {
                errors.add(Messages.getInstance().get("xpconnect_dialog_port_empty"));
            }
        } else if (StringUtil.isEmpty(this.xplaneDirectoryPanel.getChosenPath())) {
            errors.add(Messages.getInstance().get("xpconnect_dialog_xplane_main_dir_empty"));
        } else {
            String prfFileLocation = StringUtil.finishWithSlash(this.xplaneDirectoryPanel.getChosenPath()) + "Output/preferences/X-Plane.prf";
            Map<String, String> config = XPCUtil.readPrfConfig(prfFileLocation);
            if (config != null) {
                this.validatePrfFile(config, errors);
            } else {
                errors.add(Messages.getInstance().get("xpconnect_dialog_invalid_xplane_prf_file"));
            }
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void validatePrfFile(Map<String, String> config, List<String> errors) {
        boolean isXp10;
        boolean bl = isXp10 = config.get("_snd_ip_str_64") != null;
        if (isXp10) {
            this.validateXp10PrfFile(config, errors);
        } else {
            this.validateXp11PrfFile(config, errors);
        }
    }

    private void validateXp10PrfFile(Map<String, String> config, List<String> errors) {
        String configuredIp = config.get("_snd_ip_str_64");
        Integer configuredPort = null;
        if (config.get("_snd_pt_str_64") != null) {
            try {
                configuredPort = Integer.valueOf(config.get("_snd_pt_str_64"));
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
        if (!"127.0.0.1".equals(configuredIp)) {
            errors.add(Messages.getInstance().get("xpconnect_dialog_expected_ip_in_config", "127.0.0.1"));
        }
        if (configuredPort == null) {
            errors.add(Messages.getInstance().get("xpconnect_dialog_empty_port_in_config"));
        } else {
            this.portTextField.setValue(configuredPort);
        }
        Map<Integer, Boolean> binetConfig = XplaneImportUtil.readDatarefsConfig(config, "_Binet_");
        if (!(Boolean.TRUE.equals(binetConfig.get(3)) && Boolean.TRUE.equals(binetConfig.get(17)) && Boolean.TRUE.equals(binetConfig.get(20)))) {
            errors.add(Messages.getInstance().get("xpconnect_dialog_invalid_datarefs_in_config"));
        }
    }

    private void validateXp11PrfFile(Map<String, String> config, List<String> errors) {
        String configuredIp = config.get("_snd_ip_str_42");
        Integer configuredPort = null;
        if (config.get("_snd_pt_str_42") != null) {
            try {
                configuredPort = Integer.valueOf(config.get("_snd_pt_str_42"));
            }
            catch (NumberFormatException e) {
                log.error(e, e);
            }
        }
        if (!"127.0.0.1".equals(configuredIp)) {
            errors.add(Messages.getInstance().get("xpconnect_dialog_expected_ip_in_config", "127.0.0.1"));
        }
        if (configuredPort == null) {
            errors.add(Messages.getInstance().get("xpconnect_dialog_empty_port_in_config"));
        } else {
            this.portTextField.setValue(configuredPort);
        }
        Map<Integer, Boolean> binetConfig = XplaneImportUtil.readDatarefsConfig(config, "_Binet");
        if (!(Boolean.TRUE.equals(binetConfig.get(3)) && Boolean.TRUE.equals(binetConfig.get(17)) && Boolean.TRUE.equals(binetConfig.get(20)))) {
            errors.add(Messages.getInstance().get("xpconnect_dialog_invalid_datarefs_in_config"));
        }
    }

    private void closeWindowAction(boolean cancelled) {
        this.cancelled = cancelled;
        this.setVisible(false);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

