/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.button.ToolbarButton;
import main.java.guru.vfrflight.gui.swing.panel.image.ImageFilePanel;
import main.java.guru.vfrflight.util.GuiUtil;

public class WelcomeScreenDialog
extends JDialog {
    private static final long serialVersionUID = 9159649316937343948L;
    private JCheckBox dontShowAgainCheckBox;

    public WelcomeScreenDialog(Frame frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                WelcomeScreenDialog.this.closeWindowAction();
            }
        });
        this.setTitle(Messages.getInstance().get("welcome_screen_dialog_title"));
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        JButton closeButton = new JButton(Messages.getInstance().get("close_button"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WelcomeScreenDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(closeButton);
        JPanel resultsTablePanel = new JPanel();
        panel.add((Component)resultsTablePanel, "Center");
        resultsTablePanel.setLayout(new BorderLayout(0, 0));
        JPanel panel_3 = new JPanel();
        resultsTablePanel.add((Component)panel_3, "South");
        this.dontShowAgainCheckBox = new JCheckBox(Messages.getInstance().get("dont_show_again"));
        panel_3.add(this.dontShowAgainCheckBox);
        JPanel panel_4 = new JPanel();
        resultsTablePanel.add(panel_4);
        panel_4.setLayout(new BorderLayout(0, 0));
        ImageFilePanel imagePanel = new ImageFilePanel("img/welcome" + SettingsBean.getInstance().getParamLanguage() + ".jpg");
        panel_4.add((Component)imagePanel, "Center");
        JPanel textPanel = new JPanel();
        panel_4.add((Component)textPanel, "North");
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("welcome_screen_dialog_text"));
        lblNewLabel.setHorizontalAlignment(0);
        textPanel.add(lblNewLabel);
        lblNewLabel.setFont(new Font("SansSerif", 0, 12));
        JPanel linksPanel = new JPanel();
        panel_4.add((Component)linksPanel, "South");
        linksPanel.setLayout(new BorderLayout(0, 0));
        JPanel facebookPanel = new JPanel();
        linksPanel.add(facebookPanel);
        facebookPanel.setLayout(new FlowLayout(1, 5, 5));
        JLabel lblNewLabel_1 = new JLabel(Messages.getInstance().get("welcome_screen_dialog_facebook_page"));
        facebookPanel.add(lblNewLabel_1);
        ToolbarButton facebookButton = new ToolbarButton("img/gui/facebook.png", Messages.getInstance().get("main_frame_menu_help_facebook"), false);
        facebookButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFrame.getInstance().getUIPanel().facebookAction();
            }
        });
        facebookPanel.add(facebookButton);
        JPanel panel_1 = new JPanel();
        panel.add((Component)panel_1, "North");
        panel_1.setLayout(new BorderLayout(0, 0));
        this.setPreferredSize(new Dimension(500, 450));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.setModal(true);
    }

    public void closeWindowAction() {
        SettingsBean.getInstance().setParamShowWelcomeScreen(!this.dontShowAgainCheckBox.isSelected());
        if (GuiUtil.showConfirmationDialog(MapFrame.getInstance(), Messages.getInstance().get("welcome_dialog_example_plan"), Messages.getInstance().get("welcome_dialog_load_example_plan"))) {
            MapFrame.getInstance().getUIPanel().loadAction("data/example.vfr");
        }
        if (SettingsBean.getInstance().isParamFsxP3dMode()) {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("welcome_screen_dialog_fsx_p3d_data_import"), "", 1);
        }
        this.setVisible(false);
    }
}

