/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.item.ComboBoxItem;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.core.WnBProfile;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.PositiveDecimalFilter;
import main.java.guru.vfrflight.gui.swing.button.ToolbarButton;
import main.java.guru.vfrflight.gui.table.WeightAndBalanceTable;
import main.java.guru.vfrflight.gui.table.model.row.WnBRow;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.WnBProfileUtil;

public class WeightAndBalanceDialog
extends JDialog {
    private static final long serialVersionUID = -4455090335630982624L;
    private WeightAndBalanceTable wnbTable;
    private JLabel totalMassLabel;
    private JTextField totalMassTextField;
    private JLabel cogLabel;
    private JLabel totalMassUnitLabel;
    private JLabel remainingMassUnitLabel;
    private JTextField cogTextField;
    private JComboBox<StringComboBoxItem> totalMassCombo;
    private JComboBox<StringComboBoxItem> cogCombo;
    private JComboBox<StringComboBoxItem> torqueCombo;
    private JComboBox<ComboBoxItem<WnBProfile>> profilesCombo;
    private String prevMassUnit;
    private JTextArea remarksTextArea;
    private StringComboBoxItem[] MASS_VALUES_COMBO = new StringComboBoxItem[]{new StringComboBoxItem("kg", "kg"), new StringComboBoxItem("lbs", "lbs")};
    private StringComboBoxItem[] COG_VALUES_COMBO = new StringComboBoxItem[]{new StringComboBoxItem("in", "in"), new StringComboBoxItem("cm", "cm")};
    private StringComboBoxItem[] TORQUE_VALUES_COMBO = new StringComboBoxItem[]{new StringComboBoxItem("kg*mm/1000", "kg*mm/1000"), new StringComboBoxItem("lbs*in/1000", "lbs*in/1000")};
    private JTextField mtowTextField;
    private static final Color TEXTFIELD_COLOR_DISABLED = new Color(200, 200, 200);
    private static final Color TEXTFIELD_COLOR_WARNING = new Color(255, 100, 100);
    private JTextField remainingMassTextField;

    public WeightAndBalanceDialog(JFrame frame) {
        super(frame);
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                WeightAndBalanceDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{227, 280};
        gridBagLayout.rowHeights = new int[]{42, 227, 192, 30};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
        this.getContentPane().setLayout(gridBagLayout);
        JPanel profilePanel = new JPanel();
        GridBagConstraints gbc_profilePanel = new GridBagConstraints();
        gbc_profilePanel.fill = 1;
        gbc_profilePanel.insets = new Insets(0, 0, 5, 0);
        gbc_profilePanel.gridwidth = 2;
        gbc_profilePanel.gridx = 0;
        gbc_profilePanel.gridy = 0;
        this.getContentPane().add((Component)profilePanel, gbc_profilePanel);
        profilePanel.setBorder(new EtchedBorder(1, null, null));
        JLabel lblProfil = new JLabel(Messages.getInstance().get("wnb_frame_profile_label"));
        profilePanel.add(lblProfil);
        this.profilesCombo = new JComboBox();
        this.profilesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WeightAndBalanceDialog.this.profileChangedAction();
            }
        });
        profilePanel.add(this.profilesCombo);
        ToolbarButton profileUpdateButton = new ToolbarButton("img/gui/disk.png", Messages.getInstance().get("profile_update_tool_tip"), SettingsBean.getInstance().isTouchScreenMode());
        profileUpdateButton.setBounds(0, 0, 30, 27);
        profilePanel.add(profileUpdateButton);
        profileUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WeightAndBalanceDialog.this.updateProfileAction();
            }
        });
        ToolbarButton profileSaveNewButton = new ToolbarButton("img/gui/add.png", Messages.getInstance().get("profile_save_tool_tip"), SettingsBean.getInstance().isTouchScreenMode());
        profileSaveNewButton.setBounds(30, 0, 30, 27);
        profilePanel.add(profileSaveNewButton);
        profileSaveNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WeightAndBalanceDialog.this.saveNewProfileAction();
            }
        });
        ToolbarButton profileDeleteButton = new ToolbarButton("img/gui/cross.png", Messages.getInstance().get("profile_delete_tool_tip"), SettingsBean.getInstance().isTouchScreenMode());
        profileDeleteButton.setBounds(60, 0, 30, 27);
        profilePanel.add(profileDeleteButton);
        profileDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WeightAndBalanceDialog.this.deleteProfileAction();
            }
        });
        JPanel panel = new JPanel();
        panel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.anchor = 17;
        gbc_panel.fill = 1;
        gbc_panel.insets = new Insets(0, 0, 5, 0);
        gbc_panel.gridwidth = 2;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 1;
        this.getContentPane().add((Component)panel, gbc_panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel mainPanel = new JPanel();
        panel.add((Component)mainPanel, "Center");
        mainPanel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        buttonPanel.setLayout(new FlowLayout(1, 5, 5));
        JButton btnNewButton = new JButton(Messages.getInstance().get("add_row_button"));
        buttonPanel.add(btnNewButton);
        JButton btnNewButton_1 = new JButton(Messages.getInstance().get("delete_row_button"));
        buttonPanel.add(btnNewButton_1);
        btnNewButton_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WeightAndBalanceDialog.this.deleteRowAction();
            }
        });
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WeightAndBalanceDialog.this.addRowAction();
            }
        });
        JPanel summaryPanel = new JPanel();
        GridBagConstraints gbc_summaryPanel = new GridBagConstraints();
        gbc_summaryPanel.fill = 1;
        gbc_summaryPanel.insets = new Insets(0, 0, 5, 5);
        gbc_summaryPanel.gridx = 0;
        gbc_summaryPanel.gridy = 2;
        this.getContentPane().add((Component)summaryPanel, gbc_summaryPanel);
        GridBagLayout gbl_summaryPanel = new GridBagLayout();
        gbl_summaryPanel.columnWidths = new int[]{220};
        gbl_summaryPanel.rowHeights = new int[]{66, 39, 36};
        gbl_summaryPanel.columnWeights = new double[]{0.0};
        gbl_summaryPanel.rowWeights = new double[]{0.0, 0.0, 0.0};
        summaryPanel.setLayout(gbl_summaryPanel);
        JPanel massSummaryPanel = new JPanel();
        massSummaryPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_massSummaryPanel = new GridBagConstraints();
        gbc_massSummaryPanel.anchor = 11;
        gbc_massSummaryPanel.fill = 2;
        gbc_massSummaryPanel.insets = new Insets(0, 0, 5, 0);
        gbc_massSummaryPanel.gridx = 0;
        gbc_massSummaryPanel.gridy = 0;
        summaryPanel.add((Component)massSummaryPanel, gbc_massSummaryPanel);
        massSummaryPanel.setLayout(new BorderLayout(0, 0));
        JPanel mtowPanel = new JPanel();
        massSummaryPanel.add((Component)mtowPanel, "North");
        JLabel mtowLabel = new JLabel(Messages.getInstance().get("wnb_frame_mtow_label"));
        mtowPanel.add(mtowLabel);
        this.mtowTextField = new JTextField();
        mtowPanel.add(this.mtowTextField);
        this.mtowTextField.setColumns(5);
        this.mtowTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    WeightAndBalanceDialog.this.mtowChanged();
                }
            }
        });
        this.totalMassCombo = new JComboBox();
        mtowPanel.add(this.totalMassCombo);
        this.totalMassCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WeightAndBalanceDialog.this.recalculateMass();
            }
        });
        this.totalMassCombo.setModel(new DefaultComboBoxModel<StringComboBoxItem>(this.MASS_VALUES_COMBO));
        StringComboBoxItem massUnit = (StringComboBoxItem)this.totalMassCombo.getSelectedItem();
        JPanel totalMassPanel = new JPanel();
        massSummaryPanel.add((Component)totalMassPanel, "Center");
        this.totalMassLabel = new JLabel(Messages.getInstance().get("wnb_frame_total_mass_label"));
        totalMassPanel.add(this.totalMassLabel);
        this.totalMassTextField = new JTextField();
        this.totalMassTextField.setEditable(false);
        totalMassPanel.add(this.totalMassTextField);
        this.totalMassTextField.setColumns(5);
        this.totalMassTextField.setBackground(TEXTFIELD_COLOR_DISABLED);
        this.totalMassUnitLabel = new JLabel(massUnit.getValue());
        totalMassPanel.add(this.totalMassUnitLabel);
        JPanel remainingMassPanel = new JPanel();
        massSummaryPanel.add((Component)remainingMassPanel, "South");
        JLabel remainingMassLabel = new JLabel(Messages.getInstance().get("wnb_frame_remaining_mass_label"));
        remainingMassPanel.add(remainingMassLabel);
        this.remainingMassTextField = new JTextField();
        this.remainingMassTextField.setEditable(false);
        this.remainingMassTextField.setColumns(5);
        this.remainingMassTextField.setBackground(new Color(200, 200, 200));
        remainingMassPanel.add(this.remainingMassTextField);
        this.remainingMassUnitLabel = new JLabel(massUnit.getValue());
        remainingMassPanel.add(this.remainingMassUnitLabel);
        ((AbstractDocument)this.mtowTextField.getDocument()).setDocumentFilter(new PositiveDecimalFilter());
        this.mtowTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                WeightAndBalanceDialog.this.mtowChanged();
            }
        });
        JPanel cogSummaryPanel = new JPanel();
        cogSummaryPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_cogSummaryPanel = new GridBagConstraints();
        gbc_cogSummaryPanel.fill = 1;
        gbc_cogSummaryPanel.insets = new Insets(0, 0, 5, 0);
        gbc_cogSummaryPanel.gridx = 0;
        gbc_cogSummaryPanel.gridy = 1;
        summaryPanel.add((Component)cogSummaryPanel, gbc_cogSummaryPanel);
        this.cogLabel = new JLabel(Messages.getInstance().get("wnb_frame_cog_label"));
        cogSummaryPanel.add(this.cogLabel);
        this.cogTextField = new JTextField();
        cogSummaryPanel.add(this.cogTextField);
        this.cogTextField.setEditable(false);
        this.cogTextField.setColumns(5);
        this.cogTextField.setBackground(TEXTFIELD_COLOR_DISABLED);
        this.cogCombo = new JComboBox();
        cogSummaryPanel.add(this.cogCombo);
        this.cogCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WeightAndBalanceDialog.this.recalculateCog();
            }
        });
        this.cogCombo.setModel(new DefaultComboBoxModel<StringComboBoxItem>(this.COG_VALUES_COMBO));
        String selectedCogUnit = ((StringComboBoxItem)this.cogCombo.getSelectedItem()).getValue();
        JPanel torqueSummaryPanel = new JPanel();
        torqueSummaryPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_torqueSummaryPanel = new GridBagConstraints();
        gbc_torqueSummaryPanel.anchor = 11;
        gbc_torqueSummaryPanel.fill = 2;
        gbc_torqueSummaryPanel.gridx = 0;
        gbc_torqueSummaryPanel.gridy = 2;
        summaryPanel.add((Component)torqueSummaryPanel, gbc_torqueSummaryPanel);
        JLabel torqueLabel = new JLabel(Messages.getInstance().get("wnb_frame_torque_label"));
        torqueSummaryPanel.add(torqueLabel);
        this.torqueCombo = new JComboBox();
        torqueSummaryPanel.add(this.torqueCombo);
        this.torqueCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                WeightAndBalanceDialog.this.recalculateTorque();
            }
        });
        this.torqueCombo.setModel(new DefaultComboBoxModel<StringComboBoxItem>(this.TORQUE_VALUES_COMBO));
        String selectedTorqueUnit = ((StringComboBoxItem)this.torqueCombo.getSelectedItem()).getValue();
        JPanel remarksWrapperPanel = new JPanel();
        GridBagConstraints gbc_remarksWrapperPanel = new GridBagConstraints();
        gbc_remarksWrapperPanel.insets = new Insets(0, 0, 5, 0);
        gbc_remarksWrapperPanel.fill = 1;
        gbc_remarksWrapperPanel.gridx = 1;
        gbc_remarksWrapperPanel.gridy = 2;
        this.getContentPane().add((Component)remarksWrapperPanel, gbc_remarksWrapperPanel);
        remarksWrapperPanel.setBorder(new EtchedBorder(1, null, null));
        remarksWrapperPanel.setLayout(new BorderLayout(0, 0));
        JPanel remarksPanel = new JPanel();
        remarksWrapperPanel.add((Component)remarksPanel, "Center");
        remarksPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.remarksTextArea = new JTextArea();
        this.remarksTextArea.setLineWrap(true);
        this.remarksTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                WeightAndBalanceDialog.this.remarksChanged();
            }
        });
        remarksPanel.setLayout(new BorderLayout(0, 0));
        JScrollPane scroll = new JScrollPane(this.remarksTextArea);
        scroll.setVerticalScrollBarPolicy(20);
        remarksPanel.add(scroll);
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("wnb_frame_remarks"));
        lblNewLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        remarksWrapperPanel.add((Component)lblNewLabel, "North");
        this.prevMassUnit = massUnit.getValue();
        this.wnbTable = new WeightAndBalanceTable(this, selectedCogUnit, selectedTorqueUnit);
        mainPanel.add(this.wnbTable);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("wnb_frame_title"));
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.recalculateInfoLabel();
        this.setWnBProfilesCombo(SettingsBean.getInstance().getWnbProfiles());
        this.remarksTextArea.setBorder(this.cogTextField.getBorder());
        JPanel panel_1 = new JPanel();
        GridBagConstraints gbc_panel_1 = new GridBagConstraints();
        gbc_panel_1.gridwidth = 2;
        gbc_panel_1.insets = new Insets(0, 0, 0, 5);
        gbc_panel_1.fill = 1;
        gbc_panel_1.gridx = 0;
        gbc_panel_1.gridy = 3;
        this.getContentPane().add((Component)panel_1, gbc_panel_1);
        JLabel disclaimerLabel = new JLabel(Messages.getInstance().get("wnb_frame_disclaimer"));
        panel_1.add(disclaimerLabel);
        this.setPreferredSize(new Dimension(531, 545));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        this.updateData();
    }

    private void mtowChanged() {
        WnBProfile selected = (WnBProfile)((ComboBoxItem)this.profilesCombo.getSelectedItem()).getValue();
        if (selected != null && !selected.equals(WnBProfile.EMPTY)) {
            StringComboBoxItem massUnit = (StringComboBoxItem)this.totalMassCombo.getSelectedItem();
            selected.setMtowUnit(massUnit.getValue());
            try {
                Double mtow = Double.valueOf(this.mtowTextField.getText());
                if (!mtow.equals(selected.getMtow())) {
                    selected.setMtow(mtow);
                }
            }
            catch (NumberFormatException e) {
                this.mtowTextField.setText("");
                selected.setMtow(null);
            }
        }
        this.recalculateInfoLabel();
    }

    private void remarksChanged() {
        WnBProfile selected = (WnBProfile)((ComboBoxItem)this.profilesCombo.getSelectedItem()).getValue();
        if (selected != null && !selected.equals(WnBProfile.EMPTY)) {
            selected.setRemarks(this.remarksTextArea.getText());
        }
    }

    private void deleteRowAction() {
        if (this.wnbTable.getTable().getSelectedRow() >= 0) {
            int[] idxs = this.wnbTable.getTable().getSelectedRows();
            for (int q = 0; q < idxs.length; ++q) {
                int idx = idxs[q] - q;
                this.wnbTable.removeRow(idx);
            }
            this.recalculateInfoLabel();
        }
    }

    private void addRowAction() {
        this.wnbTable.addWnbRow(new WnBRow());
    }

    private void closeWindowAction() {
        MapFrame.getInstance().showPanel();
        this.setVisible(false);
    }

    private void recalculateMass() {
        WnBProfile selected = (WnBProfile)((ComboBoxItem)this.profilesCombo.getSelectedItem()).getValue();
        StringComboBoxItem massUnit = (StringComboBoxItem)this.totalMassCombo.getSelectedItem();
        if (selected != null && selected.getMtow() != null) {
            Double mtow = selected.getMtow();
            mtow = UnitUtil.recalculateFuel(mtow, this.prevMassUnit, massUnit.getValue(), false);
            selected.setMtow(mtow);
            this.mtowTextField.setText(String.valueOf((double)Math.round(mtow * 10.0) / 10.0));
            selected.setMtowUnit(massUnit.getValue());
        } else if (selected != null && selected.getMtow() == null) {
            this.mtowTextField.setText("");
        }
        this.totalMassUnitLabel.setText(massUnit.getValue());
        this.remainingMassUnitLabel.setText(massUnit.getValue());
        this.recalculateInfoLabel();
        this.prevMassUnit = massUnit.getValue();
    }

    public void recalculateInfoLabel() {
        if (this.wnbTable != null) {
            StringComboBoxItem massUnit = (StringComboBoxItem)this.totalMassCombo.getSelectedItem();
            Double mass = this.wnbTable.getMass(massUnit.getValue());
            this.totalMassTextField.setText(mass != null ? String.valueOf(mass) : "-");
            if (this.profilesCombo != null) {
                ComboBoxItem combo = (ComboBoxItem)this.profilesCombo.getSelectedItem();
                if (combo != null && combo.getValue() != null && ((WnBProfile)combo.getValue()).getMtow() != null) {
                    mass = (double)Math.round(mass * 10.0) / 10.0;
                    double mtow = (double)Math.round(((WnBProfile)combo.getValue()).getMtow() * 10.0) / 10.0;
                    if (mass > mtow) {
                        this.totalMassTextField.setBackground(TEXTFIELD_COLOR_WARNING);
                        this.remainingMassTextField.setBackground(TEXTFIELD_COLOR_WARNING);
                    } else {
                        this.totalMassTextField.setBackground(TEXTFIELD_COLOR_DISABLED);
                        this.remainingMassTextField.setBackground(TEXTFIELD_COLOR_DISABLED);
                    }
                    this.remainingMassTextField.setText(String.valueOf((double)Math.round((mtow - mass) * 10.0) / 10.0));
                } else {
                    this.totalMassTextField.setBackground(TEXTFIELD_COLOR_DISABLED);
                    this.remainingMassTextField.setBackground(TEXTFIELD_COLOR_DISABLED);
                    if (combo != null) {
                        this.remainingMassTextField.setText("-");
                    }
                }
            } else {
                this.remainingMassTextField.setText("-");
            }
            Double cog = this.wnbTable.getCoG();
            this.cogTextField.setText(cog != null ? String.valueOf(cog) : "-");
        }
    }

    private void recalculateCog() {
        StringComboBoxItem cogUnit = (StringComboBoxItem)this.cogCombo.getSelectedItem();
        if (!cogUnit.getValue().equals(this.wnbTable.getCogUnit())) {
            this.wnbTable.recalculateCoG(cogUnit.getValue());
            this.recalculateInfoLabel();
        }
    }

    private void recalculateTorque() {
        StringComboBoxItem torqueUnit = (StringComboBoxItem)this.torqueCombo.getSelectedItem();
        if (!torqueUnit.getValue().equals(this.wnbTable.getTorqueUnit())) {
            this.wnbTable.recalculateTorque(torqueUnit.getValue());
        }
    }

    private void setWnBProfilesCombo(List<WnBProfile> profiles) {
        this.profilesCombo.removeAllItems();
        this.profilesCombo.addItem(new ComboBoxItem<WnBProfile>("", WnBProfile.EMPTY));
        for (WnBProfile profile : profiles) {
            this.profilesCombo.addItem(new ComboBoxItem<WnBProfile>(profile.getName(), profile));
        }
    }

    private void profileChangedAction() {
        if (this.profilesCombo.getSelectedItem() != null) {
            this.updateData();
        }
    }

    private void updateData() {
        this.wnbTable.clearData();
        WnBProfile selected = (WnBProfile)((ComboBoxItem)this.profilesCombo.getSelectedItem()).getValue();
        if (selected != null && !selected.equals(WnBProfile.EMPTY)) {
            this.wnbTable.setCogUnit(selected.getArmUnit());
            if ("cm".equals(selected.getArmUnit())) {
                this.cogCombo.setSelectedIndex(1);
            } else {
                this.cogCombo.setSelectedIndex(0);
            }
            this.wnbTable.setData(selected.getRows());
            StringComboBoxItem massUnit = (StringComboBoxItem)this.totalMassCombo.getSelectedItem();
            if (selected.getMtow() != null) {
                Double mtow = selected.getMtow();
                if (!massUnit.getValue().equals(selected.getMtowUnit())) {
                    mtow = UnitUtil.recalculateFuel(mtow, selected.getMtowUnit(), massUnit.getValue(), false);
                }
                selected.setMtow(mtow);
                this.mtowTextField.setText(String.valueOf((double)Math.round(mtow * 10.0) / 10.0));
            } else {
                this.mtowTextField.setText("");
            }
            selected.setMtowUnit(massUnit.getValue());
            if (selected.getRemarks() != null) {
                this.remarksTextArea.setText(selected.getRemarks());
            } else {
                this.remarksTextArea.setText("");
            }
        }
        this.wnbTable.updateHeader();
        this.recalculateInfoLabel();
    }

    private void updateProfileAction() {
        List<WnBRow> rows = this.wnbTable.getData();
        if (rows.size() > 0) {
            if (this.profilesCombo.getSelectedIndex() == 0) {
                this.saveNewProfileAction();
            } else {
                WnBProfile profile = SettingsBean.getInstance().getWnbProfiles().get(this.profilesCombo.getSelectedIndex() - 1);
                String cogUnit = ((StringComboBoxItem)this.cogCombo.getSelectedItem()).getValue();
                profile.setArmUnit(cogUnit);
                profile.setRows(rows);
                StringComboBoxItem massUnit = (StringComboBoxItem)this.totalMassCombo.getSelectedItem();
                profile.setMtowUnit(massUnit.getValue());
                int sel = this.profilesCombo.getSelectedIndex();
                this.setWnBProfilesCombo(SettingsBean.getInstance().getWnbProfiles());
                this.profilesCombo.setSelectedIndex(sel);
                WnBProfileUtil.saveProfiles(SettingsBean.getInstance().getWnbProfiles(), "conf/wnbs.xml");
            }
        }
    }

    private void saveNewProfileAction() {
        List<WnBRow> rows = this.wnbTable.getData();
        if (rows.size() > 0) {
            String name = null;
            while ((name = JOptionPane.showInputDialog(this, (Object)Messages.getInstance().get("profile_save_name"))) != null && StringUtil.isEmpty(name)) {
            }
            if (name != null) {
                WnBProfile selected = (WnBProfile)((ComboBoxItem)this.profilesCombo.getSelectedItem()).getValue();
                WnBProfile profile = null;
                profile = selected == null || selected.equals(WnBProfile.EMPTY) ? new WnBProfile() : selected.clone();
                profile.setName(name);
                String cogUnit = ((StringComboBoxItem)this.cogCombo.getSelectedItem()).getValue();
                profile.setArmUnit(cogUnit);
                profile.setRows(rows);
                StringComboBoxItem massUnit = (StringComboBoxItem)this.totalMassCombo.getSelectedItem();
                profile.setMtowUnit(massUnit.getValue());
                SettingsBean.getInstance().getWnbProfiles().add(profile);
                this.setWnBProfilesCombo(SettingsBean.getInstance().getWnbProfiles());
                this.profilesCombo.setSelectedIndex(SettingsBean.getInstance().getWnbProfiles().size());
                WnBProfileUtil.saveProfiles(SettingsBean.getInstance().getWnbProfiles(), "conf/wnbs.xml");
            }
        }
    }

    private void deleteProfileAction() {
        if (this.profilesCombo.getSelectedIndex() > 0 && GuiUtil.showConfirmationDialog(this, Messages.getInstance().get("delete"), Messages.getInstance().get("are_you_sure"))) {
            int sel = this.profilesCombo.getSelectedIndex() - 1;
            SettingsBean.getInstance().getWnbProfiles().remove(sel);
            this.setWnBProfilesCombo(SettingsBean.getInstance().getWnbProfiles());
            this.profilesCombo.setSelectedIndex(sel);
            WnBProfileUtil.saveProfiles(SettingsBean.getInstance().getWnbProfiles(), "conf/wnbs.xml");
        }
    }
}

