/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import main.java.guru.vfrflight.gui.task.WeatherDownloadMultiCoreTask;
import main.java.guru.vfrflight.gui.task.WeatherDownloadTask;
import main.java.guru.vfrflight.gui.task.WeatherInRegionDownloadTask;
import main.java.guru.vfrflight.util.UnitUtil;

public class WeatherDownloadDialog
extends JDialog {
    private static final long serialVersionUID = -876376181269852183L;
    private JTextField maxDistanceTextField;
    private JCheckBox metarCheckbox;
    private JCheckBox tafCheckbox;

    public WeatherDownloadDialog(JFrame frame) {
        super(frame);
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                WeatherDownloadDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("weather_download_frame_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton searchButton = new JButton(Messages.getInstance().get("download_along_route_button"));
        buttonPanel.add(searchButton);
        JButton downloadForRegionButton = new JButton(Messages.getInstance().get("download_for_current_region_button"));
        buttonPanel.add(downloadForRegionButton);
        JPanel northPanel = new JPanel();
        panel_3.add((Component)northPanel, "North");
        northPanel.setLayout(new FlowLayout(1, 5, 5));
        JPanel panel = new JPanel();
        northPanel.add(panel);
        JLabel maxDistanceLabel = new JLabel(Messages.getInstance().get("weather_download_frame_max_distance_from_route") + UnitUtil.getDistanceUnit());
        panel.add(maxDistanceLabel);
        this.maxDistanceTextField = new JTextField();
        panel.add(this.maxDistanceTextField);
        this.maxDistanceTextField.setText("40");
        this.maxDistanceTextField.setHorizontalAlignment(0);
        this.maxDistanceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    // empty if block
                }
            }
        });
        ((AbstractDocument)this.maxDistanceTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter(2));
        this.maxDistanceTextField.setColumns(5);
        JPanel centerPanel = new JPanel();
        panel_3.add((Component)centerPanel, "Center");
        this.metarCheckbox = new JCheckBox("METAR");
        centerPanel.add(this.metarCheckbox);
        this.metarCheckbox.setSelected(true);
        this.tafCheckbox = new JCheckBox("TAF");
        centerPanel.add(this.tafCheckbox);
        this.tafCheckbox.setSelected(true);
        downloadForRegionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                WeatherDownloadDialog.this.searchInRegionAction();
            }
        });
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                WeatherDownloadDialog.this.searchOnPathAction();
            }
        });
        this.setModal(true);
        this.setSize(350, 141);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void searchOnPathAction() {
        if (this.doValidate(true)) {
            MapFrame.getInstance().hidePanel();
            FlightPlanBean.getInstance().getRoute().calculateSegments();
            int maxDistance = 50;
            try {
                maxDistance = Integer.parseInt(this.maxDistanceTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            maxDistance = (int)Math.round(UnitUtil.recalculateDistance(maxDistance, SettingsBean.getInstance().getParamUnitsDistance(), "sm", false));
            Thread t = null;
            if (SettingsBean.getInstance().isParamUseMultipleCores()) {
                WeatherDownloadMultiCoreTask wdt = new WeatherDownloadMultiCoreTask(FlightPlanBean.getInstance().getRoute().getSegments(), this.metarCheckbox.isSelected(), this.tafCheckbox.isSelected(), maxDistance);
                t = new Thread(wdt);
                PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(false, wdt);
            } else {
                WeatherDownloadTask wdt = new WeatherDownloadTask(FlightPlanBean.getInstance().getRoute().getSegments(), this.metarCheckbox.isSelected(), this.tafCheckbox.isSelected(), maxDistance);
                t = new Thread(wdt);
                PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(false, wdt);
            }
            t.start();
            this.setVisible(false);
        }
    }

    private void searchInRegionAction() {
        if (this.doValidate(false)) {
            MapFrame.getInstance().hidePanel();
            WeatherInRegionDownloadTask wdt = new WeatherInRegionDownloadTask(this.metarCheckbox.isSelected(), this.tafCheckbox.isSelected(), true);
            new Thread(wdt).start();
            PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(true, wdt);
            this.setVisible(false);
        }
    }

    private boolean doValidate(boolean checkDistance) {
        ArrayList<String> errors = new ArrayList<String>();
        if (checkDistance && this.maxDistanceTextField.getText().trim().length() == 0) {
            errors.add(Messages.getInstance().get("weather_download_frame_max_distance_empty"));
        }
        if (checkDistance && FlightPlanBean.getInstance().getRoute().getPoints().size() < 2) {
            errors.add(Messages.getInstance().get("weather_download_no_points"));
        }
        if (!checkDistance && SettingsBean.getInstance().getParamMapRegionSelected() == 0) {
            errors.add(Messages.getInstance().get("weather_download_no_region_selected"));
        }
        if (!this.metarCheckbox.isSelected() && !this.tafCheckbox.isSelected()) {
            errors.add(Messages.getInstance().get("weather_download_frame_no_report_type_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }
}

