/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.sql.facade.ElevationFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class WaypointInfoDialog
extends JDialog {
    private static final long serialVersionUID = -1638625653134175899L;
    private GpsPlace point;
    private IntegerTextField altitudeTextField;
    private JTextField nameTextField;

    public WaypointInfoDialog(JFrame frame, GpsPlace point) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                WaypointInfoDialog.this.closeWindowAction();
            }
        });
        this.point = point.clone();
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaypointInfoDialog.this.okAction();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaypointInfoDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(cancelButton);
        JPanel panel_5 = new JPanel();
        panel_3.add((Component)panel_5, "North");
        panel_5.setBorder(new EtchedBorder(1, null, null));
        panel_5.setLayout(new BorderLayout(0, 0));
        JPanel altitudePanel = new JPanel();
        panel_5.add((Component)altitudePanel, "South");
        JLabel altitudeLabel = new JLabel(Messages.getInstance().get("waypoint_info_dialog_altitude") + UnitUtil.getAltitudeUnit());
        altitudePanel.add(altitudeLabel);
        this.altitudeTextField = new IntegerTextField(1);
        this.altitudeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    WaypointInfoDialog.this.okAction();
                } else if (27 == e.getKeyCode()) {
                    WaypointInfoDialog.this.closeWindowAction();
                }
            }
        });
        altitudePanel.add(this.altitudeTextField);
        if (point.getAlt() != null) {
            this.altitudeTextField.setValue((int)Math.round(point.getAlt()));
        }
        this.altitudeTextField.setHorizontalAlignment(0);
        this.altitudeTextField.setColumns(7);
        ElevationFacade facade = new ElevationFacade(DBUtil.getDataSource());
        Integer msa = facade.getMsaforPlace(point);
        if (msa != null) {
            if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                msa = (int)Math.ceil(UnitUtil.recalculateAltitude(msa.intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false) / 100.0) * 100;
            }
            JLabel msaLabel = new JLabel("MSA: " + msa + SettingsBean.getInstance().getParamUnitsAltitude());
            altitudePanel.add(msaLabel);
        }
        JPanel panel_6 = new JPanel();
        panel_5.add((Component)panel_6, "Center");
        JLabel nameLabel = new JLabel(Messages.getInstance().get("waypoint_info_dialog_name"));
        panel_6.add(nameLabel);
        this.nameTextField = new JTextField();
        if (point.getName() != null) {
            this.nameTextField.setText(point.getName());
        }
        this.nameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    WaypointInfoDialog.this.okAction();
                } else if (27 == e.getKeyCode()) {
                    WaypointInfoDialog.this.closeWindowAction();
                }
            }
        });
        this.nameTextField.setHorizontalAlignment(0);
        panel_6.add(this.nameTextField);
        this.nameTextField.setColumns(20);
        this.setModal(true);
        this.setSize(300, 140);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void okAction() {
        if (this.doValidate()) {
            this.point.setAlt(this.altitudeTextField.getValue().doubleValue());
            this.point.setName(this.nameTextField.getText());
            this.closeWindowAction();
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtil.isEmpty(this.nameTextField.getText())) {
            errors.add(Messages.getInstance().get("waypoint_info_dialog_name_empty"));
        }
        if (this.altitudeTextField.getValue() == null) {
            errors.add(Messages.getInstance().get("waypoint_info_dialog_altitude_empty"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    public GpsPlace getPoint() {
        return this.point;
    }

    public void setPoint(GpsPlace point) {
        this.point = point;
    }
}

