/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import main.java.guru.vfrflight.util.UnitUtil;

public class VorSearchDialog
extends JDialog {
    private static final long serialVersionUID = -4444570042504346193L;
    private JTextField maxDistanceTextField;
    private JCheckBox vorCheckbox;
    private JCheckBox ndbCheckbox;

    public VorSearchDialog(Window frame) {
        super(frame);
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                VorSearchDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("vor_search_frame_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        this.maxDistanceTextField = new JTextField();
        this.maxDistanceTextField.setText("25");
        this.maxDistanceTextField.setHorizontalAlignment(0);
        this.maxDistanceTextField.setBounds(242, 54, 40, 20);
        this.maxDistanceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    VorSearchDialog.this.searchAction();
                }
            }
        });
        ((AbstractDocument)this.maxDistanceTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter(3));
        panel_3.setLayout(null);
        panel_3.add(this.maxDistanceTextField);
        this.maxDistanceTextField.setColumns(45);
        JButton searchButton = new JButton(Messages.getInstance().get("search_button"));
        searchButton.setBounds(100, 95, 98, 23);
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                VorSearchDialog.this.searchAction();
            }
        });
        panel_3.add(searchButton);
        JLabel maxDistanceLabel = new JLabel(Messages.getInstance().get("vor_search_frame_max_distance_from_route") + UnitUtil.getDistanceUnit());
        maxDistanceLabel.setBounds(10, 57, 222, 14);
        panel_3.add(maxDistanceLabel);
        this.vorCheckbox = new JCheckBox("VOR");
        this.vorCheckbox.setSelected(true);
        this.vorCheckbox.setBounds(42, 20, 93, 23);
        panel_3.add(this.vorCheckbox);
        this.ndbCheckbox = new JCheckBox("NDB");
        this.ndbCheckbox.setBounds(137, 20, 93, 23);
        panel_3.add(this.ndbCheckbox);
        this.setModal(true);
        this.setSize(298, 151);
        this.setLocation(frame.getLocation().x + (frame.getWidth() - this.getSize().width) / 2, frame.getLocation().y + (frame.getHeight() - this.getSize().height) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void searchAction() {
        if (this.doValidate()) {
            PleaseWaitDialog.getInstance(MapFrame.getInstance()).start();
            int maxDistance = 25;
            try {
                maxDistance = Integer.parseInt(this.maxDistanceTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            maxDistance = (int)Math.round(UnitUtil.recalculateDistance(maxDistance, SettingsBean.getInstance().getParamUnitsDistance(), "nm", false));
            if (MapFrame.getInstance().getUIPanel().searchVorDmeAction(maxDistance, this.vorCheckbox.isSelected(), this.ndbCheckbox.isSelected())) {
                this.closeWindowAction();
            }
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.maxDistanceTextField.getText().trim().length() == 0) {
            errors.add(Messages.getInstance().get("vor_search_frame_max_distance_empty"));
        }
        if (!this.vorCheckbox.isSelected() && !this.ndbCheckbox.isSelected()) {
            errors.add(Messages.getInstance().get("vor_search_frame_no_type_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }
}

