/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.gui.AutoDownloadFrame;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import main.java.guru.vfrflight.gui.swing.panel.file.HgtFileChooserPanel;
import main.java.guru.vfrflight.gui.swing.panel.vertical.profile.VerticalProfileWrapperPanel;
import main.java.guru.vfrflight.gui.task.CalculateVerticalProfileTask;
import main.java.guru.vfrflight.gui.task.HgtFilesDownloaderTask;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.bean.HgtZipFilesToDownload;

public class VerticalProfileMainDialog
extends JDialog
implements AutoDownloadFrame {
    private static final long serialVersionUID = -8687311844912996256L;
    private JLabel scaleLabel;
    private JSlider scaleSlider;
    private JCheckBox scaleAutosetCheckbox;
    private JRadioButton useAverageValueRadio;
    private JRadioButton useMaximumValueRadio;
    private JTextField optimalDistanceTextField;
    private HgtFileChooserPanel hgtPathPanel;
    private double routeDistance;
    private JTextField samplesNumTextField;
    private JTextField heightTextField;
    private JTextField windDataTextField;
    private JCheckBox withTerrainCheckBox;
    private JLabel resolutionLabel;
    private JLabel totalDistanceLabel;
    private JLabel optimalDistanceNumberLabel;
    private boolean airspacesInfoDrawnBefore;

    public VerticalProfileMainDialog(JFrame frame) {
        super(frame);
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                VerticalProfileMainDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle(Messages.getInstance().get("vertical_profile_main_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(0, 30, 0, 30));
        panel_3.add((Component)contentPanel, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        double val = SettingsBean.getInstance().getVerticalProfileBean().getOptimalDistance();
        if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
            val = UnitUtil.recalculateDistance(val, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
        }
        val = this.routeDistance = FlightPlanBean.getInstance().getRoute().calculateTotalDistance();
        if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
            val = UnitUtil.recalculateDistance(val, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
        }
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel speedPanel = new JPanel();
        speedPanel.setBorder(new EtchedBorder(1, null, null));
        contentPanel.add((Component)speedPanel, "South");
        speedPanel.setLayout(new BorderLayout(0, 0));
        JPanel windPanel = new JPanel();
        speedPanel.add((Component)windPanel, "North");
        JLabel lblWindDirection = new JLabel("Wind direction / speed :");
        windPanel.add(lblWindDirection);
        this.windDataTextField = new JTextField();
        this.windDataTextField.setHorizontalAlignment(0);
        this.windDataTextField.setEnabled(false);
        this.windDataTextField.setEditable(false);
        windPanel.add(this.windDataTextField);
        this.windDataTextField.setColumns(10);
        JPanel southSpeedPanel = new JPanel();
        speedPanel.add((Component)southSpeedPanel, "Center");
        southSpeedPanel.setLayout(new FlowLayout(1, 5, 5));
        JLabel lblSamplesLabel = new JLabel(Messages.getInstance().get("vertical_profile_main_dialog_samples"));
        southSpeedPanel.add(lblSamplesLabel);
        this.samplesNumTextField = new JTextField();
        this.samplesNumTextField.setHorizontalAlignment(0);
        this.samplesNumTextField.setColumns(6);
        this.samplesNumTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                VerticalProfileMainDialog.this.samplesNumChangedAction();
            }
        });
        this.samplesNumTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    VerticalProfileMainDialog.this.samplesNumChangedAction();
                }
            }
        });
        ((AbstractDocument)this.samplesNumTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter());
        southSpeedPanel.add(this.samplesNumTextField);
        JLabel lblHeightLabel = new JLabel(Messages.getInstance().get("vertical_profile_main_dialog_height"));
        southSpeedPanel.add(lblHeightLabel);
        this.heightTextField = new JTextField();
        this.heightTextField.setHorizontalAlignment(0);
        this.heightTextField.setColumns(6);
        this.heightTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                VerticalProfileMainDialog.this.heightChangedAction();
            }
        });
        this.heightTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    VerticalProfileMainDialog.this.heightChangedAction();
                }
            }
        });
        ((AbstractDocument)this.heightTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter());
        southSpeedPanel.add(this.heightTextField);
        JPanel terrainWrapperPanel = new JPanel();
        terrainWrapperPanel.setBorder(new EtchedBorder(1, null, null));
        contentPanel.add((Component)terrainWrapperPanel, "North");
        terrainWrapperPanel.setLayout(new BorderLayout(0, 0));
        JPanel terrainPanel = new JPanel();
        terrainWrapperPanel.add((Component)terrainPanel, "South");
        terrainPanel.setBorder(new EtchedBorder(1, null, null));
        terrainPanel.setLayout(new BorderLayout(0, 0));
        this.hgtPathPanel = new HgtFileChooserPanel(Messages.getInstance().get("terrain_layer_dialog_path_to_hgt_files"), Messages.getInstance().get("hgt_files"), "HGT", false, 22);
        terrainPanel.add((Component)this.hgtPathPanel, "North");
        this.hgtPathPanel.setChosenPath(SettingsBean.getInstance().getTerrainLayerBean().getPathToHgtFiles());
        this.hgtPathPanel.getAutoDownloadButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileMainDialog.this.autoDownloadAction();
            }
        });
        JPanel scaleMainPanel = new JPanel();
        terrainPanel.add((Component)scaleMainPanel, "Center");
        scaleMainPanel.setBorder(new EtchedBorder(1, null, null));
        scaleMainPanel.setLayout(new BorderLayout(0, 0));
        JPanel findMaxValuePanel = new JPanel();
        scaleMainPanel.add((Component)findMaxValuePanel, "Center");
        findMaxValuePanel.setBorder(null);
        findMaxValuePanel.setLayout(new FlowLayout(1, 5, 5));
        this.useAverageValueRadio = new JRadioButton(Messages.getInstance().get("terrain_layer_dialog_use_average_value"), !SettingsBean.getInstance().getVerticalProfileBean().isFindMaxValue());
        this.useAverageValueRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettingsBean.getInstance().getVerticalProfileBean().setFindMaxValue(!VerticalProfileMainDialog.this.useAverageValueRadio.isSelected());
            }
        });
        findMaxValuePanel.add(this.useAverageValueRadio);
        this.useMaximumValueRadio = new JRadioButton(Messages.getInstance().get("terrain_layer_dialog_use_maximum_value"), SettingsBean.getInstance().getVerticalProfileBean().isFindMaxValue());
        this.useMaximumValueRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettingsBean.getInstance().getVerticalProfileBean().setFindMaxValue(VerticalProfileMainDialog.this.useMaximumValueRadio.isSelected());
            }
        });
        findMaxValuePanel.add(this.useMaximumValueRadio);
        buttonGroup.add(this.useAverageValueRadio);
        buttonGroup.add(this.useMaximumValueRadio);
        JPanel scalePanel = new JPanel();
        scaleMainPanel.add((Component)scalePanel, "North");
        scalePanel.setBorder(null);
        scalePanel.setLayout(new FlowLayout(1, 5, 5));
        this.scaleSlider = new JSlider();
        this.scaleSlider.setValue(SettingsBean.getInstance().getVerticalProfileBean().getScaleValue());
        this.scaleSlider.setMaximum(20);
        this.scaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                VerticalProfileMainDialog.this.changeScaleAction();
            }
        });
        this.scaleAutosetCheckbox = new JCheckBox(Messages.getInstance().get("terrain_layer_dialog_auto_set"), SettingsBean.getInstance().getVerticalProfileBean().isAutoSetScale());
        this.scaleAutosetCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileMainDialog.this.scaleAutoSetAction();
            }
        });
        this.resolutionLabel = new JLabel(Messages.getInstance().get("terrain_layer_dialog_scale"));
        scalePanel.add(this.resolutionLabel);
        scalePanel.add(this.scaleAutosetCheckbox);
        scalePanel.add(this.scaleSlider);
        this.scaleLabel = new JLabel();
        this.scaleLabel.setFont(new Font("Tahoma", 0, 15));
        scalePanel.add(this.scaleLabel);
        JPanel optimalDistancePanel = new JPanel();
        terrainPanel.add((Component)optimalDistancePanel, "South");
        optimalDistancePanel.setBorder(new EtchedBorder(1, null, null));
        optimalDistancePanel.setLayout(new BorderLayout(0, 0));
        JPanel optlDistTextFieldPanel = new JPanel();
        optimalDistancePanel.add((Component)optlDistTextFieldPanel, "Center");
        this.optimalDistanceNumberLabel = new JLabel(Messages.getInstance().get("vertical_profile_main_dialog_optimal_distance") + UnitUtil.getDistanceUnit());
        optlDistTextFieldPanel.add(this.optimalDistanceNumberLabel);
        this.optimalDistanceTextField = new JTextField(String.valueOf((double)Math.round(val * 10.0) / 10.0));
        optlDistTextFieldPanel.add(this.optimalDistanceTextField);
        this.optimalDistanceTextField.setHorizontalAlignment(0);
        this.optimalDistanceTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                VerticalProfileMainDialog.this.optimalDistanceChangedAction();
            }
        });
        this.optimalDistanceTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    VerticalProfileMainDialog.this.optimalDistanceChangedAction();
                }
            }
        });
        this.optimalDistanceTextField.setColumns(8);
        ((AbstractDocument)this.optimalDistanceTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter());
        JPanel optDistLabelPanel = new JPanel();
        optimalDistancePanel.add((Component)optDistLabelPanel, "North");
        this.totalDistanceLabel = new JLabel(Messages.getInstance().get("vertical_profile_main_dialog_route_distance") + ": " + (double)Math.round(val * 10.0) / 10.0 + " " + SettingsBean.getInstance().getParamUnitsDistance());
        optDistLabelPanel.add(this.totalDistanceLabel);
        JPanel withTerrainCheckboxPanel = new JPanel();
        terrainWrapperPanel.add((Component)withTerrainCheckboxPanel, "North");
        this.withTerrainCheckBox = new JCheckBox(Messages.getInstance().get("vertical_profile_main_dialog_with_terrain"), SettingsBean.getInstance().getVerticalProfileBean().isWithTerrain());
        this.withTerrainCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileMainDialog.this.withTerrainChangedAction();
            }
        });
        withTerrainCheckboxPanel.add(this.withTerrainCheckBox);
        JPanel namePanel = new JPanel();
        namePanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)namePanel, "South");
        JButton loadButton = new JButton(Messages.getInstance().get("vertical_profile_main_dialog_calculate"));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VerticalProfileMainDialog.this.calculateProfileAction();
            }
        });
        namePanel.add(loadButton);
        MapFrame.getInstance().hidePanel();
        MapFrame.getInstance().lock();
        this.setSize(475, 400);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        this.init();
        this.setModal(true);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    protected void autoDownloadAction() {
        if (!StringUtil.isEmpty(this.hgtPathPanel.getChosenPath())) {
            GpsArea selectionArea = GpsUtil.getRectangleOverVertices(GpsUtil.getPointsFromSegments(new ArrayList<LineSegment>(FlightPlanBean.getInstance().getRoute().getSegments())));
            HgtZipFilesToDownload files = ElevationsUtil.getHgtFilesToDownloadForArea(selectionArea, this.hgtPathPanel.getChosenPath(), SettingsBean.getInstance().getHgtZipFilesMappings());
            if (files != null && files.getFilename() != null && files.getFilename().size() > 0) {
                double sizeInMb = NumberUtil.roundDouble((double)files.getSize() / 1024.0 / 1024.0, 2);
                if (GuiUtil.showConfirmationDialog(this, "", Messages.getInstance().get("terrain_layer_dialog_autodownload_confirm", String.valueOf(files.getFilename().size()), String.valueOf(sizeInMb)))) {
                    this.setVisible(false);
                    MapFrame.getInstance().lock();
                    PleaseWaitDialog.getInstance().start(true);
                    HgtFilesDownloaderTask task = new HgtFilesDownloaderTask(this, files.getFilename(), this.hgtPathPanel.getChosenPath());
                    new Thread(task).start();
                }
            } else {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("terrain_layer_dialog_autodownload_nofiles_to_download_error"), Messages.getInstance().get("error"), 0);
            }
        }
    }

    private void withTerrainChangedAction() {
        boolean enabled = this.withTerrainCheckBox.isSelected();
        SettingsBean.getInstance().getVerticalProfileBean().setWithTerrain(enabled);
        this.hgtPathPanel.setEnabled(enabled);
        this.resolutionLabel.setEnabled(enabled);
        this.scaleAutosetCheckbox.setEnabled(enabled);
        this.scaleSlider.setEnabled(enabled);
        this.useAverageValueRadio.setEnabled(enabled);
        this.useMaximumValueRadio.setEnabled(enabled);
        this.totalDistanceLabel.setEnabled(enabled);
        this.optimalDistanceNumberLabel.setEnabled(enabled);
        this.optimalDistanceTextField.setEnabled(enabled);
        if (enabled) {
            this.changeScaleAction();
            this.scaleAutoSetAction();
        }
    }

    private void init() {
        this.updateWindData();
        this.changeScaleAction();
        this.scaleAutoSetAction();
        this.withTerrainChangedAction();
        SettingsBean.getInstance().getVerticalProfileBean().setClimbSpeed(FlightPlanBean.getInstance().getRoute().getClimbingSpeed());
        SettingsBean.getInstance().getVerticalProfileBean().setDescentSpeed(FlightPlanBean.getInstance().getRoute().getDescendingSpeed());
        this.samplesNumTextField.setText(String.valueOf(SettingsBean.getInstance().getVerticalProfileBean().getSamplesNum()));
        this.heightTextField.setText(String.valueOf(SettingsBean.getInstance().getVerticalProfileBean().getHeight()));
    }

    private void updateWindData() {
        String windData = null;
        windData = FlightPlanBean.getInstance().getRoute().getWindDirection() != null ? FormatUtil.formattedCourse(FlightPlanBean.getInstance().getRoute().getWindDirection(), true) : "---";
        windData = windData + " / ";
        windData = FlightPlanBean.getInstance().getRoute().getWindSpeed() != null ? windData + (double)Math.round(FlightPlanBean.getInstance().getRoute().getWindSpeed() * 10.0) / 10.0 + SettingsBean.getInstance().getParamUnitsWindSpeed() : windData + "--";
        this.windDataTextField.setText(windData);
    }

    private void scaleAutoSetAction() {
        this.scaleSlider.setEnabled(!this.scaleAutosetCheckbox.isSelected());
        if (this.scaleAutosetCheckbox.isSelected()) {
            this.calculateScale();
        }
        SettingsBean.getInstance().getVerticalProfileBean().setAutoSetScale(this.scaleAutosetCheckbox.isSelected());
        this.optimalDistanceTextField.setEnabled(this.scaleAutosetCheckbox.isSelected());
    }

    private void calculateScale() {
        int scale = (int)Math.floor(this.routeDistance / SettingsBean.getInstance().getVerticalProfileBean().getOptimalDistance());
        if (scale % 2 == 0) {
            ++scale;
        }
        this.scaleSlider.setValue((scale - 1) / 2);
    }

    private void changeScaleAction() {
        if (this.scaleSlider != null && this.scaleLabel != null) {
            this.scaleLabel.setText(String.valueOf(this.getScaleValue()));
            SettingsBean.getInstance().getVerticalProfileBean().setScaleValue(this.scaleSlider.getValue());
            if (this.scaleSlider.getValue() == 0) {
                this.useAverageValueRadio.setEnabled(false);
                this.useMaximumValueRadio.setEnabled(false);
            } else {
                this.useAverageValueRadio.setEnabled(true);
                this.useMaximumValueRadio.setEnabled(true);
            }
        }
    }

    public int getScaleValue() {
        return this.scaleSlider.getValue() * 2 + 1;
    }

    private void closeWindowAction() {
        SettingsBean.getInstance().getTerrainLayerBean().setPathToHgtFiles(this.hgtPathPanel.getChosenPath());
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().unlock();
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }

    private void heightChangedAction() {
        Integer newValue = null;
        if (!StringUtil.isEmpty(this.heightTextField.getText())) {
            try {
                newValue = Integer.valueOf(this.heightTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (newValue != null && newValue > 100) {
            SettingsBean.getInstance().getVerticalProfileBean().setHeight(newValue);
        } else {
            this.heightTextField.setText(String.valueOf(SettingsBean.getInstance().getVerticalProfileBean().getHeight()));
        }
    }

    private void samplesNumChangedAction() {
        Integer newValue = null;
        if (!StringUtil.isEmpty(this.samplesNumTextField.getText())) {
            try {
                newValue = Integer.valueOf(this.samplesNumTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (newValue != null && newValue > 100) {
            SettingsBean.getInstance().getVerticalProfileBean().setSamplesNum(newValue);
        } else {
            this.samplesNumTextField.setText(String.valueOf(SettingsBean.getInstance().getVerticalProfileBean().getSamplesNum()));
        }
    }

    private void optimalDistanceChangedAction() {
        Double newValue = null;
        if (!StringUtil.isEmpty(this.optimalDistanceTextField.getText())) {
            try {
                newValue = Double.valueOf(this.optimalDistanceTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (newValue != null && newValue > 0.0) {
            if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                newValue = UnitUtil.recalculateDistance(newValue, SettingsBean.getInstance().getParamUnitsDistance(), "nm", false);
            }
            SettingsBean.getInstance().getVerticalProfileBean().setOptimalDistance(newValue);
            if (this.scaleAutosetCheckbox.isSelected()) {
                this.calculateScale();
            }
        } else {
            newValue = SettingsBean.getInstance().getVerticalProfileBean().getOptimalDistance();
            if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                newValue = UnitUtil.recalculateDistance(newValue, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false);
            }
            this.optimalDistanceTextField.setText(String.valueOf((double)Math.round(newValue * 10.0) / 10.0));
        }
    }

    private void calculateProfileAction() {
        if (this.doValidate()) {
            CalculateVerticalProfileTask st = new CalculateVerticalProfileTask(this, SettingsBean.getInstance().getVerticalProfileBean().getSamplesNum());
            Thread t = new Thread(st);
            t.start();
            PleaseWaitDialog.getInstance().start(st);
        }
    }

    public void finishedTerrainLoadingTask(Elevation[] elev, int height) {
        this.addVerticalProfilePanel(elev, height);
        PleaseWaitDialog.getInstance().stop();
        SettingsBean.getInstance().getTerrainLayerBean().setPathToHgtFiles(this.hgtPathPanel.getChosenPath());
        this.setVisible(false);
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.withTerrainCheckBox.isSelected() && StringUtil.isEmpty(this.hgtPathPanel.getChosenPath())) {
            errors.add(Messages.getInstance().get("terrain_layer_dialog_no_hgt_files_path"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    public HgtFileChooserPanel getHgtPathPanel() {
        return this.hgtPathPanel;
    }

    public void setHgtPathPanel(HgtFileChooserPanel hgtPathPanel) {
        this.hgtPathPanel = hgtPathPanel;
    }

    public JRadioButton getUseMaximumValueRadio() {
        return this.useMaximumValueRadio;
    }

    public void setUseMaximumValueRadio(JRadioButton useMaximumValueRadio) {
        this.useMaximumValueRadio = useMaximumValueRadio;
    }

    public JCheckBox getWithTerrainCheckBox() {
        return this.withTerrainCheckBox;
    }

    public void setWithTerrainCheckBox(JCheckBox withTerrainCheckBox) {
        this.withTerrainCheckBox = withTerrainCheckBox;
    }

    public void addVerticalProfilePanel(Elevation[] samples, int height) {
        this.recalculateSampleAltitudes(samples);
        BufferedImage image = GraphicsUtil.createImageFromSamples(VfrUtil.getSamples(samples), height, 50);
        this.airspacesInfoDrawnBefore = SettingsBean.getInstance().isDrawAirspacesListUnderCursor();
        List<AirspaceAreaDTO> airspaces = null;
        if (SettingsBean.getInstance().isDrawAirspaces() && (airspaces = MapObjectsBean.getInstance().getViolatedAirspaceAreas2D(MapFrame.getInstance().getMapViewer(), FlightPlanBean.getInstance().getRoute().getPoints())) != null && airspaces.size() > 0) {
            SettingsBean.getInstance().setDrawAirspacesListUnderCursor(true);
        }
        VerticalProfileWrapperPanel imagePanel = new VerticalProfileWrapperPanel(MapFrame.getInstance(), this, image, samples, height, airspaces);
        MapFrame.getInstance().getMapSouthPanel().add(imagePanel);
        MapFrame.getInstance().revalidate();
        MapFrame.getInstance().updateMap();
    }

    public void removeVerticalProfilePanel() {
        SettingsBean.getInstance().setDrawAirspacesListUnderCursor(this.airspacesInfoDrawnBefore);
        MapFrame.getInstance().getMapSouthPanel().removeAll();
        MapFrame.getInstance().revalidate();
        MapFrame.getInstance().setMarkerPlace(null);
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().unlock();
        MapFrame.getInstance().updateMap();
    }

    private void recalculateSampleAltitudes(Elevation[] samples) {
        if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            for (int i = 0; i < samples.length; ++i) {
                if (samples[i] == null || samples[i].getElev() == null) continue;
                samples[i].setElev((short)Math.round(UnitUtil.recalculateAltitude(samples[i].getElev().shortValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false)));
            }
        }
    }

    public void noElevationsFoundError() {
        JOptionPane.showMessageDialog(this, Messages.getInstance().get("terrain_layer_dialog_no_elevations_found"), "", 0);
    }

    @Override
    public void autoDownloadActionFinish() {
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().unlock();
        this.setVisible(true);
        JOptionPane.showMessageDialog(this, Messages.getInstance().get("terrain_layer_dialog_autodownload_success"), Messages.getInstance().get("success"), 1);
    }
}

