/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.panel.track.BankPanel;
import main.java.guru.vfrflight.gui.swing.panel.track.ControlsPanel;
import main.java.guru.vfrflight.gui.swing.panel.track.HeadingPanel;
import main.java.guru.vfrflight.gui.swing.panel.track.InfoPanel;
import main.java.guru.vfrflight.gui.swing.panel.track.UserTrackAnalyzerPanel;
import main.java.guru.vfrflight.gui.task.ReplayUserTrackThread;
import main.java.guru.vfrflight.util.GraphicsUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;

public class UserTrackAnalyzerDialog
extends JDialog {
    private static final long serialVersionUID = 4206943325871766123L;
    private ReplayUserTrackThread replayThread = null;
    private UserTrackAnalyzerPanel analyzerPanel;
    private JSlider slider;
    private BankPanel bankPanel;
    private ControlsPanel controlsPanel;
    private HeadingPanel headingPanel;
    private InfoPanel infoPanel;
    private int maxHeight;
    private float replaySpeed = 1.0f;

    public UserTrackAnalyzerDialog(JFrame parent, List<ExtConnectBean> userTrack, int maxHeight) {
        super(parent);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                UserTrackAnalyzerDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.maxHeight = maxHeight;
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        contentPanel.add((Component)panel, "South");
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "West");
        JButton playButton = new JButton(Messages.getInstance().get("button_play"));
        buttonPanel.add(playButton);
        JButton stopButton = new JButton(Messages.getInstance().get("button_stop"));
        buttonPanel.add(stopButton);
        JPanel sliderPanel = new JPanel();
        panel.add(sliderPanel);
        sliderPanel.setLayout(new BorderLayout(0, 0));
        JPanel topPanel = new JPanel();
        contentPanel.add((Component)topPanel, "Center");
        topPanel.setLayout(new BorderLayout(0, 0));
        topPanel.setBorder(null);
        this.initAnalyzerPanel(userTrack);
        this.analyzerPanel.setBackground(Color.LIGHT_GRAY);
        JScrollPane scrollPane = new JScrollPane(this.analyzerPanel);
        topPanel.add(scrollPane);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        JPanel eastPanel = new JPanel();
        topPanel.add((Component)eastPanel, "East");
        eastPanel.setLayout(new BorderLayout(0, 0));
        JPanel eastTopPanel = new JPanel();
        eastTopPanel.setLayout(new BorderLayout(0, 0));
        eastPanel.add((Component)eastTopPanel, "North");
        JPanel eastMiddlePanel = new JPanel();
        eastMiddlePanel.setLayout(new BorderLayout(0, 0));
        eastPanel.add((Component)eastMiddlePanel, "Center");
        this.controlsPanel = new ControlsPanel(this.getBackground());
        eastTopPanel.add((Component)this.controlsPanel, "North");
        this.controlsPanel.setMinimumSize(new Dimension(150, 150));
        this.controlsPanel.setPreferredSize(new Dimension(150, 150));
        this.bankPanel = new BankPanel(this.getBackground());
        eastTopPanel.add((Component)this.bankPanel, "Center");
        this.bankPanel.setMinimumSize(new Dimension(150, 150));
        this.bankPanel.setPreferredSize(new Dimension(150, 150));
        this.headingPanel = new HeadingPanel(this.getBackground());
        this.headingPanel.setMinimumSize(new Dimension(150, 150));
        this.headingPanel.setPreferredSize(new Dimension(150, 150));
        eastTopPanel.add((Component)this.headingPanel, "South");
        this.infoPanel = new InfoPanel(this.getBackground());
        this.infoPanel.setGroundAltitudeOffset(SimConnectUtil.getInstance().getGroundAltitudeOffset());
        this.infoPanel.setMinimumSize(new Dimension(150, 150));
        this.infoPanel.setPreferredSize(new Dimension(150, 150));
        eastMiddlePanel.add((Component)this.infoPanel, "Center");
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserTrackAnalyzerDialog.this.stopAction();
            }
        });
        playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UserTrackAnalyzerDialog.this.playAction();
            }
        });
        this.slider = new JSlider();
        this.slider.setValue(0);
        sliderPanel.add(this.slider);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                UserTrackAnalyzerDialog.this.sliderChanged();
            }
        });
        this.slider.setMaximum(userTrack.size() - 1);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setPreferredSize(new Dimension(dim.width - 300, maxHeight + 170));
        this.pack();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        MapFrame.getInstance().getUIPanel().hidePanel();
        MapFrame.getInstance().lock();
        this.setVisible(true);
    }

    public void initAnalyzerPanel(List<ExtConnectBean> userTrack) {
        BufferedImage image = GraphicsUtil.createAnalyzerFrame(userTrack, this.maxHeight, 75);
        this.analyzerPanel = new UserTrackAnalyzerPanel(this, image, userTrack, this.maxHeight);
    }

    private void sliderChanged() {
        this.analyzerPanel.setIndex(this.slider.getValue());
        if (this.analyzerPanel.getCurrentUserBean().getUserBank() != null) {
            this.bankPanel.setBank(this.analyzerPanel.getCurrentUserBean().getUserBank().floatValue());
            this.bankPanel.repaint();
        }
        if (this.analyzerPanel.getCurrentUserBean().getYokeXPosition() != null) {
            this.controlsPanel.setYokeXPosition(this.analyzerPanel.getCurrentUserBean().getYokeXPosition().floatValue());
        }
        if (this.analyzerPanel.getCurrentUserBean().getYokeYPosition() != null) {
            this.controlsPanel.setYokeYPosition(this.analyzerPanel.getCurrentUserBean().getYokeYPosition().floatValue());
        }
        if (this.analyzerPanel.getCurrentUserBean().getRudderPeddalsPosition() != null) {
            this.controlsPanel.setRudderPedalsPosition(this.analyzerPanel.getCurrentUserBean().getRudderPeddalsPosition().floatValue());
        }
        if (this.analyzerPanel.getCurrentUserBean().getFlapsHandle() != null) {
            this.controlsPanel.setFlapsPosition(this.analyzerPanel.getCurrentUserBean().getFlapsHandle());
        }
        this.controlsPanel.repaint();
        if (this.analyzerPanel.getCurrentUserBean().getUserTrueHeading() != null) {
            this.headingPanel.setHeading(this.analyzerPanel.getCurrentUserBean().getUserTrueHeading().floatValue());
        }
        if (this.analyzerPanel.getCurrentUserBean().getWindDirection() != null) {
            this.headingPanel.setWindDirection(this.analyzerPanel.getCurrentUserBean().getWindDirection().floatValue());
        }
        if (this.analyzerPanel.getCurrentUserBean().getWindVelocity() != null) {
            this.headingPanel.setWindVelocity(this.analyzerPanel.getCurrentUserBean().getWindVelocity().floatValue());
        }
        this.headingPanel.repaint();
        this.infoPanel.setBean(this.analyzerPanel.getCurrentUserBean());
        this.infoPanel.repaint();
    }

    private void playAction() {
        if (this.replayThread == null) {
            this.replayThread = new ReplayUserTrackThread(this, this.replaySpeed);
            this.replayThread.start();
            this.slider.setEnabled(false);
        }
    }

    public void stopAction() {
        if (this.replayThread != null) {
            this.replayThread.setRunning(false);
            this.replayThread = null;
            this.slider.setEnabled(true);
        }
    }

    private void closeWindowAction() {
        this.stopAction();
        this.analyzerPanel.selectionClearAction();
        MapFrame.getInstance().setMarkerPlace(null);
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().unlock();
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }

    public UserTrackAnalyzerPanel getAnalyzerPanel() {
        return this.analyzerPanel;
    }

    public void setAnalyzerPanel(UserTrackAnalyzerPanel analyzerPanel) {
        this.analyzerPanel = analyzerPanel;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    public void setSlider(JSlider slider) {
        this.slider = slider;
    }

    public ReplayUserTrackThread getReplayThread() {
        return this.replayThread;
    }

    public void setReplayThread(ReplayUserTrackThread replayThread) {
        this.replayThread = replayThread;
    }

    public float getReplaySpeed() {
        return this.replaySpeed;
    }

    public void setReplaySpeed(float replaySpeed) {
        this.replaySpeed = replaySpeed;
    }

    public void changeReplaySpeed(float replaySpeed) {
        this.setReplaySpeed(replaySpeed);
        if (this.replayThread != null) {
            this.replayThread.setRunning(false);
            try {
                this.replayThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.playAction();
        }
    }
}

