/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.util.UrlUtil;

public class UpdateDialog
extends JDialog {
    private static final long serialVersionUID = 2006086811427452389L;

    public UpdateDialog(Frame frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                UpdateDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("update"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel = new JPanel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        panel.add((Component)panel_1, "Center");
        panel_1.setLayout(new FlowLayout(1, 5, 5));
        JLabel lblNewVersionAvailable = new JLabel(Messages.getInstance().get("new_version_available_update"));
        panel_1.add(lblNewVersionAvailable);
        JPanel panel_3 = new JPanel();
        panel.add((Component)panel_3, "South");
        JButton downloadButton = new JButton(Messages.getInstance().get("open_download_page_button"));
        downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                UpdateDialog.this.downloadAction();
            }
        });
        panel_3.add(downloadButton);
        JButton laterButton = new JButton(Messages.getInstance().get("remind_me_later_button"));
        laterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UpdateDialog.this.laterAction();
            }
        });
        panel_3.add(laterButton);
        this.setModal(true);
        this.setSize(456, 90);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void downloadAction() {
        UrlUtil.openUrlInBrowser("http://vfrflight.org/{lang}/downloads.php".replaceAll("\\{lang\\}", SettingsBean.getInstance().getLanguageCode().toLowerCase()));
        this.closeWindowAction();
    }

    private void laterAction() {
        SettingsBean.getInstance().setParamLastUpdateCheck(new Date());
        this.closeWindowAction();
    }
}

