/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.gui.AutoDownloadFrame;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.SelectionModeDialog;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.swing.DigitsFilter;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import main.java.guru.vfrflight.gui.swing.panel.file.HgtFileChooserPanel;
import main.java.guru.vfrflight.gui.task.HgtFilesDownloaderTask;
import main.java.guru.vfrflight.gui.task.LoadTerrainLayerTask;
import main.java.guru.vfrflight.gui.task.OpenGlTerrainTask;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.bean.HgtZipFilesToDownload;

public class TerrainLayerDialog
extends SelectionModeDialog
implements KeyListener,
AutoDownloadFrame {
    private static final long serialVersionUID = -8687311844912996256L;
    private JLabel scaleLabel;
    private JLabel opacityLabel;
    private JSlider scaleSlider;
    private JSlider opacitySlider;
    private JLabel elevationsNumberLabel;
    private JCheckBox scaleAutosetCheckbox;
    private JCheckBox maxElevAutoCheckbox;
    private JCheckBox minElevAutoCheckbox;
    private GpsArea selectionArea;
    private JTextField maxElevTextField;
    private JTextField minElevTextField;
    private JCheckBox drawWithZeroCheckbox;
    private JRadioButton useAverageValueRadio;
    private JRadioButton useMaximumValueRadio;
    private JTextField optimalElevationsTextField;
    private HgtFileChooserPanel hgtPathPanel;

    public TerrainLayerDialog(JFrame frame) {
        super(frame);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                TerrainLayerDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle(Messages.getInstance().get("terrain_layer_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(0, 30, 0, 30));
        panel_3.add((Component)contentPanel, "Center");
        GridBagLayout gbl_contentPanel = new GridBagLayout();
        gbl_contentPanel.columnWidths = new int[]{470};
        gbl_contentPanel.rowHeights = new int[]{68, 60, 68, 58, 103, 43};
        gbl_contentPanel.columnWeights = new double[]{0.0};
        gbl_contentPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        contentPanel.setLayout(gbl_contentPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(1, null, null), "", 4, 2, null, null), new EmptyBorder(0, 10, 0, 10)));
        GridBagConstraints gbc_infoPanel = new GridBagConstraints();
        gbc_infoPanel.fill = 1;
        gbc_infoPanel.insets = new Insets(0, 0, 5, 0);
        gbc_infoPanel.gridx = 0;
        gbc_infoPanel.gridy = 0;
        contentPanel.add((Component)infoPanel, gbc_infoPanel);
        infoPanel.setLayout(new BorderLayout(0, 0));
        JLabel label = new JLabel(Messages.getInstance().get("terrain_layer_dialog_info_label"));
        label.setHorizontalAlignment(0);
        infoPanel.add((Component)label, "Center");
        this.hgtPathPanel = new HgtFileChooserPanel(Messages.getInstance().get("terrain_layer_dialog_path_to_hgt_files"), Messages.getInstance().get("hgt_files"), "HGT", false, 30);
        this.hgtPathPanel.setChosenPath(SettingsBean.getInstance().getTerrainLayerBean().getPathToHgtFiles());
        GridBagConstraints gbc_hgtPathPanel = new GridBagConstraints();
        gbc_hgtPathPanel.fill = 1;
        gbc_hgtPathPanel.insets = new Insets(0, 0, 5, 0);
        gbc_hgtPathPanel.gridx = 0;
        gbc_hgtPathPanel.gridy = 1;
        contentPanel.add((Component)this.hgtPathPanel, gbc_hgtPathPanel);
        this.hgtPathPanel.getAutoDownloadButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TerrainLayerDialog.this.autoDownloadAction();
            }
        });
        JPanel scaleMainPanel = new JPanel();
        scaleMainPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_scaleMainPanel = new GridBagConstraints();
        gbc_scaleMainPanel.fill = 1;
        gbc_scaleMainPanel.insets = new Insets(0, 0, 5, 0);
        gbc_scaleMainPanel.gridx = 0;
        gbc_scaleMainPanel.gridy = 2;
        contentPanel.add((Component)scaleMainPanel, gbc_scaleMainPanel);
        scaleMainPanel.setLayout(new BorderLayout(0, 0));
        JPanel findMaxValuePanel = new JPanel();
        scaleMainPanel.add((Component)findMaxValuePanel, "Center");
        findMaxValuePanel.setBorder(null);
        findMaxValuePanel.setLayout(new FlowLayout(1, 5, 5));
        this.useAverageValueRadio = new JRadioButton(Messages.getInstance().get("terrain_layer_dialog_use_average_value"), !SettingsBean.getInstance().getTerrainLayerBean().isFindMaxValue());
        this.useAverageValueRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettingsBean.getInstance().getTerrainLayerBean().setFindMaxValue(!TerrainLayerDialog.this.useAverageValueRadio.isSelected());
            }
        });
        findMaxValuePanel.add(this.useAverageValueRadio);
        this.useMaximumValueRadio = new JRadioButton(Messages.getInstance().get("terrain_layer_dialog_use_maximum_value"), SettingsBean.getInstance().getTerrainLayerBean().isFindMaxValue());
        this.useMaximumValueRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettingsBean.getInstance().getTerrainLayerBean().setFindMaxValue(TerrainLayerDialog.this.useMaximumValueRadio.isSelected());
            }
        });
        findMaxValuePanel.add(this.useMaximumValueRadio);
        buttonGroup.add(this.useAverageValueRadio);
        buttonGroup.add(this.useMaximumValueRadio);
        JPanel scalePanel = new JPanel();
        scaleMainPanel.add((Component)scalePanel, "North");
        scalePanel.setBorder(null);
        scalePanel.setLayout(new FlowLayout(1, 5, 5));
        this.scaleSlider = new JSlider();
        this.scaleSlider.setValue(SettingsBean.getInstance().getTerrainLayerBean().getScaleValue());
        this.scaleSlider.setMaximum(20);
        this.scaleSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TerrainLayerDialog.this.changeScaleAction();
            }
        });
        this.scaleAutosetCheckbox = new JCheckBox(Messages.getInstance().get("terrain_layer_dialog_auto_set"), SettingsBean.getInstance().getTerrainLayerBean().isAutoSetScale());
        this.scaleAutosetCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TerrainLayerDialog.this.scaleAutoSetAction();
            }
        });
        JLabel lblScale = new JLabel(Messages.getInstance().get("terrain_layer_dialog_scale"));
        scalePanel.add(lblScale);
        scalePanel.add(this.scaleAutosetCheckbox);
        scalePanel.add(this.scaleSlider);
        this.scaleLabel = new JLabel();
        this.scaleLabel.setFont(new Font("Tahoma", 0, 15));
        scalePanel.add(this.scaleLabel);
        JPanel pointsPanel = new JPanel();
        pointsPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_pointsPanel = new GridBagConstraints();
        gbc_pointsPanel.anchor = 11;
        gbc_pointsPanel.fill = 2;
        gbc_pointsPanel.insets = new Insets(0, 0, 5, 0);
        gbc_pointsPanel.gridx = 0;
        gbc_pointsPanel.gridy = 3;
        contentPanel.add((Component)pointsPanel, gbc_pointsPanel);
        pointsPanel.setLayout(new BorderLayout(0, 0));
        JPanel estimationPanel = new JPanel();
        pointsPanel.add((Component)estimationPanel, "North");
        JLabel lblNumberOfPoints = new JLabel(Messages.getInstance().get("terrain_layer_dialog_est_elev_number"));
        estimationPanel.add(lblNumberOfPoints);
        this.elevationsNumberLabel = new JLabel("0");
        estimationPanel.add(this.elevationsNumberLabel);
        this.elevationsNumberLabel.setHorizontalAlignment(0);
        JPanel panel = new JPanel();
        pointsPanel.add((Component)panel, "Center");
        JLabel lblOptimalElevationsNumber = new JLabel(Messages.getInstance().get("terrain_layer_dialog_optimal_elev_number"));
        panel.add(lblOptimalElevationsNumber);
        this.optimalElevationsTextField = new JTextField(String.valueOf(SettingsBean.getInstance().getTerrainLayerBean().getOptimalElevationsNum()));
        this.optimalElevationsTextField.setHorizontalAlignment(0);
        this.optimalElevationsTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                TerrainLayerDialog.this.optimalElevationsNumChangedAction();
            }
        });
        this.optimalElevationsTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    TerrainLayerDialog.this.optimalElevationsNumChangedAction();
                }
            }
        });
        this.optimalElevationsTextField.setColumns(8);
        ((AbstractDocument)this.optimalElevationsTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter());
        panel.add(this.optimalElevationsTextField);
        JLabel lblThousendsAbbr = new JLabel(Messages.getInstance().get("thousend_abbr"));
        panel.add(lblThousendsAbbr);
        JPanel elevationsPanel = new JPanel();
        elevationsPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_elevationsPanel = new GridBagConstraints();
        gbc_elevationsPanel.anchor = 11;
        gbc_elevationsPanel.fill = 2;
        gbc_elevationsPanel.insets = new Insets(0, 0, 5, 0);
        gbc_elevationsPanel.gridx = 0;
        gbc_elevationsPanel.gridy = 4;
        contentPanel.add((Component)elevationsPanel, gbc_elevationsPanel);
        elevationsPanel.setLayout(new BorderLayout(0, 0));
        JPanel drawZeroElevationsPanel = new JPanel();
        elevationsPanel.add((Component)drawZeroElevationsPanel, "Center");
        this.drawWithZeroCheckbox = new JCheckBox(Messages.getInstance().get("terrain_layer_dialog_draw_elev_with_zero_value"), SettingsBean.getInstance().getTerrainLayerBean().isDrawZeroElevations());
        this.drawWithZeroCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TerrainLayerDialog.this.drawWithZeroAction();
            }
        });
        drawZeroElevationsPanel.add(this.drawWithZeroCheckbox);
        JPanel elevationRangePanel = new JPanel();
        elevationsPanel.add((Component)elevationRangePanel, "North");
        elevationRangePanel.setBorder(null);
        elevationRangePanel.setLayout(new BorderLayout(0, 0));
        JPanel minimumRangePanel = new JPanel();
        minimumRangePanel.setBorder(null);
        elevationRangePanel.add((Component)minimumRangePanel, "South");
        minimumRangePanel.setLayout(new FlowLayout(1, 5, 5));
        this.maxElevAutoCheckbox = new JCheckBox(Messages.getInstance().get("terrain_layer_dialog_auto_set"), SettingsBean.getInstance().getTerrainLayerBean().isAutoSetMaxElev());
        this.maxElevAutoCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TerrainLayerDialog.this.maxElevAutoSetAction();
            }
        });
        JLabel lblMaximumElevation = new JLabel(Messages.getInstance().get("terrain_layer_dialog_maximum_elevation") + UnitUtil.getAltitudeUnit());
        minimumRangePanel.add(lblMaximumElevation);
        minimumRangePanel.add(this.maxElevAutoCheckbox);
        this.maxElevTextField = new JTextField();
        this.maxElevTextField.setHorizontalAlignment(0);
        minimumRangePanel.add(this.maxElevTextField);
        ((AbstractDocument)this.maxElevTextField.getDocument()).setDocumentFilter(new DigitsFilter());
        this.maxElevTextField.setColumns(8);
        JPanel maximumRangePanel = new JPanel();
        maximumRangePanel.setBorder(null);
        elevationRangePanel.add((Component)maximumRangePanel, "Center");
        maximumRangePanel.setLayout(new FlowLayout(1, 5, 5));
        JLabel lblScaleMinimumElevation = new JLabel(Messages.getInstance().get("terrain_layer_dialog_minimum_elevation") + UnitUtil.getAltitudeUnit());
        maximumRangePanel.add(lblScaleMinimumElevation);
        this.minElevAutoCheckbox = new JCheckBox(Messages.getInstance().get("terrain_layer_dialog_auto_set"), SettingsBean.getInstance().getTerrainLayerBean().isAutoSetMinElev());
        this.minElevAutoCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TerrainLayerDialog.this.minElevAutoSetAction();
            }
        });
        maximumRangePanel.add(this.minElevAutoCheckbox);
        this.minElevTextField = new JTextField();
        this.minElevTextField.setHorizontalAlignment(0);
        this.minElevTextField.setColumns(8);
        ((AbstractDocument)this.minElevTextField.getDocument()).setDocumentFilter(new DigitsFilter());
        maximumRangePanel.add(this.minElevTextField);
        JPanel opacityPanel = new JPanel();
        opacityPanel.setBorder(new EtchedBorder(1, null, null));
        GridBagConstraints gbc_opacityPanel = new GridBagConstraints();
        gbc_opacityPanel.fill = 1;
        gbc_opacityPanel.gridx = 0;
        gbc_opacityPanel.gridy = 5;
        contentPanel.add((Component)opacityPanel, gbc_opacityPanel);
        opacityPanel.setLayout(new FlowLayout(1, 5, 5));
        this.opacitySlider = new JSlider();
        this.opacitySlider.setValue(SettingsBean.getInstance().getTerrainLayerBean().getOpacityValue());
        this.opacitySlider.setMinimum(2);
        this.opacitySlider.setMaximum(20);
        this.opacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                TerrainLayerDialog.this.changeOpacityAction();
            }
        });
        JLabel lblOpacity = new JLabel(Messages.getInstance().get("terrain_layer_dialog_opacity"));
        opacityPanel.add(lblOpacity);
        opacityPanel.add(this.opacitySlider);
        this.opacityLabel = new JLabel();
        this.opacityLabel.setFont(new Font("Tahoma", 0, 15));
        opacityPanel.add(this.opacityLabel);
        JPanel namePanel = new JPanel();
        namePanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)namePanel, "South");
        JButton loadButton = new JButton(Messages.getInstance().get("load"));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TerrainLayerDialog.this.loadTerrainLayerAction(false);
            }
        });
        namePanel.add(loadButton);
        JButton loadAndOpenIn3DButton = new JButton(Messages.getInstance().get("terrain_layer_dialog_load_and_open_in_3d_viewer"));
        loadAndOpenIn3DButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TerrainLayerDialog.this.loadTerrainLayerAction(true);
            }
        });
        namePanel.add(loadAndOpenIn3DButton);
        JButton removeButton = new JButton(Messages.getInstance().get("remove"));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TerrainLayerDialog.removeTerrainLayerAction();
                TerrainLayerDialog.this.closeWindowAction();
            }
        });
        namePanel.add(removeButton);
        MapFrame.getInstance().hidePanel();
        MapFrame.getInstance().getMapViewer().setDrawSelectionMode(true);
        MapFrame.getInstance().lock();
        this.setSize(500, 508);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        MapFrame.getInstance().getMapViewer().setSelectionModeDialog(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                boolean keyHandled = false;
                if (e.getID() == 401) {
                    TerrainLayerDialog.this.keyReleased(e);
                }
                return keyHandled;
            }
        });
        this.init();
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    protected void autoDownloadAction() {
        if (this.selectionArea != null && !StringUtil.isEmpty(this.hgtPathPanel.getChosenPath())) {
            HgtZipFilesToDownload files = ElevationsUtil.getHgtFilesToDownloadForArea(this.selectionArea, this.hgtPathPanel.getChosenPath(), SettingsBean.getInstance().getHgtZipFilesMappings());
            if (files != null && files.getFilename() != null && files.getFilename().size() > 0) {
                double sizeInMb = NumberUtil.roundDouble((double)files.getSize() / 1024.0 / 1024.0, 2);
                if (GuiUtil.showConfirmationDialog(this, "", Messages.getInstance().get("terrain_layer_dialog_autodownload_confirm", String.valueOf(files.getFilename().size()), String.valueOf(sizeInMb)))) {
                    this.setVisible(false);
                    MapFrame.getInstance().lock();
                    PleaseWaitDialog.getInstance().start(true);
                    HgtFilesDownloaderTask task = new HgtFilesDownloaderTask(this, files.getFilename(), this.hgtPathPanel.getChosenPath());
                    new Thread(task).start();
                }
            } else {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("terrain_layer_dialog_autodownload_nofiles_to_download_error"), Messages.getInstance().get("error"), 0);
            }
        }
    }

    @Override
    public void autoDownloadActionFinish() {
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().unlock();
        this.setVisible(true);
        JOptionPane.showMessageDialog(this, Messages.getInstance().get("terrain_layer_dialog_autodownload_success"), Messages.getInstance().get("success"), 1);
    }

    private void init() {
        if (MapObjectsBean.getInstance().getTerrainMesh() != null) {
            MapFrame.getInstance().getMapViewer().setSelectionArea(MapObjectsBean.getInstance().getTerrainMeshArea());
            MapFrame.getInstance().getMapViewer().setDrawSelectionMode(true);
            this.selectionChanged(MapObjectsBean.getInstance().getTerrainMeshArea());
            this.minElevTextField.setText(String.valueOf(MapFrame.getInstance().getMapViewer().getElevationScaleMin()));
            this.maxElevTextField.setText(String.valueOf(MapFrame.getInstance().getMapViewer().getElevationScaleMax()));
            MapFrame.getInstance().getMapViewer().repaint();
        }
        this.changeScaleAction();
        this.changeOpacityAction();
        this.maxElevAutoSetAction();
        this.minElevAutoSetAction();
        this.scaleAutoSetAction();
    }

    private void maxElevAutoSetAction() {
        this.maxElevTextField.setEnabled(!this.maxElevAutoCheckbox.isSelected());
        SettingsBean.getInstance().getTerrainLayerBean().setAutoSetMaxElev(this.maxElevAutoCheckbox.isSelected());
    }

    private void drawWithZeroAction() {
        SettingsBean.getInstance().getTerrainLayerBean().setDrawZeroElevations(this.drawWithZeroCheckbox.isSelected());
    }

    private void minElevAutoSetAction() {
        this.minElevTextField.setEnabled(!this.minElevAutoCheckbox.isSelected());
        SettingsBean.getInstance().getTerrainLayerBean().setAutoSetMinElev(this.minElevAutoCheckbox.isSelected());
    }

    private void scaleAutoSetAction() {
        this.scaleSlider.setEnabled(!this.scaleAutosetCheckbox.isSelected());
        if (this.scaleAutosetCheckbox.isSelected()) {
            this.calculateScale();
        }
        SettingsBean.getInstance().getTerrainLayerBean().setAutoSetScale(this.scaleAutosetCheckbox.isSelected());
    }

    private void calculateScale() {
        if (this.selectionArea != null) {
            int optimalPointsNum;
            int pointsNum = this.getPointsNumber();
            if (pointsNum > (optimalPointsNum = SettingsBean.getInstance().getTerrainLayerBean().getOptimalElevationsNum() * 1000) && this.scaleSlider.getValue() < this.scaleSlider.getMaximum()) {
                do {
                    this.scaleSlider.setValue(this.scaleSlider.getValue() + 1);
                } while ((pointsNum = this.getPointsNumber()) > optimalPointsNum && this.scaleSlider.getValue() < this.scaleSlider.getMaximum());
                this.calculatePointsNumber();
            } else if (pointsNum < optimalPointsNum && this.scaleSlider.getValue() > 0 && this.getPointsNumber(this.scaleSlider.getValue() - 1) < optimalPointsNum) {
                int newValue = this.scaleSlider.getValue();
                while ((pointsNum = this.getPointsNumber(--newValue)) < optimalPointsNum && newValue > 0) {
                }
                if (pointsNum > optimalPointsNum) {
                    ++newValue;
                }
                this.scaleSlider.setValue(newValue);
                this.calculatePointsNumber();
            }
        }
    }

    private void changeOpacityAction() {
        if (this.opacitySlider != null && this.opacityLabel != null) {
            this.opacityLabel.setText(Math.round(this.getOpacityValue() * 100.0f) + "%");
            SettingsBean.getInstance().getTerrainLayerBean().setOpacityValue(this.opacitySlider.getValue());
        }
    }

    private void changeScaleAction() {
        if (this.scaleSlider != null && this.scaleLabel != null) {
            this.scaleLabel.setText(String.valueOf(this.getScaleValue()));
            this.calculatePointsNumber();
            SettingsBean.getInstance().getTerrainLayerBean().setScaleValue(this.scaleSlider.getValue());
            if (this.scaleSlider.getValue() == 0) {
                this.useAverageValueRadio.setEnabled(false);
                this.useMaximumValueRadio.setEnabled(false);
            } else {
                this.useAverageValueRadio.setEnabled(true);
                this.useMaximumValueRadio.setEnabled(true);
            }
        }
    }

    public float getOpacityValue() {
        return (float)this.opacitySlider.getValue() / 20.0f;
    }

    public int getScaleValue() {
        return this.scaleSlider.getValue() * 2 + 1;
    }

    private void closeWindowAction() {
        SettingsBean.getInstance().getTerrainLayerBean().setPathToHgtFiles(this.hgtPathPanel.getChosenPath());
        MapFrame.getInstance().getMapViewer().setSelectionModeDialog(null);
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().getMapViewer().setDrawSelectionMode(false);
        MapFrame.getInstance().unlock();
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }

    public static void removeTerrainLayerAction() {
        MapObjectsBean.getInstance().setTerrainMesh(null);
        MapObjectsBean.getInstance().setTerrainMeshArea(null);
        MapFrame.getInstance().getMapViewer().setDrawElevationScale(false);
        MapFrame.getInstance().getMapViewer().setElevationScaleMin(null);
        MapFrame.getInstance().getMapViewer().setElevationScaleMax(null);
        SettingsBean.getInstance().getTerrainLayerBean().setAutoSetMaxElev(true);
        SettingsBean.getInstance().getTerrainLayerBean().setAutoSetMinElev(true);
        System.gc();
    }

    private void optimalElevationsNumChangedAction() {
        Integer newValue = null;
        if (!StringUtil.isEmpty(this.optimalElevationsTextField.getText())) {
            try {
                newValue = Integer.valueOf(this.optimalElevationsTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (newValue != null && newValue > 0) {
            SettingsBean.getInstance().getTerrainLayerBean().setOptimalElevationsNum(newValue);
            this.selectionChanged(this.selectionArea);
        } else {
            this.optimalElevationsTextField.setText(String.valueOf(SettingsBean.getInstance().getTerrainLayerBean().getOptimalElevationsNum()));
        }
    }

    private void loadTerrainLayerAction(boolean openIn3DViewer) {
        if (this.doValidate()) {
            LoadTerrainLayerTask task = new LoadTerrainLayerTask(this, MapFrame.getInstance().getMapViewer().getSelectionArea(), openIn3DViewer);
            Thread t = new Thread(task);
            t.start();
            PleaseWaitDialog.getInstance().start(task);
        }
    }

    public void finishedTerrainLoadingTask(boolean openIn3DViewer) {
        MapFrame.getInstance().getUIPanel().updateUIFilter();
        if (openIn3DViewer) {
            OpenGlTerrainTask task = new OpenGlTerrainTask(this, MapFrame.getInstance().getMapViewer().getSelectionArea());
            Thread t = new Thread(task);
            t.start();
            PleaseWaitDialog.getInstance().setTaskExecuting(task);
        } else {
            PleaseWaitDialog.getInstance().stop();
            this.closeWindowAction();
        }
    }

    public void finishedOpenGlTerrainTask(JFrame frame) {
        PleaseWaitDialog.getInstance().stop();
        this.closeWindowAction();
        if (frame != null) {
            frame.setVisible(true);
            frame.toFront();
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (MapFrame.getInstance().getMapViewer().getSelectionArea() == null) {
            errors.add(Messages.getInstance().get("terrain_layer_dialog_no_area_selected"));
        }
        if (StringUtil.isEmpty(this.hgtPathPanel.getChosenPath())) {
            errors.add(Messages.getInstance().get("terrain_layer_dialog_no_hgt_files_path"));
        }
        if (!this.minElevAutoCheckbox.isSelected() && StringUtil.isEmpty(this.minElevTextField.getText())) {
            errors.add(Messages.getInstance().get("terrain_layer_dialog_min_elev_empty"));
        }
        if (!this.maxElevAutoCheckbox.isSelected() && StringUtil.isEmpty(this.maxElevTextField.getText())) {
            errors.add(Messages.getInstance().get("terrain_layer_dialog_max_elev_empty"));
        }
        if (!this.minElevAutoCheckbox.isSelected() && !this.maxElevAutoCheckbox.isSelected()) {
            Short max = null;
            Short min = null;
            if (!this.minElevAutoCheckbox.isSelected()) {
                try {
                    min = Short.valueOf(this.minElevTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!this.maxElevAutoCheckbox.isSelected()) {
                try {
                    max = Short.valueOf(this.maxElevTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (max != null && min != null && max <= min) {
                errors.add(Messages.getInstance().get("terrain_layer_dialog_invalid_elev_range"));
            }
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    @Override
    public void selectionChanged(GpsArea area) {
        this.selectionArea = area;
        this.calculatePointsNumber();
        if (this.scaleAutosetCheckbox.isSelected()) {
            this.calculateScale();
        }
    }

    private int getPointsNumber() {
        return this.getPointsNumber(null);
    }

    private int getPointsNumber(Integer scaleValue) {
        scaleValue = scaleValue == null ? Integer.valueOf(this.getScaleValue()) : Integer.valueOf(scaleValue * 2 + 1);
        double latWidth = (this.selectionArea.getMaxLat() - this.selectionArea.getMinLat()) * 1201.0;
        double lonWidth = (this.selectionArea.getMaxLon() - this.selectionArea.getMinLon()) * 1201.0;
        return (int)Math.round(latWidth * lonWidth / (double)scaleValue.intValue() / (double)scaleValue.intValue());
    }

    private void calculatePointsNumber() {
        if (this.selectionArea != null) {
            int pointsNum = this.getPointsNumber();
            String txt = null;
            if (pointsNum > 1000) {
                pointsNum = (int)Math.round((double)pointsNum / 1000.0);
                txt = String.valueOf(pointsNum) + " " + Messages.getInstance().get("thousend_abbr");
                this.elevationsNumberLabel.setForeground(pointsNum > SettingsBean.getInstance().getTerrainLayerBean().getOptimalElevationsNum() ? Color.RED : Color.BLACK);
            } else {
                txt = String.valueOf(pointsNum);
                this.elevationsNumberLabel.setForeground(Color.BLACK);
            }
            this.elevationsNumberLabel.setText(txt);
        }
    }

    public JCheckBox getMaxElevAutoCheckbox() {
        return this.maxElevAutoCheckbox;
    }

    public void setMaxElevAutoCheckbox(JCheckBox maxElevAutoCheckbox) {
        this.maxElevAutoCheckbox = maxElevAutoCheckbox;
    }

    public JCheckBox getMinElevAutoCheckbox() {
        return this.minElevAutoCheckbox;
    }

    public void setMinElevAutoCheckbox(JCheckBox minElevAutoCheckbox) {
        this.minElevAutoCheckbox = minElevAutoCheckbox;
    }

    public JTextField getMaxElevTextField() {
        return this.maxElevTextField;
    }

    public void setMaxElevTextField(JTextField maxElevTextField) {
        this.maxElevTextField = maxElevTextField;
    }

    public JTextField getMinElevTextField() {
        return this.minElevTextField;
    }

    public void setMinElevTextField(JTextField minElevTextField) {
        this.minElevTextField = minElevTextField;
    }

    public HgtFileChooserPanel getHgtPathPanel() {
        return this.hgtPathPanel;
    }

    public void setHgtPathPanel(HgtFileChooserPanel hgtPathPanel) {
        this.hgtPathPanel = hgtPathPanel;
    }

    public JCheckBox getDrawWithZeroCheckbox() {
        return this.drawWithZeroCheckbox;
    }

    public void setDrawWithZeroCheckbox(JCheckBox drawWithZeroCheckbox) {
        this.drawWithZeroCheckbox = drawWithZeroCheckbox;
    }

    public JRadioButton getUseMaximumValueRadio() {
        return this.useMaximumValueRadio;
    }

    public void setUseMaximumValueRadio(JRadioButton useMaximumValueRadio) {
        this.useMaximumValueRadio = useMaximumValueRadio;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 37) {
            MapFrame.getInstance().getMapViewer().moveMap(-100, 0);
        } else if (e.getKeyCode() == 40) {
            MapFrame.getInstance().getMapViewer().moveMap(0, 100);
        } else if (e.getKeyCode() == 39) {
            MapFrame.getInstance().getMapViewer().moveMap(100, 0);
        } else if (e.getKeyCode() == 38) {
            MapFrame.getInstance().getMapViewer().moveMap(0, -100);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void rotatedSelectionChanged(RotatedGpsArea area) {
    }

    @Override
    public boolean isRotationEnabled() {
        return false;
    }
}

