/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.swing.button.ToolbarButton;

public class TermsOfUseDialog
extends JDialog {
    private static final long serialVersionUID = 5507025239609783026L;
    private JCheckBox agreementCheckBox;
    private JButton startButton;
    private JTextArea termsOfUseTextArea;
    private ToolbarButton enButton;
    private ToolbarButton plButton;
    private ToolbarButton itButton;
    private ToolbarButton ptButton;
    private ToolbarButton deButton;
    private ToolbarButton esButton;
    private ToolbarButton nlButton;
    private boolean continueToApp = false;
    private String language = null;

    public TermsOfUseDialog() {
        this.setAlwaysOnTop(true);
        this.setType(Window.Type.UTILITY);
        this.setResizable(false);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                TermsOfUseDialog.this.closeWindowAction(false);
            }
        });
        this.language = SettingsBean.getInstance().getLanguageCode().toLowerCase();
        this.setTitle(Messages.getInstance().get("terms_of_use_dialog_title_" + this.language));
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel resultsTablePanel = new JPanel();
        panel.add((Component)resultsTablePanel, "Center");
        resultsTablePanel.setLayout(new BorderLayout(0, 0));
        JPanel panel_4 = new JPanel();
        panel_4.setBorder(new EtchedBorder(1, null, null));
        resultsTablePanel.add(panel_4);
        panel_4.setLayout(new BorderLayout(0, 0));
        JPanel bottomPanel = new JPanel();
        panel_4.add((Component)bottomPanel, "South");
        bottomPanel.setLayout(new BorderLayout(0, 0));
        JPanel agreementPanel = new JPanel();
        bottomPanel.add((Component)agreementPanel, "South");
        this.agreementCheckBox = new JCheckBox(Messages.getInstance().get("terms_of_use_dialog_agreement_" + this.language));
        this.agreementCheckBox.setFont(new Font("Tahoma", 0, 14));
        this.agreementCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TermsOfUseDialog.this.toggleAgreementAction();
            }
        });
        agreementPanel.add(this.agreementCheckBox);
        JPanel languagePanel = new JPanel();
        bottomPanel.add((Component)languagePanel, "North");
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(null);
        toolBar.setFloatable(false);
        languagePanel.add(toolBar);
        this.enButton = new ToolbarButton("img/flags/en.png", "English", false);
        this.enButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TermsOfUseDialog.this.languageChangedAction("EN");
            }
        });
        toolBar.add(this.enButton);
        this.plButton = new ToolbarButton("img/flags/pl.png", "Polski", false);
        this.plButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TermsOfUseDialog.this.languageChangedAction("PL");
            }
        });
        toolBar.add(this.plButton);
        this.itButton = new ToolbarButton("img/flags/it.png", "Italiano", false);
        this.itButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TermsOfUseDialog.this.languageChangedAction("IT");
            }
        });
        toolBar.add(this.itButton);
        this.ptButton = new ToolbarButton("img/flags/pt.png", "Portugu\u00eas", false);
        this.ptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TermsOfUseDialog.this.languageChangedAction("PT");
            }
        });
        toolBar.add(this.ptButton);
        this.deButton = new ToolbarButton("img/flags/de.png", "Deutsch", false);
        this.deButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TermsOfUseDialog.this.languageChangedAction("DE");
            }
        });
        toolBar.add(this.deButton);
        this.esButton = new ToolbarButton("img/flags/es.png", "Espa\u00f1ol", false);
        this.esButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TermsOfUseDialog.this.languageChangedAction("ES");
            }
        });
        toolBar.add(this.esButton);
        this.nlButton = new ToolbarButton("img/flags/nl.png", "Nederlands", false);
        this.nlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TermsOfUseDialog.this.languageChangedAction("NL");
            }
        });
        toolBar.add(this.nlButton);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel_4.add(panel_1);
        panel_1.setLayout(new BorderLayout(0, 0));
        this.termsOfUseTextArea = new JTextArea();
        this.termsOfUseTextArea.setBackground(new Color(230, 230, 250));
        this.termsOfUseTextArea.setWrapStyleWord(true);
        this.termsOfUseTextArea.setEditable(false);
        this.termsOfUseTextArea.setLineWrap(true);
        this.termsOfUseTextArea.setFont(new Font("Tahoma", 0, 16));
        this.termsOfUseTextArea.setText(Messages.getInstance().get("terms_of_use_dialog_content_" + this.language));
        this.termsOfUseTextArea.setCaretPosition(0);
        JScrollPane scroll = new JScrollPane(this.termsOfUseTextArea);
        panel_1.add(scroll);
        scroll.setVerticalScrollBarPolicy(22);
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        this.startButton = new JButton(Messages.getInstance().get("terms_of_use_dialog_start_button_" + this.language));
        this.startButton.setFont(new Font("Tahoma", 0, 14));
        this.startButton.setEnabled(false);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TermsOfUseDialog.this.closeWindowAction(true);
            }
        });
        buttonPanel.add(this.startButton);
        this.setSize(550, 500);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void toggleAgreementAction() {
        this.startButton.setEnabled(this.agreementCheckBox.isSelected());
    }

    private void closeWindowAction(boolean continueToApp) {
        this.continueToApp = continueToApp;
        SettingsBean.getInstance().setParamShowTermsOfUseScreen(!this.agreementCheckBox.isSelected());
        if (!continueToApp) {
            SettingsBean.getInstance().setParamFirstRun(true);
        }
        this.setVisible(false);
    }

    private void languageChangedAction(String languageClicked) {
        this.language = languageClicked.toLowerCase();
        this.agreementCheckBox.setText(Messages.getInstance().get("terms_of_use_dialog_agreement_" + this.language));
        this.termsOfUseTextArea.setText(Messages.getInstance().get("terms_of_use_dialog_content_" + this.language));
        this.startButton.setText(Messages.getInstance().get("terms_of_use_dialog_start_button_" + this.language));
        this.setTitle(Messages.getInstance().get("terms_of_use_dialog_title_" + this.language));
    }

    public boolean isContinueToApp() {
        return this.continueToApp;
    }

    public void setContinueToApp(boolean continueToApp) {
        this.continueToApp = continueToApp;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

