/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SessionBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.VfrUtil;
import net.sourceforge.jdatepicker.DateModel;
import net.sourceforge.jdatepicker.impl.JDatePanelImpl;
import net.sourceforge.jdatepicker.impl.JDatePickerImpl;
import net.sourceforge.jdatepicker.impl.UtilCalendarModel;

public class SunriseSunsetCalculatorDialog
extends JDialog {
    private static final long serialVersionUID = 7569795277926751960L;
    private final GpsPlace place;
    private JDatePickerImpl datePicker;
    private JLabel infoLabel;

    public SunriseSunsetCalculatorDialog(GpsPlace place) {
        this.place = place;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                SunriseSunsetCalculatorDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("sunrise_sunset_calculator_dialog_title"));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add((Component)panel_3, "North");
        this.datePicker = new JDatePickerImpl(new JDatePanelImpl((DateModel)new UtilCalendarModel(SessionBean.getInstance().getRecentlySelectedDate())));
        this.datePicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                SessionBean.getInstance().setRecentlySelectedDate((Calendar)SunriseSunsetCalculatorDialog.this.datePicker.getModel().getValue());
                SunriseSunsetCalculatorDialog.this.updateInfoPanel();
            }
        });
        panel_3.add((Component)this.datePicker);
        JPanel infoPanel = new JPanel();
        this.getContentPane().add((Component)infoPanel, "Center");
        this.infoLabel = new JLabel();
        infoPanel.add(this.infoLabel);
        this.setModal(true);
        MapFrame.getInstance().setMarkerPlace(place);
        MapFrame.getInstance().updateMap();
        this.updateInfoPanel();
        this.setSize(250, 100);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void closeWindowAction() {
        MapFrame.getInstance().setMarkerPlace(null);
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }

    private void updateInfoPanel() {
        Calendar calendar = (Calendar)this.datePicker.getModel().getValue();
        if (calendar != null) {
            String sunsetTxtResult;
            String sunriseTxtResult = VfrUtil.getSunriseForPlace(this.place, calendar);
            if (sunriseTxtResult == null) {
                sunriseTxtResult = Messages.getInstance().get("not_available");
            }
            if ((sunsetTxtResult = VfrUtil.getSunsetForPlace(this.place, calendar)) == null) {
                sunsetTxtResult = Messages.getInstance().get("not_available");
            }
            String txtResult = "<html>" + Messages.getInstance().get("sunrise_sunset_calculator_dialog_sunrise_result", sunriseTxtResult) + "<br/>" + Messages.getInstance().get("sunrise_sunset_calculator_dialog_sunset_result", sunsetTxtResult) + "</html>";
            this.infoLabel.setText(txtResult);
        } else {
            this.infoLabel.setText("");
        }
    }
}

