/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.auth.ProxyBean;
import main.java.guru.vfrflight.bean.combo.item.NumericComboBoxItem;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.bean.theme.airspace.AirspaceThemeFactory;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.PdfSettingsDialog;
import main.java.guru.vfrflight.gui.lookandfeel.LookAndFeelFactory;
import main.java.guru.vfrflight.gui.lookandfeel.LookAndFeelUtil;
import main.java.guru.vfrflight.gui.swing.PositiveDigitsFilter;
import main.java.guru.vfrflight.gui.swing.textfield.IntegerTextField;
import main.java.guru.vfrflight.gui.task.RefreshMagneticDeclinationsTask;
import main.java.guru.vfrflight.gui.task.RefreshObstaclesTask;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class SettingsDialog
extends JDialog {
    private static final long serialVersionUID = -5062874276487759070L;
    private JComboBox<NumericComboBoxItem> languageCombo;
    private JComboBox<StringComboBoxItem> distanceCombo;
    private JComboBox<StringComboBoxItem> speedCombo;
    private JComboBox<StringComboBoxItem> altitudeCombo;
    private JComboBox<StringComboBoxItem> fuelCombo;
    private JComboBox<StringComboBoxItem> windSpeedCombo;
    private JComboBox<NumericComboBoxItem> renderingQualityComboBox;
    private JComboBox<NumericComboBoxItem> maxMemoryComboBox;
    private JPanel mapTab;
    private JCheckBox showScaleOnMapCheckBox;
    private JCheckBox showWarningsCheckBox;
    private JCheckBox geStickyToTerrainCheckBox;
    private JCheckBox useSecondsCheckBox;
    private JCheckBox useMapDecimalCoordsCheckBox;
    private JCheckBox useMultipleCoresCheckBox;
    private JRadioButton googleStyleRadioButton;
    private JRadioButton normalStyleRadioButton;
    private JPanel proxyTab;
    private JCheckBox useProxyCheckbox;
    private JCheckBox proxyUseAuthenticationCheckbox;
    private JTextField proxyHostTextField;
    private JTextField proxyPortTextField;
    private JPanel panel_4;
    private JLabel lblUsername;
    private JTextField proxyUserTextField;
    private JLabel lblPassword;
    private JPasswordField proxyPasswordField;
    private JRadioButton importMagvarFsxP3dRadioButton;
    private JRadioButton importMagvarRealWorldRadioButton;
    private JPanel externalConnectionTabPanel;
    private JTabbedPane tabbedPaneFsxP3D;
    private JPanel generalConnectionTab;
    private JPanel simconnectTab;
    private JPanel aiTrafficTab;
    private IntegerTextField aiTrafficRadius;
    private JCheckBox mixtureLeanCheckBox;
    private JCheckBox throttleCutOffCheckBox;
    private JCheckBox traceUserPositionCheckBox;
    private JCheckBox saveFpsCheckBox;
    private JCheckBox saveUserTrackCheckBox;
    private JCheckBox simConnectIntervalBoostCheckBox;
    private JCheckBox showTrafficCheckBox;
    private JCheckBox showTrafficOnlyInTheAir;
    private JCheckBox showTrafficOnlyInTheAltitudeRange;
    private JSlider failureProbabilitySlider;
    private JSlider simConnectIntervalSlider;
    private JLabel engineProbabilityLabel;
    private JLabel simConnectIntervalLabel;
    private JPanel engineFailureTab;
    private JComboBox<StringComboBoxItem> airspacesThemesComboBox;
    private JComboBox<StringComboBoxItem> lookAndFeelComboBox;
    private NumericComboBoxItem[] RENDERING_QUALITY_COMBO = new NumericComboBoxItem[]{new NumericComboBoxItem(Messages.getInstance().get("rendering_hints_speed"), 2), new NumericComboBoxItem(Messages.getInstance().get("rendering_hints_text_antialias"), 1), new NumericComboBoxItem(Messages.getInstance().get("rendering_hints_normal"), 0), new NumericComboBoxItem(Messages.getInstance().get("rendering_hints_quality"), 3)};
    private NumericComboBoxItem[] maxMemoryCombo;
    private IntegerTextField sidePanelWidthTextField;
    private JCheckBox gpsMapOverlayCheckBox;
    private JCheckBox threeRowsLayoutCheckBox;

    public SettingsDialog(JFrame frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                SettingsDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("settings_frame_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)buttonPanel, "South");
        JButton eksportujButton = new JButton(Messages.getInstance().get("ok_button"));
        eksportujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.saveAction();
            }
        });
        buttonPanel.add(eksportujButton);
        JButton anulujButton = new JButton(Messages.getInstance().get("cancel_button"));
        anulujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.cancelAction();
            }
        });
        buttonPanel.add(anulujButton);
        JPanel tabPanel = new JPanel();
        panel.add((Component)tabPanel, "Center");
        tabPanel.setLayout(new BorderLayout(0, 0));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setBorder(new EtchedBorder(1, null, null));
        tabPanel.add(tabbedPane);
        JPanel mainTab = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("settings_frame_tab_main"), null, mainTab, null);
        mainTab.setLayout(null);
        JLabel languageLabel = new JLabel(Messages.getInstance().get("settings_frame_language"));
        languageLabel.setBounds(23, 20, 138, 14);
        mainTab.add(languageLabel);
        JPanel appearanceTab = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("settings_frame_tab_appearance"), null, appearanceTab, null);
        appearanceTab.setLayout(null);
        JLabel airspacesThemesLabel = new JLabel(Messages.getInstance().get("settings_frame_map_airspaces_theme"));
        airspacesThemesLabel.setBounds(25, 50, 190, 14);
        appearanceTab.add(airspacesThemesLabel);
        this.airspacesThemesComboBox = new JComboBox();
        this.airspacesThemesComboBox.setModel(new DefaultComboBoxModel<StringComboBoxItem>(AirspaceThemeFactory.createComboBoxValues()));
        this.airspacesThemesComboBox.setBounds(235, 45, 120, 22);
        appearanceTab.add(this.airspacesThemesComboBox);
        JLabel renderingQualityLabel = new JLabel(Messages.getInstance().get("settings_frame_rendering_quality"));
        renderingQualityLabel.setBounds(25, 80, 150, 14);
        appearanceTab.add(renderingQualityLabel);
        this.renderingQualityComboBox = new JComboBox();
        this.renderingQualityComboBox.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(this.RENDERING_QUALITY_COMBO));
        this.renderingQualityComboBox.setBounds(185, 75, 170, 20);
        appearanceTab.add(this.renderingQualityComboBox);
        JLabel lookAndFeelLabel = new JLabel(Messages.getInstance().get("settings_frame_look_and_feel_theme"));
        lookAndFeelLabel.setBounds(25, 20, 190, 14);
        appearanceTab.add(lookAndFeelLabel);
        this.lookAndFeelComboBox = new JComboBox();
        this.lookAndFeelComboBox.setModel(new DefaultComboBoxModel<StringComboBoxItem>(LookAndFeelFactory.createComboBoxValues()));
        this.lookAndFeelComboBox.setBounds(235, 15, 120, 20);
        appearanceTab.add(this.lookAndFeelComboBox);
        this.gpsMapOverlayCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_gps_map_overlay"));
        this.gpsMapOverlayCheckBox.setBounds(20, 143, 442, 23);
        appearanceTab.add(this.gpsMapOverlayCheckBox);
        this.threeRowsLayoutCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_three_rows_layout"));
        this.threeRowsLayoutCheckBox.setBounds(20, 115, 442, 23);
        appearanceTab.add(this.threeRowsLayoutCheckBox);
        JPanel magvarTab = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("settings_frame_tab_magvar"), null, magvarTab, null);
        this.mapTab = new JPanel();
        this.mapTab.setLayout(null);
        tabbedPane.addTab(Messages.getInstance().get("settings_frame_tab_map"), null, this.mapTab, null);
        this.showScaleOnMapCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_show_scale_on_map"));
        this.showScaleOnMapCheckBox.setSelected(SettingsBean.getInstance().isParamShowScaleOnMap());
        this.showScaleOnMapCheckBox.setBounds(20, 11, 200, 23);
        this.mapTab.add(this.showScaleOnMapCheckBox);
        this.showWarningsCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_show_warnings"));
        this.showWarningsCheckBox.setSelected(SettingsBean.getInstance().isParamShowWarnings());
        this.showWarningsCheckBox.setBounds(255, 11, 200, 23);
        this.mapTab.add(this.showWarningsCheckBox);
        ButtonGroup bg = new ButtonGroup();
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new EtchedBorder(1, null, null));
        panel_1.setBounds(10, 77, 467, 117);
        this.mapTab.add(panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{447};
        gbl_panel_1.rowHeights = new int[]{14, 73};
        gbl_panel_1.columnWeights = new double[]{0.0};
        gbl_panel_1.rowWeights = new double[]{0.0, 0.0};
        panel_1.setLayout(gbl_panel_1);
        JLabel mapMouseInterfaceLabel = new JLabel(Messages.getInstance().get("settings_frame_map_mouse_interface"));
        GridBagConstraints gbc_mapMouseInterfaceLabel = new GridBagConstraints();
        gbc_mapMouseInterfaceLabel.anchor = 11;
        gbc_mapMouseInterfaceLabel.fill = 2;
        gbc_mapMouseInterfaceLabel.insets = new Insets(0, 0, 5, 0);
        gbc_mapMouseInterfaceLabel.gridx = 0;
        gbc_mapMouseInterfaceLabel.gridy = 0;
        panel_1.add((Component)mapMouseInterfaceLabel, gbc_mapMouseInterfaceLabel);
        this.normalStyleRadioButton = new JRadioButton(Messages.getInstance().get("settings_frame_map_mouse_normal_style"), !SettingsBean.getInstance().isParamMapMouseGoogleStyle());
        GridBagConstraints gbc_normalStyleRadioButton = new GridBagConstraints();
        gbc_normalStyleRadioButton.anchor = 15;
        gbc_normalStyleRadioButton.fill = 2;
        gbc_normalStyleRadioButton.gridx = 0;
        gbc_normalStyleRadioButton.gridy = 1;
        panel_1.add((Component)this.normalStyleRadioButton, gbc_normalStyleRadioButton);
        this.normalStyleRadioButton.setVerticalAlignment(1);
        bg.add(this.normalStyleRadioButton);
        this.googleStyleRadioButton = new JRadioButton(Messages.getInstance().get("settings_frame_map_mouse_google_style"), SettingsBean.getInstance().isParamMapMouseGoogleStyle());
        GridBagConstraints gbc_googleStyleRadioButton = new GridBagConstraints();
        gbc_googleStyleRadioButton.anchor = 11;
        gbc_googleStyleRadioButton.fill = 2;
        gbc_googleStyleRadioButton.gridx = 0;
        gbc_googleStyleRadioButton.gridy = 1;
        panel_1.add((Component)this.googleStyleRadioButton, gbc_googleStyleRadioButton);
        this.googleStyleRadioButton.setVerticalAlignment(1);
        bg.add(this.googleStyleRadioButton);
        this.languageCombo = new JComboBox();
        this.languageCombo.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(Constants.LANGUAGES_COMBO));
        this.languageCombo.setBounds(171, 17, 140, 20);
        mainTab.add(this.languageCombo);
        this.geStickyToTerrainCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_ge_sticky_terrain"));
        this.geStickyToTerrainCheckBox.setBounds(20, 72, 442, 23);
        mainTab.add(this.geStickyToTerrainCheckBox);
        this.useSecondsCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_use_seconds"));
        this.useSecondsCheckBox.setBounds(20, 97, 442, 23);
        mainTab.add(this.useSecondsCheckBox);
        this.useMapDecimalCoordsCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_map_decimal_coords"));
        this.useMapDecimalCoordsCheckBox.setBounds(20, 122, 442, 23);
        mainTab.add(this.useMapDecimalCoordsCheckBox);
        this.useMultipleCoresCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_use_multiple_cores"));
        this.useMultipleCoresCheckBox.setBounds(20, 147, 442, 23);
        mainTab.add(this.useMultipleCoresCheckBox);
        JLabel maxMemoryLabel = new JLabel(Messages.getInstance().get("settings_frame_maximum_memory"));
        maxMemoryLabel.setBounds(23, 47, 138, 14);
        mainTab.add(maxMemoryLabel);
        this.maxMemoryCombo = new NumericComboBoxItem[64];
        for (int i = 0; i < this.maxMemoryCombo.length; ++i) {
            int mem = (i + 1) * 128;
            String txt = null;
            txt = mem % 1024 == 0 ? mem / 1024 + "GB" : mem + "MB";
            this.maxMemoryCombo[i] = new NumericComboBoxItem(txt, mem);
        }
        this.maxMemoryComboBox = new JComboBox();
        this.maxMemoryComboBox.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(this.maxMemoryCombo));
        this.maxMemoryComboBox.setBounds(171, 45, 100, 20);
        mainTab.add(this.maxMemoryComboBox);
        JLabel memoryAvailableLabel = new JLabel("(" + VfrUtil.getFreeHeapSpace() + " MB " + Messages.getInstance().get("settings_frame_available_memory") + ")");
        memoryAvailableLabel.setBounds(281, 47, 194, 14);
        mainTab.add(memoryAvailableLabel);
        JLabel sidePanelWidthLabel = new JLabel(Messages.getInstance().get("settings_frame_side_panel_width"));
        sidePanelWidthLabel.setBounds(23, 177, 231, 14);
        mainTab.add(sidePanelWidthLabel);
        this.sidePanelWidthTextField = new IntegerTextField(1);
        this.sidePanelWidthTextField.setBounds(255, 174, 86, 20);
        mainTab.add(this.sidePanelWidthTextField);
        this.sidePanelWidthTextField.setColumns(10);
        JButton configurePdfButton = new JButton(Messages.getInstance().get("calculation_result_frame_configure_pdf"));
        configurePdfButton.setBounds(23, 202, 138, 23);
        configurePdfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PdfSettingsDialog dialog = new PdfSettingsDialog((Window)SettingsDialog.this);
                dialog.setVisible(true);
            }
        });
        mainTab.add(configurePdfButton);
        JPanel unitsPanel = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("settings_frame_tab_units"), null, unitsPanel, null);
        unitsPanel.setLayout(null);
        JLabel distanceLabel = new JLabel(Messages.getInstance().get("settings_frame_distance"));
        distanceLabel.setBounds(20, 20, 104, 14);
        unitsPanel.add(distanceLabel);
        this.distanceCombo = new JComboBox();
        this.distanceCombo.setModel(new DefaultComboBoxModel<StringComboBoxItem>(SettingsBean.getInstance().getDistanceValuesCombo()));
        this.distanceCombo.setBounds(134, 18, 231, 20);
        unitsPanel.add(this.distanceCombo);
        JLabel speedLabel = new JLabel(Messages.getInstance().get("settings_frame_speed"));
        speedLabel.setBounds(20, 55, 104, 14);
        unitsPanel.add(speedLabel);
        this.speedCombo = new JComboBox();
        this.speedCombo.setModel(new DefaultComboBoxModel<StringComboBoxItem>(SettingsBean.getInstance().getSpeedValuesCombo()));
        this.speedCombo.setBounds(134, 53, 231, 20);
        unitsPanel.add(this.speedCombo);
        JLabel altitudeLabel = new JLabel(Messages.getInstance().get("settings_frame_altitude"));
        altitudeLabel.setBounds(20, 125, 104, 14);
        unitsPanel.add(altitudeLabel);
        this.altitudeCombo = new JComboBox();
        this.altitudeCombo.setModel(new DefaultComboBoxModel<StringComboBoxItem>(SettingsBean.getInstance().getAltitudeValuesCombo()));
        this.altitudeCombo.setBounds(134, 123, 231, 20);
        unitsPanel.add(this.altitudeCombo);
        JLabel fuelLabel = new JLabel(Messages.getInstance().get("settings_frame_fuel"));
        fuelLabel.setBounds(20, 160, 104, 14);
        unitsPanel.add(fuelLabel);
        this.fuelCombo = new JComboBox();
        this.fuelCombo.setModel(new DefaultComboBoxModel<StringComboBoxItem>(SettingsBean.getInstance().getFuelValuesCombo()));
        this.fuelCombo.setBounds(134, 158, 231, 20);
        unitsPanel.add(this.fuelCombo);
        this.windSpeedCombo = new JComboBox();
        this.windSpeedCombo.setModel(new DefaultComboBoxModel<StringComboBoxItem>(SettingsBean.getInstance().getWindSpeedValuesCombo()));
        this.windSpeedCombo.setBounds(134, 88, 231, 20);
        unitsPanel.add(this.windSpeedCombo);
        JLabel windSpeedLabel = new JLabel(Messages.getInstance().get("settings_frame_wind_speed"));
        windSpeedLabel.setBounds(20, 90, 104, 14);
        unitsPanel.add(windSpeedLabel);
        this.proxyTab = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("settings_frame_tab_proxy"), null, this.proxyTab, null);
        this.proxyTab.setLayout(null);
        this.useProxyCheckbox = new JCheckBox(Messages.getInstance().get("settings_frame_proxy_use_proxy"));
        this.useProxyCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettingsDialog.this.useProxyToggleAction();
            }
        });
        this.useProxyCheckbox.setBounds(6, 7, 215, 23);
        this.proxyTab.add(this.useProxyCheckbox);
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new EtchedBorder(1, null, null));
        panel_2.setBounds(27, 37, 397, 210);
        this.proxyTab.add(panel_2);
        panel_2.setLayout(null);
        this.proxyUseAuthenticationCheckbox = new JCheckBox(Messages.getInstance().get("settings_frame_proxy_use_auth"));
        this.proxyUseAuthenticationCheckbox.setEnabled(false);
        this.proxyUseAuthenticationCheckbox.setBounds(20, 92, 169, 23);
        this.proxyUseAuthenticationCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SettingsDialog.this.proxyUseAuthenticationToggleAction();
            }
        });
        panel_2.add(this.proxyUseAuthenticationCheckbox);
        JPanel proxyAddressPanel = new JPanel();
        proxyAddressPanel.setBounds(10, 11, 377, 79);
        panel_2.add(proxyAddressPanel);
        proxyAddressPanel.setLayout(null);
        JLabel lblHostName = new JLabel(Messages.getInstance().get("settings_frame_proxy_host"));
        lblHostName.setBounds(10, 11, 100, 14);
        proxyAddressPanel.add(lblHostName);
        this.proxyHostTextField = new JTextField();
        this.proxyHostTextField.setEnabled(false);
        this.proxyHostTextField.setBounds(120, 10, 170, 23);
        proxyAddressPanel.add(this.proxyHostTextField);
        this.proxyHostTextField.setColumns(50);
        JLabel lblPortNumber = new JLabel(Messages.getInstance().get("settings_frame_proxy_port"));
        lblPortNumber.setBounds(10, 39, 100, 14);
        proxyAddressPanel.add(lblPortNumber);
        this.proxyPortTextField = new JTextField();
        this.proxyPortTextField.setEnabled(false);
        this.proxyPortTextField.setBounds(120, 38, 66, 23);
        proxyAddressPanel.add(this.proxyPortTextField);
        this.proxyPortTextField.setColumns(10);
        ((AbstractDocument)this.proxyPortTextField.getDocument()).setDocumentFilter(new PositiveDigitsFilter(10));
        this.panel_4 = new JPanel();
        this.panel_4.setBounds(10, 122, 377, 77);
        panel_2.add(this.panel_4);
        this.panel_4.setLayout(null);
        this.lblUsername = new JLabel(Messages.getInstance().get("settings_frame_proxy_user"));
        this.lblUsername.setBounds(10, 11, 100, 14);
        this.panel_4.add(this.lblUsername);
        this.proxyUserTextField = new JTextField();
        this.proxyUserTextField.setEnabled(false);
        this.proxyUserTextField.setColumns(50);
        this.proxyUserTextField.setBounds(120, 10, 125, 23);
        this.panel_4.add(this.proxyUserTextField);
        this.lblPassword = new JLabel(Messages.getInstance().get("settings_frame_proxy_password"));
        this.lblPassword.setBounds(10, 39, 100, 14);
        this.panel_4.add(this.lblPassword);
        this.proxyPasswordField = new JPasswordField();
        this.proxyPasswordField.setEnabled(false);
        this.proxyPasswordField.setColumns(50);
        this.proxyPasswordField.setBounds(119, 40, 125, 23);
        this.panel_4.add(this.proxyPasswordField);
        ButtonGroup bg2 = new ButtonGroup();
        this.externalConnectionTabPanel = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("settings_frame_tab_external_connection"), null, this.externalConnectionTabPanel, null);
        this.externalConnectionTabPanel.setLayout(new BorderLayout(0, 0));
        this.tabbedPaneFsxP3D = new JTabbedPane(1);
        this.externalConnectionTabPanel.add(this.tabbedPaneFsxP3D);
        magvarTab.setLayout(null);
        JPanel importMagvarPanel = new JPanel();
        importMagvarPanel.setBorder(new EtchedBorder(1, null, null));
        importMagvarPanel.setBounds(10, 11, 467, 100);
        magvarTab.add(importMagvarPanel);
        GridBagLayout gbl_importMagvarPanel = new GridBagLayout();
        gbl_importMagvarPanel.columnWidths = new int[]{447};
        gbl_importMagvarPanel.rowHeights = new int[]{25, 55};
        gbl_importMagvarPanel.columnWeights = new double[]{0.0};
        gbl_importMagvarPanel.rowWeights = new double[]{0.0, 0.0};
        importMagvarPanel.setLayout(gbl_importMagvarPanel);
        JLabel importMagvarLabel = new JLabel(Messages.getInstance().get("settings_frame_tab_import_magvar_label"));
        GridBagConstraints gbc_importMagvarLabel = new GridBagConstraints();
        gbc_importMagvarLabel.fill = 2;
        gbc_importMagvarLabel.anchor = 11;
        gbc_importMagvarLabel.insets = new Insets(0, 0, 5, 0);
        gbc_importMagvarLabel.gridx = 0;
        gbc_importMagvarLabel.gridy = 0;
        importMagvarPanel.add((Component)importMagvarLabel, gbc_importMagvarLabel);
        this.importMagvarFsxP3dRadioButton = new JRadioButton(Messages.getInstance().get("settings_frame_tab_import_magvar_fsx_p3d"), SettingsBean.getInstance().isParamFsxP3dMode());
        this.importMagvarFsxP3dRadioButton.setVerticalAlignment(1);
        GridBagConstraints gbc_importMagvarFsxP3dRadioButton = new GridBagConstraints();
        gbc_importMagvarFsxP3dRadioButton.fill = 2;
        gbc_importMagvarFsxP3dRadioButton.anchor = 11;
        gbc_importMagvarFsxP3dRadioButton.gridx = 0;
        gbc_importMagvarFsxP3dRadioButton.gridy = 1;
        importMagvarPanel.add((Component)this.importMagvarFsxP3dRadioButton, gbc_importMagvarFsxP3dRadioButton);
        this.importMagvarRealWorldRadioButton = new JRadioButton(Messages.getInstance().get("settings_frame_tab_import_magvar_real_world"), !SettingsBean.getInstance().isParamFsxP3dMode());
        this.importMagvarRealWorldRadioButton.setVerticalAlignment(1);
        GridBagConstraints gbc_importMagvarRealWorldRadioButton = new GridBagConstraints();
        gbc_importMagvarRealWorldRadioButton.fill = 2;
        gbc_importMagvarRealWorldRadioButton.anchor = 15;
        gbc_importMagvarRealWorldRadioButton.gridx = 0;
        gbc_importMagvarRealWorldRadioButton.gridy = 1;
        importMagvarPanel.add((Component)this.importMagvarRealWorldRadioButton, gbc_importMagvarRealWorldRadioButton);
        bg2.add(this.importMagvarFsxP3dRadioButton);
        bg2.add(this.importMagvarRealWorldRadioButton);
        this.generalConnectionTab = new JPanel();
        this.tabbedPaneFsxP3D.addTab(Messages.getInstance().get("settings_frame_tab_general_connection"), null, this.generalConnectionTab, null);
        this.generalConnectionTab.setLayout(null);
        this.simconnectTab = new JPanel();
        this.tabbedPaneFsxP3D.addTab(Messages.getInstance().get("settings_frame_tab_simconnect"), null, this.simconnectTab, null);
        this.simconnectTab.setLayout(null);
        JPanel panel_3 = new JPanel();
        panel_3.setBorder(new EtchedBorder(1, null, null));
        panel_3.setBounds(10, 11, 460, 108);
        panel_3.setLayout(null);
        this.mixtureLeanCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_tab_simconnect_mixture_lean"));
        this.mixtureLeanCheckBox.setBounds(253, 70, 191, 23);
        panel_3.add(this.mixtureLeanCheckBox);
        this.throttleCutOffCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_tab_simconnect_throttle_cut_off"));
        this.throttleCutOffCheckBox.setEnabled(false);
        this.throttleCutOffCheckBox.setBounds(20, 70, 206, 23);
        panel_3.add(this.throttleCutOffCheckBox);
        this.failureProbabilitySlider = new JSlider();
        this.failureProbabilitySlider.setMaximum(Constants.ENGINE_FAILURES_PROBABILITIES_MESSAGE_KEYS.length - 1);
        this.failureProbabilitySlider.setValue(0);
        this.failureProbabilitySlider.setBounds(10, 39, 434, 24);
        this.failureProbabilitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                SettingsDialog.this.changeFailureProbabilityAction();
            }
        });
        panel_3.add(this.failureProbabilitySlider);
        this.engineProbabilityLabel = new JLabel(Messages.getInstance().get("settings_frame_tab_simconnect_failure_probability"));
        this.engineProbabilityLabel.setBounds(16, 11, 428, 14);
        panel_3.add(this.engineProbabilityLabel);
        this.traceUserPositionCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_tab_simconnect_trace_user_position"));
        this.traceUserPositionCheckBox.setBounds(10, 7, 216, 23);
        this.generalConnectionTab.add(this.traceUserPositionCheckBox);
        this.saveUserTrackCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_tab_simconnect_save_user_track"));
        this.saveUserTrackCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!SettingsDialog.this.saveUserTrackCheckBox.isSelected()) {
                    SettingsDialog.this.saveFpsCheckBox.setSelected(false);
                    SettingsDialog.this.saveFpsCheckBox.setEnabled(false);
                } else {
                    SettingsDialog.this.saveFpsCheckBox.setEnabled(true);
                }
            }
        });
        this.saveUserTrackCheckBox.setSelected(true);
        this.saveUserTrackCheckBox.setBounds(10, 41, 216, 23);
        this.generalConnectionTab.add(this.saveUserTrackCheckBox);
        JPanel panel_5 = new JPanel();
        panel_5.setLayout(null);
        panel_5.setBorder(new EtchedBorder(1, null, null));
        panel_5.setBounds(10, 71, 460, 78);
        this.generalConnectionTab.add(panel_5);
        this.simConnectIntervalBoostCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_tab_simconnect_interval_boost"));
        this.simConnectIntervalBoostCheckBox.setSelected(true);
        this.simConnectIntervalBoostCheckBox.setBounds(10, 41, 464, 23);
        this.simconnectTab.add(this.simConnectIntervalBoostCheckBox);
        this.simConnectIntervalSlider = new JSlider();
        this.simConnectIntervalSlider.setValue(0);
        this.simConnectIntervalSlider.setMaximum(12);
        this.simConnectIntervalSlider.setBounds(10, 39, 434, 24);
        this.simConnectIntervalSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                SettingsDialog.this.changeIntervalAction();
            }
        });
        panel_5.add(this.simConnectIntervalSlider);
        this.simConnectIntervalLabel = new JLabel(Messages.getInstance().get("settings_frame_tab_simconnect_interval"));
        this.simConnectIntervalLabel.setBounds(16, 11, 428, 14);
        panel_5.add(this.simConnectIntervalLabel);
        this.saveFpsCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_tab_simconnect_save_fps"));
        this.saveFpsCheckBox.setSelected(true);
        this.saveFpsCheckBox.setBounds(10, 7, 464, 23);
        this.simconnectTab.add(this.saveFpsCheckBox);
        this.aiTrafficTab = new JPanel();
        this.tabbedPaneFsxP3D.addTab(Messages.getInstance().get("settings_frame_tab_aitraffic"), null, this.aiTrafficTab, null);
        this.simconnectTab.setLayout(null);
        this.aiTrafficTab.setLayout(null);
        this.showTrafficCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_tab_simconnect_show_traffic"));
        this.showTrafficCheckBox.setSelected(true);
        this.showTrafficCheckBox.setEnabled(true);
        this.showTrafficCheckBox.setBounds(22, 5, 125, 23);
        this.aiTrafficTab.add(this.showTrafficCheckBox);
        this.showTrafficOnlyInTheAir = new JCheckBox(Messages.getInstance().get("settings_frame_tab_simconnect_show_traffic_only_in_the_air"));
        this.showTrafficOnlyInTheAir.setBounds(22, 58, 305, 23);
        this.aiTrafficTab.add(this.showTrafficOnlyInTheAir);
        this.showTrafficOnlyInTheAltitudeRange = new JCheckBox(Messages.getInstance().get("settings_frame_tab_simconnect_show_traffic_only_in_the_altitude_range"));
        this.showTrafficOnlyInTheAltitudeRange.setBounds(22, 83, 325, 23);
        this.aiTrafficTab.add(this.showTrafficOnlyInTheAltitudeRange);
        this.aiTrafficRadius = new IntegerTextField();
        this.aiTrafficRadius.setBounds(137, 35, 86, 20);
        this.aiTrafficTab.add(this.aiTrafficRadius);
        this.aiTrafficRadius.setColumns(6);
        JLabel aiTrafficRadiusLabel = new JLabel(Messages.getInstance().get("settings_frame_tab_simconnect_ai_traffic_range"));
        aiTrafficRadiusLabel.setBounds(41, 37, 86, 14);
        this.aiTrafficTab.add(aiTrafficRadiusLabel);
        this.changeIntervalAction();
        this.engineFailureTab = new JPanel();
        this.engineFailureTab.setLayout(null);
        this.tabbedPaneFsxP3D.addTab(Messages.getInstance().get("settings_frame_tab_engine_failures"), null, this.engineFailureTab, null);
        this.engineFailureTab.add(panel_3);
        this.updateValues();
        this.setModal(true);
        this.setSize(500, 360);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private int parseIntervalToStep(int intervalMs) {
        if (intervalMs <= 1000) {
            return (int)Math.ceil(intervalMs / 250);
        }
        return (int)Math.ceil(intervalMs / 500) + 2;
    }

    private int parseStepToInterval(int step) {
        if (step <= 4) {
            return step * 250;
        }
        return (step - 2) * 500;
    }

    private boolean checkNoSimActionSelected() {
        if (!this.traceUserPositionCheckBox.isSelected() && this.failureProbabilitySlider.getValue() == 0 && !this.saveUserTrackCheckBox.isSelected()) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("settings_frame_tab_simconnect_no_selection"), "", 0);
            return false;
        }
        return true;
    }

    private void changeIntervalAction() {
        this.updateIntervalSliderLabel();
        if (this.simConnectIntervalSlider.getValue() == 0) {
            this.simConnectIntervalBoostCheckBox.setSelected(false);
            this.simConnectIntervalBoostCheckBox.setEnabled(false);
        } else {
            this.simConnectIntervalBoostCheckBox.setEnabled(true);
        }
    }

    private void changeFailureProbabilityAction() {
        this.updateProbabilitySliderLabel();
        if (this.failureProbabilitySlider.getValue() == 0) {
            this.mixtureLeanCheckBox.setEnabled(false);
        } else {
            this.mixtureLeanCheckBox.setEnabled(true);
        }
    }

    public void updateValues() {
        int i;
        int i2;
        for (i2 = 0; i2 < SettingsBean.getInstance().getAltitudeValuesCombo().length; ++i2) {
            if (!SettingsBean.getInstance().getParamUnitsAltitude().equals(SettingsBean.getInstance().getAltitudeValuesCombo()[i2].getValue())) continue;
            this.altitudeCombo.setSelectedIndex(i2);
            break;
        }
        for (i2 = 0; i2 < SettingsBean.getInstance().getSpeedValuesCombo().length; ++i2) {
            if (!SettingsBean.getInstance().getParamUnitsSpeed().equals(SettingsBean.getInstance().getSpeedValuesCombo()[i2].getValue())) continue;
            this.speedCombo.setSelectedIndex(i2);
            break;
        }
        for (i2 = 0; i2 < SettingsBean.getInstance().getWindSpeedValuesCombo().length; ++i2) {
            if (!SettingsBean.getInstance().getParamUnitsWindSpeed().equals(SettingsBean.getInstance().getWindSpeedValuesCombo()[i2].getValue())) continue;
            this.windSpeedCombo.setSelectedIndex(i2);
            break;
        }
        for (i2 = 0; i2 < SettingsBean.getInstance().getDistanceValuesCombo().length; ++i2) {
            if (!SettingsBean.getInstance().getParamUnitsDistance().equals(SettingsBean.getInstance().getDistanceValuesCombo()[i2].getValue())) continue;
            this.distanceCombo.setSelectedIndex(i2);
            break;
        }
        for (i2 = 0; i2 < SettingsBean.getInstance().getFuelValuesCombo().length; ++i2) {
            if (!SettingsBean.getInstance().getParamUnitsFuel().equals(SettingsBean.getInstance().getFuelValuesCombo()[i2].getValue())) continue;
            this.fuelCombo.setSelectedIndex(i2);
            break;
        }
        for (i2 = 0; i2 < Constants.LANGUAGES_COMBO.length; ++i2) {
            if (SettingsBean.getInstance().getParamLanguage() != Constants.LANGUAGES_COMBO[i2].getValue().intValue()) continue;
            this.languageCombo.setSelectedIndex(i2);
            break;
        }
        StringComboBoxItem[] values = AirspaceThemeFactory.createComboBoxValues();
        for (i = 0; i < values.length; ++i) {
            if (!SettingsBean.getInstance().getParamAirspacesColorTheme().equals(values[i].getValue())) continue;
            this.airspacesThemesComboBox.setSelectedIndex(i);
            break;
        }
        values = LookAndFeelFactory.createComboBoxValues();
        for (i = 0; i < values.length; ++i) {
            if (!SettingsBean.getInstance().getParamLookAndFeel().equals(values[i].getValue())) continue;
            this.lookAndFeelComboBox.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < this.RENDERING_QUALITY_COMBO.length; ++i) {
            if (SettingsBean.getInstance().getRenderingHintsQuality() != this.RENDERING_QUALITY_COMBO[i].getValue().intValue()) continue;
            this.renderingQualityComboBox.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < this.RENDERING_QUALITY_COMBO.length; ++i) {
            if (SettingsBean.getInstance().getRenderingHintsQuality() != this.RENDERING_QUALITY_COMBO[i].getValue().intValue()) continue;
            this.renderingQualityComboBox.setSelectedIndex(i);
            break;
        }
        for (i = 0; i < this.maxMemoryCombo.length; ++i) {
            if (SettingsBean.getInstance().getJvmParamsBean().getXmx() != this.maxMemoryCombo[i].getValue().intValue()) continue;
            this.maxMemoryComboBox.setSelectedIndex(i);
            break;
        }
        this.gpsMapOverlayCheckBox.setSelected(SettingsBean.getInstance().isParamGpsMapOverlay());
        this.threeRowsLayoutCheckBox.setSelected(SettingsBean.getInstance().isParamThreeRowsLayout());
        this.geStickyToTerrainCheckBox.setSelected(SettingsBean.getInstance().isParamGEExportStickyToTerrain());
        this.useSecondsCheckBox.setSelected(SettingsBean.getInstance().isParamIncludeSecondsInTimeCalculations());
        this.useMapDecimalCoordsCheckBox.setSelected(SettingsBean.getInstance().isParamUseMapDecimalCoords());
        this.useMultipleCoresCheckBox.setSelected(SettingsBean.getInstance().isParamUseMultipleCores());
        this.googleStyleRadioButton.setSelected(SettingsBean.getInstance().isParamMapMouseGoogleStyle());
        this.normalStyleRadioButton.setSelected(!SettingsBean.getInstance().isParamMapMouseGoogleStyle());
        this.importMagvarFsxP3dRadioButton.setSelected(SettingsBean.getInstance().isParamFsxP3dMode());
        this.importMagvarRealWorldRadioButton.setSelected(!SettingsBean.getInstance().isParamFsxP3dMode());
        this.useProxyCheckbox.setSelected(SettingsBean.getInstance().isParamUseProxy());
        this.proxyHostTextField.setEnabled(this.useProxyCheckbox.isSelected());
        this.proxyPortTextField.setEnabled(this.useProxyCheckbox.isSelected());
        if (SettingsBean.getInstance().isParamUseProxy()) {
            ProxyBean proxyBean = SettingsBean.getInstance().getProxyBean();
            this.proxyHostTextField.setText(proxyBean.getHttpHost());
            this.proxyPortTextField.setText(String.valueOf(proxyBean.getHttpPort()));
            this.proxyUserTextField.setEnabled(proxyBean.isUseHttpAuth());
            this.proxyPasswordField.setEnabled(proxyBean.isUseHttpAuth());
            this.proxyUseAuthenticationCheckbox.setEnabled(proxyBean.isUseHttpAuth());
            this.proxyUseAuthenticationCheckbox.setSelected(proxyBean.isUseHttpAuth());
            if (proxyBean.isUseHttpAuth()) {
                this.proxyUserTextField.setText(proxyBean.getHttpUserName());
                this.proxyPasswordField.setText(proxyBean.getHttpPassword());
            }
        }
        this.traceUserPositionCheckBox.setSelected(SettingsBean.getInstance().getSimConnectConfigBean().isTraceUserPosition());
        this.saveUserTrackCheckBox.setSelected(SettingsBean.getInstance().getSimConnectConfigBean().isSaveUserTrack());
        this.saveFpsCheckBox.setSelected(SettingsBean.getInstance().getSimConnectConfigBean().isGetFps());
        this.showTrafficCheckBox.setSelected(SettingsBean.getInstance().getSimConnectConfigBean().isTraceTraffic());
        this.showTrafficOnlyInTheAir.setSelected(SettingsBean.getInstance().getSimConnectConfigBean().isTrafficShowOnlyInAir());
        this.showTrafficOnlyInTheAltitudeRange.setSelected(SettingsBean.getInstance().getSimConnectConfigBean().isTrafficShowOnlyIn2kAltitudeRange());
        this.aiTrafficRadius.setValue(SettingsBean.getInstance().getSimConnectConfigBean().getTrafficRadius());
        this.saveFpsCheckBox.setEnabled(this.saveUserTrackCheckBox.isSelected());
        this.simConnectIntervalBoostCheckBox.setSelected(SettingsBean.getInstance().getSimConnectConfigBean().isIntervalBoostAtLowAlt());
        this.simConnectIntervalSlider.setValue(this.parseIntervalToStep(SettingsBean.getInstance().getSimConnectConfigBean().getInterval()));
        this.mixtureLeanCheckBox.setSelected(SettingsBean.getInstance().getSimConnectConfigBean().isMixtureLean());
        this.throttleCutOffCheckBox.setSelected(SettingsBean.getInstance().getSimConnectConfigBean().isThrottleCutOff());
        this.failureProbabilitySlider.setValue(SettingsBean.getInstance().getSimConnectConfigBean().getProbability());
        this.changeFailureProbabilityAction();
        this.tabbedPaneFsxP3D.setEnabledAt(0, !SettingsBean.getInstance().isConnectedToSim());
        this.tabbedPaneFsxP3D.setEnabledAt(1, !SettingsBean.getInstance().isConnectedToSim());
        this.tabbedPaneFsxP3D.setEnabledAt(2, !SettingsBean.getInstance().isConnectedToSim());
        this.sidePanelWidthTextField.setValue(SettingsBean.getInstance().getParamSidePanelWidth());
    }

    private void updateIntervalSliderLabel() {
        String txt = null;
        txt = this.simConnectIntervalSlider.getValue() > 0 ? this.parseStepToInterval(this.simConnectIntervalSlider.getValue()) + " ms" : Messages.getInstance().get("settings_frame_tab_simconnect_as_fast_as_posible");
        this.simConnectIntervalLabel.setText(Messages.getInstance().get("settings_frame_tab_simconnect_interval") + " " + txt);
    }

    private void updateProbabilitySliderLabel() {
        this.engineProbabilityLabel.setText(Messages.getInstance().get("settings_frame_tab_simconnect_failure_probability") + ": " + Messages.getInstance().get(Constants.ENGINE_FAILURES_PROBABILITIES_MESSAGE_KEYS[this.failureProbabilitySlider.getValue()]));
    }

    public void closeWindowAction() {
        MapFrame.getInstance().showPanel();
        this.setVisible(false);
    }

    public void cancelAction() {
        this.closeWindowAction();
    }

    public void saveAction() {
        if (this.doValidate()) {
            StringComboBoxItem airspaceTheme;
            boolean updateMap = false;
            SettingsBean.getInstance().setParamGpsMapOverlay(this.gpsMapOverlayCheckBox.isSelected());
            if (this.showScaleOnMapCheckBox.isSelected() != SettingsBean.getInstance().isParamShowScaleOnMap()) {
                SettingsBean.getInstance().setParamShowScaleOnMap(this.showScaleOnMapCheckBox.isSelected());
                updateMap = true;
            }
            if (this.showWarningsCheckBox.isSelected() != SettingsBean.getInstance().isParamShowWarnings()) {
                SettingsBean.getInstance().setParamShowWarnings(this.showWarningsCheckBox.isSelected());
                updateMap = true;
            }
            if (!(airspaceTheme = (StringComboBoxItem)this.airspacesThemesComboBox.getSelectedItem()).getValue().equals(SettingsBean.getInstance().getParamAirspacesColorTheme())) {
                SettingsBean.getInstance().setParamAirspacesColorTheme(airspaceTheme.getValue());
                SettingsBean.getInstance().setAirspacesColorTheme(AirspaceThemeFactory.createTheme(airspaceTheme.getValue()));
                MapFrame.getInstance().getUIPanel().getAirspacesFilterCollapsablePanel().updateAirspacesTypes();
                updateMap = true;
            }
            SettingsBean.getInstance().setParamMapMouseGoogleStyle(this.googleStyleRadioButton.isSelected());
            if (SettingsBean.getInstance().isParamFsxP3dMode() != this.importMagvarFsxP3dRadioButton.isSelected()) {
                SettingsBean.getInstance().setParamFsxP3dMode(this.importMagvarFsxP3dRadioButton.isSelected());
                try {
                    VfrUtil.executeTaskInFixedSinglePool(new RefreshMagneticDeclinationsTask(SettingsBean.getInstance().getDeclinationCalculator()));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                updateMap = true;
            }
            MapFrame.getInstance().setMeasurementLineButton(!SettingsBean.getInstance().isParamMapMouseGoogleStyle());
            SettingsBean.getInstance().setParamGEExportStickyToTerrain(this.geStickyToTerrainCheckBox.isSelected());
            if (this.useSecondsCheckBox.isSelected() != SettingsBean.getInstance().isParamIncludeSecondsInTimeCalculations()) {
                SettingsBean.getInstance().setParamIncludeSecondsInTimeCalculations(this.useSecondsCheckBox.isSelected());
                updateMap = true;
            }
            SettingsBean.getInstance().setParamUseMapDecimalCoords(this.useMapDecimalCoordsCheckBox.isSelected());
            SettingsBean.getInstance().setParamUseMultipleCores(this.useMultipleCoresCheckBox.isSelected());
            SettingsBean.getInstance().setParamUseProxy(this.useProxyCheckbox.isSelected());
            ProxyBean proxyBean = new ProxyBean();
            if (this.useProxyCheckbox.isSelected()) {
                proxyBean.setHttpHost(this.proxyHostTextField.getText());
                try {
                    proxyBean.setHttpPort(Integer.valueOf(this.proxyPortTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.proxyUseAuthenticationCheckbox.isSelected()) {
                    proxyBean.setHttpUserName(this.proxyUserTextField.getText());
                    proxyBean.setHttpPassword(new String(this.proxyPasswordField.getPassword()));
                }
                proxyBean.setGlobalProxy();
            }
            SettingsBean.getInstance().setProxyBean(proxyBean);
            SettingsBean.getInstance().getSimConnectConfigBean().setMixtureLean(this.mixtureLeanCheckBox.isSelected());
            SettingsBean.getInstance().getSimConnectConfigBean().setThrottleCutOff(this.throttleCutOffCheckBox.isSelected());
            SettingsBean.getInstance().getSimConnectConfigBean().setTraceUserPosition(this.traceUserPositionCheckBox.isSelected());
            SettingsBean.getInstance().getSimConnectConfigBean().setSaveUserTrack(this.saveUserTrackCheckBox.isSelected());
            SettingsBean.getInstance().getSimConnectConfigBean().setGetFps(this.saveFpsCheckBox.isSelected());
            SettingsBean.getInstance().getSimConnectConfigBean().setTraceTraffic(this.showTrafficCheckBox.isSelected());
            SettingsBean.getInstance().getSimConnectConfigBean().setTrafficShowOnlyInAir(this.showTrafficOnlyInTheAir.isSelected());
            SettingsBean.getInstance().getSimConnectConfigBean().setTrafficShowOnlyIn2kAltitudeRange(this.showTrafficOnlyInTheAltitudeRange.isSelected());
            SettingsBean.getInstance().getSimConnectConfigBean().setTrafficRadius(this.aiTrafficRadius.getValue());
            SettingsBean.getInstance().getSimConnectConfigBean().setIntervalBoostAtLowAlt(this.simConnectIntervalBoostCheckBox.isSelected());
            SettingsBean.getInstance().getSimConnectConfigBean().setProbability(this.failureProbabilitySlider.getValue());
            SettingsBean.getInstance().getSimConnectConfigBean().setInterval(this.parseStepToInterval(this.simConnectIntervalSlider.getValue()));
            if (SettingsBean.getInstance().getJvmParamsBean().getXmx() != this.maxMemoryCombo[this.maxMemoryComboBox.getSelectedIndex()].getValue().intValue()) {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("settings_frame_max_memory_changed"), "", 2);
                SettingsBean.getInstance().getJvmParamsBean().setXmx(this.maxMemoryCombo[this.maxMemoryComboBox.getSelectedIndex()].getValue());
                VfrUtil.saveLaunch4jIni(SettingsBean.getInstance().getJvmParamsBean());
                VfrUtil.saveCommandFileWindows(SettingsBean.getInstance().getJvmParamsBean());
                VfrUtil.saveCommandFileLinux(SettingsBean.getInstance().getJvmParamsBean());
                VfrUtil.saveCommandFileMacOs(SettingsBean.getInstance().getJvmParamsBean());
            }
            if (updateMap) {
                MapFrame.getInstance().updateMap();
            }
            if (this.settingsChanged()) {
                NumericComboBoxItem selLang;
                SettingsBean.getInstance().setParamThreeRowsLayout(this.threeRowsLayoutCheckBox.isSelected());
                StringComboBoxItem lafTheme = (StringComboBoxItem)this.lookAndFeelComboBox.getSelectedItem();
                if (!lafTheme.getValue().equals(SettingsBean.getInstance().getParamLookAndFeel())) {
                    SettingsBean.getInstance().setParamLookAndFeel(lafTheme.getValue());
                    LookAndFeelUtil.initLookAndFeelTheme();
                }
                if (this.sidePanelWidthTextField.getValue() != null && this.sidePanelWidthTextField.getValue().intValue() != SettingsBean.getInstance().getParamSidePanelWidth()) {
                    SettingsBean.getInstance().setParamSidePanelWidth(this.sidePanelWidthTextField.getValue());
                }
                if ((selLang = (NumericComboBoxItem)this.languageCombo.getSelectedItem()).getValue().intValue() != SettingsBean.getInstance().getParamLanguage()) {
                    Messages.getInstance().loadResources(selLang.getValue());
                }
                SettingsBean.getInstance().setParamLanguage(selLang.getValue());
                NumericComboBoxItem renderingQuality = (NumericComboBoxItem)this.renderingQualityComboBox.getSelectedItem();
                SettingsBean.getInstance().setRenderingHintsQuality(renderingQuality.getValue());
                StringComboBoxItem selUnitsDist = (StringComboBoxItem)this.distanceCombo.getSelectedItem();
                StringComboBoxItem selUnitsSpeed = (StringComboBoxItem)this.speedCombo.getSelectedItem();
                StringComboBoxItem selUnitsAlt = (StringComboBoxItem)this.altitudeCombo.getSelectedItem();
                StringComboBoxItem selUnitsFuel = (StringComboBoxItem)this.fuelCombo.getSelectedItem();
                StringComboBoxItem selUnitsWindSpeed = (StringComboBoxItem)this.windSpeedCombo.getSelectedItem();
                HashMap<String, String> to = new HashMap<String, String>();
                to.put("unitsDistance", selUnitsDist.getValue());
                to.put("unitsSpeed", selUnitsSpeed.getValue());
                to.put("unitsAltitude", selUnitsAlt.getValue());
                to.put("unitsFuel", selUnitsFuel.getValue());
                to.put("unitsWindSpeed", selUnitsWindSpeed.getValue());
                UnitUtil.recalculateUnits(to);
                VfrUtil.refreshUI();
                try {
                    VfrUtil.executeTaskInFixedSinglePool(new RefreshObstaclesTask());
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                MapFrame.getInstance().updateMap();
            }
            this.closeWindowAction();
        }
    }

    public boolean doValidate() {
        return this.checkNoSimActionSelected();
    }

    private boolean settingsChanged() {
        NumericComboBoxItem selLang = (NumericComboBoxItem)this.languageCombo.getSelectedItem();
        if (selLang.getValue().intValue() != SettingsBean.getInstance().getParamLanguage()) {
            return true;
        }
        StringComboBoxItem selUnitsDist = (StringComboBoxItem)this.distanceCombo.getSelectedItem();
        if (!selUnitsDist.getValue().equals(SettingsBean.getInstance().getParamUnitsDistance())) {
            return true;
        }
        StringComboBoxItem selUnitsSpeed = (StringComboBoxItem)this.speedCombo.getSelectedItem();
        if (!selUnitsSpeed.getValue().equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            return true;
        }
        StringComboBoxItem selUnitsWindSpeed = (StringComboBoxItem)this.windSpeedCombo.getSelectedItem();
        if (!selUnitsWindSpeed.getValue().equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
            return true;
        }
        StringComboBoxItem selUnitsAlt = (StringComboBoxItem)this.altitudeCombo.getSelectedItem();
        if (!selUnitsAlt.getValue().equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            return true;
        }
        StringComboBoxItem selUnitsFuel = (StringComboBoxItem)this.fuelCombo.getSelectedItem();
        if (!selUnitsFuel.getValue().equals(SettingsBean.getInstance().getParamUnitsFuel())) {
            return true;
        }
        NumericComboBoxItem renderingQuality = (NumericComboBoxItem)this.renderingQualityComboBox.getSelectedItem();
        if (!renderingQuality.getValue().equals(SettingsBean.getInstance().getRenderingHintsQuality())) {
            return true;
        }
        StringComboBoxItem lafTheme = (StringComboBoxItem)this.lookAndFeelComboBox.getSelectedItem();
        if (!lafTheme.getValue().equals(SettingsBean.getInstance().getParamLookAndFeel())) {
            return true;
        }
        if (this.sidePanelWidthTextField.getValue() != null && this.sidePanelWidthTextField.getValue().intValue() != SettingsBean.getInstance().getParamSidePanelWidth()) {
            return true;
        }
        return this.threeRowsLayoutCheckBox.isSelected() != SettingsBean.getInstance().isParamThreeRowsLayout();
    }

    private void useProxyToggleAction() {
        boolean selected = this.useProxyCheckbox.isSelected();
        this.proxyHostTextField.setEnabled(selected);
        this.proxyPortTextField.setEnabled(selected);
        this.proxyUseAuthenticationCheckbox.setEnabled(selected);
        if (!selected) {
            this.proxyHostTextField.setText("");
            this.proxyPortTextField.setText("");
            this.proxyUseAuthenticationCheckbox.setSelected(false);
            this.proxyUserTextField.setText("");
            this.proxyPasswordField.setText("");
            this.proxyUserTextField.setEnabled(false);
            this.proxyPasswordField.setEnabled(false);
        }
    }

    private void proxyUseAuthenticationToggleAction() {
        boolean selected = this.proxyUseAuthenticationCheckbox.isSelected();
        this.proxyUserTextField.setEnabled(selected);
        this.proxyPasswordField.setEnabled(selected);
        if (!selected) {
            this.proxyUserTextField.setText("");
            this.proxyPasswordField.setText("");
        }
    }
}

