/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.core.map.MapMode;
import main.java.guru.vfrflight.gui.flightplan.CalculationResultDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.SelectionModeDialog;
import main.java.guru.vfrflight.gui.task.SelectionDialogTask;

public class SelectionDialog
extends SelectionModeDialog
implements KeyListener {
    private static final long serialVersionUID = 5884705345521663711L;
    private GpsArea selectionArea;
    private Integer selectedZoom = null;
    private CalculationResultDialog mainDialog;
    private final SelectionDialogTask task;

    public SelectionDialog(JFrame frame, SelectionDialogTask task) {
        super(frame);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                SelectionDialog.this.closeWindowAction();
                MapFrame.getInstance().updateMap();
                SelectionDialog.this.setVisible(false);
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.task = task;
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel vorSelectionPanel = new JPanel();
        vorSelectionPanel.setBorder(new EmptyBorder(0, 30, 0, 30));
        panel_3.add((Component)vorSelectionPanel, "Center");
        GridBagLayout gbl_vorSelectionPanel = new GridBagLayout();
        gbl_vorSelectionPanel.columnWidths = new int[]{382};
        gbl_vorSelectionPanel.rowHeights = new int[]{68};
        gbl_vorSelectionPanel.columnWeights = new double[]{0.0};
        gbl_vorSelectionPanel.rowWeights = new double[]{0.0};
        vorSelectionPanel.setLayout(gbl_vorSelectionPanel);
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(1, null, null), "", 4, 2, null, null), new EmptyBorder(0, 10, 0, 10)));
        GridBagConstraints gbc_infoPanel = new GridBagConstraints();
        gbc_infoPanel.fill = 1;
        gbc_infoPanel.gridx = 0;
        gbc_infoPanel.gridy = 0;
        vorSelectionPanel.add((Component)infoPanel, gbc_infoPanel);
        infoPanel.setLayout(new BorderLayout(0, 0));
        JLabel label = new JLabel(Messages.getInstance().get("pdf_region_dialog_info_label"));
        label.setHorizontalAlignment(0);
        infoPanel.add((Component)label, "Center");
        JPanel namePanel = new JPanel();
        namePanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)namePanel, "South");
        JButton loadButton = new JButton(Messages.getInstance().get("select"));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SelectionDialog.this.selectAction();
            }
        });
        namePanel.add(loadButton);
        JButton clearButton = new JButton(Messages.getInstance().get("clear_selection"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SelectionDialog.this.clearAction();
            }
        });
        namePanel.add(clearButton);
        this.setPreferredSize(new Dimension(410, 150));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        MapFrame.getInstance().getMapViewer().setSelectionModeDialog(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                boolean keyHandled = false;
                if (e.getID() == 401) {
                    SelectionDialog.this.keyReleased(e);
                }
                return keyHandled;
            }
        });
        this.init();
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void init() {
        MapFrame.getInstance().getMapViewer().setMapMode(MapMode.RECTANGLE_DRAW);
        MapFrame.getInstance().getMapViewer().setDrawSelectionMode(true);
        MapFrame.getInstance().getMapViewer().setAllowRotationInRectangleDrawMode(false);
        if (this.selectionArea != null) {
            MapFrame.getInstance().getMapViewer().setSelectionArea(this.selectionArea);
            MapFrame.getInstance().getMapViewer().repaint();
        }
    }

    private void closeWindowAction() {
        MapFrame.getInstance().getMapViewer().setMapMode(MapMode.DEFAULT);
        MapFrame.getInstance().getMapViewer().setSelectionModeDialog(null);
        MapFrame.getInstance().getMapViewer().setDrawSelectionMode(false);
        if (this.mainDialog != null) {
            this.mainDialog.setVisible(true);
        }
        this.setVisible(false);
    }

    private void clearAction() {
        MapFrame.getInstance().getMapViewer().setRotatedSelectionArea(null);
        this.selectionArea = null;
        MapFrame.getInstance().updateMap();
    }

    private void selectAction() {
        if (this.doValidate()) {
            this.task.setArea(this.selectionArea);
            new Thread(this.task).start();
            this.closeWindowAction();
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (MapFrame.getInstance().getMapViewer().getSelectionArea() == null) {
            errors.add(Messages.getInstance().get("terrain_layer_dialog_no_area_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    @Override
    public void selectionChanged(GpsArea area) {
        this.selectionArea = area;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 37) {
            MapFrame.getInstance().getMapViewer().moveMap(-100, 0);
        } else if (e.getKeyCode() == 40) {
            MapFrame.getInstance().getMapViewer().moveMap(0, 100);
        } else if (e.getKeyCode() == 39) {
            MapFrame.getInstance().getMapViewer().moveMap(100, 0);
        } else if (e.getKeyCode() == 38) {
            MapFrame.getInstance().getMapViewer().moveMap(0, -100);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public GpsArea getSelectionArea() {
        return this.selectionArea;
    }

    public void setSelectionArea(GpsArea selectionArea) {
        this.selectionArea = selectionArea;
    }

    @Override
    public boolean isRotationEnabled() {
        return false;
    }

    public Integer getSelectedZoom() {
        return this.selectedZoom;
    }

    public void setSelectedZoom(Integer selectedZoom) {
        this.selectedZoom = selectedZoom;
    }

    @Override
    public void rotatedSelectionChanged(RotatedGpsArea area) {
    }
}

