/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.gui.flightplan.PdfSettingsDialog;
import main.java.guru.vfrflight.gui.swing.panel.image.FitToPanelImagePanel;
import main.java.guru.vfrflight.pdf.sections.type.PdfSectionType;
import main.java.guru.vfrflight.pdf.util.PdfSectionFactory;

public class SelectPdfSectionDialog
extends JDialog {
    private static final long serialVersionUID = -6317824064013733211L;
    private JComboBox<StringComboBoxItem> sectionsComboBox;
    private JTextArea sectionsTextArea;
    private PdfSettingsDialog mainDialog;
    private static final String PATH_TO_IMAGES = "img/pdf/";
    private FitToPanelImagePanel imagePanel;

    public SelectPdfSectionDialog(PdfSettingsDialog mainDialog) {
        super(mainDialog);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                SelectPdfSectionDialog.this.closeWindowAction();
            }
        });
        this.setResizable(true);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setTitle("");
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.mainDialog = mainDialog;
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel topPanel = new JPanel();
        panel_3.add((Component)topPanel, "North");
        this.sectionsComboBox = new JComboBox();
        this.sectionsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SelectPdfSectionDialog.this.updateTextArea();
            }
        });
        this.sectionsComboBox.setModel(new DefaultComboBoxModel<StringComboBoxItem>(PdfSectionFactory.createComboBoxValues()));
        topPanel.add(this.sectionsComboBox);
        JPanel descPanel = new JPanel();
        panel_3.add((Component)descPanel, "Center");
        descPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        panel.setBorder(new CompoundBorder(new EmptyBorder(10, 20, 10, 20), new EtchedBorder(1, null, null)));
        descPanel.add((Component)panel, "South");
        panel.setLayout(new BorderLayout(0, 0));
        this.sectionsTextArea = new JTextArea();
        this.sectionsTextArea.setEnabled(false);
        this.sectionsTextArea.setEditable(false);
        this.sectionsTextArea.setRows(3);
        this.sectionsTextArea.setWrapStyleWord(true);
        this.sectionsTextArea.setLineWrap(true);
        panel.add(this.sectionsTextArea);
        this.imagePanel = new FitToPanelImagePanel();
        descPanel.add((Component)this.imagePanel, "Center");
        JPanel buttonPanel = new JPanel();
        panel_3.add((Component)buttonPanel, "South");
        JButton selectButton = new JButton(Messages.getInstance().get("add_button"));
        buttonPanel.add(selectButton);
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPdfSectionDialog.this.addAction();
            }
        });
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        buttonPanel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPdfSectionDialog.this.closeWindowAction();
            }
        });
        this.updateTextArea();
        this.setPreferredSize(new Dimension(600, 650));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void updateTextArea() {
        StringComboBoxItem val = (StringComboBoxItem)this.sectionsComboBox.getSelectedItem();
        String key = "pdf_section_type_" + val.getValue().toLowerCase() + "_desc";
        if (Messages.getInstance().exists(key)) {
            this.sectionsTextArea.setText(Messages.getInstance().get(key));
        } else {
            this.sectionsTextArea.setText("");
        }
        String previewFilename = PdfSectionType.valueOf(val.getValue()).getPreviewFilename();
        if (previewFilename != null) {
            this.imagePanel.loadImage(PATH_TO_IMAGES + previewFilename);
        } else {
            this.imagePanel.setImage(null);
        }
    }

    private void addAction() {
        StringComboBoxItem val = (StringComboBoxItem)this.sectionsComboBox.getSelectedItem();
        this.mainDialog.addSectionToList(PdfSectionType.valueOf(val.getValue()));
        this.closeWindowAction();
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }
}

