/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.combo.item.ComboBoxItem;
import main.java.guru.vfrflight.core.sql.entity.AirportFreq;

public class SelectAirportFrequencyDialog
extends JDialog {
    private static final long serialVersionUID = -6317824064013733211L;
    private Double chosenFrequency = null;
    private boolean frequencyWasChosen = false;
    private JComboBox<ComboBoxItem<Double>> comboBox;

    public SelectAirportFrequencyDialog(List<AirportFreq> frequencies) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                SelectAirportFrequencyDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("select_airport_frequency_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("select_airport_frequency_dialog_label"));
        panel_3.add(lblNewLabel);
        ArrayList<ComboBoxItem<Object>> comboData = new ArrayList<ComboBoxItem<Object>>(frequencies.size() + 1);
        comboData.add(new ComboBoxItem<Object>("", null));
        for (AirportFreq f : frequencies) {
            if (f.getFrequency() == null) continue;
            String type = f.getType() != null ? f.getType().toString() : "";
            comboData.add(new ComboBoxItem<Double>((type + " " + String.valueOf(f.getFrequency())).trim(), f.getFrequency()));
        }
        this.comboBox = new JComboBox();
        this.comboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(comboData.toArray(new ComboBoxItem[comboData.size()])));
        panel_3.add(this.comboBox);
        if (comboData.size() == 2) {
            this.comboBox.setSelectedIndex(1);
        }
        JButton selectButton = new JButton(Messages.getInstance().get("select_button"));
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectAirportFrequencyDialog.this.selectAction();
            }
        });
        panel_3.add(selectButton);
        this.setModal(true);
        this.setPreferredSize(new Dimension(350, 64));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void selectAction() {
        ComboBoxItem sel = (ComboBoxItem)this.comboBox.getSelectedItem();
        this.chosenFrequency = (Double)sel.getValue();
        this.frequencyWasChosen = true;
        this.closeWindowAction();
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    public Double getChosenFrequency() {
        return this.chosenFrequency;
    }

    public boolean isFrequencyWasChosen() {
        return this.frequencyWasChosen;
    }

    public void setFrequencyWasChosen(boolean frequencyWasChosen) {
        this.frequencyWasChosen = frequencyWasChosen;
    }
}

