/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.comparator.MatchComparator;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.SearchResultDataTable;

public class SearchDialog
extends JDialog {
    private static final long serialVersionUID = 1128367340311205503L;
    private SearchResultDataTable resultTable;

    public SearchDialog(JFrame frame, String query, List<GpsPlace> results) {
        super(frame);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("popup_menu_search") + " [" + query + "]");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                SearchDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        JButton anulujButton = new JButton(Messages.getInstance().get("close_button"));
        anulujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(anulujButton);
        JPanel resultsTablePanel = new JPanel();
        panel.add((Component)resultsTablePanel, "Center");
        resultsTablePanel.setLayout(new BorderLayout(0, 0));
        Collections.sort(results, new MatchComparator(query));
        this.resultTable = new SearchResultDataTable(false);
        this.resultTable.setData(results);
        resultsTablePanel.add(this.resultTable);
        JPanel panel_1 = new JPanel();
        this.resultTable.add((Component)panel_1, "North");
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("search_dialog_double_click"));
        panel_1.add(lblNewLabel);
        this.setSize(500, 380);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        MapFrame.getInstance().lock();
        MapFrame.getInstance().hidePanel();
    }

    private void closeWindowAction() {
        this.resultTable.centerOnSelected();
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().unlock();
        MapFrame.getInstance().setMarkerPlace(null);
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }
}

