/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.filter.AirspaceReservationFilter;
import main.java.guru.vfrflight.core.AirspaceReservation;
import main.java.guru.vfrflight.core.AirspaceReservationPlan;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.panel.textfield.reservations.AirspaceReservationTextField;
import main.java.guru.vfrflight.gui.flightplan.panel.textfield.reservations.AirspaceReservationTimeTextField;
import main.java.guru.vfrflight.gui.table.ReservedAirspacesDataTable;
import main.java.guru.vfrflight.util.UnitUtil;

public class ReservedAirspacesDialog
extends JDialog {
    private static final long serialVersionUID = -9105675095897520236L;
    private AirspaceReservationTimeTextField timeFromTextField;
    private AirspaceReservationTimeTextField timeToTextField;
    private List<AirspaceReservation> foundReservations;
    private List<AirspaceReservation> missingReservations;
    private ReservedAirspacesDataTable foundTable;
    private ReservedAirspacesDataTable missingTable;
    private JPanel filterPanel;
    private JPanel buttonPanel;
    private JCheckBox timeRangeCheckBox;
    private AirspaceReservationFilter filter = new AirspaceReservationFilter();
    private JPanel altitudePanel;
    private JCheckBox altRangeCheckBox;
    private AirspaceReservationTextField altFromTextField;
    private AirspaceReservationTextField altToTextField;
    private JPanel descPanel;
    private JLabel descLabel;

    public ReservedAirspacesDialog(JFrame parent, AirspaceReservationPlan plan) {
        super(parent);
        this.setResizable(false);
        this.setModal(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                ReservedAirspacesDialog.this.closeWindowAction();
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout(new FlowLayout(1, 5, 5));
        this.filterPanel = new JPanel();
        this.filterPanel.setBorder(new EtchedBorder(1, null, null));
        panel.add(this.filterPanel);
        this.filterPanel.setLayout(new BorderLayout(0, 0));
        JPanel timePanel = new JPanel();
        this.filterPanel.add((Component)timePanel, "North");
        timePanel.setBorder(new EtchedBorder(1, null, null));
        this.timeRangeCheckBox = new JCheckBox("", false);
        this.timeRangeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReservedAirspacesDialog.this.timeRangeToggleAction();
            }
        });
        timePanel.add(this.timeRangeCheckBox);
        timePanel.add(new JLabel(Messages.getInstance().get("reserved_airspaces_frame_time_from")));
        this.timeFromTextField = new AirspaceReservationTimeTextField(this, 6.0, this.timeRangeCheckBox.isSelected());
        timePanel.add(this.timeFromTextField);
        timePanel.add(new JLabel(Messages.getInstance().get("reserved_airspaces_frame_time_to")));
        this.timeToTextField = new AirspaceReservationTimeTextField(this, 6.0, this.timeRangeCheckBox.isSelected());
        timePanel.add(this.timeToTextField);
        this.buttonPanel = new JPanel();
        this.filterPanel.add((Component)this.buttonPanel, "South");
        JButton clearButton = new JButton(Messages.getInstance().get("reserved_airspaces_frame_clear_filter"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReservedAirspacesDialog.this.clearAction();
            }
        });
        this.buttonPanel.add(clearButton);
        this.altitudePanel = new JPanel();
        this.altitudePanel.setBorder(new EtchedBorder(1, null, null));
        this.filterPanel.add((Component)this.altitudePanel, "West");
        this.altRangeCheckBox = new JCheckBox("", false);
        this.altRangeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReservedAirspacesDialog.this.altRangeToggleAction();
            }
        });
        this.altitudePanel.add(this.altRangeCheckBox);
        this.altitudePanel.add(new JLabel(Messages.getInstance().get("reserved_airspaces_frame_alt_from") + UnitUtil.getAltitudeUnit()));
        this.altFromTextField = new AirspaceReservationTextField(this);
        this.altFromTextField.setColumns(7);
        this.altFromTextField.setEnabled(this.altRangeCheckBox.isSelected());
        this.altitudePanel.add(this.altFromTextField);
        this.altitudePanel.add(new JLabel(Messages.getInstance().get("reserved_airspaces_frame_alt_to")));
        this.altToTextField = new AirspaceReservationTextField(this);
        this.altToTextField.setColumns(7);
        this.altToTextField.setEnabled(this.altRangeCheckBox.isSelected());
        this.altitudePanel.add(this.altToTextField);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        ArrayList<AirspaceReservation> missingReservations = new ArrayList<AirspaceReservation>();
        ArrayList<AirspaceReservation> foundReservations = new ArrayList<AirspaceReservation>();
        for (AirspaceReservation res : plan.getReservations()) {
            if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                if (res.getAltitudeFrom() != null) {
                    res.setAltitudeFrom((int)Math.round(UnitUtil.recalculateAltitude(res.getAltitudeFrom().intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false)));
                }
                if (res.getAltitudeTo() != null) {
                    res.setAltitudeTo((int)Math.round(UnitUtil.recalculateAltitude(res.getAltitudeTo().intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false)));
                }
            }
            if (res.getShape() == null) {
                missingReservations.add(res);
                continue;
            }
            foundReservations.add(res);
        }
        this.foundTable = new ReservedAirspacesDataTable(foundReservations);
        tabbedPane.addTab(Messages.getInstance().get("reserved_airspaces_frame_tab_found"), null, this.foundTable, null);
        this.missingTable = new ReservedAirspacesDataTable(missingReservations);
        tabbedPane.addTab(Messages.getInstance().get("reserved_airspaces_frame_tab_missing"), null, this.missingTable, null);
        this.foundReservations = foundReservations;
        this.missingReservations = missingReservations;
        this.getContentPane().add(tabbedPane);
        this.descPanel = new JPanel();
        this.getContentPane().add((Component)this.descPanel, "North");
        this.descLabel = new JLabel("<html><center>" + plan.getDesc() + "<br/>" + plan.getCharlieCount() + " CHARLIE, " + plan.getFoxtrotCount() + " FOXTROT.</center></html>");
        this.descPanel.add(this.descLabel);
        this.setSize(750, 454);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("reserved_airspaces_frame_title"));
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.initAction();
    }

    private void clearAction() {
        this.filter.clear();
        this.timeRangeCheckBox.setSelected(false);
        if (this.altRangeCheckBox.isSelected()) {
            this.altRangeCheckBox.setSelected(false);
            this.altRangeToggleAction();
        }
        this.updateData();
    }

    private void timeRangeToggleAction() {
        this.timeFromTextField.setEnabled(this.timeRangeCheckBox.isSelected());
        this.timeToTextField.setEnabled(this.timeRangeCheckBox.isSelected());
        if (!this.timeRangeCheckBox.isSelected()) {
            this.filter.setTimeTo(null);
            this.filter.setTimeFrom(null);
            this.updateData();
        }
        this.filterAction();
    }

    private void altRangeToggleAction() {
        this.altFromTextField.setEnabled(this.altRangeCheckBox.isSelected());
        this.altToTextField.setEnabled(this.altRangeCheckBox.isSelected());
        if (!this.altRangeCheckBox.isSelected()) {
            this.filter.setAltTo(null);
            this.filter.setAltFrom(null);
            this.updateData();
        }
        this.filterAction();
    }

    public void filterAction() {
        if (this.timeRangeCheckBox.isSelected()) {
            int timeTo;
            int timeFrom = (int)Math.round(this.timeFromTextField.getValue());
            if (timeFrom >= (timeTo = (int)Math.round(this.timeToTextField.getValue()))) {
                timeTo += 24;
            }
            this.filter.setTimeFrom(timeFrom);
            this.filter.setTimeTo(timeTo);
        }
        if (this.altRangeCheckBox.isSelected()) {
            if (this.altFromTextField.getValue() != null && this.altToTextField.getValue() != null && this.altFromTextField.getValue() > this.altToTextField.getValue()) {
                this.altFromTextField.setValue(null);
                this.altToTextField.setValue(null);
            }
            this.filter.setAltFrom(this.altFromTextField.getValue());
            this.filter.setAltTo(this.altToTextField.getValue());
        }
        this.updateData();
    }

    private void updateData() {
        MapObjectsBean.getInstance().setAirspaceReservations(null);
        if (this.foundReservations != null) {
            ArrayList<AirspaceReservation> filteredFoundReservations = new ArrayList<AirspaceReservation>();
            for (AirspaceReservation r : this.foundReservations) {
                if (!this.filter.checkDisplay(r)) continue;
                filteredFoundReservations.add(r);
            }
            this.foundTable.setData(filteredFoundReservations);
            MapObjectsBean.getInstance().setAirspaceReservations(filteredFoundReservations.toArray(new AirspaceReservation[filteredFoundReservations.size()]));
            ArrayList<AirspaceReservation> filteredMissingReservations = new ArrayList<AirspaceReservation>();
            for (AirspaceReservation r : this.missingReservations) {
                if (!this.filter.checkDisplay(r)) continue;
                filteredMissingReservations.add(r);
            }
            this.missingTable.setData(filteredMissingReservations);
        }
        MapFrame.getInstance().updateMap();
    }

    private void initAction() {
        SettingsBean.getInstance().setDrawAirspaces(false);
        MapFrame.getInstance().hidePanel();
        MapFrame.getInstance().lock();
        this.updateData();
    }

    private void closeWindowAction() {
        SettingsBean.getInstance().setDrawAirspaces(true);
        MapFrame.getInstance().unlock();
        MapFrame.getInstance().showPanel();
        MapObjectsBean.getInstance().setAirspaceReservations(null);
        MapFrame.getInstance().updateMap();
        this.setVisible(false);
    }
}

