/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.AirspaceReservationPlan;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.ReservedAirspacesDialog;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.amc.AmcUtil;
import org.apache.log4j.Logger;

public class ReservedAirspaceDataInputDialog
extends JDialog {
    private static final Logger log = Logger.getLogger(ReservedAirspaceDataInputDialog.class);
    private static final long serialVersionUID = 2110195912575918488L;
    private JLabel infoLabel;
    private static final String AMC_URL_PL = "http://amc.pansa.pl/?menu_lewe=aup&lang=_pl&opis=amc_aup";
    private static final String AMC_URL_EN = "http://amc.pansa.pl/?menu_lewe=aup&lang=_eng&opis=amc_aup";
    private String amcUrl;

    public ReservedAirspaceDataInputDialog(JFrame parent) {
        super(parent);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                ReservedAirspaceDataInputDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("reserved_airspaces_dialog_title"));
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel buttonBarPanel = new JPanel();
        buttonBarPanel.setBorder(new EtchedBorder(1, null, null));
        this.getContentPane().add((Component)buttonBarPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                ReservedAirspaceDataInputDialog.this.loadAction();
            }
        });
        buttonBarPanel.setLayout(new FlowLayout(1, 5, 5));
        buttonBarPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                ReservedAirspaceDataInputDialog.this.closeWindowAction();
            }
        });
        buttonBarPanel.add(cancelButton);
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new EtchedBorder(1, null, null));
        this.getContentPane().add((Component)infoPanel, "Center");
        infoPanel.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        infoPanel.add((Component)panel, "Center");
        this.infoLabel = new JLabel();
        panel.add(this.infoLabel);
        JPanel panel_1 = new JPanel();
        infoPanel.add((Component)panel_1, "South");
        JButton openUrlButton = new JButton(Messages.getInstance().get("reserved_airspaces_dialog_open_url"));
        panel_1.add(openUrlButton);
        JPanel infoTextPanel = new JPanel();
        infoPanel.add((Component)infoTextPanel, "North");
        JLabel informationLabel = new JLabel(Messages.getInstance().get("reserved_airspaces_dialog_information"));
        infoTextPanel.add(informationLabel);
        openUrlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                UrlUtil.openUrlInBrowser(ReservedAirspaceDataInputDialog.this.amcUrl);
            }
        });
        this.setModal(true);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.setPreferredSize(new Dimension(500, 200));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        this.updateData();
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    private void loadAction() {
        String clipboard = StringUtil.pasteFromClipboard();
        if (StringUtil.isEmpty(clipboard)) {
            JOptionPane.showMessageDialog(this, Messages.getInstance().get("reserved_airspaces_clipboard_is_empty"), Messages.getInstance().get("error"), 0);
        } else {
            AirspaceReservationPlan plan = AmcUtil.loadAirspaceReservationPlan(MapObjectsBean.getInstance().getAirspaces(), clipboard);
            if (plan != null && plan.getReservations() != null && plan.getReservations().size() > 0) {
                log.debug("Loaded " + plan.getReservations().size() + " into MapObjectsBean: " + plan.getCharlieCount() + " CHARLIE, " + plan.getFoxtrotCount() + " FOXTROT.");
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("reserved_airspaces_airspaces_found"), "", 1);
                ReservedAirspacesDialog dialog = new ReservedAirspacesDialog(MapFrame.getInstance(), plan);
                dialog.setVisible(true);
                this.closeWindowAction();
            } else {
                JOptionPane.showMessageDialog(this, Messages.getInstance().get("reserved_airspaces_invalid_data"), Messages.getInstance().get("error"), 0);
            }
        }
    }

    private void updateData() {
        this.amcUrl = "PL".equals(SettingsBean.getInstance().getLanguageCode()) ? AMC_URL_PL : AMC_URL_EN;
        this.infoLabel.setText("<html><a href=\"" + this.amcUrl + "\">" + this.amcUrl + "</a></html>");
    }
}

