/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.SelectPdfSectionDialog;
import main.java.guru.vfrflight.gui.list.ToggleableListSelectionModel;
import main.java.guru.vfrflight.gui.swing.list.PdfSettingsListModel;
import main.java.guru.vfrflight.pdf.sections.type.PdfSectionType;
import main.java.guru.vfrflight.util.GuiUtil;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;

public class PdfSettingsDialog
extends JDialog {
    private static final long serialVersionUID = 7818755704857515893L;
    private JCheckBox halfSizeCheckBox;
    private JCheckBox includeEtaCheckBox;
    private JCheckBox includeFilledEtaCheckBox;
    private JCheckBox includeEmptyAtaCheckBox;
    private JCheckBox includeLandmarksCheckBox;
    private JCheckBox includeVorRadialsCheckBox;
    private JCheckBox drawVorRadialsCheckBox;
    private JCheckBox vorRadialsTableCheckBox;
    private JPanel layoutPdf;
    private JList<String> sectionsList;

    public PdfSettingsDialog(Window frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                PdfSettingsDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setTitle("VfrFlight: " + Messages.getInstance().get("pdf_settings_dialog_title"));
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(new EtchedBorder(1, null, null));
        panel.add((Component)buttonPanel, "South");
        JButton eksportujButton = new JButton(Messages.getInstance().get("ok_button"));
        eksportujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PdfSettingsDialog.this.saveAction();
            }
        });
        buttonPanel.add(eksportujButton);
        JButton anulujButton = new JButton(Messages.getInstance().get("cancel_button"));
        anulujButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PdfSettingsDialog.this.cancelAction();
            }
        });
        buttonPanel.add(anulujButton);
        JPanel tabPanel = new JPanel();
        panel.add((Component)tabPanel, "Center");
        tabPanel.setLayout(new BorderLayout(0, 0));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        tabbedPane.setBorder(new EtchedBorder(1, null, null));
        tabPanel.add(tabbedPane);
        this.layoutPdf = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("pdf_settings_dialog_layout"), null, this.layoutPdf, null);
        this.layoutPdf.setLayout(new BorderLayout(0, 0));
        JPanel jlistPanel = new JPanel();
        this.layoutPdf.add((Component)jlistPanel, "Center");
        jlistPanel.setLayout(new BorderLayout(0, 0));
        JPanel listWrapperPanel = new JPanel();
        listWrapperPanel.setBorder(new CompoundBorder(new EmptyBorder(10, 50, 10, 50), new EtchedBorder(1, null, null)));
        jlistPanel.add((Component)listWrapperPanel, "Center");
        listWrapperPanel.setLayout(new BorderLayout(0, 0));
        this.sectionsList = new JList();
        this.sectionsList.setSelectionModel(new ToggleableListSelectionModel());
        this.sectionsList.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(22, 30);
        scrollPane.setViewportView(this.sectionsList);
        listWrapperPanel.add(scrollPane);
        JPanel listButtonPanel = new JPanel();
        this.layoutPdf.add((Component)listButtonPanel, "South");
        JButton upButton = new JButton("^^^");
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] idxs = PdfSettingsDialog.this.sectionsList.getSelectedIndices();
                if (idxs.length > 0 && idxs[0] > 0) {
                    for (int q = 0; q < idxs.length; ++q) {
                        PdfSettingsDialog.this.getListModel().moveUp(idxs[q]);
                    }
                }
            }
        });
        listButtonPanel.add(upButton);
        JButton addButton = new JButton(Messages.getInstance().get("add_button"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SelectPdfSectionDialog dialog = new SelectPdfSectionDialog(PdfSettingsDialog.this);
                dialog.setVisible(true);
            }
        });
        listButtonPanel.add(addButton);
        JButton deleteButton = new JButton(Messages.getInstance().get("delete_button"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] idxs = PdfSettingsDialog.this.sectionsList.getSelectedIndices();
                if (idxs.length >= 0) {
                    for (int q = 0; q < idxs.length; ++q) {
                        PdfSettingsDialog.this.getListModel().remove(idxs[q] - q);
                    }
                }
            }
        });
        listButtonPanel.add(deleteButton);
        JButton defaultsButton = new JButton(Messages.getInstance().get("restore_defaults_button"));
        defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PdfSettingsDialog.this.restoreDefaultsAction();
            }
        });
        listButtonPanel.add(defaultsButton);
        JButton downButton = new JButton("vvv");
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] idxs = PdfSettingsDialog.this.sectionsList.getSelectedIndices();
                if (idxs.length > 0 && idxs[idxs.length - 1] < PdfSettingsDialog.this.getListModel().getSize() - 1) {
                    int q = idxs.length - 1;
                    while (q >= 0) {
                        PdfSettingsDialog.this.getListModel().moveDown(idxs[q]);
                        int n = q--;
                        idxs[n] = idxs[n] + 1;
                    }
                    PdfSettingsDialog.this.sectionsList.setSelectedIndices(idxs);
                }
            }
        });
        listButtonPanel.add(downButton);
        JPanel pdfTab = new JPanel();
        pdfTab.setLayout(null);
        tabbedPane.addTab(Messages.getInstance().get("settings_frame_tab_pdf"), null, pdfTab, null);
        PdfConfigBean configBean = SettingsBean.getInstance().getPdfConfigBean();
        this.halfSizeCheckBox = new JCheckBox(Messages.getInstance().get("calculation_result_frame_pdf_half_page"), configBean.isHalfSize());
        this.halfSizeCheckBox.setBounds(20, 24, 359, 23);
        pdfTab.add(this.halfSizeCheckBox);
        JPanel routePanel = new JPanel();
        routePanel.setBorder(new EtchedBorder(1, null, null));
        routePanel.setLayout(null);
        this.includeEtaCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_pdf_include_empty_eta"), configBean.isIncludeEta());
        this.includeEtaCheckBox.setBounds(6, 32, 185, 23);
        routePanel.add(this.includeEtaCheckBox);
        this.includeFilledEtaCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_pdf_include_filled_eta"), configBean.isIncludeFilledEta());
        this.includeFilledEtaCheckBox.setBounds(197, 32, 162, 23);
        routePanel.add(this.includeFilledEtaCheckBox);
        this.includeEmptyAtaCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_pdf_include_empty_ata"), configBean.isIncludeEmptyAta());
        this.includeEmptyAtaCheckBox.setBounds(6, 58, 185, 23);
        routePanel.add(this.includeEmptyAtaCheckBox);
        this.includeLandmarksCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_pdf_include_landmarks"), configBean.isIncludeLandmarksInCalculationResults());
        this.includeLandmarksCheckBox.setBounds(6, 84, 185, 23);
        routePanel.add(this.includeLandmarksCheckBox);
        this.includeVorRadialsCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_pdf_include_vors"), configBean.isIncludeVorRadialsInCalculationResults());
        this.includeVorRadialsCheckBox.setBounds(6, 111, 185, 23);
        routePanel.add(this.includeVorRadialsCheckBox);
        this.includeEtaCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PdfSettingsDialog.this.updateEmptyEtaAction();
            }
        });
        JPanel routeSectionPdf = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("settings_frame_pdf_route_table"), null, routeSectionPdf, null);
        routeSectionPdf.setLayout(null);
        routePanel.setBounds(10, 11, 365, 152);
        routeSectionPdf.add(routePanel);
        JPanel oneMapPerLegSectionPdf = new JPanel();
        tabbedPane.addTab(Messages.getInstance().get("settings_frame_pdf_one_map_per_leg_table"), null, oneMapPerLegSectionPdf, null);
        oneMapPerLegSectionPdf.setLayout(null);
        JPanel panel_1 = new JPanel();
        panel_1.setLayout(null);
        panel_1.setBorder(new EtchedBorder(1, null, null));
        panel_1.setBounds(10, 11, 365, 125);
        oneMapPerLegSectionPdf.add(panel_1);
        this.drawVorRadialsCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_pdf_draw_vor_radials"), configBean.isOneMapPerLegDrawVorRadials());
        this.drawVorRadialsCheckBox.setBounds(6, 32, 185, 23);
        panel_1.add(this.drawVorRadialsCheckBox);
        this.vorRadialsTableCheckBox = new JCheckBox(Messages.getInstance().get("settings_frame_pdf_include_vor_radials_table"), configBean.isOneMapPerLegIncludeVorRadialsTable());
        this.vorRadialsTableCheckBox.setBounds(6, 58, 185, 23);
        panel_1.add(this.vorRadialsTableCheckBox);
        this.updateValues();
        this.setModal(true);
        this.setSize(400, 341);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    protected void restoreDefaultsAction() {
        if (GuiUtil.showConfirmationDialog(this, "", Messages.getInstance().get("are_you_sure"))) {
            this.sectionsList.setModel(new PdfSettingsListModel(PdfConfigBean.getDefaultLayout()));
        }
    }

    public void updateValues() {
        this.sectionsList.setModel(new PdfSettingsListModel(SettingsBean.getInstance().getPdfConfigBean().getLayout()));
        this.updateEmptyEtaAction();
    }

    private PdfSettingsListModel getListModel() {
        return (PdfSettingsListModel)this.sectionsList.getModel();
    }

    private void updateEmptyEtaAction() {
        if (!this.includeEtaCheckBox.isSelected()) {
            this.includeFilledEtaCheckBox.setSelected(false);
            this.includeFilledEtaCheckBox.setEnabled(false);
        } else {
            this.includeFilledEtaCheckBox.setEnabled(true);
        }
    }

    public void closeWindowAction() {
        this.setVisible(false);
    }

    public void cancelAction() {
        this.closeWindowAction();
    }

    public void saveAction() {
        if (this.doValidate()) {
            SettingsBean.getInstance().getPdfConfigBean().setLayout(this.getListModel().getTypes());
            PdfConfigBean configBean = SettingsBean.getInstance().getPdfConfigBean();
            configBean.setHalfSize(this.halfSizeCheckBox.isSelected());
            configBean.setIncludeEta(this.includeEtaCheckBox.isSelected());
            configBean.setIncludeFilledEta(this.includeFilledEtaCheckBox.isSelected());
            configBean.setIncludeEmptyAta(this.includeEmptyAtaCheckBox.isSelected());
            configBean.setIncludeLandmarksInCalculationResults(this.includeLandmarksCheckBox.isSelected());
            configBean.setIncludeVorRadialsInCalculationResults(this.includeVorRadialsCheckBox.isSelected());
            configBean.setOneMapPerLegDrawVorRadials(this.drawVorRadialsCheckBox.isSelected());
            configBean.setOneMapPerLegIncludeVorRadialsTable(this.vorRadialsTableCheckBox.isSelected());
            this.closeWindowAction();
        }
    }

    public boolean doValidate() {
        return true;
    }

    public void addSectionToList(PdfSectionType section) {
        this.getListModel().addSection(section);
    }
}

