/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.combo.item.NumericComboBoxItem;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.core.map.MapMode;
import main.java.guru.vfrflight.gui.flightplan.CalculationResultDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.SelectionModeDialog;
import main.java.guru.vfrflight.pdf.util.PdfUtil;

public class PdfRegionDialog
extends SelectionModeDialog
implements KeyListener {
    public static final int MODE_FLIGHT_PLAN_PDF = 0;
    public static final int MODE_EXPORT_MAP_TO_PDF = 1;
    public static final int MODE_EXPORT_MAP_TO_PNG = 2;
    public static final int MODE_EXPORT_XML = 3;
    private static final long serialVersionUID = 8186184484560238388L;
    private RotatedGpsArea selectionArea;
    private Integer selectedZoom = null;
    private CalculationResultDialog mainDialog;
    private JComboBox<NumericComboBoxItem> zoomComboBox;
    private JPanel northDetailsPanel;
    private final int mode;
    private JCheckBox includeCompassRoseCheckBox;
    private JComboBox<NumericComboBoxItem> compassRoseLocationComboBox;

    public PdfRegionDialog(JFrame frame, CalculationResultDialog mainDialog, RotatedGpsArea selectionArea, int mode) {
        super(frame);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                PdfRegionDialog.this.closeWindowAction();
                MapFrame.getInstance().updateMap();
                PdfRegionDialog.this.setVisible(false);
            }
        });
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new GridLayout(0, 1, 0, 0));
        this.selectionArea = selectionArea;
        this.mainDialog = mainDialog;
        this.mode = mode;
        JPanel panel_3 = new JPanel();
        this.getContentPane().add(panel_3);
        panel_3.setLayout(new BorderLayout(0, 0));
        JPanel vorSelectionPanel = new JPanel();
        vorSelectionPanel.setBorder(new EmptyBorder(0, 30, 0, 30));
        panel_3.add((Component)vorSelectionPanel, "North");
        GridBagLayout gbl_vorSelectionPanel = new GridBagLayout();
        gbl_vorSelectionPanel.columnWidths = new int[]{382};
        gbl_vorSelectionPanel.rowHeights = new int[]{68};
        gbl_vorSelectionPanel.columnWeights = new double[]{0.0};
        gbl_vorSelectionPanel.rowWeights = new double[]{0.0};
        vorSelectionPanel.setLayout(gbl_vorSelectionPanel);
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(1, null, null), "", 4, 2, null, null), new EmptyBorder(0, 10, 0, 10)));
        GridBagConstraints gbc_infoPanel = new GridBagConstraints();
        gbc_infoPanel.fill = 1;
        gbc_infoPanel.gridx = 0;
        gbc_infoPanel.gridy = 0;
        vorSelectionPanel.add((Component)infoPanel, gbc_infoPanel);
        infoPanel.setLayout(new BorderLayout(0, 0));
        JLabel label = new JLabel(Messages.getInstance().get("pdf_region_dialog_info_label"));
        label.setHorizontalAlignment(0);
        infoPanel.add((Component)label, "Center");
        JPanel namePanel = new JPanel();
        namePanel.setBorder(new EtchedBorder(1, null, null));
        panel_3.add((Component)namePanel, "South");
        JButton loadButton = new JButton(Messages.getInstance().get("select"));
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PdfRegionDialog.this.selectAction();
            }
        });
        namePanel.add(loadButton);
        JButton clearButton = new JButton(Messages.getInstance().get("clear_selection"));
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PdfRegionDialog.this.clearAction();
            }
        });
        namePanel.add(clearButton);
        JPanel detailsPanel = new JPanel();
        detailsPanel.setBorder(new CompoundBorder(new EmptyBorder(0, 10, 0, 10), new EtchedBorder(1, null, null)));
        panel_3.add((Component)detailsPanel, "Center");
        detailsPanel.setLayout(new BorderLayout(0, 0));
        this.northDetailsPanel = new JPanel();
        detailsPanel.add((Component)this.northDetailsPanel, "North");
        JLabel lblNewLabel = new JLabel(Messages.getInstance().get("pdf_region_dialog_resolution_label"));
        this.northDetailsPanel.add(lblNewLabel);
        JPanel middlePanel = new JPanel();
        detailsPanel.add((Component)middlePanel, "Center");
        this.includeCompassRoseCheckBox = new JCheckBox(Messages.getInstance().get("pdf_region_dialog_include_north_designator"), SettingsBean.getInstance().getPdfConfigBean().isWithCompassRose());
        this.includeCompassRoseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PdfRegionDialog.this.includeCompassRoseAction();
            }
        });
        middlePanel.add(this.includeCompassRoseCheckBox);
        JLabel compassRoseLocationLabel = new JLabel(Messages.getInstance().get("pdf_region_dialog_north_designator_location"));
        middlePanel.add(compassRoseLocationLabel);
        ArrayList<NumericComboBoxItem> compassRoseLocationCombo = new ArrayList<NumericComboBoxItem>();
        compassRoseLocationCombo.add(new NumericComboBoxItem(Messages.getInstance().get("top_left"), 0));
        compassRoseLocationCombo.add(new NumericComboBoxItem(Messages.getInstance().get("top_right"), 1));
        compassRoseLocationCombo.add(new NumericComboBoxItem(Messages.getInstance().get("bottom_left"), 2));
        compassRoseLocationCombo.add(new NumericComboBoxItem(Messages.getInstance().get("bottom_right"), 3));
        this.compassRoseLocationComboBox = new JComboBox();
        this.compassRoseLocationComboBox.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(compassRoseLocationCombo.toArray(new NumericComboBoxItem[compassRoseLocationCombo.size()])));
        this.compassRoseLocationComboBox.setEnabled(SettingsBean.getInstance().getPdfConfigBean().isWithCompassRose());
        for (int i = 0; i < compassRoseLocationCombo.size(); ++i) {
            if (((NumericComboBoxItem)compassRoseLocationCombo.get(i)).getValue().intValue() != SettingsBean.getInstance().getPdfConfigBean().getCompassRoseLocation()) continue;
            this.compassRoseLocationComboBox.setSelectedIndex(i);
            break;
        }
        middlePanel.add(this.compassRoseLocationComboBox);
        int selZoom = -1;
        if (selectionArea != null) {
            selZoom = FlightPlanBean.getInstance().getRoute().getPdfMapZoom() == null ? MapFrame.getInstance().getMapViewer().getZoom() : FlightPlanBean.getInstance().getRoute().getPdfMapZoom().intValue();
        }
        this.recreateZoomLevelCombo(selZoom);
        this.zoomLevelChanged();
        this.setPreferredSize(new Dimension(410, 220));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        MapFrame.getInstance().getMapViewer().setSelectionModeDialog(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                boolean keyHandled = false;
                if (e.getID() == 401) {
                    PdfRegionDialog.this.keyReleased(e);
                }
                return keyHandled;
            }
        });
        this.init();
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    protected void includeCompassRoseAction() {
        this.compassRoseLocationComboBox.setEnabled(this.includeCompassRoseCheckBox.isSelected());
    }

    private void recreateZoomLevelCombo(int selectedZoomLevel) {
        if (this.zoomComboBox != null) {
            this.northDetailsPanel.remove(this.zoomComboBox);
            this.zoomComboBox = null;
        }
        ArrayList<NumericComboBoxItem> zoomLevelCombo = new ArrayList<NumericComboBoxItem>();
        int selIdx = -1;
        if (this.selectionArea != null) {
            int zoomMin = MapFrame.getInstance().getMapViewer().getTileFactory().getInfo().getMinimumZoomLevel();
            int zoomMax = MapFrame.getInstance().getMapViewer().getTileFactory().getInfo().getMaximumZoomLevel();
            int i = 0;
            for (int zoom = zoomMin; zoom <= zoomMax; ++zoom) {
                Dimension size = this.selectionArea.getSize(MapFrame.getInstance().getMapViewer(), zoom);
                int dpi = PdfUtil.calculateDpiForA4Page(this.selectionArea, zoom, 1.0);
                if (dpi < 25 || dpi > 400) continue;
                zoomLevelCombo.add(new NumericComboBoxItem((int)Math.round(size.getWidth()) + "x" + (int)Math.round(size.getHeight()) + " [" + dpi + "dpi]", zoom));
                if (zoom == selectedZoomLevel) {
                    selIdx = i;
                }
                ++i;
            }
        }
        this.zoomComboBox = new JComboBox();
        this.northDetailsPanel.add(this.zoomComboBox);
        this.zoomComboBox.setModel(new DefaultComboBoxModel<NumericComboBoxItem>(zoomLevelCombo.toArray(new NumericComboBoxItem[zoomLevelCombo.size()])));
        if (selIdx >= 0) {
            this.zoomComboBox.setSelectedIndex(selIdx);
        }
        this.zoomComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PdfRegionDialog.this.zoomLevelChanged();
            }
        });
        this.zoomComboBox.setEnabled(zoomLevelCombo.size() > 0);
        this.northDetailsPanel.revalidate();
        this.northDetailsPanel.repaint();
    }

    private void zoomLevelChanged() {
        if (this.zoomComboBox == null) {
            this.recreateZoomLevelCombo(-1);
        } else {
            NumericComboBoxItem sel = (NumericComboBoxItem)this.zoomComboBox.getSelectedItem();
            this.recreateZoomLevelCombo(sel != null ? sel.getValue() : -1);
        }
    }

    private void init() {
        MapFrame.getInstance().getMapViewer().setMapMode(MapMode.RECTANGLE_DRAW);
        MapFrame.getInstance().getMapViewer().setDrawSelectionMode(true);
        MapFrame.getInstance().getMapViewer().setAllowRotationInRectangleDrawMode(true);
        if (this.selectionArea != null) {
            MapFrame.getInstance().getMapViewer().setRotatedSelectionArea(this.selectionArea);
            MapFrame.getInstance().getMapViewer().repaint();
        }
    }

    private void closeWindowAction() {
        MapFrame.getInstance().getMapViewer().setMapMode(MapMode.DEFAULT);
        MapFrame.getInstance().getMapViewer().setAllowRotationInRectangleDrawMode(false);
        MapFrame.getInstance().getMapViewer().setSelectionModeDialog(null);
        MapFrame.getInstance().getMapViewer().setDrawSelectionMode(false);
        if (this.mainDialog != null) {
            this.mainDialog.setVisible(true);
        }
        this.setVisible(false);
    }

    private void clearAction() {
        MapFrame.getInstance().getMapViewer().setRotatedSelectionArea(null);
        this.selectionArea = null;
        this.recreateZoomLevelCombo(-1);
        MapFrame.getInstance().updateMap();
    }

    private void selectAction() {
        if (this.doValidate()) {
            NumericComboBoxItem sel = (NumericComboBoxItem)this.zoomComboBox.getSelectedItem();
            if (sel != null) {
                this.selectedZoom = sel.getValue();
            }
            int location = 0;
            NumericComboBoxItem locSel = (NumericComboBoxItem)this.compassRoseLocationComboBox.getSelectedItem();
            if (locSel != null) {
                location = locSel.getValue();
            }
            if (this.mode == 0) {
                FlightPlanBean.getInstance().getRoute().setPdfMapRegion(this.selectionArea);
                FlightPlanBean.getInstance().getRoute().setPdfMapZoom(this.selectedZoom);
                SettingsBean.getInstance().getPdfConfigBean().setWithCompassRose(this.includeCompassRoseCheckBox.isSelected());
                SettingsBean.getInstance().getPdfConfigBean().setCompassRoseLocation(location);
                FlightPlanBean.getInstance().getRoute().setMapResolutionAndAreaSelected(true);
                this.closeWindowAction();
            } else if (this.mode == 1) {
                this.closeWindowAction();
                MapFrame.getInstance().exportMapAsPdfFinish(this.selectionArea, this.selectedZoom, this.includeCompassRoseCheckBox.isSelected(), location);
            } else if (this.mode == 2) {
                this.closeWindowAction();
                MapFrame.getInstance().exportMapAsPngFinish(this.selectionArea, this.selectedZoom, this.includeCompassRoseCheckBox.isSelected(), location);
            } else if (this.mode == 3) {
                this.closeWindowAction();
            }
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (MapFrame.getInstance().getMapViewer().getSelectionArea() == null) {
            errors.add(Messages.getInstance().get("terrain_layer_dialog_no_area_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    @Override
    public void selectionChanged(GpsArea area) {
        this.selectionArea = new RotatedGpsArea(area);
        this.zoomLevelChanged();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 37) {
            MapFrame.getInstance().getMapViewer().moveMap(-100, 0);
        } else if (e.getKeyCode() == 40) {
            MapFrame.getInstance().getMapViewer().moveMap(0, 100);
        } else if (e.getKeyCode() == 39) {
            MapFrame.getInstance().getMapViewer().moveMap(100, 0);
        } else if (e.getKeyCode() == 38) {
            MapFrame.getInstance().getMapViewer().moveMap(0, -100);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public RotatedGpsArea getSelectionArea() {
        return this.selectionArea;
    }

    public void setSelectionArea(RotatedGpsArea selectionArea) {
        this.selectionArea = selectionArea;
    }

    @Override
    public void rotatedSelectionChanged(RotatedGpsArea area) {
        this.selectionArea = area;
        this.zoomLevelChanged();
    }

    @Override
    public boolean isRotationEnabled() {
        return true;
    }

    public Integer getSelectedZoom() {
        return this.selectedZoom;
    }

    public void setSelectedZoom(Integer selectedZoom) {
        this.selectedZoom = selectedZoom;
    }
}

