/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.swing.panel.file.FileChooserPanel;
import main.java.guru.vfrflight.gui.task.ImportOpenAipDataTask;
import main.java.guru.vfrflight.gui.task.RefreshAllTask;
import main.java.guru.vfrflight.util.VfrUtil;

public class OpenAipImportDialog
extends JDialog {
    private static final long serialVersionUID = 2754079588492315987L;
    private FileChooserPanel directoryChooserPanel;
    private JCheckBox removeCurrentDataCheckBox;

    public OpenAipImportDialog(Window frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                OpenAipImportDialog.this.closeWindowAction();
            }
        });
        this.setTitle(Messages.getInstance().get("import"));
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        this.getContentPane().add(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JPanel buttonPanel = new JPanel();
        panel.add((Component)buttonPanel, "South");
        JButton okButton = new JButton(Messages.getInstance().get("ok_button"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenAipImportDialog.this.exportAction();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getInstance().get("cancel_button"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenAipImportDialog.this.closeWindowAction();
            }
        });
        buttonPanel.add(cancelButton);
        JPanel panel_2 = new JPanel();
        panel.add((Component)panel_2, "Center");
        panel_2.setLayout(new BorderLayout(0, 0));
        JPanel panel_1 = new JPanel();
        panel_2.add((Component)panel_1, "North");
        this.directoryChooserPanel = new FileChooserPanel(Messages.getInstance().get("open_aip_import_dialog_select_directory"), false);
        this.directoryChooserPanel.setBorder(new EtchedBorder(1, null, null));
        panel_1.add(this.directoryChooserPanel);
        JPanel panel_4 = new JPanel();
        panel_2.add((Component)panel_4, "Center");
        this.removeCurrentDataCheckBox = new JCheckBox(Messages.getInstance().get("open_aip_import_dialog_remove_current_data"), true);
        panel_4.add(this.removeCurrentDataCheckBox);
        this.setSize(500, 200);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
        this.setModal(true);
        this.pack();
    }

    private void exportAction() {
        if (this.doValidate()) {
            this.closeWindowAction();
            new Thread(new ImportOpenAipDataTask(this, this.directoryChooserPanel.getChosenPath(), this.removeCurrentDataCheckBox.isSelected())).start();
        }
    }

    private boolean doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.directoryChooserPanel.isPathSelected()) {
            errors.add(Messages.getInstance().get("open_aip_import_dialog_directory_not_selected"));
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            for (String error : errors) {
                sb.append(error);
                sb.append("<br/>");
            }
            sb.append("</html>");
            JOptionPane.showMessageDialog(this, sb.toString(), Messages.getInstance().get("error"), 0);
        }
        return errors.size() == 0;
    }

    private void closeWindowAction() {
        this.setVisible(false);
    }

    public void importFinishedAction() {
        VfrUtil.setLayerVisibilityAction(new RefreshAllTask());
        JOptionPane.showMessageDialog(this, Messages.getInstance().get("open_aip_import_dialog_import_finished"), "", 1);
    }
}

