/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.flightplan;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.swing.panel.image.ImageFilePanel;

public class MeteoViewDialog
extends JDialog {
    private static final long serialVersionUID = -5970335488372607482L;
    private static volatile MeteoViewDialog instance = null;
    private ImageFilePanel imagePanel;
    private JButton nextButton;
    private JButton prevButton;
    private int imageNum = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MeteoViewDialog getInstance() {
        if (instance != null) return instance;
        Class<MeteoViewDialog> clazz = MeteoViewDialog.class;
        synchronized (MeteoViewDialog.class) {
            if (instance != null) return instance;
            instance = new MeteoViewDialog(MapFrame.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void refreshInstance() {
        if (instance != null) {
            instance.dispose();
            instance = null;
            MeteoViewDialog.getInstance();
        }
    }

    public MeteoViewDialog(JFrame frame) {
        super(frame);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                MeteoViewDialog.this.closeWindowAction();
            }
        });
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel buttonBarPanel = new JPanel();
        this.getContentPane().add((Component)buttonBarPanel, "South");
        JButton closeButton = new JButton(Messages.getInstance().get("close_button"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                MeteoViewDialog.this.closeWindowAction();
            }
        });
        buttonBarPanel.setLayout(new FlowLayout(1, 5, 5));
        this.prevButton = new JButton(Messages.getInstance().get("previous_button"));
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MeteoViewDialog.this.previousImageAction();
            }
        });
        buttonBarPanel.add(this.prevButton);
        buttonBarPanel.add(closeButton);
        this.nextButton = new JButton(Messages.getInstance().get("next_button"));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MeteoViewDialog.this.nextImageAction();
            }
        });
        buttonBarPanel.add(this.nextButton);
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout(null);
        this.imagePanel = new ImageFilePanel();
        this.imagePanel.setBounds(0, 0, 540, 660);
        contentPanel.add(this.imagePanel);
        this.setSize(550, 700);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, (dim.height / 2 - this.getSize().height / 2) / 2);
        ImageIcon img = new ImageIcon("img/icon.png");
        this.setIconImage(img.getImage());
    }

    private void previousImageAction() {
        if (this.imageNum > 0) {
            --this.imageNum;
            this.updateImage(true);
        }
    }

    private void nextImageAction() {
        if (this.imageNum < FlightPlanBean.getInstance().getRoute().getMeteoReports().size() - 1) {
            ++this.imageNum;
            this.updateImage(true);
        }
    }

    private void closeWindowAction() {
        this.setVisible(false);
        FlightPlanBean.getInstance().selectMeteoReport(-1);
        MapFrame.getInstance().setPopupEnabled(true);
        MapFrame.getInstance().unlockPoints();
        MapFrame.getInstance().setPaintMeteoPoints(false);
        MapFrame.getInstance().updateMap();
        MapFrame.getInstance().getUIPanel().unlockForMeteo();
    }

    public void openWindow(boolean center) {
        this.updateData(center);
        this.setVisible(true);
        MapFrame.getInstance().setPopupEnabled(false);
        MapFrame.getInstance().lockPoints();
        MapFrame.getInstance().setPaintMeteoPoints(true);
        MapFrame.getInstance().updateMap();
        MapFrame.getInstance().getUIPanel().lockForMeteo();
    }

    public void updateData(boolean center) {
        this.imageNum = 0;
        if (FlightPlanBean.getInstance().getRoute().getMeteoReports().size() > 0) {
            this.updateImage(center);
        }
    }

    public void updateImage(boolean center) {
        int size = FlightPlanBean.getInstance().getRoute().getMeteoReports().size();
        this.imagePanel.setImage(FlightPlanBean.getInstance().getRoute().getMeteoReports().get(this.imageNum).getImage());
        FlightPlanBean.getInstance().selectMeteoReport(this.imageNum);
        this.prevButton.setEnabled(this.imageNum > 0);
        this.nextButton.setEnabled(this.imageNum < size - 1);
        this.updateTitle();
        this.updateMap(center);
        this.repaint();
    }

    public void updateTitle() {
        int max = FlightPlanBean.getInstance().getRoute().getMeteoReports().size();
        this.setTitle("METEO: " + FlightPlanBean.getInstance().getRoute().getMeteoReports().get(this.imageNum).getPlace().getName() + " (" + (this.imageNum + 1) + "/" + max + ")");
    }

    public void updateMap(boolean center) {
        if (center) {
            MapFrame.getInstance().centerOnPoint(FlightPlanBean.getInstance().getRoute().getMeteoReports().get(this.imageNum).getPlace(), false);
        }
        MapFrame.getInstance().updateMap();
    }
}

